/*
 * @(#)SortedSet.java	1.4 98/03/18
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.java.util.collections; import java.util.*;

/**
 * A Set that further guarantees that it will be in ascending element order,
 * sorted according to the <i>natural sort method</i> of its elements (see
 * Comparable), or by a Comparator provided at SortedSet creation time.
 * Several additional operations are provided to take advantage of the
 * ordering.  (This interface is the Set analogue of SortedMap.)
 * <p>
 * All elements inserted into an SortedSet must implement the Comparable
 * interface.  Furthermore, all such elements must be <i>mutually
 * comparable</i>: k1.compareTo(k2) must not throw a typeMismatchException for
 * any elements k1 and k2 in the TreeSet.  Attempts to violate this
 * restriction will cause the offending method or constructor invocation to
 * throw a ClassCastException.
 * <p>
 * All general-purpose SortedSet implementation classes should provide four
 * "standard" constructors: 1) A void (no arguments) constructor, which
 * creates an empty SortedSet sorted according to the <i>natural sort
 * method</i> of its elements.  2) A constructor with a single argument of
 * type Comparator, which creates an empty SortedSet sorted according to the
 * specified Comparator.  3) A constructor with a single argument of type
 * Collection, which creates a new Set with the same elements as its argument,
 * sorted according to the elements' natural sort method.  4) A constructor
 * with a single argument of type SortedSet, which creates a new SortedSet
 * with the same elements and the same ordering as the input SortedSet.
 * There is no way to enforce this recommendation (as interfaces cannot
 * contain constructors) but the JDK implementation (TreeSet) complies.
 *
 * @author  Josh Bloch
 * @version 1.4 03/18/98
 * @see Set
 * @see TreeSet
 * @see SortedMap
 * @see Collection
 * @see ClassCastException
 * @since JDK1.2
 */

public interface SortedSet<A> extends Set<A> {
    /**
     * Returns the Comparator associated with this SortedSet, or null
     * if it uses its elements' natural sort method.
     *
     * @return the Comparator associated with this SortedSet, or null
     * 	       if it uses its elements' natural sort method.
     * @since JDK1.2
     */
    Comparator<A> comparator();

    /**
     * Returns a view of the portion of this SortedSet whose elements range
     * from fromElement, inclusive, to toElement, exclusive.  The returned
     * SortedSet is backed by this SortedSet, so changes in the returned
     * SortedSet are reflected in this SortedSet, and vice-versa.  The
     * returned Set supports all optional Set operations.
     *
     * The Set returned by this method will throw an IllegalArgumentException
     * if the user attempts to insert a element outside the specified range.
     *
     * @param fromElement low endpoint (inclusive) of the subSet.
     * @param toElement high endpoint (exclusive) of the subSet.
     * @return a view of the specified range within this SortedSet.
     * @exception ClassCastException fromElement or toElement cannot be
     *		  compared with the elements currently in the SortedSet.
     * @exception NullPointerException fromElement or toElement is null and
     *		  this SortedSet does not tolerate null elements.
     * @exception IllegalArgumentException fromElement is greater than
     *		  toElement.
     * @since JDK1.2
     */
    SortedSet<A> subSet(A fromElement, A toElement);

    /**
     * Returns a view of the portion of this SortedSet whose elements are
     * strictly less than toElement.  The returned SortedSet is backed by this
     * SortedSet, so changes in the returned SortedSet are reflected in this
     * SortedSet, and vice-versa.  The returned Set supports all optional Set
     * operations.
     * <p>
     * The Set returned by this method will throw an IllegalArgumentException
     * if the user attempts to insert a element outside the specified range.
     *
     * @param toElement high endpoint (exclusive) of the headSet.
     * @return a view of the specified initial range of this SortedSet.
     * @exception ClassCastException toElement cannot be compared with the
     *		  elements currently in the SortedSet.
     * @exception NullPointerException toElement is null and this SortedSet
     *		  does not tolerate null elements.
     * @since JDK1.2
     */
    SortedSet<A> headSet(A toElement);

    /**
     * Returns a view of the portion of this SortedSet whose elements are
     * greater than or equal to fromElement.  The returned SortedSet is
     * backed by this SortedSet, so changes in the returned SortedSet are
     * reflected in this SortedSet, and vice-versa.  The returned Set
     * supports all optional Set operations.
     *
     * The Set returned by this method will throw an IllegalArgumentException
     * if the user attempts to insert a element outside the specified range.
     *
     * @param toElement high endpoint (exclusive) of the tailSet.
     * @return a view of the specified final range of this SortedSet.
     * @exception ClassCastException toElement cannot be compared with the
     *		  elements currently in the SortedSet.
     * @exception NullPointerException fromElement is null and this SortedSet
     *		  does not tolerate null elements.
     * @since JDK1.2
     */
    SortedSet<A> tailSet(A fromElement);

    /**
     * Returns the first (lowest) element currently in this SortedSet.
     *
     * @return the first (lowest) element currently in this SortedSet.
     * @exception NoSuchElementException Set is empty.
     * @since JDK1.2
     */
    A first();

    /**
     * Returns the last (highest) element currently in this SortedSet.
     *
     * @return the last (highest) element currently in this SortedSet.
     * @exception NoSuchElementException Set is empty.
     * @since JDK1.2
     */
    A last();
}

