/*  A parametric class for stacks,
 *  derived from java.util.Stack
 *  @author  Martin Odersky
 *  @java-version 	1.29, 12/01/95
 *  @java-author	Jonathan Payne
 *  @java-author	Lee Boynton
 */

/*
 * @(#)Stack.java	1.12 95/08/11  
 *
 * Copyright (c) 1994 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

package gj.util;

/**
 * A Last-In-First-Out(LIFO) stack of objects.
 *
 * @version 	1.12, 11 Aug 1995
 * @author 	Jonathan Payne
 */
public
class Stack<A> extends Vector<A> {
    /**
     * Pushes an item onto the stack.
     * @param item the item to be pushed on.
     */
    public A push(A item) {
	addElement(item);

	return item;
    }

    /**
     * Pops an item off the stack.
     * @exception EmptyStackException If the stack is empty.
     */
    public A pop() {
	A	obj;
	int	len = size();

	obj = peek();
	removeElementAt(len - 1);

	return obj;
    }

    /**
     * Peeks at the top of the stack.
     * @exception EmptyStackException If the stack is empty.
     */
    public A peek() {
	int	len = size();

	if (len == 0)
	    throw new java.util.EmptyStackException();
	return elementAt(len - 1);
    }

    /**
     * Returns true if the stack is empty.
     */
    public boolean empty() {
	return size() == 0;
    }

    /**
     * Sees if an object is on the stack.
     * @param o the desired object
     * @return the distance from the top, or -1 if it is not found.
     */
    public int search(A o) {
	int i = lastIndexOf(o);

	if (i >= 0) {
	    return size() - i;
	}
	return -1;
    }
}
