/*
 * @(#)Comparator.java	1.6 98/03/18
 *
 * Copyright 1997 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package java.util;

/**
 * A comparison function, which imposes a total ordering on some collection
 * of Objects.  Comparators can be passed to a sort method (such as
 * Arrays.sort) to allow precise control over the sort order. Comparators can
 * also be used to control the order of certain data structures (such as
 * TreeMap).
 *
 * @author  Josh Bloch
 * @version 1.4 09/22/97
 * @see java.lang.Comparable
 * @see Arrays#sort(Object[], Comparator)
 * @see TreeMap
 * @since   JDK1.2
 */

public interface Comparator<A> {
    /**
     * Compares its two arguments for order.  Returns a negative integer,
     * zero, or a positive integer as the first argument is less than, equal
     * to, or greater than the second.
     * <p>
     * The implementor must ensure that sgn(compare(x, y)) == -sgn(compare(y,
     * x)) for all x and y.  (This implies that compare(x, y) must throw
     * an exception if and only if compare(y, x) throws an exception.)
     * <p>
     * The implementor must also ensure that the relation is transitive:
     * ((compare(x, y)&gt;0) &amp;&amp; (compare(y, z)&gt;0)) implies
     * compare(x, z)>0. 
     * <p>
     * The implementer must also ensure that x.equals(y) implies that 
     * compare(x, y) == 0.  Note that the converse is not necessarily true.
     * <p>
     * Finally, the implementer must ensure that compare(x, y) == 0 implies
     * that sgn(compare(x, z)) == sgn(compare(y, z)), for all z.
     * 
     * @return a negative integer, zero, or a positive integer as the
     * 	       first argument is less than, equal to, or greater than the
     *	       second. 
     * @exception ClassCastException the arguments' types prevent them from
     * 		  being compared by this Comparator.
     * @since   JDK1.2
     */
    public int compare(A o1, A o2);
}
