/*
 * @(#)EventObject.java	1.8 98/03/18
 *
 * Copyright 1996, 1997 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package java.util;

/**
 * <p>
 * The Event class is the abstract root class from which all event state
 * objects shall be derived.
 * <p>
 * All Event's are constructed with a reference to the object, the "source",
 * that is logically deemed to be the object upon which the Event in question
 * initially occurred upon.
 */

public class EventObject implements java.io.Serializable {
    protected transient Object  source;

    /**
     * Constructs a prototypical Event 
     *
     * @param    source    The object that the Event occurred upon.
     */
    public EventObject(Object source) {
	if (source == null)
	    throw new IllegalArgumentException("null source");

        this.source = source;
    }

    /**
     * @return  The object that the Event initially occurred upon.
     */

    public Object getSource() {
        return source;
    }

    public String toString() {
        return getClass().getName() + "[source=" + source + "]";
    }
}
