/*
 * @(#)Iterator.java	1.6 98/03/18
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package java.util;

/**
 * An iterator over a Collection.  Iterator takes the place of Enumeration in
 * the Java collection framework.  Iterators differ from Enumerations in two
 * ways: <ul> <li> Iterators allow the caller to remove elements from the
 * underlying collection during the iteration with well-defined
 * semantics. <li>Method names have been improved.</ul>
 *
 * @author  Josh Bloch
 * @version 1.6 03/18/98
 * @see Collection
 * @see ListIterator
 * @see Enumeration
 * @since JDK1.2
 */
public interface Iterator<A> {
    /**
     * Returns true if the iteration has more elements.
     *
     * @since JDK1.2
     */
    boolean hasNext();

    /**
     * Returns the next element in the interation.
     *
     * @exception NoSuchElementException iteration has no more elements.
     * @since JDK1.2
     */
    A next();

    /**
     * Removes from the underlying Collection the last element returned by the
     * Iterator .  This method can be called only once per call to next  The
     * behavior of an Iterator is unspecified if the underlying Collection is
     * modified while the iteration is in progress in any way other than by
     * calling this method.  Optional operation.
     *
     * @exception UnsupportedOperationException remove is not supported
     * 		  by this Iterator.
     * @exception IllegalStateException next has not yet been called,
     *		  or remove has already been called after the last call
     *		  to next.
     * @since JDK1.2
     */
    void remove();
}
