/*  Copyright (C) 2002 yvind Hagen */

/*  This file is part of gkleds. */

/*  gkleds is free software; you can redistribute it and/or modify */
/*  it under the terms of the GNU General Public License Version 2 as */ 
/*  published by the Free Software Foundation */

/*  gkleds is distributed in the hope that it will be useful, */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the */
/*  GNU General Public License for more details.  */

/*  You should have received a copy of the GNU General Public License */
/*  along with gkleds; if not, write to the Free Software */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

#include "gkleds_com.h"

struct struct_gkleds_indicator_conf{
  int w; /* actual width and height of leds */
  int h;
  int y; /* leds y position in panel == user_conf.margin[2](top) */
  int led_x[GKLEDS_NUM_IND]; /* actual leds x position in panel */
#if defined(WIN32)
  SHORT keys[GKLEDS_NUM_IND]; /* NUM, CAPS, SCROLL: keycode for indicators */
#else
  Display *dpy; /* the X display */
  KeyCode keys[GKLEDS_NUM_IND]; /* NUM, CAPS, SCROLL: keycode for indicators */
#endif
  int masks[GKLEDS_NUM_IND]; /* NUM, CAPS, SCROLL: indicator mask, for XKB*/
  int idx[GKLEDS_NUM_IND];/* NUM, CAPS, SCROLL: indicator index, for XKB */
};
typedef struct struct_gkleds_indicator_conf gkleds_indicator_conf;

void gkleds_ind_conf(gkleds_indicator_conf *ind);
