/*  Copyright (C) 2002 yvind Hagen */

/*  This file is part of gkleds. */

/*  gkleds is free software; you can redistribute it and/or modify */
/*  it under the terms of the GNU General Public License Version 2 as */ 
/*  published by the Free Software Foundation */

/*  gkleds is distributed in the hope that it will be useful, */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the */
/*  GNU General Public License for more details.  */

/*  You should have received a copy of the GNU General Public License */
/*  along with gkleds; if not, write to the Free Software */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */


#include "gkleds_ind.h"


void gkleds_ind_conf(gkleds_indicator_conf *ind){
  int i;
#if defined(WIN32)
  SHORT key_syms[GKLEDS_NUM_IND] = {VK_NUMLOCK, VK_CAPITAL, VK_SCROLL};
#else
  char *ind_name = NULL;
  int j, mask;
  int key_syms[GKLEDS_NUM_IND] = {XK_Num_Lock, XK_Caps_Lock, XK_Scroll_Lock};
  char *lock_names[GKLEDS_NUM_IND] = {"Num Lock","Caps Lock", "Scroll Lock"};
  XkbDescPtr xkb;
#endif

#ifdef GKLEDS_DEBUG
  printf("configure_indicators: start\n"); fflush(stdout);
#endif

#if defined(WIN32)
  for(i = 0; i < GKLEDS_NUM_IND; i++){
    ind->idx[i] = i; 
    ind->masks[i] = 1 << i;
	ind->keys[i] = key_syms[i];
  }
#else  
  /* we need a display handler to get/set indicator status */
  ind->dpy = XOpenDisplay(NULL);
  if(!ind->dpy){
    printf("gkrellm::%s : unable to connect to the X server\n", 
	   GKLEDS_NAME);
    printf("gkrellm::%s : you won't be able to get/set indicator status\n", 
	   GKLEDS_NAME);
    return;
  }
  
  /* get the keycode for set_indicators */
  for(i = 0; i < GKLEDS_NUM_IND; i++)
    ind->keys[i] = XKeysymToKeycode(ind->dpy, key_syms[i]);

  /* get a keyboard structure */
  xkb = XkbAllocKeyboard();
  if(!xkb){
    printf("gkrellm::%s : unable to allocate keyboard structure\n", 
	   GKLEDS_NAME);
    printf("gkrellm::%s : you won't be able to get/set indicator status\n", 
	   GKLEDS_NAME);
    XCloseDisplay(ind->dpy); ind->dpy = NULL;
    return;
  }

  /* get the names(atoms) of the indicators */
  if(XkbGetNames(ind->dpy, XkbIndicatorNamesMask, xkb) != Success){
    printf("gkrellm::%s : unable to get indicator names from the X server\n", 
	   GKLEDS_NAME);
    printf("gkrellm::%s : you won't be able to get/set indicator status\n", 
	   GKLEDS_NAME);
    XkbFreeKeyboard(xkb, 0, True);
    XCloseDisplay(ind->dpy); ind->dpy = NULL;
    return;
  }    

  /* get the correct mask & shift for get_indicators */ 
  for(i = 0; i < XkbNumIndicators; i++){
    if(xkb->names->indicators[i])
      ind_name = XGetAtomName(ind->dpy, xkb->names->indicators[i]);
#ifdef GKLEDS_DEBUG
  if(ind_name) printf("configure_indicators: %s\n", ind_name); fflush(stdout);
#endif
    for(j = 0; j < GKLEDS_NUM_IND; j++){
      if(ind_name && !strcmp(lock_names[j], ind_name)){
	if(XkbGetNamedIndicator(ind->dpy, xkb->names->indicators[i], &mask, 
				NULL, NULL, NULL) == True){
#ifdef GKLEDS_DEBUG
  printf("configure_indicators: mask %d: %d\n", i, mask); fflush(stdout);
#endif
	  ind->masks[j] = 1 << mask;
	  ind->idx[j] = mask;
	}else{
	  printf("gkrellm::%s : unable to get the indicator mask from the X "
		 "server\n", GKLEDS_NAME);
	  printf("gkrellm::%s : you won't be able to get/set indicator "
		 "status\n", GKLEDS_NAME);
	  XkbFreeKeyboard(xkb, 0, True);
	  XCloseDisplay(ind->dpy); ind->dpy = NULL;
	  return;
	}
      }
    }
    if(ind_name){ 
      free(ind_name);
      ind_name = NULL;
    }
  }

  XkbFreeKeyboard(xkb, 0, True);
#endif

#ifdef GKLEDS_DEBUG
  printf("configure_indicators: end\n"); fflush(stdout);
#endif
  return;
}

