
#include <stdlib.h>
#include <stdarg.h>
#include <sys/time.h>
#include "doomdef.h"

#include <SDL/SDL.h>

#include "gl_struct.h"

extern long do_grabMouse;

static int      lastmousex = 0;
static int      lastmousey = 0;

/* Public Data */


/*
 *--------------------------------------------------------------------------
 *
 * PROC I_SetPalette
 *
 * Palette source must use 8 bit RGB elements.
 *
 *--------------------------------------------------------------------------
 */

void I_SetPalette(byte *palette)
{
  /* dummy in OGL Mode */
}

/*
============================================================================

							GRAPHICS MODE

============================================================================
*/

byte *destview;

/*
==============
=
= I_Update
=
==============
*/

int UpdateState;
extern int screenblocks;

void I_FinishUpdate (void)
{
  GL_Finish();
}

void InitGraphLib(void) {
  /* is not needed */
}

/*
 *--------------------------------------------------------------------------
 *
 * PROC I_InitGraphics
 *
 *--------------------------------------------------------------------------
 */

void I_InitGraphics(void) {
  /* check if the user wants to grab the mouse (quite unnice) */
  if ( !do_grabMouse && M_CheckParm("-grabmouse"))
  	do_grabMouse = 1;
  
  I_GL_InitGraphics();
}

/*
 *--------------------------------------------------------------------------
 *
 * PROC I_ShutdownGraphics
 *
 *--------------------------------------------------------------------------
 */

void I_ShutdownGraphics(void)
{
  /* Destroy our GL context, etc. */
  SDL_Quit();
}

void I_CheckRes()
{
  /* nothing to do... */
}

/*
 *  Translates the key 
 */

int xlatekey(SDL_keysym *key)
{
  int rc;
  
  switch(key->sym)
    {
    case SDLK_LEFT:	rc = KEY_LEFTARROW;	break;
    case SDLK_RIGHT:	rc = KEY_RIGHTARROW;	break;
    case SDLK_DOWN:	rc = KEY_DOWNARROW;	break;
    case SDLK_UP:	rc = KEY_UPARROW;	break;
    case SDLK_ESCAPE:	rc = KEY_ESCAPE;	break;
    case SDLK_RETURN:	rc = KEY_ENTER;		break;
    case SDLK_F1:	rc = KEY_F1;		break;
    case SDLK_F2:	rc = KEY_F2;		break;
    case SDLK_F3:	rc = KEY_F3;		break;
    case SDLK_F4:	rc = KEY_F4;		break;
    case SDLK_F5:	rc = KEY_F5;		break;
    case SDLK_F6:	rc = KEY_F6;		break;
    case SDLK_F7:	rc = KEY_F7;		break;
    case SDLK_F8:	rc = KEY_F8;		break;
    case SDLK_F9:	rc = KEY_F9;		break;
    case SDLK_F10:	rc = KEY_F10;		break;
    case SDLK_F11:	rc = KEY_F11;		break;
    case SDLK_F12:	rc = KEY_F12;		break;
      
    case SDLK_INSERT: rc = KEY_INSERT;           break;
    case SDLK_DELETE: rc = KEY_DELETE;           break;
    case SDLK_PAGEUP: rc = KEY_PAGEUP;          break;
    case SDLK_PAGEDOWN: rc = KEY_PAGEDOWN;        break;
    case SDLK_HOME:   rc = KEY_HOME;          break;
    case SDLK_END:    rc = KEY_END;           break;
      
    case SDLK_BACKSPACE: rc = KEY_BACKSPACE;	break;
      
    case SDLK_PAUSE:	rc = KEY_PAUSE;		break;
      
    case SDLK_EQUALS:	rc = KEY_EQUALS;	break;
      
    case SDLK_KP_MINUS:
    case SDLK_MINUS:	rc = KEY_MINUS;		break;
      
    case SDLK_KP_PLUS:
    case SDLK_PLUS:         rc = KEY_EQUALS;        break;
      
    case SDLK_LSHIFT:
    case SDLK_RSHIFT:
      rc = KEY_RSHIFT;
      break;
      
    case SDLK_LCTRL:
    case SDLK_RCTRL:
      rc = KEY_RCTRL;
      break;
      
    case SDLK_LALT:
    case SDLK_LMETA:
    case SDLK_RALT:
    case SDLK_RMETA:
      rc = KEY_RALT;
      break;
      
    default:
      rc = key->sym;
      break;
    }
  return rc;
}


/* This processes SDL events */
void I_GetEvent(SDL_Event *Event)
{
  Uint8 buttonstate;
  event_t event;
  
  switch (Event->type)
    {
    case SDL_KEYDOWN:
      event.type = ev_keydown;
      event.data1 = xlatekey(&Event->key.keysym);
      D_PostEvent(&event);
      break;
      
    case SDL_KEYUP:
      event.type = ev_keyup;
      event.data1 = xlatekey(&Event->key.keysym);
      D_PostEvent(&event);
      break;
      
    case SDL_MOUSEBUTTONDOWN:
    case SDL_MOUSEBUTTONUP:
      buttonstate = SDL_GetMouseState(NULL, NULL);
      event.type = ev_mouse;
      event.data1 = 0
	| (buttonstate & SDL_BUTTON(1) ? 1 : 0)
	| (buttonstate & SDL_BUTTON(2) ? 2 : 0)
	| (buttonstate & SDL_BUTTON(3) ? 4 : 0);
      event.data2 = event.data3 = 0;
      D_PostEvent(&event);
      break;
      
    case SDL_MOUSEMOTION:
      event.type = ev_mouse;
      event.data1 = 0
	| (Event->motion.state & SDL_BUTTON(1) ? 1 : 0)
	| (Event->motion.state & SDL_BUTTON(2) ? 2 : 0)
	| (Event->motion.state & SDL_BUTTON(3) ? 4 : 0);
      event.data2 = (Event->motion.x - lastmousex) << 2;
      event.data3 = (lastmousey - Event->motion.y) << 2;
      
      if (event.data2 || event.data3) {
	lastmousex = Event->motion.x;
	lastmousey = Event->motion.y;
	if (Event->motion.x != screenwidth/2 &&
	    Event->motion.y != screenheight/2) {
	  D_PostEvent(&event);
	}
      }

      if ( (Event->motion.x != screenwidth/2) ||
	   (Event->motion.y != screenheight/2) ) {
	/* Warp the mouse back to the center */
	if (do_grabMouse) {
	  SDL_WarpMouse(screenwidth/2, screenheight/2);
	}
      }
      break;

    case SDL_QUIT:
      I_Quit();
    }
}

/*
 * I_StartTic
 */
void I_StartTic (void)
{
    SDL_Event Event;
    
    while ( SDL_PollEvent(&Event) )
        I_GetEvent(&Event);
}

/*
===============
=
= I_StartFrame
=
===============
*/

void I_StartFrame (void)
{
    /* ? */
}
