#ifdef GL_HERETIC
/*
	OPENGL LIGHTING EFFECTS - GL_Effects.C

    This file contains funtions that will handle certain dynamic lighting effects, like
	strobing, flicker, fade, etc. Everything is easily done through a struct! Yay!

	Credit goes out to Kokak, of DoomGL fame for his sources. Kayin, Rethcir, and the rest of
	the Ninja Doom team for letting me work on their project for as a "test" before I add this
	into Thrust. 

	Creator: DarkFang
	
	THRUST;
	http://doomnation.com/thrust

    Ninja Doom;
	http://www.doomworld.com/ninja

    DoomGL:
	http://www.doomworld.com/doomgl
*/

//
// INCLUDES
//

#include <stdio.h>
#include <string.h>
#include <math.h>

#include <GL/gl.h>
#include <GL/glu.h>

#include "gl_struct.h"
#include "gl_mem.h"

#ifndef GL_HEXEN
#include "doomdef.h"
#else
#include "h2def.h"
#endif
#include "r_local.h"
//#ifndef GL_HEXEN
#ifdef DOOM_GL
#include "p_spec.h"
#endif
#include "p_local.h"


//
// VARIBLES
//
#ifdef DOOM_GL
#define NUM_EFFECTS		24

GLdynamic_effect lighteffects[NUM_EFFECTS] =
{

// Tall Red Torch	
	{ MT_MISC43, S_REDTORCH,		1.0f, 0.0f, 0.0f, 0.0f, 1.8f },
	{ MT_MISC43, S_REDTORCH2,		1.0f, 0.0f, 0.0f, 0.0f, 1.9f },
	{ MT_MISC43, S_REDTORCH3,		1.0f, 0.0f, 0.0f, 0.0f, 1.7f },
	{ MT_MISC43, S_REDTORCH4,		1.0f, 0.0f, 0.0f, 0.0f, 2.0f },

// Tall Green Torch
	{ MT_MISC42, S_GREENTORCH,		0.0f, 1.0f, 0.0f, 0.0f, 1.8f },
	{ MT_MISC42, S_GREENTORCH2,		0.0f, 1.0f, 0.0f, 0.0f, 1.9f },
	{ MT_MISC42, S_GREENTORCH3,		0.0f, 1.0f, 0.0f, 0.0f, 1.7f },
	{ MT_MISC42, S_GREENTORCH4,		0.0f, 1.0f, 0.0f, 0.0f, 2.0f },

// Tall Blue Torch
	{ MT_MISC41, S_BLUETORCH,		0.0f, 0.0f, 1.0f, 0.0f, 1.8f },
	{ MT_MISC41, S_BLUETORCH2,		0.0f, 0.0f, 1.0f, 0.0f, 1.9f },
	{ MT_MISC41, S_BLUETORCH3,		0.0f, 0.0f, 1.0f, 0.0f, 1.7f },
	{ MT_MISC41, S_BLUETORCH4,		0.0f, 0.0f, 1.0f, 0.0f, 2.0f },

// Short Red Torch
	{ MT_MISC46, S_RTORCHSHRT,		1.0f, 0.0f, 0.0f, 0.0f, 1.1f },
	{ MT_MISC46, S_RTORCHSHRT2,		1.0f, 0.0f, 0.0f, 0.0f, 0.9f },
	{ MT_MISC46, S_RTORCHSHRT3,		1.0f, 0.0f, 0.0f, 0.0f, 1.0f },
	{ MT_MISC46, S_RTORCHSHRT4,		1.0f, 0.0f, 0.0f, 0.0f, 0.7f },

// Short Green Torch
	{ MT_MISC45, S_GTORCHSHRT,		0.0f, 1.0f, 0.0f, 0.0f, 1.1f },
	{ MT_MISC45, S_GTORCHSHRT2,		0.0f, 1.0f, 0.0f, 0.0f, 0.9f },
	{ MT_MISC45, S_GTORCHSHRT3,		0.0f, 1.0f, 0.0f, 0.0f, 1.0f },
	{ MT_MISC45, S_GTORCHSHRT4,		0.0f, 1.0f, 0.0f, 0.0f, 0.7f },

// Short Blue Torch
	{ MT_MISC44, S_BTORCHSHRT,		0.0f, 0.0f, 1.0f, 0.0f, 1.1f },
	{ MT_MISC44, S_BTORCHSHRT2,		0.0f, 0.0f, 1.0f, 0.0f, 0.9f },
	{ MT_MISC44, S_BTORCHSHRT3,		0.0f, 0.0f, 1.0f, 0.0f, 1.0f },
	{ MT_MISC44, S_BTORCHSHRT4,		0.0f, 0.0f, 1.0f, 0.0f, 0.7f }
};
#endif	

//
// FUNCTIONS
//

void AGL_HandleEffects(int i)
{
#ifdef DOOM_GL
int	ii;

	for(ii=0; ii<NUM_EFFECTS; ii++)
	{
		if (a_stGLLight[i].thing->type == lighteffects[ii].type)
		{
			if (a_stGLLight[i].thing->state == &states[lighteffects[ii].state])
			{
				a_stGLLight[i].fRed		= lighteffects[ii].fRed;
				a_stGLLight[i].fGreen	= lighteffects[ii].fGreen;
				a_stGLLight[i].fBlue	= lighteffects[ii].fBlue;
				a_stGLLight[i].fNear	= lighteffects[ii].fNear;
				a_stGLLight[i].fFar		= lighteffects[ii].fFar;

				a_stGLLight[i].fFar2 = lighteffects[ii].fFar * lighteffects[ii].fFar;
			}
		}
	}
#endif
}
				

#endif	// GL_HERETIC
