#ifdef GL_HERETIC

//#define __DOOMTYPE__

#include <stdio.h>
#include <string.h>
#include <math.h>

#include "gl_syms.h"

#include "gl_struct.h"
#include "gl_mem.h"
#ifndef GL_HEXEN
#include "doomdef.h"
#else
#include "h2def.h"
#endif
#include "r_local.h"

#ifdef GL_HEXEN
#define F_SKY	"F_SKY"
extern int GL_Sky1Texture,GL_Sky2Texture;
char GLCurrentSky;
#else
#define F_SKY	"F_SKY1"
#endif

extern lumpinfo_t	*lumpinfo;		// location of each lump on disk
extern GLTexture *p_stGLTextures;
extern GLTexArray *p_stGLTexArray;

extern GLuint *texobjs;

extern int *a_iGlDrawLine,*a_iGlDrawFloorCeil;

extern int *a_iGLTexTranslation;

//FloorCeilVertexesArray *a_stFloorVertexesArray;
//GLFloorCeilPolygon *a_stFCPolygons;
GLFloorCeilingPolygonArray *a_stFCPolygonArray;

int iXMin,iXMax,iYMin,iYMax;
int xMapMin=0x7fffffff,xMapMax=-0x7fffffff,yMapMin=0x7fffffff,yMapMax=-0x7fffffff,iAltitudeMin=0x7fffffff,iAltitudeMax=-0x7fffffff;
int iLightLevelMin=0xffff,iLightLevelMax=-0xffff;

GLFloorCeiling *a_stFloorCeiling;
//int startCeilingList,startFloorList;
int *a_iLineArray,*a_iLinePresent;

//GLboolean bFloorCompute;
int iCurrentSector/*,iNbPoints*/;

float fSkyRadius;
int iSkyList;
#ifdef GL_HEXEN
int iSkyList1,iSkyList2;
fixed_t Sky1ColumnOffset;
fixed_t Sky2ColumnOffset;
#endif

int hVertexTmpHeap;

/*typedef struct GLUtesselator GLUtriangulatorObj;
#define gluTessBeginPolygon(x,y) gluBeginPolygon(x)
#define gluTessEndPolygon gluEndPolygon
#define gluTessBeginContour
#define gluTessEndContour(x) gluNextContour(x,GLU_UNKNOWN)
*/
int g_iSector;

#ifndef DOOM_GL
H_boolean modifiedgame;
#endif


void printLineInfo(line_t *lines, int l) {
  printf("===================================\n");
  printf("LINE-INFO of Line %u\n", l);
  printf("iLineID: %d\n", lines[l].iLineID);
  printf("v1[%.2f, %.2f] ; v2[%.2f, %.2f]\n", 
	 ((GLdouble)lines[l].v1->x)/((GLdouble)MAP_SCALE), 
         ((GLdouble)lines[l].v1->y)/((GLdouble)MAP_SCALE),
	 ((GLdouble)lines[l].v2->x)/((GLdouble)MAP_SCALE), 
         ((GLdouble)lines[l].v2->y)/((GLdouble)MAP_SCALE));
  printf("flags: %d ; special: %d ; tag: %d\n",
	 lines[l].flags, lines[l].special, lines[l].tag);
  printf("===================================\n");
}

void printSectorInfo(sector_t *sectors, int s) {
  int l;
  printf("------------------------------------\n");
  printf("SECTOR-INFO of Sector %u\n", s);
  printf("iSectorID: %d\n", sectors[s].iSectorID);
  printf("floorheight: %d\n", sectors[s].floorheight/MAP_SCALE);
  printf("ceilingheight: %d\n", sectors[s].ceilingheight/MAP_SCALE);
  printf("floorpic: %d\n", sectors[s].floorpic);
  printf("floorpic: %d\n", sectors[s].ceilingpic);
  printf("lightlevel: %d\n", sectors[s].lightlevel);
  printf("special: %d\n", sectors[s].special);
  printf("tag: %d\n", sectors[s].tag);
  printf("validcount: %d\n", sectors[s].validcount);
  printf("linecount: %d\n", sectors[s].linecount);
  
  for (l=0; l<sectors[s].linecount; l++)
    printLineInfo(*sectors[s].lines, l);

  printf("------------------------------------\n");
}

void GLCALLBACK errorCallback(GLenum errorCode)
{
  //const GLubyte *estring;
  
  //estring = gluErrorString(errorCode);
  //fprintf(stderr, "Tessellation Error: %s in sector %ul\n", estring,g_iSector);
  fprintf(stderr, "[SDLGLdrv/floorceil] Tessellation Error: in sector %ul\n", g_iSector);
  if (!modifiedgame)
    exit(0);
}


int fn_iGetUpperLeftLine(int *a_iLineArray,int *a_iLinePresent,int iNbLines,int sector)
{ int i=0,iRet=-1,xMin,yMax,x,y;
 GLboolean bBadSens=false;
 
 xMin=0x7fffffff;
 yMax=-0x7fffffff;
 iXMin=0x7fffffff;
 iYMin=0x7fffffff;
 iXMax=-0x7fffffff;
 iYMax=-0x7fffffff;
 
 for (i=0;i<iNbLines;i++)
   {	//if (a_iLineArray[i]==-1)
     if (!a_iLinePresent[i])
       continue;
     //goto mapbound;
     
     x=-lines[a_iLineArray[i]].v1->x;
     y=lines[a_iLineArray[i]].v1->y;
     
     if ((y==yMax)&&bBadSens&&(lines[a_iLineArray[i]].frontsector->iSectorID==sector))
       {	yMax=y;
       iRet=i;
       bBadSens=false;
       }
     
     //if ((x<=xMin)&&(y>=yMax))
     if (/*(x<=xMin)||*/(y>yMax))
       {	xMin=x;
       yMax=y;
       iRet=i;
       if (lines[a_iLineArray[i]].frontsector->iSectorID==sector)
	 bBadSens=false;
       else
	 bBadSens=true;
       }
     
     x=-lines[a_iLineArray[i]].v2->x;
     y=lines[a_iLineArray[i]].v2->y;
     
     if ((y==yMax)&&bBadSens&&lines[a_iLineArray[i]].frontsector->iSectorID==sector)
       {	yMax=y;
       iRet=i;
       bBadSens=false;
       }
     
     //if ((x<=xMin)&&(y>=yMax))
     if (/*(x<=xMin)||*/(y>yMax))
       {	xMin=x;
       yMax=y;
       iRet=i;
       if (lines[a_iLineArray[i]].frontsector->iSectorID==sector)
	 bBadSens=false;
       else
	 bBadSens=true;
       }
     if (x<iXMin)
       iXMin=x;
     if (x>iXMax)
       iXMax=x;
     if (y<iYMin)
       iYMin=y;
     if (y>iYMax)
       iYMax=y;
     
/*mapbound:
  if (x<xMapMin)
  xMapMin=x;
  if (x>xMapMax)
  xMapMax=x;
  if (y<yMapMin)
  yMapMin=y;
  if (y>yMapMax)
  yMapMax=y;*/
   }
 return iRet;
}

GLfloat *fn_p_fVertex(GLdouble *p_dVertex/*,GLfloat fLightLevel*/)
{ GLfloat *p_fVertex;

 //p_fVertex=(GLfloat *)malloc(sizeof(GLfloat)*4);
 p_fVertex=(GLfloat *)HeapAlloc(hVertexTmpHeap,0,sizeof(GLfloat)*4);
 
 p_fVertex[0]=(float)p_dVertex[0];
 p_fVertex[1]=(float)p_dVertex[1];
 p_fVertex[2]=(float)p_dVertex[2];
 //p_fVertex[3]=fLightLevel;
 p_fVertex[3]=(float)sectors[iCurrentSector].ceilingheight/MAP_SCALE;
 
 /*	if (bFloorCompute)
	{	a_stFloorVertexesArray[iCurrentSector].p_fFloor=(GLfloat **)Realloc(a_stFloorVertexesArray[iCurrentSector].p_fFloor,(iNbPoints+1)*sizeof(GLfloat *));
	a_stFloorVertexesArray[iCurrentSector].p_fCeiling=(GLfloat **)Realloc(a_stFloorVertexesArray[iCurrentSector].p_fCeiling,(iNbPoints+1)*sizeof(GLfloat *));
	a_stFloorVertexesArray[iCurrentSector].p_fFloor[iNbPoints++]=p_fVertex+1;
	}
	else
	a_stFloorVertexesArray[iCurrentSector].p_fCeiling[iNbPoints++]=p_fVertex+1;*/
 
 return p_fVertex;
}

void GLCALLBACK vertexArrayCallback(GLvoid *vertex)
{
 GLfloat *fVertex,fU,fV;
 GLVertexArray *p_stVertexArray;

 /* ANDRE !!! */ 
 /* fprintf(stderr, "vertexArrayCallback called.\n"); */
 
 p_stVertexArray=&a_stFCPolygonArray[iCurrentSector].p_stVertexArray[a_stFCPolygonArray[iCurrentSector].iNbArrays-1];
 p_stVertexArray->iNbVertices++;
 p_stVertexArray->p_fVertex=(GLfloat *)Realloc(p_stVertexArray->p_fVertex,3*p_stVertexArray->iNbVertices*sizeof(GLfloat));
 p_stVertexArray->p_fUV=(GLfloat *)Realloc(p_stVertexArray->p_fUV,2*p_stVertexArray->iNbVertices*sizeof(GLfloat));
 p_stVertexArray->p_fCeiling=(GLfloat *)Realloc(p_stVertexArray->p_fCeiling,p_stVertexArray->iNbVertices*sizeof(GLfloat));
 
 fVertex=(GLfloat *)vertex;
 //fU=(float)(fVertex[0]*MAP_SCALE/*-iXMin*/)/FLAT_TEX_SIZE;
 //fV=(float)(/*iYMax-*/fVertex[2]*MAP_SCALE)/FLAT_TEX_SIZE;
 fU=(float)(fVertex[0]*(MAP_SCALE>>FRACBITS))/FLAT_TEX_SIZE;
 fV=(float)(fVertex[2]*(MAP_SCALE>>FRACBITS))/FLAT_TEX_SIZE;
 
 p_stVertexArray->p_fVertex[3*(p_stVertexArray->iNbVertices-1)]=fVertex[0];
 p_stVertexArray->p_fVertex[3*(p_stVertexArray->iNbVertices-1)+1]=fVertex[1];
 p_stVertexArray->p_fVertex[3*(p_stVertexArray->iNbVertices-1)+2]=fVertex[2];

 /* ANDRE !!! */
 /* printf("vertex info: vertex[%.2f, %.2f, %.2f]\n", fVertex[0], fVertex[1], fVertex[2]); */
 
 p_stVertexArray->p_fUV[2*(p_stVertexArray->iNbVertices-1)]=fU;
 p_stVertexArray->p_fUV[2*(p_stVertexArray->iNbVertices-1)+1]=fV;
 
 p_stVertexArray->p_fCeiling[p_stVertexArray->iNbVertices-1]=fVertex[3];
 
 //free(fVertex);	// A voir
 
/*	(*glTexCoord2f_s) (fU,fV);
	(*glVertex3fv_s) (fVertex);*/
}

void GLCALLBACK glArrayBegin(GLenum mode)
{
 GLFloorCeilingPolygonArray *p_stPolyArray=a_stFCPolygonArray+iCurrentSector;
 
 /* ANDRE !!! */
 /* fprintf(stderr, "glArrayBegin called.\n"); */
 
 p_stPolyArray->iNbArrays++;
 p_stPolyArray->p_stVertexArray=(GLVertexArray *)Realloc(p_stPolyArray->p_stVertexArray,p_stPolyArray->iNbArrays*sizeof(GLVertexArray));

 p_stPolyArray->p_stVertexArray[p_stPolyArray->iNbArrays-1].mode=mode;
 p_stPolyArray->p_stVertexArray[p_stPolyArray->iNbArrays-1].iNbVertices=0;
 p_stPolyArray->p_stVertexArray[p_stPolyArray->iNbArrays-1].p_fVertex=(GLfloat *)Malloc(3*sizeof(GLfloat));
 p_stPolyArray->p_stVertexArray[p_stPolyArray->iNbArrays-1].p_fUV=(GLfloat *)Malloc(2*sizeof(GLfloat));
 p_stPolyArray->p_stVertexArray[p_stPolyArray->iNbArrays-1].p_fCeiling=(GLfloat *)Malloc(sizeof(GLfloat));
}

void GLCALLBACK glArrayEnd(void)
{
 /* ANDRE !!! */
  /* fprintf(stderr, "glArrayEnd called.\n"); */
}

int VtxDist(vertex_t *v1,vertex_t *v2)
{
  return abs(v1->x-v2->x)+abs(v1->y-v2->y);
}

#ifdef NDEBUG
#pragma optimize( "", off )
#endif

void fn_vCreatePolygonsForSector(int s)
{ GLUtesselator *tobj;
 int iLine,iRemainingLines,iNumLines,iDblLines;
 vertex_t *vCurrentVertex,*vStartVertex,*vLastVertex;
 GLdouble a_fVertex[2][3];
 GLboolean bAbortSector;
 int iLineCandidate;
 
 g_iSector=s;
 tobj = gluNewTess();
 
 iCurrentSector=s;
 a_stFCPolygonArray[s].iNbArrays=0;
 a_stFCPolygonArray[s].p_stVertexArray=(GLVertexArray *)Malloc(sizeof(GLVertexArray));
 
 a_stFCPolygonArray[s].iCeilingTexture=fn_iGetGLFlatTexturef(sectors[s].ceilingpic);
 a_stFCPolygonArray[s].iFloorTexture=fn_iGetGLFlatTexturef(sectors[s].floorpic);
 
 gluTessCallback(tobj, GLU_TESS_VERTEX, 
		 vertexArrayCallback);

 gluTessCallback(tobj, GLU_TESS_BEGIN, 
		 glArrayBegin);

 gluTessCallback(tobj, GLU_TESS_END,
	  	 glArrayEnd);
 
 gluTessCallback(tobj, GLU_TESS_ERROR,
		 errorCallback);
 
 gluTessBeginPolygon(tobj, NULL);
 
 iNumLines=sectors[s].linecount;
 iDblLines=0;	// MR1006
 for (iLine=0;iLine<iNumLines;iLine++)
   { int i;
   
   i=sectors[s].lines[iLine]->iLineID;
   a_iLineArray[iLine]=i;
   if (modifiedgame)
     {	if (lines[i].frontsector==lines[i].backsector)
       {	// MR1006
				//a_iLinePresent[iLine]=2;
	 a_iLinePresent[iLine]=0;
	 iDblLines++;
       }
     else
       a_iLinePresent[iLine]=1;
     }
   else
     {
#ifdef DOOM_GL	// anti-bug...
       if ((gamemap==22)&&(s==109)&&
	   ((i==530)||(i==607)||(i==542)||(i==610)))
	 {	a_iLinePresent[iLine]=0;
	 iDblLines++;
	 }
       else
	 if ((gameepisode==4)&&(gamemap==3)&&(s==81)&&((i==757)||(i==759)))
	   {	a_iLinePresent[iLine]=0;
	   iDblLines++;
	   }
#elif GL_HEXEN
       if ((gamemap==2)&&(i>1635)&&(i<1660))
	 {	// MR1006
				//a_iLinePresent[iLine]=2;
	   a_iLinePresent[iLine]=0;
	   iDblLines++;
	 }
       else
	 if ((gamemap==8)&&
	     ((i>2147)&&(i<2152))||(i==2141)||(i==2142))
	   {	
	     a_iLinePresent[iLine]=0;
	     iDblLines++;
	   }
	 else
	   if ((gamemap==10)&&(s==89)&&
	       ((i==107)||(i==123)||(i==708)))
	     {	
	       a_iLinePresent[iLine]=0;
	       iDblLines++;
	     }
	   else
	     if ((gamemap==10)&&(s==91)&&
		 ((i==108)||(i==122)))
	       {	
		 a_iLinePresent[iLine]=0;
		 iDblLines++;
	       }
	     else
	       if ((gamemap==10)&&(s==259)&&
		   ((i==1916)||(i==1925)||(i==1047)||((i>1048)&&(i<1053))||(i==1054)||(i==1056)))
		 {	
		   a_iLinePresent[iLine]=0;
		   iDblLines++;
		 }
	       else
		 if ((gamemap==10)&&(s==189))
		   {	gluTessEndPolygon(tobj);
		   
		   gluDeleteTess(tobj);
		   return;
		   }
		 else
		   if ((gamemap==21)&&(s==114)&&
		       ((i==1179)||(i==1169)||
			((i>933)&&(i<938))||((i>946)&&(i<951)||((i>986)&&(i<991)))
			))
		     {	
		       a_iLinePresent[iLine]=0;
		       iDblLines++;
		     }
		   else
#endif
		     if (lines[i].frontsector==lines[i].backsector)
		       {	// MR1006
				//a_iLinePresent[iLine]=2;
			 a_iLinePresent[iLine]=0;
			 iDblLines++;
		       }
		     else
		       a_iLinePresent[iLine]=1;
     }
   }
 
 if (!modifiedgame)
   goto endantibugs;
#ifdef DOOM_GL	// Anti bug Doom1 E1M4 sector 61 :-((
 if ((gameepisode==4)&&(gamemap==1)&&(s==61))
   {	iNumLines+=2;
   a_iLineArray[iLine]=403;
   a_iLinePresent[iLine++]=1;
   a_iLineArray[iLine]=404;
   a_iLinePresent[iLine]=1;
   }
 if ((gameepisode==3)&&(gamemap==8)&&(s==1))	// anti bug E3M8 sectors 1 & 2
   {	iNumLines+=2;
   a_iLineArray[iLine]=57;
   a_iLinePresent[iLine++]=1;
   a_iLineArray[iLine]=21;
   a_iLinePresent[iLine]=1;
   }
 if ((gameepisode==3)&&(gamemap==8)&&(s==2))
   {	gluTessEndPolygon(tobj);
   
   gluDeleteTess(tobj);
   
   lines[57].backsector->iSectorID=1;
   lines[21].frontsector->iSectorID=1;
   return;
   }
 if ((gamemap==21)&&(s==49))
   {	iNumLines+=2;
   a_iLineArray[iLine]=134;
   a_iLinePresent[iLine++]=1;
   a_iLineArray[iLine]=114;
   a_iLinePresent[iLine]=1;
   }
 if ((gamemap==50)||(gamemap==51))
   {	gluTessEndPolygon(tobj);
   
   gluDeleteTess(tobj);
   return;
   }
#elif GL_HEXEN
	if ((gamemap==4)&&((s==140)||(s==152)))
	  {	gluTessEndPolygon(tobj);
	  
	  gluDeleteTess(tobj);
	  return;
	  }
	if ((gamemap==35)&&(s==23))
	  {	iNumLines++;
	  a_iLineArray[iLine]=1414;
	  a_iLinePresent[iLine]=1;
	  }
#else	// heretic
	if ((gameepisode==3)&&(gamemap==4)&&(s==112))
	  {	gluTessEndPolygon(tobj);
	  
	  gluDeleteTess(tobj);
	  return;
	  }
	
#endif
 endantibugs:
	iRemainingLines=iNumLines-iDblLines;
	bAbortSector=FALSE;
	
	while (iRemainingLines)
	  {
	    /* fprintf(stderr,"in fn_vCreatePolygonsForSector- iRemainingLines: %d\n", iRemainingLines); */
	    
	    gluTessBeginContour(tobj);
	    
	    //glColor3f_s(fLightLevel, fLightLevel, fLightLevel);
	    /*iLine=0;
	      while (!a_iLinePresent[iLine]) iLine++;*/
	    iLine=fn_iGetUpperLeftLine(a_iLineArray,a_iLinePresent,iNumLines,s);
	    
	    // MR0906
	    if (lines[a_iLineArray[iLine]].frontsector->iSectorID==s)
	      {
		vStartVertex=lines[a_iLineArray[iLine]].v1;
		vCurrentVertex=lines[a_iLineArray[iLine]].v2;
		a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v1->x/MAP_SCALE;	// x
		a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;		// y
		a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v1->y/MAP_SCALE;	// z
		a_fVertex[1][0]=-(GLdouble)lines[a_iLineArray[iLine]].v2->x/MAP_SCALE;	// x
		a_fVertex[1][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;		// y
		a_fVertex[1][2]=(GLdouble)lines[a_iLineArray[iLine]].v2->y/MAP_SCALE;	// z
	      }
	    else
	      {
		vStartVertex=lines[a_iLineArray[iLine]].v2;
		vCurrentVertex=lines[a_iLineArray[iLine]].v1;
		a_fVertex[1][0]=-(GLdouble)lines[a_iLineArray[iLine]].v1->x/MAP_SCALE;	// x
		a_fVertex[1][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;		// y
		a_fVertex[1][2]=(GLdouble)lines[a_iLineArray[iLine]].v1->y/MAP_SCALE;	// z
		a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v2->x/MAP_SCALE;	// x
		a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;		// y
		a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v2->y/MAP_SCALE;	// z
	      }
	    
	    gluTessVertex(tobj, a_fVertex[0], fn_p_fVertex(a_fVertex[0]/*,fLightLevel*/));
	    gluTessVertex(tobj, a_fVertex[1], fn_p_fVertex(a_fVertex[1]/*,fLightLevel*/));
	    
	    a_iLinePresent[iLine]--;
	    if (!a_iLinePresent[iLine])
	      iRemainingLines--;
	    vLastVertex=NULL;
	    while (vCurrentVertex!=vStartVertex)
	      {	
		// DOOM_GL: anti-bug (CF E1M3: linedefs 933 & 927 !!!)
		if (iLine==iNumLines)
		  { int dist, distMin=0x7fffffff, v=0, iLineMin=0;
		  
		  if (!iRemainingLines)	// Anti-bug 2: Cf MAP02 sector 39
		    {	vCurrentVertex=vStartVertex;
		    continue;
		    }
		  
		  for (iLine=0;iLine<iNumLines;iLine++)				
		    {	
		      if (!a_iLinePresent[iLine])
			continue;
		      if ((dist=VtxDist(lines[a_iLineArray[iLine]].v1,vCurrentVertex))<distMin)
			{
			  distMin=dist;
			  iLineMin=iLine;
			  v=1;
			}
		      if ((dist=VtxDist(lines[a_iLineArray[iLine]].v2,vCurrentVertex))<distMin)
			{
			  distMin=dist;
			  iLineMin=iLine;
			  v=2;
			}
		    }
		  iLine=iLineMin;
		  if (v==1)
		    {	vCurrentVertex=lines[a_iLineArray[iLine]].v2;
		    
		    if (vCurrentVertex!=vStartVertex)
		      {
			a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v2->x/MAP_SCALE;	// x
			a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
			a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v2->y/MAP_SCALE;	// z
			gluTessVertex(tobj, a_fVertex[0], fn_p_fVertex(a_fVertex[0]/*,fLightLevel*/));
		      }
		    
		    //a_iLineArray[iLine]=-1;
		    a_iLinePresent[iLine]--;
		    if (!a_iLinePresent[iLine])
		      iRemainingLines--;
		    }
		  else
		    {
		      vCurrentVertex=lines[a_iLineArray[iLine]].v1;
		      
		      if (vCurrentVertex!=vStartVertex)
			{
			  a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v1->x/MAP_SCALE;	// x
			  a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
			  a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v1->y/MAP_SCALE;	// z
			  gluTessVertex(tobj, a_fVertex[0], fn_p_fVertex(a_fVertex[0]/*,fLightLevel*/));
			}
		      
		      a_iLinePresent[iLine]--;
		      if (!a_iLinePresent[iLine])
			iRemainingLines--;
		    }
		  continue;
		  }
		// End DOOM_GL anti-bug...
		if (vCurrentVertex==vLastVertex)	// Invalid sector (not closed: Cf E1M9)
		  {	bAbortSector=TRUE;
		  break;
		  }
		vLastVertex=vCurrentVertex;
		
		iLineCandidate=-1;	// MR1306
		for (iLine=0;iLine<iNumLines;iLine++)				
		  {	
		    if (!a_iLinePresent[iLine])
		      continue;
		    if (lines[a_iLineArray[iLine]].v1==vCurrentVertex)
		      {
			iLineCandidate=iLine;
			if (lines[a_iLineArray[iLine]].frontsector->iSectorID==s)
			  break;
			/*				
							vCurrentVertex=lines[a_iLineArray[iLine]].v2;
							
							if (vCurrentVertex!=vStartVertex)
							{
							a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v2->x/MAP_SCALE;	// x
							a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
							a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v2->y/MAP_SCALE;	// z
							gluTessVertex(tobj, a_fVertex[0], fn_p_fVertex(a_fVertex[0]));
							}
							
							//a_iLineArray[iLine]=-1;
							a_iLinePresent[iLine]--;
							if (!a_iLinePresent[iLine])
							iRemainingLines--;
							break;*/
		      }
		  }
		// MR1306
		//			if (iLine==iNumLines)
		if (iLineCandidate!=-1)
		  {	vCurrentVertex=lines[a_iLineArray[iLineCandidate]].v2;
		  
		  if (vCurrentVertex!=vStartVertex)
		    {
		      a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLineCandidate]].v2->x/MAP_SCALE;	// x
		      a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
		      a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLineCandidate]].v2->y/MAP_SCALE;	// z
		      gluTessVertex(tobj, a_fVertex[0], fn_p_fVertex(a_fVertex[0]));
		    }
		  
				//a_iLineArray[iLine]=-1;
		  a_iLinePresent[iLineCandidate]--;
		  if (!a_iLinePresent[iLineCandidate])
		    iRemainingLines--;
		  }
		else
		  // End MR1306
		  for (iLine=0;iLine<iNumLines;iLine++)				
		    {
		      /* fprintf(stderr,"in fn_vCreatePolygonsForSector- endLoop - iLine: %d ; iNumLines: %d\n",
			 iLine, iNumLines); */
		      if (!a_iLinePresent[iLine])
			continue;
		      
		      if (lines[a_iLineArray[iLine]].v2==vCurrentVertex)
			{
			  vCurrentVertex=lines[a_iLineArray[iLine]].v1;
			  
			  if (vCurrentVertex!=vStartVertex)
			    {
			      a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v1->x/MAP_SCALE;	// x
			      a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
			      a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v1->y/MAP_SCALE;	// z
			      gluTessVertex(tobj, a_fVertex[0], fn_p_fVertex(a_fVertex[0]/*,fLightLevel*/));
			    }
			  
			  a_iLinePresent[iLine]--;
			  if (!a_iLinePresent[iLine])
			    iRemainingLines--;
			  break;
			}
		    }
	      }
	    gluTessEndContour(tobj);
	    if (bAbortSector)
	      break;
	  }
	gluTessEndPolygon(tobj);
	//glEndList();
	
	gluDeleteTess(tobj);
}

// MR0507
void fn_vComputeBounds(int s)
{ int i,j;
 float fUp,fDown,fLeft,fRight;
 
 for (i=0;i<a_stFCPolygonArray[s].iNbArrays;i++)
   {	fUp=-1e+10;
   fRight=-1e+10;
   fDown=1e+10;
   fLeft=1e+10;
   for (j=0;j<a_stFCPolygonArray[s].p_stVertexArray[i].iNbVertices;j++)
     {
       if (a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2]>fUp)
	 fUp=a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2];
       if (a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2]<fDown)
	 fDown=a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2];
       if (a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3]>fRight)
	 fRight=a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3];
       if (a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3]<fLeft)
	 fLeft=a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3];
     }
   a_stFCPolygonArray[s].p_stVertexArray[i].fUp=fUp;
   a_stFCPolygonArray[s].p_stVertexArray[i].fDown=fDown;
   a_stFCPolygonArray[s].p_stVertexArray[i].fLeft=fLeft;
   a_stFCPolygonArray[s].p_stVertexArray[i].fRight=fRight;
   }
}

#ifdef NDEBUG
#pragma optimize( "", on )
#endif

void fn_vCreateFloorCeilingPolygons()
{ 
  int s;
  
  xMapMin=0x7fffffff;
  xMapMax=-0x7fffffff;
  yMapMin=0x7fffffff;
  yMapMax=-0x7fffffff;
  iAltitudeMin=0x7fffffff;
  iAltitudeMax=-0x7fffffff;
  
  hVertexTmpHeap=HeapCreate(OTHER);
  /* fprintf(stderr, "hVertexTmpHeap: %d\n", hVertexTmpHeap); */
  
  a_iLineArray=(int *)Malloc(sizeof(int)*numlines);
  a_iLinePresent=(int *)Malloc(sizeof(int)*numlines);
  
  a_stFCPolygonArray=(GLFloorCeilingPolygonArray *)Malloc(sizeof(GLFloorCeilingPolygonArray)*numsectors);
  
  a_iGlDrawFloorCeil=(int *)Malloc(sizeof(int)*numlines);
  
  for (s=0; s<numsectors; s++)
    {
      if (sectors[s].ceilingheight>iAltitudeMax)
	iAltitudeMax=sectors[s].ceilingheight;
      if (sectors[s].floorheight<iAltitudeMin)
	iAltitudeMin=sectors[s].floorheight;
      
      iCurrentSector=s;

      /* ANDRE !!! */
      /* fprintf(stderr, "numsectors: %u ; s: %u\n", numsectors, s); */
      /* printSectorInfo(sectors, s); */

      /* E3M1 */
      /* if ((s==8) || (s==14) || (s==49) || (s==103) || (s==105) || (s==106)) { */
      /* E1M1 */
      /* if ((s==6) || (s==34) || (s==52)) {
	printSectorInfo(sectors, s);
      } else { */

      fn_vCreatePolygonsForSector(s);
      // MR0507
      fn_vComputeBounds(s);

      /* } */
  }
  
  HeapDestroy(hVertexTmpHeap);
}

#ifndef M_PI
#  define M_PI (3.1415926f)
#endif
#define TXTR_COORD(x,y)    /*if (qobj->TextureFlag)*/ (*glTexCoord2f_s) (x,y);

void fn_vGetMapExtremities()
{ int i,x,y;

	for (i=0;i<numlines;i++)
	{	x=-lines[i].v1->x;
		y=lines[i].v1->y;
		if (x<xMapMin)
			xMapMin=x;
		if (x>xMapMax)
			xMapMax=x;
		if (y<yMapMin)
			yMapMin=y;
		if (y>yMapMax)
			yMapMax=y;
		x=-lines[i].v2->x;
		y=lines[i].v2->y;
		if (x<xMapMin)
			xMapMin=x;
		if (x>xMapMax)
			xMapMax=x;
		if (y<yMapMin)
			yMapMin=y;
		if (y>yMapMax)
			yMapMax=y;
	}	
}

//#ifndef GL_HEXEN
#if 0		// For 3Dfx Minigl...
void MygluSphere( GLUquadricObj *qobj,
                         GLdouble radius, GLint slices, GLint stacks )
{
   GLfloat rho, drho, theta, dtheta;
   GLfloat x, y, z;
   GLfloat s, t, ds, dt;
   GLint i, j, imin, imax;
   GLboolean normals;
   GLfloat nsign;

   normals = GL_TRUE;
   nsign = -1.0f;

   drho = M_PI / (GLfloat) stacks;
   dtheta = 2.0f * M_PI / (GLfloat) slices;

   /* texturing: s goes from 0.0/0.25/0.5/0.75/1.0 at +y/+x/-y/-x/+y axis */
   /* t goes from -1.0/+1.0 at z = -radius/+radius (linear along longitudes) */
   /* cannot use triangle fan on texturing (s coord. at top/bottom tip varies) */

   //if (qobj->DrawStyle==GLU_FILL)
   {

      //ds = 1.0 / slices;
      //dt = 1.0 / stacks;
      ds = 5.0f / slices;
#ifndef DOOM_GL
      dt = 1.0f / stacks;
#else
	  //dt = 1.2f / stacks;	// DOOM_GL
	  dt = 1.0f / stacks;	// DOOM_GL
#endif
      t = 1.0f;  /* because loop now runs from 0 */
      //if (qobj->TextureFlag)
	  {
        imin = 0;
        imax = stacks;
      }
      /*else
	  {
        imin = 1;
        imax = stacks-1;
      }*/

      /* draw intermediate stacks as quad strips */
      for (i=imin;i<imax;i++)
	  {
		 rho = i * drho;
		 (*glBegin_s) ( GL_QUAD_STRIP );
			 s = 0.0f;
		 for (j=0;j<=slices;j++)
		 {
			theta = (j==slices) ? 0.0f : j * dtheta;
			x = -(float)(sin(theta) * sin(rho));
			y = (float)(cos(theta) * sin(rho));
			z = nsign * (float)cos(rho);
			if (normals)  (*glNormal3f_s) ( x*nsign, y*nsign, z*nsign );
			TXTR_COORD(s,t);
			(*glVertex3f_s) ( x*(float)radius, y*(float)radius, z*(float)radius );
			x = -(float)(sin(theta) * sin(rho+drho));
			y = (float)(cos(theta) * sin(rho+drho));
			z = (float)(nsign * cos(rho+drho));
			if (normals)  (*glNormal3f_s) ( x*nsign, y*nsign, z*nsign );
			TXTR_COORD(s,t-dt);
				s += ds;
			(*glVertex3f_s) ( x*(float)radius, y*(float)radius, z*(float)radius );
		 }
		 (*glEnd_s) ();
		 t -= dt;
	 }

   }
}

extern char szSkyName[4][8];
extern byte *p_bPalette;	// a virer

void fn_vCreateSky(int episode)
{ GLUquadricObj *qObj;
  float fU1,fU2,fV1,fV2,fU1Off,fV2Off;
  int iSubTex,iGLTex;
  float xMapCenter,yMapCenter,zMapCenter;
  float fX,fY,fAlt;

	fn_vGetMapExtremities();

	//xMapCenter=(float)(-xMapMin)/MAP_SCALE+(float)(-xMapMax+xMapMin)/(2*MAP_SCALE);
	xMapCenter=(GLdouble)xMapMin/MAP_SCALE+(GLdouble)(xMapMax-xMapMin)/(2*MAP_SCALE);
	yMapCenter=(GLdouble)iAltitudeMin/MAP_SCALE+(GLdouble)(iAltitudeMax-iAltitudeMin)/(2*MAP_SCALE);
#ifdef DOOM_GL
	zMapCenter=(GLdouble)yMapMin/MAP_SCALE+(GLdouble)(yMapMax-yMapMin)/(2*MAP_SCALE);		// DOOM_GL
#else
	zMapCenter=(GLdouble)yMapMin/MAP_SCALE+5.0f*(GLdouble)(yMapMax-yMapMin)/(6*MAP_SCALE);
#endif

	fAlt=(float)((iAltitudeMax-iAltitudeMin)>>FRACBITS);
	fX=(float)((xMapMax-xMapMin)>>FRACBITS);
	fY=(float)((yMapMax-yMapMin)>>FRACBITS);
	fSkyRadius=(float)sqrt(fX*fX+fY*fY+fAlt*fAlt);
	fSkyRadius*=1.5f/MAP_COEFF;
	fSkyRadius=fSkyRadius>320.0f?fSkyRadius:320.0f;

	iSkyList = (*glGenLists_s) (1);
#ifdef GL_HEXEN
	if (episode==1)
		iSkyList1 = iSkyList;
	else
		iSkyList2 = iSkyList;
#endif
	(*glNewList_s) (iSkyList, GL_COMPILE);

	//fn_vLoadSkyTexture(episode);
	//(*glColor3f_s) (1.0f, 1.0f, 1.0f);
/*	qObj=gluNewQuadric();
	gluQuadricDrawStyle(qObj, GLU_FILL);
	gluQuadricOrientation(qObj,GLU_INSIDE);
	gluQuadricTexture(qObj,GL_TRUE);*/
	
#ifndef GL_HEXEN
	iGLTex=fn_iGetGLTexturef(-2,0,0,&fU1,&fU2,&fV1,&fV2,&fU1Off,&fV2Off,&iSubTex);
	(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iGLTex]);
#else
	if (episode==1)
		(*glBindTexture_s) (GL_TEXTURE_2D, GL_Sky1Texture);
	else
		(*glBindTexture_s) (GL_TEXTURE_2D, GL_Sky2Texture);
#endif
	//(*glColor3f_s) (1.0f, 1.0f, 1.0f);	// MR1405

	(*glMatrixMode_s) (GL_MODELVIEW);
	(*glPushMatrix_s) ();
	(*glLoadIdentity_s) ();
	(*glRotatef_s) (-90.0f,   1.0f, 0.0f, 0.0f);		// -90 for MygluSphere & 90 for gluSphere
	(*glTranslatef_s) (xMapCenter,yMapCenter,zMapCenter);
	
	MygluSphere(qObj,fSkyRadius,10,10);
	(*glPopMatrix_s) ();

	(*glEndList_s) ();
}
#else	// GL_HEXEN
GLSky *GLSky1;

GLSky *MygluSphere( GLdouble radius, GLint slices, GLint stacks )
{
   GLSky *p_stSky;
   GLfloat rho, drho, theta, dtheta;
   GLfloat x, y, z;
   GLfloat s, t, ds, dt;
   GLint i, j, imin, imax;
   GLboolean normals;
   GLfloat nsign;
   GLint iPoint;


   p_stSky=(GLSky *)Malloc(sizeof(GLSky));
   normals = GL_TRUE;
   nsign = -1.0f;

   drho = M_PI / (GLfloat) stacks;
   dtheta = 2.0f * M_PI / (GLfloat) slices;

   /* texturing: s goes from 0.0/0.25/0.5/0.75/1.0 at +y/+x/-y/-x/+y axis */
   /* t goes from -1.0/+1.0 at z = -radius/+radius (linear along longitudes) */
   /* cannot use triangle fan on texturing (s coord. at top/bottom tip varies) */

   {

      ds = 5.0f / slices;
      dt = 1.0f / stacks;
      t = 1.0f;  /* because loop now runs from 0 */
	  {
        imin = 0;
        imax = stacks;
      }

      p_stSky->iNbPoints=(imax-imin)*(slices+1)*2;
	  p_stSky->p_fVertex=(GLfloat *)Malloc(3*p_stSky->iNbPoints*sizeof(GLfloat));
	  p_stSky->p_fNormals=(GLfloat *)Malloc(3*p_stSky->iNbPoints*sizeof(GLfloat));
	  p_stSky->p_fV=(GLfloat *)Malloc(p_stSky->iNbPoints*sizeof(GLfloat));
	  p_stSky->slices=slices;
	  p_stSky->stacks=stacks;
	  iPoint=0;
	  /* draw intermediate stacks as quad strips */
      for (i=imin;i<imax;i++)
	  {
		 rho = i * drho;
		 //(*glBegin_s) ( GL_QUAD_STRIP );
			 s = 0.0f;
		 for (j=0;j<=slices;j++)
		 {
			theta = (j==slices) ? 0.0f : j * dtheta;
			x = -(float)(sin(theta) * sin(rho));
			y = (float)(cos(theta) * sin(rho));
			z = nsign * (float)cos(rho);
			//if (normals)  (*glNormal3f_s) ( x*nsign, y*nsign, z*nsign );
			if (normals)
			{	p_stSky->p_fNormals[3*iPoint]=x*nsign;
				p_stSky->p_fNormals[3*iPoint+1]=y*nsign;
				p_stSky->p_fNormals[3*iPoint+2]=z*nsign;
			}
			//TXTR_COORD(s,t);
			//(*glVertex3f_s) ( x*(float)radius, y*(float)radius, z*(float)radius );
			p_stSky->p_fV[iPoint]=t;
			p_stSky->p_fVertex[3*iPoint]=x*radius;
			p_stSky->p_fVertex[3*iPoint+1]=y*radius;
			p_stSky->p_fVertex[3*iPoint+2]=z*radius;
			iPoint++;

			x = -(float)(sin(theta) * sin(rho+drho));
			y = (float)(cos(theta) * sin(rho+drho));
			z = (float)(nsign * cos(rho+drho));
//			if (normals)  (*glNormal3f_s) ( x*nsign, y*nsign, z*nsign );
			if (normals)
			{	p_stSky->p_fNormals[3*iPoint]=x*nsign;
				p_stSky->p_fNormals[3*iPoint+1]=y*nsign;
				p_stSky->p_fNormals[3*iPoint+2]=z*nsign;
			}
//			TXTR_COORD(s,t-dt);
				s += ds;
//			(*glVertex3f_s) ( x*(float)radius, y*(float)radius, z*(float)radius );
			p_stSky->p_fV[iPoint]=t-dt;
			p_stSky->p_fVertex[3*iPoint]=x*radius;
			p_stSky->p_fVertex[3*iPoint+1]=y*radius;
			p_stSky->p_fVertex[3*iPoint+2]=z*radius;
			iPoint++;
		 }
		 //(*glEnd_s) ();
		 t -= dt;
	 }

   }
   return p_stSky;
}

void fn_vCreateSky(int episode)
{ /* GLUquadricObj *qObj; */
  /* float fU1,fU2,fV1,fV2,fU1Off,fV2Off; */
  /* int iSubTex,iGLTex; */
  float xMapCenter,yMapCenter,zMapCenter;
  float fX,fY,fAlt;

	fn_vGetMapExtremities();

	xMapCenter=(GLdouble)xMapMin/MAP_SCALE+(GLdouble)(xMapMax-xMapMin)/(2*MAP_SCALE);
	yMapCenter=(GLdouble)iAltitudeMin/MAP_SCALE+(GLdouble)(iAltitudeMax-iAltitudeMin)/(2*MAP_SCALE);
	//zMapCenter=(GLdouble)yMapMin/MAP_SCALE+5.0f*(GLdouble)(yMapMax-yMapMin)/(6*MAP_SCALE);
#ifdef DOOM_GL
	zMapCenter=(GLdouble)yMapMin/MAP_SCALE+(GLdouble)(yMapMax-yMapMin)/(2*MAP_SCALE);		// DOOM_GL
#elif GL_HEXEN	
	//zMapCenter=(GLdouble)yMapMin/MAP_SCALE+8.0f*((GLdouble)(yMapMax-yMapMin)/MAP_SCALE);
	zMapCenter=(GLdouble)yMapMin/MAP_SCALE+7.5f*((GLdouble)(yMapMax-yMapMin)/MAP_SCALE);
#else
	zMapCenter=(GLdouble)yMapMin/MAP_SCALE+5.0f*(GLdouble)(yMapMax-yMapMin)/(6*MAP_SCALE);
#endif

	fAlt=(float)((iAltitudeMax-iAltitudeMin)>>FRACBITS);
	fX=(float)((xMapMax-xMapMin)>>FRACBITS);
	fY=(float)((yMapMax-yMapMin)>>FRACBITS);
	fSkyRadius=(float)sqrt(fX*fX+fY*fY+fAlt*fAlt);
	fSkyRadius*=1.5f/MAP_COEFF;
	fSkyRadius=fSkyRadius>320.0f?fSkyRadius:320.0f;
	
	GLSky1=MygluSphere(fSkyRadius,10,10);

	GLSky1->xMapCenter=xMapCenter;
	GLSky1->yMapCenter=yMapCenter;
	GLSky1->zMapCenter=zMapCenter;
#ifdef GL_HEXEN
	GLCurrentSky=1;
#endif
}

void fn_vDrawSky(int index)
{ GLint iPoint,i,j;
  GLfloat ds,s;
  int offset,iTex;

#ifdef GL_HEXEN
	if (index==1)
	{	(*glBindTexture_s) (GL_TEXTURE_2D, GL_Sky1Texture);
		offset = Sky1ColumnOffset>>16;
		iTex=GL_Sky1Texture-1;
	}
	else
	{	(*glBindTexture_s) (GL_TEXTURE_2D, GL_Sky2Texture);
		offset = Sky2ColumnOffset>>16;
		iTex=GL_Sky2Texture-1;
	}
#else
	int iSubTex;
	float fU1,fU2,fV1,fV2,fU1Off,fV2Off;

	iTex=fn_iGetGLTexturef(-2,0,0,&fU1,&fU2,&fV1,&fV2,&fU1Off,&fV2Off,&iSubTex);
	(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iTex]);
	offset=0;
#endif
	(*glMatrixMode_s) (GL_MODELVIEW);
	(*glPushMatrix_s) ();
	(*glLoadIdentity_s) ();
	(*glRotatef_s) (-90.0f,   1.0f, 0.0f, 0.0f);		// -90 for MygluSphere & 90 for gluSphere
	(*glTranslatef_s) (GLSky1->xMapCenter,GLSky1->yMapCenter,GLSky1->zMapCenter);

    iPoint=0;
	ds = 5.0f / GLSky1->slices;

	/* draw intermediate stacks as quad strips */
    for (i=0;i<GLSky1->stacks;i++)
	{
		 (*glBegin_s) ( GL_QUAD_STRIP );
		 //s = 0.0f;
		 s=(float)offset/(float)p_stGLTextures[iTex].iWidth;
		 for (j=0;j<=GLSky1->slices;j++)
		 {
			(*glNormal3f_s) ( GLSky1->p_fNormals[3*iPoint], GLSky1->p_fNormals[3*iPoint+1], GLSky1->p_fNormals[3*iPoint+2] );
			TXTR_COORD(s,GLSky1->p_fV[iPoint]);
			(*glVertex3f_s) ( GLSky1->p_fVertex[3*iPoint], GLSky1->p_fVertex[3*iPoint+1], GLSky1->p_fVertex[3*iPoint+2] );
			iPoint++;

			(*glNormal3f_s) ( GLSky1->p_fNormals[3*iPoint], GLSky1->p_fNormals[3*iPoint+1], GLSky1->p_fNormals[3*iPoint+2] );
			TXTR_COORD(s,GLSky1->p_fV[iPoint]);
			(*glVertex3f_s) ( GLSky1->p_fVertex[3*iPoint], GLSky1->p_fVertex[3*iPoint+1], GLSky1->p_fVertex[3*iPoint+2] );
			iPoint++;
			s += ds;
		 }
		 (*glEnd_s) ();
	 }
	
	(*glPopMatrix_s) ();
}
#endif	// GL_HEXEN

extern long g_bDynLight;
void fn_vRenderSector(int s)
{ int i,j,iGlTex;
  float fLightLevel;
#ifdef GL_HEXEN
  short special; 
  int scrollOffset,xOffset,yOffset;
  float fU,fV;
#endif

   //(*glEnableClientState_s) (GL_VERTEX_ARRAY);
   //(*glEnableClientState_s) (GL_TEXTURE_COORD_ARRAY);

	// MR0207
	//fLightLevel=(float)(sectors[s].lightlevel-iLightLevelMin)/(float)(iLightLevelMax-iLightLevelMin);
	//fLightLevel=(float)sectors[s].lightlevel/255.0f;
	//fLightLevel=(float)(sectors[s].lightlevel-iLightLevelMin/2)/255.0f;
	//fLightLevel=(1.0f+0.25f*(float)usegamma)*((float)sectors[s].lightlevel-0.5f)/512.0f;		// MR0706
	fLightLevel=(1.0f+0.25f*(float)usegamma)*((float)(sectors[s].lightlevel+(extralight<<LIGHTSEGSHIFT))-0.5f)/512.0f;		// MR0706
	//fLightLevel=(1.0f+0.25f*(float)usegamma)*(float)(sectors[s].lightlevel-iLightLevelMin)/(float)(iLightLevelMax-iLightLevelMin);

	if (sectors[s].floorpic==R_FlatNumForName(F_SKY))
	{	
		goto dceiling;
	}
	//iGlTex=a_iGLTexTranslation[fn_iGetGLFlatTexturef(sectors[s].floorpic)];

	/* ANDRE !!! */
	/* printf("POLYDRAW: a_stFCPolygonArray[%d].iFloorTexture: %d\n", s, a_stFCPolygonArray[s].iFloorTexture); */

	iGlTex=a_iGLTexTranslation[a_stFCPolygonArray[s].iFloorTexture];
	(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iGlTex]);

#ifdef GL_HEXEN
	special=sectors[s].special;
	scrollOffset = leveltime>>1&63;
	switch(special)
	{ // Handle scrolling flats
		case 201: case 202: case 203: // Scroll_North_xxx
			/*ds_source = tempSource+((scrollOffset
				<<(pl->special-201)&63)<<6);*/
			xOffset=0;
			yOffset=((63-scrollOffset)<<(special-201)&63);
			break;
		case 204: case 205: case 206: // Scroll_East_xxx
			/*ds_source = tempSource+((63-scrollOffset)
				<<(pl->special-204)&63);*/
			xOffset=(scrollOffset<<(special-204)&63);
			yOffset=0;
			break;
		case 207: case 208: case 209: // Scroll_South_xxx
			/*ds_source = tempSource+(((63-scrollOffset)
				<<(pl->special-207)&63)<<6);*/
			xOffset=0;
			yOffset=(scrollOffset<<(special-207)&63);
			break;
		case 210: case 211: case 212: // Scroll_West_xxx
			/*ds_source = tempSource+(scrollOffset
				<<(pl->special-210)&63);*/
			xOffset=((63-scrollOffset)<<(special-210)&63);
			yOffset=0;
			break;
		case 213: case 214: case 215: // Scroll_NorthWest_xxx
			/*ds_source = tempSource+(scrollOffset
				<<(pl->special-213)&63)+((scrollOffset
				<<(pl->special-213)&63)<<6);*/
			xOffset=((63-scrollOffset)<<(special-213)&63);
			yOffset=((63-scrollOffset)<<(special-213)&63);
			break;
		case 216: case 217: case 218: // Scroll_NorthEast_xxx
			/*ds_source = tempSource+((63-scrollOffset)
				<<(pl->special-216)&63)+((scrollOffset
				<<(pl->special-216)&63)<<6);*/
			xOffset=(scrollOffset<<(special-216)&63);
			yOffset=((63-scrollOffset)<<(special-216)&63);
			break;
		case 219: case 220: case 221: // Scroll_SouthEast_xxx
			/*ds_source = tempSource+((63-scrollOffset)
				<<(pl->special-219)&63)+(((63-scrollOffset)
				<<(pl->special-219)&63)<<6);*/
			xOffset=(scrollOffset<<(special-219)&63);
			yOffset=(scrollOffset<<(special-219)&63);
			break;
		case 222: case 223: case 224: // Scroll_SouthWest_xxx
			/*ds_source = tempSource+(scrollOffset
				<<(pl->special-222)&63)+(((63-scrollOffset)
				<<(pl->special-222)&63)<<6);*/
			xOffset=((63-scrollOffset)<<(special-222)&63);
			yOffset=(scrollOffset<<(special-222)&63);
			break;
		default:
			xOffset=0;
			yOffset=0;
	}
	fU=(float)xOffset/64.0f;
	fV=(float)yOffset/64.0f;
#endif

	/* ANDRE !!! */
	/* printf("POLYDRAW - FRONT a_stFCPolygonArray[%d].iNbArrays: %d\n", s, a_stFCPolygonArray[s].iNbArrays); */

	// MR090699
	(*glCullFace_s) (GL_FRONT);
	
	if (g_bDynLight==1)
	{	
		for (i=0;i<a_stFCPolygonArray[s].iNbArrays;i++)
		{
		  (*glBegin_s) (a_stFCPolygonArray[s].p_stVertexArray[i].mode);
			for (j=0;j<a_stFCPolygonArray[s].p_stVertexArray[i].iNbVertices;j++)
			{	
				GL_DynamicLight4f(a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+1],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2],
							fLightLevel,1.0f );
#ifndef GL_HEXEN
				(*glTexCoord2f_s) (a_stFCPolygonArray[s].p_stVertexArray[i].p_fUV[j*2],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fUV[j*2+1] );
#else
				(*glTexCoord2f_s) (a_stFCPolygonArray[s].p_stVertexArray[i].p_fUV[j*2]+fU,
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fUV[j*2+1]+fV );
#endif
				(*glVertex3f_s) ( a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+1],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2] );
			}
			(*glEnd_s) ();
		}		
	}
	else
	{	GL_StaticLight3f(fLightLevel, fLightLevel, fLightLevel);
		for (i=0;i<a_stFCPolygonArray[s].iNbArrays;i++)
		{	
			//(*glVertexPointer_s) (3, GL_FLOAT, 0, a_stFCPolygonArray[s].p_stVertexArray[i].iNbVertices, a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex);
			//(*glTexCoordPointer_s) (2, GL_FLOAT, 0, a_stFCPolygonArray[s].p_stVertexArray[i].iNbVertices, a_stFCPolygonArray[s].p_stVertexArray[i].p_fUV);
			//(*glDrawArrays_s) (a_stFCPolygonArray[s].p_stVertexArray[i].mode,0,a_stFCPolygonArray[s].p_stVertexArray[i].iNbVertices);
			(*glBegin_s) (a_stFCPolygonArray[s].p_stVertexArray[i].mode);
			for (j=0;j<a_stFCPolygonArray[s].p_stVertexArray[i].iNbVertices;j++)
			{	
				//(*glArrayElement_s) (j);
#ifndef GL_HEXEN
				(*glTexCoord2f_s) (a_stFCPolygonArray[s].p_stVertexArray[i].p_fUV[j*2],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fUV[j*2+1] );
#else
				(*glTexCoord2f_s) (a_stFCPolygonArray[s].p_stVertexArray[i].p_fUV[j*2]+fU,
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fUV[j*2+1]+fV );
#endif
				(*glVertex3f_s) ( a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+1],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2] );
			}
			(*glEnd_s) ();
		}		
	}
dceiling:

	/* ANDRE !!! */
	/* printf("POLYDRAW - BACK a_stFCPolygonArray[%d].iNbArrays: %d\n", s, a_stFCPolygonArray[s].iNbArrays); */

	// MR090699
	(*glCullFace_s) (GL_BACK);

 	if (sectors[s].ceilingpic==R_FlatNumForName(F_SKY))
	{	
		//return;
		goto dynlight;
	}
	//iGlTex=a_iGLTexTranslation[fn_iGetGLFlatTexturef(sectors[s].ceilingpic)];
	iGlTex=a_iGLTexTranslation[a_stFCPolygonArray[s].iCeilingTexture];
	(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iGlTex]);
	
	if (g_bDynLight==1)
	{	
		for (i=0;i<a_stFCPolygonArray[s].iNbArrays;i++)
		{	
		  (*glBegin_s) (a_stFCPolygonArray[s].p_stVertexArray[i].mode);
			for (j=0;j<a_stFCPolygonArray[s].p_stVertexArray[i].iNbVertices;j++)
			{	
				GL_DynamicLight4f(a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fCeiling[j],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2],
							fLightLevel,1.0f );
				(*glTexCoord2f_s) (a_stFCPolygonArray[s].p_stVertexArray[i].p_fUV[j*2],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fUV[j*2+1] );
				(*glVertex3f_s) ( a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fCeiling[j],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2] );
			}
			(*glEnd_s) ();
		}		
	}
	else
	{	
		for (i=0;i<a_stFCPolygonArray[s].iNbArrays;i++)
		{	
			(*glBegin_s) (a_stFCPolygonArray[s].p_stVertexArray[i].mode);
			for (j=0;j<a_stFCPolygonArray[s].p_stVertexArray[i].iNbVertices;j++)
			{	
				(*glTexCoord2f_s) (a_stFCPolygonArray[s].p_stVertexArray[i].p_fUV[j*2],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fUV[j*2+1] );
				(*glVertex3f_s) ( a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fCeiling[j],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2] );
			}
			(*glEnd_s) ();
		}		
	}
dynlight:
	if (g_bDynLight==2)
		GL_DrawLightForFloorCeiling(s);
   //(*glDisableClientState_s) (GL_VERTEX_ARRAY);
   //(*glDisableClientState_s) (GL_TEXTURE_COORD_ARRAY);
}

#ifdef GL_HEXEN
GLint GL_vRegisterFlatTextureOnTheFly(int iTexNum);
#endif

void GL_vSetFloorTexture(int iSectorID,int texture)
{
#ifndef GL_HEXEN	// MR0309
	a_stFCPolygonArray[iSectorID].iFloorTexture=fn_iGetGLFlatTexturef(texture);
#else
	if ((a_stFCPolygonArray[iSectorID].iFloorTexture=fn_iIsFlatTextureRegistered(texture))==-1)
	{	a_stFCPolygonArray[iSectorID].iFloorTexture=GL_vRegisterFlatTextureOnTheFly(texture);
		fn_vCheckIfFlatIsAnimated(texture);
	}
#endif
}
#ifdef GL_HEXEN
void GL_vSetCeilingTexture(int iSectorID,int texture)
{
	//a_stFCPolygonArray[iSectorID].iCeilingTexture=fn_iGetGLFlatTexturef(texture);
	if ((a_stFCPolygonArray[iSectorID].iCeilingTexture=fn_iIsFlatTextureRegistered(texture))==-1)
	{	a_stFCPolygonArray[iSectorID].iCeilingTexture=GL_vRegisterFlatTextureOnTheFly(texture);
		fn_vCheckIfFlatIsAnimated(texture);
	}
}

void fn_vUpdateFloorCeilingTexturesFromSavedGame()
{ int s;

	for (s=0;s<numsectors;s++)
	{
		GL_vSetFloorTexture(s,sectors[s].floorpic);
		GL_vSetCeilingTexture(s,sectors[s].ceilingpic);
	}
}
#endif

#if 0
void fn_vCreateFloorPolygons()
{ 
  int s;

	//bFloorCompute=TRUE;

	//a_stFloorCeiling=(GLFloorCeiling *)Malloc(sizeof(GLFloorCeiling)*numsectors);
	a_iLineArray=(int *)Malloc(sizeof(int)*numlines);
	a_iLinePresent=(int *)Malloc(sizeof(int)*numlines);
	
	//a_stFloorVertexesArray=(FloorCeilVertexesArray *)Malloc(sizeof(FloorCeilVertexesArray)*numsectors);
	//a_stFCPolygons=(GLFloorCeilPolygon *)Malloc(sizeof(GLFloorCeilPolygon)*numsectors);
	a_stFCPolygonArray=(GLFloorCeilingPolygonArray *)Malloc(sizeof(GLFloorCeilingPolygonArray)*numsectors);
	
	a_iGlDrawFloorCeil=(int *)Malloc(sizeof(int)*numlines);;

	//startFloorList = glGenLists(numsectors);
	for (s=0;s<numsectors;s++)
	{
		if (sectors[s].ceilingheight>iAltitudeMax)
			iAltitudeMax=sectors[s].ceilingheight;
		if (sectors[s].floorheight<iAltitudeMin)
			iAltitudeMin=sectors[s].floorheight;

		iCurrentSector=s;
		//a_stFloorVertexesArray[s].p_fFloor=(GLfloat **)Malloc(sizeof(GLfloat *));
		//a_stFloorVertexesArray[s].p_fCeiling=(GLfloat **)Malloc(sizeof(GLfloat *));
				
		//fn_vGeneratePolygonForSector(s);
		//fn_vCreateFloorPolygonsForSector(s);
		fn_vCreateFloorPolygonsForSectorWithArrays(s);

		//a_stFloorVertexesArray[s].iNbPoints=iNbPoints;
	}
}

void GLCALLBACK vertexCallback(GLvoid *vertex)
{ GLfloat *fVertex,fU,fV;

	fVertex=(GLfloat *)vertex;
	//fU=(float)(fVertex[0]*MAP_SCALE/*-iXMin*/)/FLAT_TEX_SIZE;
	//fV=(float)(/*iYMax-*/fVertex[2]*MAP_SCALE)/FLAT_TEX_SIZE;
	fU=(float)(fVertex[0]*(MAP_SCALE>>FRACBITS))/FLAT_TEX_SIZE;
	fV=(float)(fVertex[2]*(MAP_SCALE>>FRACBITS))/FLAT_TEX_SIZE;
	(*glTexCoord2f_s) (fU,fV);
	(*glVertex3fv_s) (fVertex);
}

void fn_vAddVertexToContour(GLContour *p_stContour,GLdouble *p_fVertex)
{
	p_stContour->iNbVertexes++;
	p_stContour->p_fVertex=(GLVertex *)Realloc(p_stContour->p_fVertex,p_stContour->iNbVertexes*sizeof(GLVertex));
	p_stContour->p_fVertex[p_stContour->iNbVertexes-1].a_fCoord[0]=p_fVertex[0];
	p_stContour->p_fVertex[p_stContour->iNbVertexes-1].a_fCoord[1]=p_fVertex[2];
}

void fn_vAddContourToPolygon(GLFloorCeilPolygon *p_stPolygon)
{
	p_stPolygon->iNbContours++;
	p_stPolygon->p_stContours=(GLContour *)Realloc(p_stPolygon->p_stContours,p_stPolygon->iNbContours*sizeof(GLContour));
	p_stPolygon->p_stContours[p_stPolygon->iNbContours-1].iNbVertexes=0;
	p_stPolygon->p_stContours[p_stPolygon->iNbContours-1].p_fVertex=(GLVertex *)Malloc(sizeof(GLVertex));
}

void fn_vGeneratePolygonForSector(int s)
{ 
  int iLine/*,iCurrentVertex,iStartVertex*/,iRemainingLines,iNumLines;
  vertex_t *vCurrentVertex,*vStartVertex,*vLastVertex;
  //int *a_iLineArray,*a_iLinePresent;
  GLdouble a_fVertex[2][3];
  //int iLastVertex;
  GLboolean bAbortSector;

	iNbPoints=0;
			
	a_stFCPolygons[s].iNbContours=0;
	a_stFCPolygons[s].p_stContours=(GLContour *)Malloc(sizeof(GLContour));
	
	if (sectors[s].floorpic==R_FlatNumForName(F_SKY))
	{	(*glEndList_s) ();
		return;
	}

	iNumLines=sectors[s].linecount;
	for (iLine=0;iLine<iNumLines;iLine++)
	{ int i;

		i=sectors[s].lines[iLine]->iLineID;

		a_iLineArray[iLine]=i;
		if (lines[i].frontsector==lines[i].backsector)
			a_iLinePresent[iLine]=2;
		else
			a_iLinePresent[iLine]=1;
	}
	
	iRemainingLines=iNumLines;
	bAbortSector=FALSE;
	while (iRemainingLines)
	{
		fn_vAddContourToPolygon(a_stFCPolygons+s);

		/*iLine=0;
		while (!a_iLinePresent[iLine]) iLine++;*/
		iLine=fn_iGetUpperLeftLine(a_iLineArray,a_iLinePresent,iNumLines);

		vStartVertex=lines[a_iLineArray[iLine]].v1;
		vCurrentVertex=lines[a_iLineArray[iLine]].v2;
		a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v1->x/MAP_SCALE;	// x
		a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;				// y
		a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v1->y/MAP_SCALE;	// z
		a_fVertex[1][0]=-(GLdouble)lines[a_iLineArray[iLine]].v2->x/MAP_SCALE;	// x
		a_fVertex[1][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;				// y
		a_fVertex[1][2]=(GLdouble)lines[a_iLineArray[iLine]].v2->y/MAP_SCALE;	// z
		
		fn_vAddVertexToContour(&a_stFCPolygons[s].p_stContours[a_stFCPolygons[s].iNbContours-1],a_fVertex[0]);
		fn_vAddVertexToContour(&a_stFCPolygons[s].p_stContours[a_stFCPolygons[s].iNbContours-1],a_fVertex[1]);

		a_iLinePresent[iLine]--;
		if (!a_iLinePresent[iLine])
			iRemainingLines--;

		vLastVertex=NULL;
		while (vCurrentVertex!=vStartVertex)
		{	if (vCurrentVertex==vLastVertex)	// Invalid sector (not closed: Cf E1M9)
			{	bAbortSector=TRUE;
				break;
			}
			vLastVertex=vCurrentVertex;

			for (iLine=0;iLine<iNumLines;iLine++)				
			{	//if (a_iLineArray[iLine]==-1)
				if (!a_iLinePresent[iLine])
					continue;
				if (lines[a_iLineArray[iLine]].v1==vCurrentVertex)
				{
					vCurrentVertex=lines[a_iLineArray[iLine]].v2;

					if (vCurrentVertex!=vStartVertex)
					{
						/*a_fVertex[0][0]=-(GLdouble)vertexes[lines[a_iLineArray[iLine]].v2].x/MAP_SCALE;	// x
						a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
						a_fVertex[0][2]=(GLdouble)vertexes[lines[a_iLineArray[iLine]].v2].y/MAP_SCALE;	// z*/
						a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v2->x/MAP_SCALE;	// x
						a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
						a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v2->y/MAP_SCALE;	// z
						fn_vAddVertexToContour(&a_stFCPolygons[s].p_stContours[a_stFCPolygons[s].iNbContours-1],a_fVertex[0]);

					}

					//a_iLineArray[iLine]=-1;
					a_iLinePresent[iLine]--;
					if (!a_iLinePresent[iLine])
						iRemainingLines--;
					break;
				}
				if (lines[a_iLineArray[iLine]].v2==vCurrentVertex)
				{
					vCurrentVertex=lines[a_iLineArray[iLine]].v1;
					
					if (vCurrentVertex!=vStartVertex)
					{
						/*a_fVertex[0][0]=-(GLdouble)vertexes[lines[a_iLineArray[iLine]].v1].x/MAP_SCALE;	// x
						a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
						a_fVertex[0][2]=(GLdouble)vertexes[lines[a_iLineArray[iLine]].v1].y/MAP_SCALE;	// z*/
						a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v1->x/MAP_SCALE;	// x
						a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
						a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v1->y/MAP_SCALE;	// z
						fn_vAddVertexToContour(&a_stFCPolygons[s].p_stContours[a_stFCPolygons[s].iNbContours-1],a_fVertex[0]);
					}

					//a_iLineArray[iLine]=-1;
					a_iLinePresent[iLine]--;
					if (!a_iLinePresent[iLine])
						iRemainingLines--;
					break;
				}
			}
		}
		if (bAbortSector)
			break;
	}
}


void Oldfn_vCreateFloorPolygonsForSectorWithArrays(int s)
{ GLUtesselator *tobj;
  int iLine/*,iCurrentVertex,iStartVertex*/,iRemainingLines,iNumLines;
  vertex_t *vCurrentVertex,*vStartVertex,*vLastVertex;
  //int *a_iLineArray,*a_iLinePresent;
  GLdouble a_fVertex[2][3];
  int iGlTex,i,j;
  float fLightLevel;
  //int iLastVertex;
  GLboolean bAbortSector;

	tobj = gluNewTess();

	iCurrentSector=s;
	a_stFCPolygonArray[s].iNbArrays=0;
	a_stFCPolygonArray[s].p_stVertexArray=(GLVertexArray *)Malloc(sizeof(GLVertexArray));
	
	//fLightLevel=(float)(sectors[s].lightlevel-iLightLevelMin)/(float)(iLightLevelMax-iLightLevelMin);

	//a_stFloorCeiling[s].iFloorCallList=startFloorList+s;
	
	gluTessCallback(tobj, GLU_TESS_VERTEX, 
					   vertexArrayCallback);
	gluTessCallback(tobj, GLU_TESS_BEGIN, 
					   glArrayBegin);
	gluTessCallback(tobj, GLU_TESS_END, 
			                   glArrayEnd);
	gluTessCallback(tobj, GLU_TESS_ERROR, 
					   errorCallback);
	
	/*(*glNewList_s) (startFloorList+s, GL_COMPILE);

	if (sectors[s].floorpic==R_FlatNumForName("F_SKY1"))
	{	(*glEndList_s) ();
		return;
	}
	iGlTex=fn_iGetGLFlatTexturef(sectors[s].floorpic);
	(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iGlTex]);*/

	gluTessBeginPolygon(tobj, NULL);
	
	for (i=0;i<a_stFCPolygons[s].iNbContours;i++)
	{
		gluTessBeginContour(tobj);

		//(*glColor3f_s) (fLightLevel, fLightLevel, fLightLevel);

		for (j=0;j<a_stFCPolygons[s].p_stContours[i].iNbVertexes;j++)
		{	a_fVertex[0][0]=a_stFCPolygons[s].p_stContours[i].p_fVertex[j].a_fCoord[0];
			a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;
			a_fVertex[0][2]=a_stFCPolygons[s].p_stContours[i].p_fVertex[j].a_fCoord[1];
			
			gluTessVertex(tobj, a_fVertex[0], fn_p_fVertex(a_fVertex[0]/*,fLightLevel*/));
		}
		gluTessEndContour(tobj);
	}
	gluTessEndPolygon(tobj);
//	(*glEndList_s) ();

	gluDeleteTess(tobj);
}

void fn_vCreateFloorPolygonsForSector(int s)
{ GLUtesselator *tobj;
  int iLine/*,iCurrentVertex,iStartVertex*/,iRemainingLines,iNumLines;
  vertex_t *vCurrentVertex,*vStartVertex,*vLastVertex;
  //int *a_iLineArray,*a_iLinePresent;
  GLdouble a_fVertex[2][3];
  int iGlTex,i,j;
  float fLightLevel;
  //int iLastVertex;
  GLboolean bAbortSector;

	tobj = gluNewTess();

	//fLightLevel=(float)sectors[s].lightlevel/255;
	fLightLevel=(float)(sectors[s].lightlevel-iLightLevelMin)/(float)(iLightLevelMax-iLightLevelMin);

	a_stFloorCeiling[s].iFloorCallList=startFloorList+s;
	
	gluTessCallback(tobj, GLU_TESS_VERTEX, 
					   vertexCallback);
	gluTessCallback(tobj, GLU_TESS_BEGIN, 
					   glBegin);
	gluTessCallback(tobj, GLU_TESS_END, 
					   glEnd);
	gluTessCallback(tobj, GLU_TESS_ERROR, 
					   errorCallback);
	
	(*glNewList_s) (startFloorList+s, GL_COMPILE);

	//if (!strncmp(sectors[s].floorpic,"F_SKY1",8))
	if (sectors[s].floorpic==R_FlatNumForName(F_SKY))
	{	(*glEndList_s) ();
		return;
	}
	iGlTex=fn_iGetGLFlatTexturef(sectors[s].floorpic);
	(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iGlTex]);

	gluTessBeginPolygon(tobj, NULL);
	
	for (i=0;i<a_stFCPolygons[s].iNbContours;i++)
	{
		gluTessBeginContour(tobj);

		GL_StaticLight3f(fLightLevel, fLightLevel, fLightLevel);

		for (j=0;j<a_stFCPolygons[s].p_stContours[i].iNbVertexes;j++)
		{	a_fVertex[0][0]=a_stFCPolygons[s].p_stContours[i].p_fVertex[j].a_fCoord[0];
			a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;
			a_fVertex[0][2]=a_stFCPolygons[s].p_stContours[i].p_fVertex[j].a_fCoord[1];
			
			gluTessVertex(tobj, a_fVertex[0], fn_p_fVertex(a_fVertex[0]/*,fLightLevel*/));
		}
		gluTessEndContour(tobj);
	}
	gluTessEndPolygon(tobj);
	(*glEndList_s) ();

	gluDeleteTess(tobj);
}

void Oldfn_vCreateFloorPolygonsForSector(int s)
{ GLUtesselator *tobj;
  int iLine/*,iCurrentVertex,iStartVertex*/,iRemainingLines,iNumLines;
  vertex_t *vCurrentVertex,*vStartVertex,*vLastVertex;
  //int *a_iLineArray,*a_iLinePresent;
  GLdouble a_fVertex[2][3];
  int iGlTex;
  float fLightLevel;
  //int iLastVertex;
  GLboolean bAbortSector;

	tobj = gluNewTess();

	iNbPoints=0;
	
	//fLightLevel=(float)sectors[s].lightlevel/255;
	fLightLevel=(float)(sectors[s].lightlevel-iLightLevelMin)/(float)(iLightLevelMax-iLightLevelMin);

	a_stFloorCeiling[s].iFloorCallList=startFloorList+s;
	
	gluTessCallback(tobj, GLU_TESS_VERTEX, 
					   vertexCallback);
	gluTessCallback(tobj, GLU_TESS_BEGIN, 
					   glBegin);
	gluTessCallback(tobj, GLU_TESS_END, 
					   glEnd);
	gluTessCallback(tobj, GLU_TESS_ERROR, 
					   errorCallback);
	
	(*glNewList_s) (startFloorList+s, GL_COMPILE);

	//if (!strncmp(sectors[s].floorpic,"F_SKY1",8))
	if (sectors[s].floorpic==R_FlatNumForName(F_SKY))
	{	(*glEndList_s) ();
		return;
	}
	iGlTex=fn_iGetGLFlatTexturef(sectors[s].floorpic);
	(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iGlTex]);

	gluTessBeginPolygon(tobj, NULL);

	iNumLines=sectors[s].linecount;
	for (iLine=0;iLine<iNumLines;iLine++)
	{ int i;

#ifdef GL_HERETIC
		i=sectors[s].lines[iLine]->iLineID;
#endif
		a_iLineArray[iLine]=i;
		if (lines[i].frontsector==lines[i].backsector)
			a_iLinePresent[iLine]=2;
		else
			a_iLinePresent[iLine]=1;
	}
	/*iNumLines=0;
	for (iLine=0;iLine<numlines;iLine++)
		//if ((sides[lines[iLine].sidenum[0]].sector==&sectors[s])||
		//	((lines[iLine].sidenum[1]!=-1)&&(sides[lines[iLine].sidenum[1]].sector==&sectors[s])))
		if ((lines[iLine].frontsector==&sectors[s])||
			(lines[iLine].backsector==&sectors[s]))
		{	a_iLineArray[iNumLines++]=iLine;
			//if ((lines[iLine].sidenum[1]!=-1)&&
			//	(sides[lines[iLine].sidenum[0]].sector==sides[lines[iLine].sidenum[1]].sector))
			if (lines[iLine].frontsector==lines[iLine].backsector)
				a_iLinePresent[iNumLines-1]=2;
			else
				a_iLinePresent[iNumLines-1]=1;
		}*/
	
	iRemainingLines=iNumLines;
	bAbortSector=FALSE;
	while (iRemainingLines)
	{
		gluTessBeginContour(tobj);

		GL_StaticLight3f(fLightLevel, fLightLevel, fLightLevel);
		iLine=0;
		while (!a_iLinePresent[iLine]) iLine++;
		//iLine=fn_iGetUpperLeftLine(a_iLineArray,a_iLinePresent,iNumLines);

/*			iStartVertex=lines[a_iLineArray[iLine]].v1;
		iCurrentVertex=lines[a_iLineArray[iLine]].v2;
		a_fVertex[0][0]=-(GLdouble)vertexes[lines[a_iLineArray[iLine]].v1].x/MAP_SCALE;	// x
		a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
		a_fVertex[0][2]=(GLdouble)vertexes[lines[a_iLineArray[iLine]].v1].y/MAP_SCALE;	// z
		a_fVertex[1][0]=-(GLdouble)vertexes[lines[a_iLineArray[iLine]].v2].x/MAP_SCALE;	// x
		a_fVertex[1][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
		a_fVertex[1][2]=(GLdouble)vertexes[lines[a_iLineArray[iLine]].v2].y/MAP_SCALE;	// z*/
		vStartVertex=lines[a_iLineArray[iLine]].v1;
		vCurrentVertex=lines[a_iLineArray[iLine]].v2;
		a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v1->x/MAP_SCALE;	// x
		a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;				// y
		a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v1->y/MAP_SCALE;	// z
		a_fVertex[1][0]=-(GLdouble)lines[a_iLineArray[iLine]].v2->x/MAP_SCALE;	// x
		a_fVertex[1][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;				// y
		a_fVertex[1][2]=(GLdouble)lines[a_iLineArray[iLine]].v2->y/MAP_SCALE;	// z
		
		gluTessVertex(tobj, a_fVertex[0], fn_p_fVertex(a_fVertex[0]/*,fLightLevel*/));
		gluTessVertex(tobj, a_fVertex[1], fn_p_fVertex(a_fVertex[1]/*,fLightLevel*/));

		//a_iLineArray[iLine]=-1;
		a_iLinePresent[iLine]--;
		if (!a_iLinePresent[iLine])
			iRemainingLines--;
		//iLastVertex=-1;
		vLastVertex=NULL;
		while (vCurrentVertex!=vStartVertex)
		{	if (vCurrentVertex==vLastVertex)	// Invalid sector (not closed: Cf E1M9)
			{	bAbortSector=TRUE;
				break;
			}
			vLastVertex=vCurrentVertex;

			for (iLine=0;iLine<iNumLines;iLine++)				
			{	//if (a_iLineArray[iLine]==-1)
				if (!a_iLinePresent[iLine])
					continue;
				if (lines[a_iLineArray[iLine]].v1==vCurrentVertex)
				{
					vCurrentVertex=lines[a_iLineArray[iLine]].v2;

					if (vCurrentVertex!=vStartVertex)
					{
						/*a_fVertex[0][0]=-(GLdouble)vertexes[lines[a_iLineArray[iLine]].v2].x/MAP_SCALE;	// x
						a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
						a_fVertex[0][2]=(GLdouble)vertexes[lines[a_iLineArray[iLine]].v2].y/MAP_SCALE;	// z*/
						a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v2->x/MAP_SCALE;	// x
						a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
						a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v2->y/MAP_SCALE;	// z
						gluTessVertex(tobj, a_fVertex[0], fn_p_fVertex(a_fVertex[0]/*,fLightLevel*/));
					}

					//a_iLineArray[iLine]=-1;
					a_iLinePresent[iLine]--;
					if (!a_iLinePresent[iLine])
						iRemainingLines--;
					break;
				}
				if (lines[a_iLineArray[iLine]].v2==vCurrentVertex)
				{
					vCurrentVertex=lines[a_iLineArray[iLine]].v1;
					
					if (vCurrentVertex!=vStartVertex)
					{
						/*a_fVertex[0][0]=-(GLdouble)vertexes[lines[a_iLineArray[iLine]].v1].x/MAP_SCALE;	// x
						a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
						a_fVertex[0][2]=(GLdouble)vertexes[lines[a_iLineArray[iLine]].v1].y/MAP_SCALE;	// z*/
						a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v1->x/MAP_SCALE;	// x
						a_fVertex[0][1]=(GLdouble)sectors[s].floorheight/MAP_SCALE;						// y
						a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v1->y/MAP_SCALE;	// z
						gluTessVertex(tobj, a_fVertex[0], fn_p_fVertex(a_fVertex[0]/*,fLightLevel*/));
					}

					//a_iLineArray[iLine]=-1;
					a_iLinePresent[iLine]--;
					if (!a_iLinePresent[iLine])
						iRemainingLines--;
					break;
				}
			}
		}
		gluTessEndContour(tobj);
		if (bAbortSector)
			break;
	}
	gluTessEndPolygon(tobj);
	(*glEndList_s) ();

	gluDeleteTess(tobj);
}


// --- Must be called after FLOOR ---
void fn_vCreateCeilingPolygonsForSector(int s)
{ GLUtesselator *tobj;
  int iLine/*,iCurrentVertex,iStartVertex*/,iRemainingLines,iNumLines;
  vertex_t *vCurrentVertex,*vStartVertex,*vLastVertex;
  GLdouble a_fVertex[2][3];
  int iGlTex;
  float fLightLevel;
  //int iLastVertex;
  GLboolean bAbortSector;
	
	tobj = gluNewTess();
	
	iNbPoints=0;

	//fLightLevel=(float)sectors[s].lightlevel/255;
	fLightLevel=(float)(sectors[s].lightlevel-iLightLevelMin)/(float)(iLightLevelMax-iLightLevelMin);

	a_stFloorCeiling[s].iCeilingCallList=startCeilingList+s;
	
	gluTessCallback(tobj, GLU_TESS_VERTEX, 
					   vertexCallback);
	gluTessCallback(tobj, GLU_TESS_BEGIN, 
					   glBegin);
	gluTessCallback(tobj, GLU_TESS_END, 
					   glEnd);
	gluTessCallback(tobj, GLU_TESS_ERROR, 
					   errorCallback);
	
	(*glNewList_s) (startCeilingList+s, GL_COMPILE);

	//if (!strncmp(sectors[s].ceilingpic,"F_SKY1",8))
	if (sectors[s].ceilingpic==R_FlatNumForName(F_SKY))
	{	(*glEndList_s) ();
		return;
	}
	iGlTex=fn_iGetGLFlatTexturef(sectors[s].ceilingpic);
	(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iGlTex]);

	gluTessBeginPolygon(tobj, NULL);

	iNumLines=0;
	for (iLine=0;iLine<numlines;iLine++)
		if ((lines[iLine].frontsector==&sectors[s])||
			(lines[iLine].backsector==&sectors[s]))
		{	a_iLineArray[iNumLines++]=iLine;
			//if ((lines[iLine].sidenum[1]!=-1)&&
			//	(sides[lines[iLine].sidenum[0]].sector==sides[lines[iLine].sidenum[1]].sector))
			if (lines[iLine].frontsector==lines[iLine].backsector)
				a_iLinePresent[iNumLines-1]=2;
			else
				a_iLinePresent[iNumLines-1]=1;
		}
	
	iRemainingLines=iNumLines;
	while (iRemainingLines)
	{
		gluTessBeginContour(tobj);

		GL_StaticLight3f(fLightLevel, fLightLevel, fLightLevel);
		/*iLine=0;
		while (a_iLineArray[iLine]==-1) iLine++;*/
		iLine=fn_iGetUpperLeftLine(a_iLineArray,a_iLinePresent,iNumLines);

		vStartVertex=lines[a_iLineArray[iLine]].v1;
		vCurrentVertex=lines[a_iLineArray[iLine]].v2;
		/*a_fVertex[0][0]=-(GLdouble)vertexes[lines[a_iLineArray[iLine]].v1].x/MAP_SCALE;	// x
		a_fVertex[0][1]=(GLdouble)sectors[s].ceilingheight/MAP_SCALE;						// y
		a_fVertex[0][2]=(GLdouble)vertexes[lines[a_iLineArray[iLine]].v1].y/MAP_SCALE;	// z
		a_fVertex[1][0]=-(GLdouble)vertexes[lines[a_iLineArray[iLine]].v2].x/MAP_SCALE;	// x
		a_fVertex[1][1]=(GLdouble)sectors[s].ceilingheight/MAP_SCALE;						// y
		a_fVertex[1][2]=(GLdouble)vertexes[lines[a_iLineArray[iLine]].v2].y/MAP_SCALE;	// z*/
		a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v1->x/MAP_SCALE;	// x
		a_fVertex[0][1]=(GLdouble)sectors[s].ceilingheight/MAP_SCALE;			// y
		a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v1->y/MAP_SCALE;	// z
		a_fVertex[1][0]=-(GLdouble)lines[a_iLineArray[iLine]].v2->x/MAP_SCALE;	// x
		a_fVertex[1][1]=(GLdouble)sectors[s].ceilingheight/MAP_SCALE;			// y
		a_fVertex[1][2]=(GLdouble)lines[a_iLineArray[iLine]].v2->y/MAP_SCALE;	// z
		
		gluTessVertex(tobj, a_fVertex[0], fn_p_fVertex(a_fVertex[0]/*,fLightLevel*/));
		gluTessVertex(tobj, a_fVertex[1], fn_p_fVertex(a_fVertex[1]/*,fLightLevel*/));
		//a_iLineArray[iLine]=-1;
		a_iLinePresent[iLine]--;
		if (!a_iLinePresent[iLine])
			iRemainingLines--;
		while (vCurrentVertex!=vStartVertex)
		{	if (vCurrentVertex==vLastVertex)
			{	bAbortSector=TRUE;
				break;
			}
			vLastVertex=vCurrentVertex;

			for (iLine=0;iLine<iNumLines;iLine++)				
			{	//if (a_iLineArray[iLine]==-1)
				if (!a_iLinePresent[iLine])
					continue;
				if (lines[a_iLineArray[iLine]].v1==vCurrentVertex)
				{
					vCurrentVertex=lines[a_iLineArray[iLine]].v2;

					if (vCurrentVertex!=vStartVertex)
					{
						/*a_fVertex[0][0]=-(GLdouble)vertexes[lines[a_iLineArray[iLine]].v2].x/MAP_SCALE;	// x
						a_fVertex[0][1]=(GLdouble)sectors[s].ceilingheight/MAP_SCALE;						// y
						a_fVertex[0][2]=(GLdouble)vertexes[lines[a_iLineArray[iLine]].v2].y/MAP_SCALE;	// z*/
						a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v2->x/MAP_SCALE;	// x
						a_fVertex[0][1]=(GLdouble)sectors[s].ceilingheight/MAP_SCALE;						// y
						a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v2->y/MAP_SCALE;	// z
						gluTessVertex(tobj, a_fVertex[0], fn_p_fVertex(a_fVertex[0]/*,fLightLevel*/));
					}

					//a_iLineArray[iLine]=-1;
					a_iLinePresent[iLine]--;
					if (!a_iLinePresent[iLine])
						iRemainingLines--;
					break;
				}
				if (lines[a_iLineArray[iLine]].v2==vCurrentVertex)
				{
					vCurrentVertex=lines[a_iLineArray[iLine]].v1;
					
					if (vCurrentVertex!=vStartVertex)
					{
						/*a_fVertex[0][0]=-(GLdouble)vertexes[lines[a_iLineArray[iLine]].v1].x/MAP_SCALE;	// x
						a_fVertex[0][1]=(GLdouble)sectors[s].ceilingheight/MAP_SCALE;						// y
						a_fVertex[0][2]=(GLdouble)vertexes[lines[a_iLineArray[iLine]].v1].y/MAP_SCALE;	// z*/
						a_fVertex[0][0]=-(GLdouble)lines[a_iLineArray[iLine]].v1->x/MAP_SCALE;	// x
						a_fVertex[0][1]=(GLdouble)sectors[s].ceilingheight/MAP_SCALE;						// y
						a_fVertex[0][2]=(GLdouble)lines[a_iLineArray[iLine]].v1->y/MAP_SCALE;	// z
						gluTessVertex(tobj, a_fVertex[0], fn_p_fVertex(a_fVertex[0]/*,fLightLevel*/));
					}

					//a_iLineArray[iLine]=-1;
					a_iLinePresent[iLine]--;
					if (!a_iLinePresent[iLine])
						iRemainingLines--;
					break;
				}
			}
		}
		gluTessEndContour(tobj);
		if (bAbortSector)
			break;
	}
	gluTessEndPolygon(tobj);
	(*glEndList_s)();

	gluDeleteTess(tobj);
}

void fn_vCreateCeilingPolygons()
{ 
  int s;
	
	bFloorCompute=FALSE;

	startCeilingList = glGenLists(numsectors);
	
	for (s=0;s<numsectors;s++)
	{
		iCurrentSector=s;
		
		fn_vCreateCeilingPolygonsForSector(s);
	}
}

#endif	// 0

#endif	// GL_HERETIC
