#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <math.h>

#include "gl_syms.h"

#include "gl_struct.h"
#include "gl_mem.h"
#include "doomdef.h"
#include "r_local.h"
#include "p_spec.h"

extern GLboolean g_b3Dfx;
extern H_boolean shareware;

extern int iNbGLTextures;
extern GLuint *texobjs;
extern byte *p_bPalette;
extern int	iNbGLSprites;
extern int iMaxSizeBeforeReduction;

extern int FontABaseLump,FontBBaseLump;
extern GLuint *FontAobjs,*FontBobjs;

extern int numpatches;
extern GLboolean g_bPaletteTexture;
/* PROC glColorTableEXT; */

GLTexture *p_stGLFontA;
int	iNbGLFontA;
GLTexArray *p_stGLFontAArray;
GLMapSprite *p_stMapFontA;
short *FontAtopoffset,*FontAoffset;

GLTexArray *p_stGLFontBArray;
short *FontBtopoffset,*FontBoffset;

int numFontAlumps,numFontBlumps;

#define NB_PATCHS	130
GLTexArray *p_stGLPatchArray;
short *Patchtopoffset,*Patchoffset;
int iPatchLump[NB_PATCHS];
char a_szPatchName[NB_PATCHS][10]=
{	
  /* Menus */
  "PAUSED",
  "M_SLCTR1",
  "M_SLCTR2",
  "M_HTIC",
  "M_SKL00",
  "M_SKL01",
  "M_SKL02",
  "M_SKL03",
  "M_SKL04",
  "M_SKL05",
  "M_SKL06",
  "M_SKL07",
  "M_SKL08",
  "M_SKL09",
  "M_SKL10",
  "M_SKL11",
  "M_SKL12",
  "M_SKL13",
  "M_SKL14",
  "M_SKL15",
  "M_SKL16",
  "M_SKL17",
  "M_FSLOT",
  "M_SLDLT",
  "M_SLDMD1",
  "M_SLDMD2",
  "M_SLDRT",
  "M_SLDKB",
  /* Intermissions */
  "IN_X",
  "IN_YAH",
  "FACEA0",
  "FACEB0",
  /* STATUS_BAR */
  "LTFACE",
  "RTFACE",
  "INVBAR",
  "LIFEBAR",
  "LIFEGEM2",
  "LTFCTOP",
  "RTFCTOP",
  "SELECTBOX",
  "INVGEML1",
  "INVGEML2",
  "INVGEMR1",
  "INVGEMR2",
  "BLACKSQ",
  "ARMCLEAR",
  "IN0",
  "IN1",
  "IN2",
  "IN3",
  "IN4",
  "IN5",
  "IN6",
  "IN7",
  "IN8",
  "IN9",
  "NEGNUM",
  "SMALLIN0",
  "SMALLIN1",
  "SMALLIN2",
  "SMALLIN3",
  "SMALLIN4",
  "SMALLIN5",
  "SMALLIN6",
  "SMALLIN7",
  "SMALLIN8",
  "SMALLIN9",
  "LAME",
  /* BARBACK w=320 h=42 */
  /* CHAIN w=296 h=8 */
  /* CHAINBACK w=320 h=10 */
  "BARBACK",
  "CHAIN",
  "CHAINBACK",
  "SPFLY0",
  "SPFLY1",
  "SPFLY2",
  "SPFLY3",
  "SPFLY4",
  "SPFLY5",
  "SPFLY6",
  "SPFLY7",
  "SPFLY8",
  "SPFLY9",
  "SPFLY10",
  "SPFLY11",
  "SPFLY12",
  "SPFLY13",
  "SPFLY14",
  "SPFLY15",
  "SPINBK0",
  "SPINBK1",
  "SPINBK2",
  "SPINBK3",
  "SPINBK4",
  "SPINBK5",
  "SPINBK6",
  "SPINBK7",
  "SPINBK8",
  "SPINBK9",
  "SPINBK10",
  "SPINBK11",
  "SPINBK12",
  "SPINBK13",
  "SPINBK14",
  "SPINBK15",
  "USEARTIA",
  "USEARTIB",
  "USEARTIC",
  "USEARTID",
  "USEARTIE",
  "ARTIBOX",
  "ARTIINVU",
  "ARTIINVS",
  "ARTIPTN2",
  "ARTISPHL",
  "ARTIPWBK",
  "ARTITRCH",
  "ARTIFBMB",
  "ARTIEGGC",
  "ARTISOAR",
  "ARTIATLP",
  "INAMGLD",
  "INAMBOW",
  "INAMBST",
  "INAMRAM",
  "INAMPNX",
  "INAMLOB",
  "YKEYICON",
  "GKEYICON",
  "BKEYICON",
  "GOD1",
  "GOD2"
};

#define NB_SCREENS 8
char a_szScreenNames[NB_SCREENS][8]=
{	
  /* V_DrawRawScreen */
  "TITLE",
  "ORDER",
  "HELP1",
  "HELP2",
  "CREDIT",
  /* V_DrawPatch */
  "MAPE1",
  "MAPE2",
  "MAPE3"
};

#define MNU_X(x)		(int)((float)(x)*screenwidth/320.0f)
#define MNU_Y(y)		(int)((float)(y)*screenheight/200.0f)

extern float fScaleSprite;

void fn_vRegisterPatchs() {
  patch_t *patch;
  int i;
  int iPrevMax;
  float fPrevScale;
  
  fPrevScale=fScaleSprite;
  iPrevMax=iMaxSizeBeforeReduction;
  iMaxSizeBeforeReduction=65536;
  
  p_stGLPatchArray=(GLTexArray *)Malloc(NB_PATCHS*sizeof(GLTexArray));
  
  for (i=0;i<NB_PATCHS;i++)
    p_stGLPatchArray[i].iTexID=-1;
  
  Patchtopoffset=(short *)Malloc(NB_PATCHS*sizeof(short));
  Patchoffset=(short *)Malloc(NB_PATCHS*sizeof(short));
  for (i=0;i<NB_PATCHS;i++) {	
    if (shareware&&
	(!strcmp(a_szPatchName[i],"ARTISPHL")||!strcmp(a_szPatchName[i],"ARTIATLP")||
	 !strcmp(a_szPatchName[i],"INAMRAM")||!strcmp(a_szPatchName[i],"INAMPNX")||
	 !strcmp(a_szPatchName[i],"INAMLOB")))	/* shareware */
      continue;
    iPatchLump[i]=W_GetNumForName(a_szPatchName[i]);
    patch = W_CacheLumpNum(iPatchLump[i], PU_CACHE);
    Patchtopoffset[i]=SHORT(patch->topoffset);
    Patchoffset[i]=SHORT(patch->leftoffset);
    if (g_b3Dfx) {
      if ((!strcmp(a_szPatchName[i],"BARBACK"))||(!strcmp(a_szPatchName[i],"CHAINBACK")))
	{
	  iMaxSizeBeforeReduction=2;
	  fScaleSprite=0.8f;
	}
      else
	if (!strcmp(a_szPatchName[i],"CHAIN"))
	  {	
	    iMaxSizeBeforeReduction=2;
	    fScaleSprite=256.0f/296.0f;
	  }
	else
	  iMaxSizeBeforeReduction=65536;
    }
    fn_vRegisterSpriteCompressed(&p_stGLFontA,&p_stMapFontA,&p_stGLPatchArray,i,patch);
  }
  iNbGLFontA=iNbGLSprites;
  /* fn_vSaveRAW("bar.raw",p_stGLFontA[3].p_bRGBBuffer,256,128); */
  
  iMaxSizeBeforeReduction=iPrevMax;
  fScaleSprite=fPrevScale;
}

int GL_GetNumForName(char *szName) {
  int i;
  
  for (i=0;i<NB_PATCHS;i++)
    if (!strcasecmp(szName,a_szPatchName[i]))
      return i;
  return -1;
}

void GL_DrawCompressedPatch(int x, int y, int iWidth, int iHeight,int iLump) {
  /* For 3Dfx (Max texture size is 256x256) */
  float fU1,fU2,fV1,fV2;
  int iTexIndex,iSubTex,i;
  
  if (iLump==-1)
    return;	/* Patch not registered */
  i=iLump;
  {
    x=MNU_X(x);
    y=MNU_Y(y);
    
    y -= MNU_Y(Patchtopoffset[i]);
    x -= MNU_X(Patchoffset[i]);
    
    iTexIndex=p_stGLPatchArray[i].iGLTexIndex;
    iSubTex=p_stGLPatchArray[i].iUVIndex;
    fU1=(float)p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iU/(float)p_stGLFontA[iTexIndex].iWidth;
    fU2=(float)(p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iU+p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iWidth)/(float)p_stGLFontA[iTexIndex].iWidth;
    fV1=(float)p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iV/(float)p_stGLFontA[iTexIndex].iHeight;
    fV2=(float)(p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iV+p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iHeight)/(float)p_stGLFontA[iTexIndex].iHeight;
    iWidth=MNU_X(iWidth);
    iHeight=MNU_Y(iHeight);
    
    
    (*glBindTexture_s) (GL_TEXTURE_2D, FontAobjs[iTexIndex]);
    
    (*glBegin_s) (GL_QUADS);
    (*glTexCoord2f_s) (fU1, fV1); (*glVertex2f_s) ( x, screenheight-1-y );
    (*glTexCoord2f_s) (fU1, fV2); (*glVertex2f_s) ( x, screenheight-1-y-iHeight );
    (*glTexCoord2f_s) (fU2, fV2); (*glVertex2f_s) ( x+iWidth, screenheight-1-y-iHeight );
    (*glTexCoord2f_s) (fU2, fV1); (*glVertex2f_s) ( x+iWidth, screenheight-1-y );
    (*glEnd_s) ();
  }
}

void GL_DrawPatch(int x, int y, int iLump) {
  float fU1,fU2,fV1,fV2;
  int iTexIndex,iSubTex,iWidth,iHeight,i;
  
  if (iLump==-1)
    return;	/* Patch not registered */
  i=iLump;
  {
    x=MNU_X(x);
    y=MNU_Y(y);
    
    y -= MNU_Y(Patchtopoffset[i]);
    x -= MNU_X(Patchoffset[i]);
    
    iTexIndex=p_stGLPatchArray[i].iGLTexIndex;
    iSubTex=p_stGLPatchArray[i].iUVIndex;
    fU1=(float)p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iU/(float)p_stGLFontA[iTexIndex].iWidth;
    fU2=(float)(p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iU+p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iWidth)/(float)p_stGLFontA[iTexIndex].iWidth;
    fV1=(float)p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iV/(float)p_stGLFontA[iTexIndex].iHeight;
    fV2=(float)(p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iV+p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iHeight)/(float)p_stGLFontA[iTexIndex].iHeight;
    iWidth=MNU_X(p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iWidth);
    iHeight=MNU_Y(p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iHeight);
    
    (*glBindTexture_s) (GL_TEXTURE_2D, FontAobjs[iTexIndex]);
    
    (*glBegin_s) (GL_QUADS);
    (*glTexCoord2f_s)(fU1, fV1); (*glVertex2f_s)( x, screenheight-1-y );
    (*glTexCoord2f_s)(fU1, fV2); (*glVertex2f_s)( x, screenheight-1-y-iHeight );
    (*glTexCoord2f_s)(fU2, fV2); (*glVertex2f_s)( x+iWidth, screenheight-1-y-iHeight );
    (*glTexCoord2f_s)(fU2, fV1); (*glVertex2f_s)( x+iWidth, screenheight-1-y );
    (*glEnd_s) ();
  }
}

void GL_DrawShadowedPatch(int x, int y, int iLump) {
  (*glColor3f_s) (0.5f,0.5f,0.5f);
  GL_DrawShadowedPatch(x,y,iLump);
  (*glColor3f_s) (1.0f,1.0f,1.0f);
}

GLboolean g_bInitFonts=false;
GLvoid fn_vGLInitFonts() {
  patch_t *patch;
  int i;
  
  g_bInitFonts=true;
  SPRITE_WIDTH=128;
  SPRITE_HEIGHT=128;
  numFontAlumps=W_GetNumForName("FONTA_E")-W_GetNumForName("FONTA_S");
  numFontBlumps=W_GetNumForName("FONTB_E")-W_GetNumForName("FONTB_S");

  p_stGLFontA=(GLTexture *)Malloc(sizeof(GLTexture));
  p_stMapFontA=(GLMapSprite *)Malloc(sizeof(GLMapSprite));
  p_stGLFontAArray=(GLTexArray *)Malloc(numFontAlumps*sizeof(GLTexArray));
  for (i=0;i<numFontAlumps;i++)
    p_stGLFontAArray[i].iTexID=-1;
  p_bPalette=W_CacheLumpName("PLAYPAL", PU_STATIC);
  
  p_stGLFontBArray=(GLTexArray *)Malloc(numFontBlumps*sizeof(GLTexArray));
  for (i=0;i<numFontBlumps;i++)
    p_stGLFontBArray[i].iTexID=-1;
  
  FontAtopoffset=(short *)Malloc(numFontAlumps*sizeof(short));
  FontAoffset=(short *)Malloc(numFontAlumps*sizeof(short));
  iNbGLSprites=0;
  for (i=0;i<numFontAlumps;i++)
    {
       /*printf("fontachar %d (%d) ",i, FontABaseLump+i);*/
      patch = W_CacheLumpNum(FontABaseLump+i, PU_CACHE);
      /*printf("  %dx%d:\n",(unsigned int)(SHORT(patch->width)),(unsigned int)(SHORT(patch->width)));*/
      /* sanity check */
      if(SHORT(patch->width)>20) {
	 printf("[SDLGLdrv/fonts] fonta %d eek!\n",i);
	 continue;
      }
      FontAtopoffset[i]=SHORT(patch->topoffset);
      FontAoffset[i]=SHORT(patch->leftoffset);
      fn_vRegisterSpriteCompressed(&p_stGLFontA,&p_stMapFontA,&p_stGLFontAArray,i,patch);
    }
  
  FontBtopoffset=(short *)Malloc(numFontBlumps*sizeof(short));
  FontBoffset=(short *)Malloc(numFontBlumps*sizeof(short));

  for (i=0;i<numFontBlumps-1;i++)	/* Why -1 ??? */
    {
       /*printf("fontbchar %d (%d) ",i, FontBBaseLump+i);*/
      patch = W_CacheLumpNum(FontBBaseLump+i, PU_CACHE);
      /*printf("  %dx%d:\n",(unsigned int)(SHORT(patch->width)),(unsigned int)(SHORT(patch->width)));*/
      /* sanity check */
      if(SHORT(patch->width)>20) {
	 printf("[SDLGLdrv/fonts] fontb %d eek!\n",i);
	 continue;
      }
      FontBtopoffset[i]=SHORT(patch->topoffset);
      FontBoffset[i]=SHORT(patch->leftoffset);
      fn_vRegisterSpriteCompressed(&p_stGLFontA,&p_stMapFontA,&p_stGLFontBArray,i,patch);
    }
  iNbGLFontA=iNbGLSprites;
  
  /* Register other patchs... */
  fn_vRegisterPatchs();
  
  iNbGLSprites=0;
  
  SPRITE_WIDTH=SPRITE_HEIGHT=128;
  g_bInitFonts=false;
}

int GL_DrawLetterA(int x,int y,int lump) {
  float fU1,fU2,fV1,fV2;
  int iTexIndex,iSubTex,iWidth,iHeight;
  
  y -= MNU_Y(FontAtopoffset[lump]);
  x -= MNU_X(FontAoffset[lump]);
  
  iTexIndex=p_stGLFontAArray[lump].iGLTexIndex;
  iSubTex=p_stGLFontAArray[lump].iUVIndex;
  fU1=(float)p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iU/(float)p_stGLFontA[iTexIndex].iWidth;
  fU2=(float)(p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iU+p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iWidth)/(float)p_stGLFontA[iTexIndex].iWidth;
  fV1=(float)p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iV/(float)p_stGLFontA[iTexIndex].iHeight;
  fV2=(float)(p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iV+p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iHeight)/(float)p_stGLFontA[iTexIndex].iHeight;
  iWidth=MNU_X(p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iWidth);
  iHeight=MNU_Y(p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iHeight);
  
  (*glBindTexture_s) (GL_TEXTURE_2D, FontAobjs[iTexIndex]);
  
  (*glBegin_s) (GL_QUADS);
  (*glTexCoord2f_s) (fU1, fV1); (*glVertex2f_s) ( x, screenheight-1-y );
  (*glTexCoord2f_s) (fU1, fV2); (*glVertex2f_s) ( x, screenheight-1-y-iHeight );
  (*glTexCoord2f_s) (fU2, fV2); (*glVertex2f_s) ( x+iWidth, screenheight-1-y-iHeight );
  (*glTexCoord2f_s) (fU2, fV1); (*glVertex2f_s) ( x+iWidth, screenheight-1-y );
  (*glEnd_s) ();
  
  return p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iWidth;
}

void GL_DrTextA(char *text, int x, int y) {
  char c;
  int width;

  while((c = *text++) != 0) {
    if(c < 33)
      {
	x += 5;
      }
    else
      {
	width=GL_DrawLetterA(MNU_X(x), MNU_Y(y), c-33);
	x += width-1;
      }
  }
}

int GL_DrawLetterB(int x,int y,int lump) {
  float fU1,fU2,fV1,fV2;
  int iTexIndex,iSubTex,iWidth,iHeight;
  
  y -= MNU_Y(FontBtopoffset[lump]);
  x -= MNU_X(FontBoffset[lump]);
  
  iTexIndex=p_stGLFontBArray[lump].iGLTexIndex;
  iSubTex=p_stGLFontBArray[lump].iUVIndex;
	
  fU1=(float)p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iU/(float)p_stGLFontA[iTexIndex].iWidth;
  fU2=(float)(p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iU+p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iWidth)/(float)p_stGLFontA[iTexIndex].iWidth;
  fV1=(float)p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iV/(float)p_stGLFontA[iTexIndex].iHeight;
  fV2=(float)(p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iV+p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iHeight)/(float)p_stGLFontA[iTexIndex].iHeight;
  iWidth=MNU_X(p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iWidth);
  iHeight=MNU_Y(p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iHeight);
  
  (*glBindTexture_s) (GL_TEXTURE_2D, FontAobjs[iTexIndex]);
  
  (*glBegin_s) (GL_QUADS);
  (*glTexCoord2f_s) (fU1, fV1); (*glVertex2f_s) ( x, screenheight-1-y );
  (*glTexCoord2f_s) (fU1, fV2); (*glVertex2f_s) ( x, screenheight-1-y-iHeight );
  (*glTexCoord2f_s) (fU2, fV2); (*glVertex2f_s) ( x+iWidth, screenheight-1-y-iHeight );
  (*glTexCoord2f_s) (fU2, fV1); (*glVertex2f_s) ( x+iWidth, screenheight-1-y );
  (*glEnd_s) ();

  return p_stGLFontA[iTexIndex].a_stSubTex[iSubTex].iWidth;
}

int GL_DrawShadowedLetterB(int x,int y,int lump) {
  int width;
  
  (*glColor3f_s) (0.5f,0.5f,0.5f);
  width=GL_DrawLetterB(MNU_X(x),MNU_Y(y),lump);
  (*glColor3f_s) (1.0f,1.0f,1.0f);
  
  return width;
}

void GL_DrTextB(char *text, int x, int y) {
  char c;
  int width;

  while((c = *text++) != 0) {
    if(c < 33)
      {
	x += 8;
      }
    else
      {
	width=GL_DrawLetterB(MNU_X(x), MNU_Y(y), c-33);
	x += width-1;
      }
  }
}

/* For the MAP */
GLvoid GL_DrawLine(int X0, int Y0, int X1, int Y1, byte BaseColor) {
  (*glDisable_s) (GL_TEXTURE_2D);
  (*glColor3f_s) ((float)p_bPalette[3*BaseColor]/255.0f,(float)p_bPalette[3*BaseColor+1]/255.0f,(float)p_bPalette[3*BaseColor+2]/255.0f);
  (*glBegin_s) (GL_LINES);
  (*glVertex2f_s) ( X0, screenheight-1-Y0 );
  (*glVertex2f_s) ( X1, screenheight-1-Y1 );
  (*glEnd_s) ();
  (*glEnable_s) (GL_TEXTURE_2D);
}

GLvoid GL_DumpScreen() { 
  (*glColor3f_s) (1.0f,1.0f,1.0f);
  (*glClear_s) (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  (*glRasterPos2i_s) (0,0);
#ifdef PALETTED_TEXTURE
  if (g_bPaletteTexture)
    {	
      (*glColorTableEXT_s) (GL_TEXTURE_2D,GL_RGB8,256,GL_RGB,GL_UNSIGNED_BYTE,p_bPalette);
      (*glDrawPixels_s) (screenwidth,screenheight,GL_COLOR_INDEX8_EXT,GL_UNSIGNED_BYTE,screen);
    }
  else
#endif
  (*glDrawPixels_s) (screenwidth,screenheight,GL_RGB,GL_UNSIGNED_BYTE,screen);
  (*glEnable_s) (GL_TEXTURE_2D);
  (*glColor3f_s) (1.0f,1.0f,1.0f);
}

unsigned char *p_bRGBTitle1[NB_SCREENS],*p_bRGBTitle2[NB_SCREENS];
int iGlObjTITLE;

GLvoid GL_RegisterPatchScreen(int i) {
  int y=0;
  int count;
  int col;
  column_t *column;
  byte *source;
  int w;
  patch_t *patch;
  
  patch=(patch_t *)W_CacheLumpName(a_szScreenNames[i],PU_CACHE);
  w = SHORT(patch->width);
#ifdef PALETTED_TEXTURE
  if (g_bPaletteTexture) {
    p_bRGBTitle1[i]=(unsigned char *)Malloc(256*256);
    for (col=0;col<256;col++) {
      column = (column_t *)((byte *)patch+LONG(patch->columnofs[col]));
      y=0;
      while (column->topdelta != 0xff ) {
	source = (byte *)column + 3;
	count = column->length;
	
	while (count--) {
	  p_bRGBTitle1[i][col+y*256]=*source;
	  source++;
	  y++;
	}
	column = (column_t *)(  (byte *)column + column->length+ 4 );
      }
    }
    p_bRGBTitle2[i]=(unsigned char *)Malloc(64*256);
    for (col=256;col<320;col++) {
      column = (column_t *)((byte *)patch+LONG(patch->columnofs[col]));
      y=0;
      while (column->topdelta != 0xff ) {
	source = (byte *)column + 3;
	count = column->length;
	
	while (count--) {
	  p_bRGBTitle2[i][col-256+y*64]=*source;
	  source++;
	  y++;
	}
	column = (column_t *)(  (byte *)column + column->length+ 4 );
      }
    }
  }
  else
#endif
    {
      p_bRGBTitle1[i]=(unsigned char *)Malloc(256*256*3);
      for (col=0;col<256;col++) {
	column = (column_t *)((byte *)patch+LONG(patch->columnofs[col]));
	y=0;
	while (column->topdelta != 0xff ) {
	  source = (byte *)column + 3;
	  count = column->length;
	  
	  while (count--) {
	    p_bRGBTitle1[i][3*(col+y*256)]=p_bPalette[3**source];
	    p_bRGBTitle1[i][3*(col+y*256)+1]=p_bPalette[3**source+1];
	    p_bRGBTitle1[i][3*(col+y*256)+2]=p_bPalette[3**source+2];
	    source++;
	    y++;
	  }
	  column = (column_t *)(  (byte *)column + column->length+ 4 );
	}
      }
      p_bRGBTitle2[i]=(unsigned char *)Malloc(64*256*3);
      for (col=256;col<320;col++) {
	column = (column_t *)((byte *)patch+LONG(patch->columnofs[col]));
	y=0;
	while (column->topdelta != 0xff ) { 
	  source = (byte *)column + 3;
	  count = column->length;
	  
	  while (count--) {
	    p_bRGBTitle2[i][3*(col-256+y*64)]=p_bPalette[3**source];
	    p_bRGBTitle2[i][3*(col-256+y*64)+1]=p_bPalette[3**source+1];
	    p_bRGBTitle2[i][3*(col-256+y*64)+2]=p_bPalette[3**source+2];
	    source++;
	    y++;
	  }
	  column = (column_t *)(  (byte *)column + column->length+ 4 );
	}
      }
    }

  (*glBindTexture_s) (GL_TEXTURE_2D, iGlObjTITLE+2*i);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
  (*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

#ifdef PALETTED_TEXTURE
  if (g_bPaletteTexture)
    {	
      (*glColorTableEXT_s) (GL_TEXTURE_2D,GL_RGB8,256,GL_RGB,GL_UNSIGNED_BYTE,p_bPalette);
      (*glTexImage2D_s) (GL_TEXTURE_2D, 0, GL_COLOR_INDEX8_EXT, 256, 256, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, p_bRGBTitle1[i]);
    }
  else
#endif
  (*glTexImage2D_s) (GL_TEXTURE_2D, 0, 3, 256, 256, 0, GL_RGB, GL_UNSIGNED_BYTE, p_bRGBTitle1[i]);
  
  (*glBindTexture_s) (GL_TEXTURE_2D, iGlObjTITLE+2*i+1);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
  (*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
  
#ifdef PALETTED_TEXTURE
  if (g_bPaletteTexture)
    {	
      (*glColorTableEXT_s) (GL_TEXTURE_2D,GL_RGB8,256,GL_RGB,GL_UNSIGNED_BYTE,p_bPalette);
      (*glTexImage2D_s) (GL_TEXTURE_2D, 0, GL_COLOR_INDEX8_EXT, 64, 256, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, p_bRGBTitle2[i]);
    }
  else
#endif
  (*glTexImage2D_s) (GL_TEXTURE_2D, 0, 3, 64, 256, 0, GL_RGB, GL_UNSIGNED_BYTE, p_bRGBTitle2[i]);
}

GLvoid GLDrawScreen(int i) { 	
  if (i==1)
    i=4;
  (*glEnable_s) (GL_TEXTURE_2D);
  (*glColor3f_s) (1.0f,1.0f,1.0f);
  (*glClear_s) (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  
  (*glBindTexture_s) (GL_TEXTURE_2D,iGlObjTITLE+2*i);
  (*glBegin_s) (GL_QUADS);
  (*glTexCoord2f_s) (0,0);		(*glVertex2f_s) (0,(float)screenheight);
  (*glTexCoord2f_s) (1,0);		(*glVertex2f_s) (0.8f*screenwidth,(float)screenheight);
  (*glTexCoord2f_s) (1,0.78125f);		(*glVertex2f_s) (0.8f*screenwidth,0);
  (*glTexCoord2f_s) (0,0.78125f);		(*glVertex2f_s) (0,0);
  (*glEnd_s) ();
  (*glBindTexture_s) (GL_TEXTURE_2D,iGlObjTITLE+2*i+1);
  (*glBegin_s) (GL_QUADS);
  (*glTexCoord2f_s) (0,0);		(*glVertex2f_s) (0.8f*screenwidth,(float)screenheight);
  (*glTexCoord2f_s) (1,0);		(*glVertex2f_s) ((float)screenwidth,(float)screenheight);
  (*glTexCoord2f_s) (1,0.78125f);		(*glVertex2f_s) ((float)screenwidth,0);
  (*glTexCoord2f_s) (0,0.78125f);		(*glVertex2f_s) (0.8f*screenwidth,0);
  (*glEnd_s) ();
}

GLvoid GLDrawScreenFromName(char *name) {
  int i;
  for (i=0;i<NB_SCREENS;i++)
    if (!strcmp(name,a_szScreenNames[i]))
      break;
  if (i==NB_SCREENS)
    return;
  
  GLDrawScreen(i);
}

GLvoid GLRegisterScreen(int i) {	/* 2 textures for one 320x200 screen because of the 3Dfx limitations (256x256) */
  byte *patch;
  int x,y;
  
  patch=(byte *)W_CacheLumpName(a_szScreenNames[i],PU_CACHE);
#ifdef PALETTED_TEXTURE
  if (g_bPaletteTexture) {
    p_bRGBTitle1[i]=(unsigned char *)Malloc(256*256);
    for (x=0;x<256;x++) {
      for (y=0;y<200;y++) {	
	p_bRGBTitle1[i][x+y*256]=patch[x+y*320];
      }
    }
    p_bRGBTitle2[i]=(unsigned char *)Malloc(64*256);
    for (x=256;x<320;x++) {
      for (y=0;y<200;y++) {	
	p_bRGBTitle2[i][x-256+y*64]=patch[x+y*320];
      }
    }
  }
  else
#endif
    {
      p_bRGBTitle1[i]=(unsigned char *)Malloc(256*256*3);
      for (x=0;x<256;x++) {
	for (y=0;y<200;y++) {	
	  p_bRGBTitle1[i][3*(x+y*256)]=p_bPalette[3*patch[x+y*320]];
	  p_bRGBTitle1[i][3*(x+y*256)+1]=p_bPalette[3*patch[x+y*320]+1];
	  p_bRGBTitle1[i][3*(x+y*256)+2]=p_bPalette[3*patch[x+y*320]+2];
	}
      }
      p_bRGBTitle2[i]=(unsigned char *)Malloc(64*256*3);
      for (x=256;x<320;x++) {
	for (y=0;y<200;y++) {	
	  p_bRGBTitle2[i][3*(x-256+y*64)]=p_bPalette[3*patch[x+y*320]];
	  p_bRGBTitle2[i][3*(x-256+y*64)+1]=p_bPalette[3*patch[x+y*320]+1];
	  p_bRGBTitle2[i][3*(x-256+y*64)+2]=p_bPalette[3*patch[x+y*320]+2];
	}
      }
    }

  iGlObjTITLE =10000;
  (*glBindTexture_s) (GL_TEXTURE_2D, iGlObjTITLE+2*i);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
  (*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
  
#ifdef PALETTED_TEXTURE
  if (g_bPaletteTexture)
    {	
      (*glColorTableEXT_s) (GL_TEXTURE_2D,GL_RGB8,256,GL_RGB,GL_UNSIGNED_BYTE,p_bPalette);
      (*glTexImage2D_s) (GL_TEXTURE_2D, 0, GL_COLOR_INDEX8_EXT, 256, 256, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, p_bRGBTitle1[i]);
    }
  else
#endif
  (*glTexImage2D_s) (GL_TEXTURE_2D, 0, 3, 256, 256, 0, GL_RGB, GL_UNSIGNED_BYTE, p_bRGBTitle1[i]);
  
  (*glBindTexture_s) (GL_TEXTURE_2D, iGlObjTITLE+2*i+1);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
  (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
  (*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
  
#ifdef PALETTED_TEXTURE
  if (g_bPaletteTexture)
    {	
      (*glColorTableEXT_s) (GL_TEXTURE_2D,GL_RGB8,256,GL_RGB,GL_UNSIGNED_BYTE,p_bPalette);
      (*glTexImage2D_s) (GL_TEXTURE_2D, 0, GL_COLOR_INDEX8_EXT, 64, 256, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, p_bRGBTitle2[i]);
    }
  else
#endif
  (*glTexImage2D_s) (GL_TEXTURE_2D, 0, 3, 64, 256, 0, GL_RGB, GL_UNSIGNED_BYTE, p_bRGBTitle2[i]);
}

GLvoid GLRegisterScreens() {
  GLRegisterScreen(0);
  if (shareware)
    GLRegisterScreen(1);
  GLRegisterScreen(2);
  GLRegisterScreen(3);
  GLRegisterScreen(4);
  
  GL_RegisterPatchScreen(5);
  if (!shareware)
    {	GL_RegisterPatchScreen(6);
    GL_RegisterPatchScreen(7);
    }
}

void GL_DrawStatBack(char *name) {
  int x;
  int y;
  int i;
  
  byte *src;
  byte *dest;
  
  src = W_CacheLumpName (name, PU_CACHE);
  dest = screen;
  
  for (y=0 ; y<screenheight ; y++) {
    for (x=0 ; x<screenwidth/64 ; x++) {
#ifdef PALETTED_TEXTURE
      if (g_bPaletteTexture) {
	memcpy (dest, src+((y&63)<<6), 64);
	dest += 64;
      }
      else
#endif
	for (i=0;i<64;i++) {
	  dest[3*(64*x+i+screenwidth*y)]=p_bPalette[3*src[i+((y&63)<<6)]];
	  dest[3*(64*x+i+screenwidth*y)+1]=p_bPalette[3*src[i+((y&63)<<6)]+1];
	  dest[3*(64*x+i+screenwidth*y)+2]=p_bPalette[3*src[i+((y&63)<<6)]+2];
	}
    }
    if (screenwidth&63) {
#ifdef PALETTED_TEXTURE
      if (g_bPaletteTexture) {
	memcpy (dest, src+((y&63)<<6), screenwidth&63);
	dest += (screenwidth&63);
      }
      else
#endif
	for (i=0; i<(screenwidth&63); i++) {
	  dest[3*(64*x+i+screenwidth*y)]=p_bPalette[3*src[i+((y&63)<<6)]];
	  dest[3*(64*x+i+screenwidth*y)+1]=p_bPalette[3*src[i+((y&63)<<6)]+1];
	  dest[3*(64*x+i+screenwidth*y)+2]=p_bPalette[3*src[i+((y&63)<<6)]+2];
	}
    }
  }
  GL_DumpScreen();
}
