#ifdef GL_HERETIC

//#define __DOOMTYPE__

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <unistd.h>

#include "gl_syms.h"

#include "gl_struct.h"
#include "gl_mem.h"
#ifndef GL_HEXEN
#include "doomdef.h"
#else
#include "h2def.h"
#endif
#include "r_local.h"

#ifdef DOOM_GL
#include "p_spec.h"
#endif

#include "p_local.h"

// From p_local.h
#define NUMREDPALS		8
#define NUMBONUSPALS	4

// For Flares
#define GL_CORONA		1
#ifdef FLARES
#define GL_FLARE		2
/*unsigned char *flareTex[6];
unsigned char *shineTex[10];
int g_iFlare[6];*/
int g_iShine[10];
#endif

int g_iCorona;

extern long	usegamma;
extern int consoleplayer;
float g_fRed=0.0f,g_fPal=0.0f,g_fGreen=0.0f,g_fBlue=0.0f;
// DarkFang
/*#define MAX_LIGHT_SOURCES	20
GLDynamicLight a_stGLLight[MAX_LIGHT_SOURCES];
int iGLNbLightSources;
float fLightUpF[MAX_LIGHT_SOURCES],fLightDownF[MAX_LIGHT_SOURCES],fLightLeftF[MAX_LIGHT_SOURCES],fLightRightF[MAX_LIGHT_SOURCES];
float fLightUpC[MAX_LIGHT_SOURCES],fLightDownC[MAX_LIGHT_SOURCES],fLightLeftC[MAX_LIGHT_SOURCES],fLightRightC[MAX_LIGHT_SOURCES];*/
// End DarkFang
H_boolean g_bLightEffects;

void GL_PaletteFlash()
{ player_t *CPlayer;
  int palette;
  int		cnt;
  /* int		bzc; */

	CPlayer = &players[consoleplayer];

    cnt = CPlayer->damagecount;

#ifdef DOOM_GL
    if (CPlayer->powers[pw_strength])
    {
	// slowly fade the berzerk out
  	bzc = 12 - (CPlayer->powers[pw_strength]>>6);

	if (bzc > cnt)
	    cnt = bzc;
    }
#endif	
    if (cnt)
	//if(CPlayer->damagecount)
	{
		//palette = (CPlayer->damagecount+7)>>3;
		palette = (cnt+7)>>3;
		if(palette >= NUMREDPALS)
		{
			palette = NUMREDPALS-1;
		}
		g_fRed=palette*0.2f;
	}
	else if(CPlayer->bonuscount)
	{
		palette = (CPlayer->bonuscount+7)>>3;
		if(palette >= NUMBONUSPALS)
		{
			palette = NUMBONUSPALS-1;
		}
		g_fPal=palette*0.2f;
	}
#ifdef DOOM_GL
    else if ( CPlayer->powers[pw_ironfeet] > 4*32
	      || CPlayer->powers[pw_ironfeet]&8)
		g_fGreen=0.5f;
#endif
#ifdef GL_HEXEN
	else if (CPlayer->poisoncount)
		{
			palette = 0;
			palette = (CPlayer->poisoncount+7)>>3;
			if(palette >= NUMPOISONPALS)
			{
				palette = NUMPOISONPALS-1;
			}
			//palette += STARTPOISONPALS;
			g_fGreen=palette*0.2f;
		}
		else if(CPlayer->mo->flags2&MF2_ICEDAMAGE)
		{ // Frozen player
			//palette = STARTICEPAL;
			g_fBlue=0.6f;
		}
#endif
    else
	{
		g_fRed = g_fPal = g_fGreen = 0.0f;
	}
}

#ifdef DOOM_GL
#define INVERSECOLORMAP		32
#endif

void GL_StaticLight3f(GLfloat fRed,GLfloat fGreen,GLfloat fBlue)
{ float fGamma=/*usegamma*0.12f+*/g_fPal;
#ifndef DOOM_GL
  float fColor;
#endif
  player_t *player;
#if 0	// test light
  float color[4];

	/*color[0]=fRed+fGamma+g_fRed;
	color[0]=fGreen+fGamma-g_fRed;
	color[0]=fBlue+fGamma-g_fRed;*/
	color[0]=1.0f;
	color[0]=1.0f;
	color[0]=1.0f;
	color[0]=1.0f;
	(*glMaterialfv_s) (GL_FRONT_AND_BACK,GL_AMBIENT,color);
    /*fRed/=2.0f;
	fGreen/=2.0f;
	fBlue/=2.0f;*/
#else	// 1
	player = &players[consoleplayer];
	if (player->fixedcolormap == INVERSECOLORMAP)
		//(*glColor3f_s) (fRed+fGamma+g_fRed+0.2f,fGreen+fGamma-g_fRed+0.2f,fBlue+fGamma-g_fRed-0.5f);
		(*glColor3f_s) (1.0f,1.0f,0.0f);
	else
	if (player->fixedcolormap)
#ifndef DOOM_GL
	{	fColor=0.05f*player->fixedcolormap+0.5f;
		(*glColor3f_s) (fColor+fGamma+g_fRed,fColor+fGamma-g_fRed,fColor+fGamma-g_fRed);
	}
	else
		(*glColor3f_s) (fRed+fGamma+g_fRed,fGreen+fGamma-g_fRed,fBlue+fGamma-g_fRed);
#elif GL_HEXEN
	{	fColor=0.05f*player->fixedcolormap+0.5f;
		(*glColor3f_s) (fColor+fGamma+g_fRed-g_fGreen-g_fBlue,fColor+fGamma-g_fRed+g_fGreen-g_fBlue,fColor+fGamma-g_fRed-g_fGreen+g_fBlue);
	}
	else
		(*glColor3f_s) (fRed+fGamma+g_fRed-g_fGreen-g_fBlue,fGreen+fGamma-g_fRed+g_fGreen-g_fBlue,fBlue+fGamma-g_fRed-g_fGreen+g_fBlue);
#else
		(*glColor3f_s) (1.0f,1.0f,1.0f);
	else
		(*glColor3f_s) (fRed+fGamma+g_fRed-g_fGreen,fGreen+fGamma-g_fRed+g_fGreen,fBlue+fGamma-g_fRed-g_fGreen);
#endif
#endif	// 1
}

void GL_StaticLight4f(GLfloat fRed,GLfloat fGreen,GLfloat fBlue,GLfloat fAlpha)
{ float fGamma=/*usegamma*0.12f+*/g_fPal;
#ifndef DOOM_GL
  float fColor;
#endif
  player_t *player;

	player = &players[consoleplayer];
	if (player->fixedcolormap == INVERSECOLORMAP)
		//(*glColor3f_s) (fRed+fGamma+g_fRed+0.2f,fGreen+fGamma-g_fRed+0.2f,fBlue+fGamma-g_fRed-0.5f);
		(*glColor4f_s) (1.0f,1.0f,0.0f,fAlpha);
	else
	if (player->fixedcolormap)
#ifndef DOOM_GL
	{	fColor=0.05f*player->fixedcolormap+0.5f;
		(*glColor4f_s) (fColor+fGamma+g_fRed,fColor+fGamma-g_fRed,fColor+fGamma-g_fRed,fAlpha);
	}
	else
		(*glColor4f_s) (fRed+fGamma+g_fRed,fGreen+fGamma-g_fRed,fBlue+fGamma-g_fRed,fAlpha);
#elif GL_HEXEN
	{	fColor=0.05f*player->fixedcolormap+0.5f;
		(*glColor4f_s) (fColor+fGamma+g_fRed-g_fGreen-g_fBlue,fColor+fGamma-g_fRed+g_fGreen-g_fBlue,fColor+fGamma-g_fRed-g_fGreen+g_fBlue,fAlpha);
	}
	else
		(*glColor4f_s) (fRed+fGamma+g_fRed-g_fGreen-g_fBlue,fGreen+fGamma-g_fRed+g_fGreen-g_fBlue,fBlue+fGamma-g_fRed-g_fGreen+g_fBlue,fAlpha);
#else
		(*glColor4f_s) (1.0f,1.0f,1.0f,fAlpha);
	else
		(*glColor4f_s) (fRed+fGamma+g_fRed-g_fGreen,fGreen+fGamma-g_fRed+g_fGreen,fBlue+fGamma-g_fRed-g_fGreen,fAlpha);
#endif
}

// ---------------------------------------------------------------------------------
// DYNAMIC LIGHTING
// ---------------------------------------------------------------------------------
extern GLboolean g_bLightRaster;

// DarkFang
#ifdef DOOM_GL
#define NUMBER_OF_DYNAMIC_LIGHT_SOURCES 20

GLdynamic_prop dynamic_mobjlight[NUMBER_OF_DYNAMIC_LIGHT_SOURCES] = 
{
	{ MT_BRUISERSHOT,   0.43f, 1.0f, 0.43f, 0.0f, 0.9f, UPDATE_FALSE		},
	{ MT_PUFF,			 0.0f, 0.4f,  1.0f, 0.0f, 0.6f, UPDATE_FALSE		},
	{ MT_ARACHPLAZ,		 0.5f, 1.0f,  0.2f, 0.0f, 0.8f, UPDATE_FALSE		},
	{ MT_BFG,			 0.1f, 1.0f,  0.1f, 0.0f, 2.0f, UPDATE_FALSE		},
	{ MT_FATSHOT,		 0.8f,0.45f, 0.15f, 0.0f, 1.0f, UPDATE_FALSE		},
	{ MT_ROCKET,		 1.0f, 0.9f,  0.1f, 0.0f, 1.0f, UPDATE_FALSE		},
	{ MT_PLASMA,		0.45f,0.66f, 0.97f, 0.0f, 1.8f, UPDATE_FALSE		},
	{ MT_EXTRABFG,		 0.1f, 1.0f,  0.1f, 0.0f, 1.0f, UPDATE_FALSE		},
	{ MT_TROOPSHOT,		 1.0f, 0.4f,  0.2f, 0.0f, 0.9f, UPDATE_FALSE		},
	{ MT_HEADSHOT,		 0.8f,0.05f,  0.8f, 0.0f, 0.9f, UPDATE_FALSE		},
	{ MT_TRACER,		 1.0f,0.25f, 0.25f, 0.0f, 0.9f, UPDATE_FALSE		},
	{ MT_FIRE,		    0.94f,0.94f, 0.27f, 0.0f, 1.6f, UPDATE_FALSE		},
	{ MT_PLAYER,		 0.9f, 0.9f,  0.2f, 0.0f, 1.0f, UPDATE_FALSE		},
	{ MT_MISC41,		0.0f, 0.0f, 1.0f, 0.0f, 1.8f, UPDATE_TRUE		},
	{ MT_MISC42,		0.0f, 1.0f, 0.0f, 0.0f, 1.8f, UPDATE_TRUE		},
	{ MT_MISC43,		1.0f, 0.0f, 0.0f, 0.0f, 1.8f, UPDATE_TRUE		},
	{ MT_MISC49,		1.0f, 0.9f, 0.3f, 0.0f, 0.4f, UPDATE_TRUE		},
	{ MT_MISC46,		1.0f, 0.0f, 0.0f, 0.0f, 1.0f, UPDATE_TRUE		},
	{ MT_MISC45,		0.0f, 1.0f, 0.0f, 0.0f, 1.0f, UPDATE_TRUE		},
	{ MT_MISC44,		0.0f, 0.0f, 1.0f, 0.0f, 1.0f, UPDATE_TRUE		}
};
#elif GL_HEXEN
#define NUMBER_OF_DYNAMIC_LIGHT_SOURCES 25

GLdynamic_prop dynamic_mobjlight[NUMBER_OF_DYNAMIC_LIGHT_SOURCES] = 
{
	{ MT_FSWORD_MISSILE,   0.1f,1.0f,0.1f,0.0f,0.5f, UPDATE_FALSE		},
	{ MT_FSWORD_FLAME,			 0.1f,1.0f,0.1f,0.0f,1.1f, UPDATE_FALSE		},
	{ MT_MWAND_MISSILE,		 0.35f,0.56f,1.0f,0.0f,0.9f, UPDATE_FALSE		},
	{ MT_LIGHTNING_ZAP,			 0.45f,0.60f,0.97f,0.0f,2.0f, UPDATE_FALSE		},
	{ MT_AXEPUFF_GLOW,		 0.45f,0.66f,0.97f,0.0f,0.9f, UPDATE_FALSE		},
	{ MT_CFLAME_MISSILE,		 1.0f,0.5f,0.2f,0.0f,1.1f, UPDATE_FALSE		},
	{ MT_CIRCLEFLAME,		1.0f,0.5f,0.2f,0.0f,0.2f, UPDATE_FALSE		},
	{ MT_HOLY_MISSILE,		 1.0f,1.0f,1.0f,0.0f,1.0f, UPDATE_FALSE		},
	{ MT_HOLY_FX,		 1.0f,1.0f,1.0f,0.0f,0.5f, UPDATE_FALSE		},
	{ MT_MSTAFF_FX2,		 1.0f,0.1f,0.05f,0.0f,2.0f, UPDATE_FALSE		},
	{ MT_SHARDFX1,		 0.45f,0.66f,0.97f,0.0f,0.4f, UPDATE_FALSE		},
	{ MT_CSTAFF_MISSILE,	0.1f,1.0f,0.1f,0.0f,0.4f, UPDATE_FALSE		},
	{ MT_HAMMER_MISSILE,		 1.0f,0.4f,0.2f,0.0f,0.9f, UPDATE_FALSE		},
	// Monsters
	{ MT_MNTRFX1,		1.0f,0.4f,0.2f,0.0f,0.9f, UPDATE_FALSE		},
	{ MT_SERPENTFX,		0.1f,1.0f,0.2f,0.0f,0.6f, UPDATE_FALSE		},
	{ MT_CENTAUR_FX,		0.45f,0.60f,0.97f,0.0f,1.1f, UPDATE_FALSE		},
	{ MT_BISH_FX,		0.79f,0.99f,0.28f,0.0f,0.3f, UPDATE_FALSE		},
	{ MT_DRAGON_FX,		0.9f,0.7f,0.1f,0.0f,1.0f, UPDATE_FALSE		},
	{ MT_DEMONFX1,		1.0f,0.8f,0.1f,0.0f,1.0f, UPDATE_FALSE		},
	{ MT_DEMON2FX1,		0.1f,1.0f,0.2f,0.0f,1.0f, UPDATE_FALSE		},
	{ MT_WRAITHFX1,		0.8f,0.45f,0.15f,0.0f,1.0f, UPDATE_FALSE		},
	{ MT_ICEGUY_FX,		0.45f,0.66f,0.97f,0.0f,0.7f, UPDATE_FALSE		},
	{ MT_FIREDEMON_FX6,		0.9f,0.7f,0.12f,0.0f,0.6f, UPDATE_FALSE		},
	{ MT_SORCFX4,		0.9f,0.2f,0.99f,0.0f,0.4f, UPDATE_FALSE		},
	{ MT_SORCFX1,		1.0f,0.45f,0.15f,0.0f,0.9f, UPDATE_FALSE		},
};
#else
#define NUMBER_OF_DYNAMIC_LIGHT_SOURCES 23

GLdynamic_prop dynamic_mobjlight[NUMBER_OF_DYNAMIC_LIGHT_SOURCES] = 
{
	{ MT_GOLDWANDPUFF1,   1.0f,0.4f,0.2f,0.0f,0.9f, UPDATE_FALSE		},
	{ MT_GOLDWANDPUFF2,	  1.0f,0.4f,0.2f,0.0f,0.4f, UPDATE_FALSE		},
	{ MT_GOLDWANDFX2,		 1.0f,0.4f,0.2f,0.0f,0.8f, UPDATE_FALSE		},
	{ MT_CRBOWFX1,			 0.1f,1.0f,0.1f,0.0f,1.0f, UPDATE_FALSE		},
	{ MT_CRBOWFX2,		 0.1f,1.0f,0.1f,0.0f,1.2f, UPDATE_FALSE		},
	{ MT_BLASTERPUFF1,		 0.45f,0.66f,0.97f,0.0f,1.0f, UPDATE_FALSE		},
	{ MT_BLASTERFX1,		0.45f,0.66f,0.97f,0.0f,1.7f, UPDATE_FALSE		},
	{ MT_HORNRODFX1,		 1.0f,0.05f,0.05f,0.0f,1.1f, UPDATE_FALSE		},
	{ MT_HORNRODFX2,		 1.0f,0.05f,0.05f,0.0f,3.0f, UPDATE_FALSE		},
	{ MT_PHOENIXFX1,		 1.0f,0.4f,0.2f,0.0f,1.8f, UPDATE_FALSE		},
	{ MT_PHOENIXFX2,		 1.0f,0.4f,0.2f,0.0f,1.0f, UPDATE_FALSE		},
	{ MT_MACEFX3,		    1.0f,0.4f,0.2f,0.0f,0.9f, UPDATE_FALSE		},
	{ MT_IMPBALL,		 1.0f,0.4f,0.2f,0.0f,0.7f, UPDATE_FALSE		},
	{ MT_MUMMYFX1,		 1.0f,0.9f,0.1f,0.0f,0.7f, UPDATE_FALSE		},
	{ MT_SRCRFX1,		 0.98f,0.9f,0.3f,0.0f,0.7f, UPDATE_FALSE		},
	{ MT_SOR2FX1,		 0.2f,0.98f,0.98f,0.0f,0.95f, UPDATE_FALSE		},
	{ MT_MNTRFX1,		 1.0f,0.4f,0.2f,0.0f,0.9f, UPDATE_FALSE		},
	{ MT_BEASTBALL,		 0.8f,0.45f,0.15f,0.0f,1.0f, UPDATE_FALSE		},
	{ MT_HEADFX1,		 0.1f,0.98f,0.98f,0.0f,1.0f, UPDATE_FALSE		},
	{ MT_HEADFX3,		 0.8f,0.45f,0.15f,0.0f,2.5f, UPDATE_FALSE		},
	{ MT_SNAKEPRO_A,		 0.9f,0.6f,0.95f,0.0f,0.65f, UPDATE_FALSE		},
	{ MT_SNAKEPRO_B,		 1.0f,0.05f,0.05f,0.0f,0.7f, UPDATE_FALSE		},
	{ MT_WIZFX1,		 0.8f,0.05f,0.9f,0.0f,0.7f, UPDATE_FALSE		}
};
#endif
// End DarkFang

void GL_fn_vInitLights()
{ int i;
	
	iGLNbLightSources=0;
	for (i=0;i<MAX_LIGHT_SOURCES;i++)
		a_stGLLight[i].thing=NULL;
}

long g_bDynLight, g_bMD2Light, g_bMonsterLight, g_bPlayerLight;
float Distance(float x1,float y1,float z1,float x2,float y2,float z2)
{
	return (x1-x2)*(x1-x2)+(y1-y2)*(y1-y2)+(z1-z2)*(z1-z2);
}

void GL_DynamicLight4f(GLfloat x, GLfloat y,GLfloat z,GLfloat fLightLevel,GLfloat fAlpha)
{ float fGamma=/*usegamma*0.12f+*/g_fPal;
#ifndef DOOM_GL
  float fColor;
#endif
  player_t *player;
  GLDynamicLight *p_stGLLight;
  float fRed,fGreen,fBlue,fCoeff[MAX_LIGHT_SOURCES],fSumCoeff;
  float fRedS,fGreenS,fBlueS;
  float fDist,fDiff,fAmb=0.7f;
  int i;
	
	fRed=fGreen=fBlue=0.0f;
	fSumCoeff=0.0f;
	for (i=0;i<iGLNbLightSources;i++)
	{	p_stGLLight=&a_stGLLight[i];
		fDist=Distance(x,y,z,p_stGLLight->x,p_stGLLight->y,p_stGLLight->z);
		if (fDist>p_stGLLight->fFar2)
		{	fCoeff[i]=0.0f;
			/*fRed=0.0f;
			fGreen=0.0f;
			fRed=0.0f;*/
		}
		else
		if (fDist<p_stGLLight->fNear)
		{	fCoeff[i]=1.0f;
			/*fRed=p_stGLLight->fRed;
			fGreen=p_stGLLight->fGreen;
			fBlue=p_stGLLight->fBlue;*/
		}
		else
		{	fCoeff[i]=(p_stGLLight->fFar2-fDist)/(p_stGLLight->fFar2-p_stGLLight->fNear);
			/*fRed=fCoeff*fDistp_stGLLight->fRed;
			fGreen=fCoeff*p_stGLLight->fGreen;
			fBlue=fCoeff*p_stGLLight->fBlue;*/
		}
		fRed+=fCoeff[i]*p_stGLLight->fRed;
		fGreen+=fCoeff[i]*p_stGLLight->fGreen;
		fBlue+=fCoeff[i]*p_stGLLight->fBlue;
		fSumCoeff+=fCoeff[i];
	}
	/*if (fSumCoeff)
	{	fRed/=fSumCoeff;
		fGreen/=fSumCoeff;
		fBlue/=fSumCoeff;
	}*/
	
	player = &players[consoleplayer];
	if (player->fixedcolormap == INVERSECOLORMAP)
	{//	(*glColor3f_s) (1.0f,1.0f,0.0f);
		fRedS=1.0f;
		fGreenS=1.0f;
		fBlueS=1.0f;
	}
	else
	if (player->fixedcolormap)
#ifndef DOOM_GL
	{	fColor=0.05f*player->fixedcolormap+0.5f;
		fRedS=fColor+fGamma+g_fRed;
		fGreenS=fColor+fGamma-g_fRed;
		fBlueS=fColor+fGamma-g_fRed;
		//(*glColor3f_s) (fColor+fGamma+g_fRed,fColor+fGamma-g_fRed,fColor+fGamma-g_fRed);
	}
	else
	{	//(*glColor3f_s) (fRed+fGamma+g_fRed,fGreen+fGamma-g_fRed,fBlue+fGamma-g_fRed);
		fRedS=fLightLevel+fGamma+g_fRed;
		fGreenS=fLightLevel+fGamma-g_fRed;
		fBlueS=fLightLevel+fGamma-g_fRed;
	}
#elif GL_HEXEN
	{	fColor=0.05f*player->fixedcolormap+0.5f;
		fRedS=fColor+fGamma+g_fRed-g_fGreen-g_fBlue;
		fGreenS=fColor+fGamma-g_fRed+g_fGreen-g_fBlue;
		fBlueS=fColor+fGamma-g_fRed-g_fGreen+g_fBlue;
	}
	else
	{	fRedS=fRed+fGamma+g_fRed-g_fGreen-g_fBlue;
		fGreenS=fGreen+fGamma-g_fRed+g_fGreen-g_fBlue;
		fBlueS=fBlue+fGamma-g_fRed-g_fGreen+g_fBlue;
	}
#else
	{//	(*glColor3f_s) (1.0f,1.0f,0.0f);
		fRedS=1.0f;
		fGreenS=1.0f;
		fBlueS=1.0f;
	}
	else
	{//	(*glColor3f_s) (fRed+fGamma+g_fRed-g_fGreen,fGreen+fGamma-g_fRed+g_fGreen,fBlue+fGamma-g_fRed-g_fGreen);
		fRedS=fLightLevel+fGamma+g_fRed-g_fGreen;
		fGreenS=fLightLevel+fGamma-g_fRed+g_fGreen;
		fBlueS=fLightLevel+fGamma-g_fRed-g_fGreen;
	}
#endif
	if (fSumCoeff)
		fDiff=fSumCoeff;
	else
		fDiff=0.0f;
	fAmb=1.0f/*-fDiff*/;
	fRed=fRed*fDiff+fRedS*fAmb;
	fGreen=fGreen*fDiff+fGreenS*fAmb;
	fBlue=fBlue*fDiff+fBlueS*fAmb;
	//(*glColor3f_s) (fRed,fGreen,fBlue);
	(*glColor4f_s) (fRed,fGreen,fBlue,fAlpha);
}

//void GL_AddLightSource(int ID,float x,float y,float z,float fRed,float fGreen,float fBlue,float fNear, float fFar)
GLboolean GL_bAddLightSource(mobj_t *obj,float x,float y,float z,float fRed,float fGreen,float fBlue,float fNear, float fFar, char update)
{
	if (iGLNbLightSources==MAX_LIGHT_SOURCES)
		return false;
	//a_stGLLight[iGLNbLightSources].ID=ID;
	a_stGLLight[iGLNbLightSources].thing=obj;
	a_stGLLight[iGLNbLightSources].x=x;
	a_stGLLight[iGLNbLightSources].y=y;
	a_stGLLight[iGLNbLightSources].z=z;
	a_stGLLight[iGLNbLightSources].fRed=fRed;
	a_stGLLight[iGLNbLightSources].fGreen=fGreen;
	a_stGLLight[iGLNbLightSources].fBlue=fBlue;
	a_stGLLight[iGLNbLightSources].fFar=fFar;
	a_stGLLight[iGLNbLightSources].fFar2=fFar*fFar;
	a_stGLLight[iGLNbLightSources].fNear=fNear;
	a_stGLLight[iGLNbLightSources].update=update;
	a_stGLLight[iGLNbLightSources++].tic=-1;
	return true;
}

void GL_RemoveLightSource(int ID)
{ int i;
  /* int j; */

	if (ID==-1)
		return;

	if (a_stGLLight[ID].update != UPDATE_FALSE)
	{ return; }

	if (!a_stGLLight[ID].thing)
		return;

		
#ifdef _DEBUG
	if (M_CheckParm("-debugstats"))
	{
		printf("[SDLGLdrv/lights] Light source removed. doomednum - %d\n", a_stGLLight[ID].thing->info->doomednum);
	}
#endif

	a_stGLLight[ID].thing->iLightID=-1;
	a_stGLLight[ID].thing=NULL;
	a_stGLLight[ID].update = -1;

	for (i=ID;i<iGLNbLightSources-1;i++)
	{	memcpy(&a_stGLLight[i],&a_stGLLight[i+1],sizeof(GLDynamicLight));
		a_stGLLight[i].thing->iLightID=i;
	}
	iGLNbLightSources--;
}

/*void GL_MoveLight(int ID,float x,float y,float z)
{ int i;

	for (i=0;i<iGLNbLightSources;i++)
	{
		if (a_stGLLight[i].ID==ID)
		{
			a_stGLLight[i].x=x;
			a_stGLLight[i].y=y;
			a_stGLLight[i].z=z;
			return;
		}
	}
}*/

void GL_SpawnLight(mobj_t *th,fixed_t x,fixed_t y,fixed_t z)
{ float fX,fY,fZ;
  GLboolean result=false;
  int i;

	fX=(float)-x/MAP_SCALE;
	fY=(float)z/MAP_SCALE;
	fZ=(float)y/MAP_SCALE;

//#ifdef DOOM_GL
// DarkFang
/*	switch (th->type)
	{	case MT_ROCKET:
			//GL_AddLightSource(th,fX,fY,fZ,1.0f,0.9f,0.1f,0.0f,7.0f);
			//GL_AddLightSource(th,fX,fY,fZ,1.0f,0.9f,0.1f,0.0f,3.5f);
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.9f,0.1f,0.0f,1.0f);
			break;
		case MT_PLASMA:
			//GL_AddLightSource(th,fX,fY,fZ,0.45f,0.66f,0.97f,0.0f,8.0f);
			//GL_AddLightSource(th,fX,fY,fZ,0.45f,0.66f,0.97f,0.0f,4.0f);
			result=GL_bAddLightSource(th,fX,fY,fZ,0.45f,0.66f,0.97f,0.0f,1.8f);
			break;
		case MT_BFG:
			//GL_AddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.1f,0.0f,10.0f);
			//GL_AddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.1f,0.0f,5.0f);
			result=GL_bAddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.1f,0.0f,2.0f);
			break;
		case MT_EXTRABFG:
			//GL_AddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.1f,0.0f,5.0f);
			//GL_AddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.1f,0.0f,2.5f);
			result=GL_bAddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.1f,0.0f,1.0f);
			break;
		case MT_ARACHPLAZ:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.5f,1.0f,0.2f,0.0f,0.8f);
			break;
		case MT_TROOPSHOT:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.4f,0.2f,0.0f,0.9f);
			break;
		case MT_HEADSHOT:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.8f,0.05f,0.8f,0.0f,0.9f);
			break;
		case MT_BRUISERSHOT:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.43f,1.0f,0.43f,0.0f,0.9f);
			break;
		case MT_TRACER:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.25f,0.25f,0.0f,0.9f);
			break;
		case MT_FATSHOT:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.8f,0.45f,0.15f,0.0f,1.0f);
			break;
		case MT_FIRE:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.94f,0.94f,0.27f,0.0f,1.6f);
			break;
		case MT_PLAYER:	// test
			//GL_AddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.1f,0.0f,1.0f);
			result=GL_bAddLightSource(th,fX,fY,fZ,0.9f,0.9f,0.2f,0.0f,1.0f);
			break;
	}*/
	for (i=0; i<NUMBER_OF_DYNAMIC_LIGHT_SOURCES; i++)
	{

		if (th->type == dynamic_mobjlight[i].type)
		{
			
#ifdef _DEBUG
			if (M_CheckParm("-debugstats"))
			{
				printf("[SDLGLdrv/lights] Lightsource added: Thing num- %d || R: %ld  G: %ld  B: %ld\n", 
					th->info->doomednum, 
					dynamic_mobjlight[i].fRed, 
					dynamic_mobjlight[i].fGreen, 
					dynamic_mobjlight[i].fBlue);
			}
#endif

			if (!g_bLightEffects&&(dynamic_mobjlight[i].update!=UPDATE_FALSE))
				return;
			result = GL_bAddLightSource(th, fX, fY, fZ, 
										dynamic_mobjlight[i].fRed,
										dynamic_mobjlight[i].fGreen,
										dynamic_mobjlight[i].fBlue,
										dynamic_mobjlight[i].fNear,
										dynamic_mobjlight[i].fFar,
										dynamic_mobjlight[i].update);
		
		}
	}
#if !defined(DOOM_GL) && !defined(GL_HEXEN)
	if (th->type==MT_PLAYER)
	{
		if ((th->player->readyweapon==wp_gauntlets)&&(th->player->powers[pw_weaponlevel2]))
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.05f,0.05f,0.0f,1.0f,UPDATE_FALSE);
		else
		if (th->player->readyweapon==wp_gauntlets)
			result=GL_bAddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.1f,0.0f,1.0f,UPDATE_FALSE);
		else
		if (th->player->readyweapon==wp_goldwand)
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.4f,0.2f,0.0f,0.8f,UPDATE_FALSE);
		else
		if (th->player->readyweapon==wp_blaster)
			result=GL_bAddLightSource(th,fX,fY,fZ,0.45f,0.66f,0.97f,0.0f,0.8f,UPDATE_FALSE);
		else result=false;
	}
#endif
// End DarkFang
/*#elif GL_HEXEN
	switch (th->type)
	{
		case MT_FSWORD_MISSILE:	
			result=GL_bAddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.1f,0.0f,0.5f);
			break;
		case MT_FSWORD_FLAME:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.1f,0.0f,1.1f);
			break;
		case MT_MWAND_MISSILE:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.35f,0.56f,1.0f,0.0f,0.9f);
			break;
		case MT_LIGHTNING_ZAP:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.45f,0.60f,0.97f,0.0f,2.0f);
			break;
		case MT_AXEPUFF_GLOW:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.45f,0.66f,0.97f,0.0f,0.9f);
			break;
		case MT_CFLAME_MISSILE:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.5f,0.2f,0.0f,1.1f);
			break;
		case MT_CIRCLEFLAME:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.5f,0.2f,0.0f,0.2f);
			break;
		case MT_HOLY_MISSILE:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,1.0f,1.0f,0.0f,1.0f);
			break;
		case MT_HOLY_FX:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,1.0f,1.0f,0.0f,0.5f);
			break;
		case MT_MSTAFF_FX2:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.1f,0.05f,0.0f,2.0f);
			break;
		case MT_SHARDFX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.45f,0.66f,0.97f,0.0f,0.4f);
			break;
		case MT_CSTAFF_MISSILE:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.1f,0.0f,0.4f);
			break;
		case MT_HAMMER_MISSILE:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.4f,0.2f,0.0f,0.9f);
			break;
		// Monsters
		case MT_MNTRFX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.4f,0.2f,0.0f,0.9f);
			break;
		case MT_SERPENTFX:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.2f,0.0f,0.6f);
			break;
		case MT_CENTAUR_FX:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.45f,0.60f,0.97f,0.0f,1.1f);
			break;
		case MT_BISH_FX:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.79f,0.99f,0.28f,0.0f,0.3f);
			break;
		case MT_DRAGON_FX:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.9f,0.7f,0.1f,0.0f,1.0f);
			break;
		case MT_DEMONFX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.8f,0.1f,0.0f,1.0f);
			break;
		case MT_DEMON2FX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.2f,0.0f,1.0f);
			break;
		case MT_WRAITHFX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.8f,0.45f,0.15f,0.0f,1.0f);
			break;
		case MT_ICEGUY_FX:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.45f,0.66f,0.97f,0.0f,0.7f);
			break;
		case MT_FIREDEMON_FX6:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.9f,0.7f,0.12f,0.0f,0.6f);
			break;
		case MT_SORCFX4:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.9f,0.2f,0.99f,0.0f,0.4f);
			break;
		case MT_SORCFX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.45f,0.15f,0.0f,0.9f);
			break;
	}
#else
	switch (th->type)
	{	
		case MT_GOLDWANDPUFF1:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.4f,0.2f,0.0f,0.9f);
			break;
		case MT_GOLDWANDPUFF2:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.4f,0.2f,0.0f,0.4f);
			break;
		case MT_GOLDWANDFX2:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.4f,0.2f,0.0f,0.8f);
			break;
		case MT_CRBOWFX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.1f,0.0f,1.0f);
			break;
		case MT_CRBOWFX2:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.1f,0.0f,1.2f);
			break;
		case MT_BLASTERPUFF1:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.45f,0.66f,0.97f,0.0f,1.0f);
			break;
		case MT_BLASTERFX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.45f,0.66f,0.97f,0.0f,1.7f);
			break;
		case MT_HORNRODFX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.05f,0.05f,0.0f,1.1f);
			break;
		case MT_HORNRODFX2:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.05f,0.05f,0.0f,3.0f);
			break;
		case MT_PHOENIXFX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.4f,0.2f,0.0f,1.8f);
			break;
		case MT_PHOENIXFX2:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.4f,0.2f,0.0f,1.0f);
			break;
		case MT_MACEFX3:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.4f,0.2f,0.0f,0.9f);
			break;
		case MT_IMPBALL:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.4f,0.2f,0.0f,0.7f);
			break;
		case MT_MUMMYFX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.9f,0.1f,0.0f,0.7f);
			break;
		case MT_SRCRFX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.98f,0.9f,0.3f,0.0f,0.7f);
			break;
		case MT_SOR2FX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.2f,0.98f,0.98f,0.0f,0.95f);
			break;
		case MT_MNTRFX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.4f,0.2f,0.0f,0.9f);
			break;
		case MT_BEASTBALL:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.8f,0.45f,0.15f,0.0f,1.0f);
			break;
		case MT_HEADFX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.1f,0.98f,0.98f,0.0f,1.0f);
			break;
		case MT_HEADFX3:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.8f,0.45f,0.15f,0.0f,2.5f);
			break;
		case MT_SNAKEPRO_A:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.9f,0.6f,0.95f,0.0f,0.65f);
			break;
		case MT_SNAKEPRO_B:
			result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.05f,0.05f,0.0f,0.7f);
			break;
		case MT_WIZFX1:
			result=GL_bAddLightSource(th,fX,fY,fZ,0.8f,0.05f,0.9f,0.0f,0.7f);
			break;
		case MT_PLAYER:			
			if ((th->player->readyweapon==wp_gauntlets)&&(th->player->powers[pw_weaponlevel2]))
				result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.05f,0.05f,0.0f,1.0f);
			else
			if (th->player->readyweapon==wp_gauntlets)
				result=GL_bAddLightSource(th,fX,fY,fZ,0.1f,1.0f,0.1f,0.0f,1.0f);
			else
			if (th->player->readyweapon==wp_goldwand)
				result=GL_bAddLightSource(th,fX,fY,fZ,1.0f,0.4f,0.2f,0.0f,0.8f);
			else
			if (th->player->readyweapon==wp_blaster)
				result=GL_bAddLightSource(th,fX,fY,fZ,0.45f,0.66f,0.97f,0.0f,0.8f);
			else result=false;
			break;
	}*/
//#endif
	if (result)
		th->iLightID=iGLNbLightSources-1;
}

void GL_UpdateLights()
{ int i;
  state_t *stat;
  //player_t *player;

	for (i=0;i<iGLNbLightSources;i++)
	{	a_stGLLight[i].x=(float)-a_stGLLight[i].thing->x/MAP_SCALE;
		a_stGLLight[i].y=(float)a_stGLLight[i].thing->z/MAP_SCALE;
		a_stGLLight[i].z=(float)a_stGLLight[i].thing->y/MAP_SCALE;

		// special effects...
		if (g_bLightEffects)	// DarkFang
		{ AGL_HandleEffects(i); }

		if (a_stGLLight[i].tic==-1)
			continue;
		stat=a_stGLLight[i].thing->state;
#ifdef DOOM_GL
		switch(stat->sprite)
		{
			case SPR_BFE1:
				if (a_stGLLight[i].tic<20)
					a_stGLLight[i].fFar+=0.2f;
				else
					a_stGLLight[i].fFar-=1.0f;
				a_stGLLight[i].tic++;
				break;
			case SPR_BFE2:
				if (a_stGLLight[i].tic<8)
					a_stGLLight[i].fFar+=0.05f;
				else
					a_stGLLight[i].fFar-=0.3f;
				a_stGLLight[i].tic++;
				break;
			case SPR_PLSE:
				if (a_stGLLight[i].tic<10)
					a_stGLLight[i].fFar+=0.1f;
				else
					a_stGLLight[i].fFar-=1.0f;
				a_stGLLight[i].tic++;
				break;
			case SPR_MISL:
				if (a_stGLLight[i].tic<8)
					a_stGLLight[i].fFar+=0.1f;
				else
					a_stGLLight[i].fFar-=0.9f;
				a_stGLLight[i].tic++;
				break;
		}
#endif
		if (a_stGLLight[i].fFar<0.0f)
			a_stGLLight[i].fFar=0.0f;
	}
}
// Special effects:
void A_GL_StartLightEffect(mobj_t *mo)
{ int iLight=mo->iLightID;

	a_stGLLight[iLight].tic=0;
}

#if 0
GLboolean fn_bComputeLightUV1(float lightRad,float x1,float y1,float z1,float x2,float y2,float z2,float x3,float y3,float z3,float *u1,float *u2,float *v1,float *v2)
{ float u,radius,dist,d1,d2,x,y,signV,sign1,sign2;
  GLboolean exit=false;

	// MR1907
#ifdef LRASTER
	if (g_bLightRaster)
		QueryPerformanceCounter(&PerformanceCountStart);
#endif

	// Mettre des if  la place des * -1.
	// Virer les / et les sqrt.
	u=((x3-x1)*(x2-x1)+(y3-y1)*(y2-y1))/((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
	x=x1+u*(x2-x1);
	y=y1+u*(y2-y1);
	dist=sqrt((x3-x)*(x3-x)+(y3-y)*(y3-y));
	if (dist>lightRad)
	//	return false;
		goto lfalse;
	d1=sqrt((x1-x)*(x1-x)+(y1-y)*(y1-y));
	d2=sqrt((x2-x)*(x2-x)+(y2-y)*(y2-y));
	radius=sqrt(lightRad*lightRad-dist*dist);		// MR0507 (sqrt)
	if ((d1>radius)&&(d2>radius))					// MR0507
	//	return false;
		exit=true;
	if (x1!=x2)
	{	signV=(x2>x1)?1.0f:-1.0f;
		sign1=(x1>x)?1.0f:-1.0f;
		sign2=(x2>x)?1.0f:-1.0f;
		if (exit&&(sign1==sign2))
			//return false;
			goto lfalse;
		*u1=signV*sign1*d1/(2*radius)+0.5f;
		*u2=signV*sign2*d2/(2*radius)+0.5f;
	}
	else
	{	signV=(y2>y1)?1.0f:-1.0f;
		sign1=(y1>y)?1.0f:-1.0f;
		sign2=(y2>y)?1.0f:-1.0f;
		if (exit&&(sign1==sign2))
			//return false;
			goto lfalse;
		*u1=signV*sign1*d1/(2*radius)+0.5f;
		*u2=signV*sign2*d2/(2*radius)+0.5f;
	}
	/**u1=(radius-d1)/(2*radius);
	*u2=1.0f+(d2-radius)/(2*radius);*/
	*v1=(radius-z1+z3)/(2*radius);
	*v2=1.0f+(z3-z2-radius)/(2*radius);

	if (g_bLightRaster)
		QueryPerformanceCounter(&PerformanceCountEnd);
	LightPerf.LowPart+=PerformanceCountEnd.LowPart-PerformanceCountStart.LowPart;
	return true;

lfalse:
#ifdef LRASTER
	if (g_bLightRaster)
		QueryPerformanceCounter(&PerformanceCountEnd);
	LightPerf.LowPart+=PerformanceCountEnd.LowPart-PerformanceCountStart.LowPart;
#endif
	return false;

}
#endif	// 0

GLboolean fn_bComputeLightUV(float lightRad,float x1,float y1,float z1,float x2,float y2,float z2,float x3,float y3,float z3,float *u1,float *u2,float *v1,float *v2)
{ float u,radius,dist,d1,d2,x,y,sign1,sign2;
  /* float signV; */
  GLboolean exit=false;
  float radiusDiv/*,radius2*/;

	// MR1907
#ifdef LRASTER
	if (g_bLightRaster)
		QueryPerformanceCounter(&PerformanceCountStart);
#endif

	u=((x3-x1)*(x2-x1)+(y3-y1)*(y2-y1))/((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
	x=x1+u*(x2-x1);
	y=y1+u*(y2-y1);
	dist=(x3-x)*(x3-x)+(y3-y)*(y3-y);
	if (dist>lightRad)
	//	return false;
		goto lfalse;
	d1=sqrt((x1-x)*(x1-x)+(y1-y)*(y1-y));
	d2=sqrt((x2-x)*(x2-x)+(y2-y)*(y2-y));
	radius=sqrt(lightRad-dist);
	//radius2=radius*radius;
	radiusDiv=1/(2*radius);
	if ((d1>radius)&&(d2>radius))
	//	return false;
		exit=true;
	
	if (x1!=x2)
	{	
		sign1=(x1>x)?1.0f:-1.0f;
		sign2=(x2>x)?1.0f:-1.0f;
		//if (exit&&(sign1==sign2))
		if (exit&&((x1>x)==(x2>x)))
		//if (exit&&((x1>x)&&(x2>x))||((x1<=x)&&(x2<=x)))
			//return false;
			goto lfalse;
		if (x2>x1)
		{	if (x1>x)
				*u1=d1*radiusDiv+0.5f;
			else
				*u1=-d1*radiusDiv+0.5f;
			if (x2>x)
				*u2=d2*radiusDiv+0.5f;
			else
				*u2=-d2*radiusDiv+0.5f;
		}
		else
		{	if (x1>x)
				*u1=-d1*radiusDiv+0.5f;
			else
				*u1=d1*radiusDiv+0.5f;
			if (x2>x)
				*u2=-d2*radiusDiv+0.5f;
			else
				*u2=d2*radiusDiv+0.5f;
		}
/*		signV=(x2>x1)?1.0f:-1.0f;
		sign1=(x1>x)?1.0f:-1.0f;
		sign2=(x2>x)?1.0f:-1.0f;
		if (exit&&(sign1==sign2))
			//return false;
			goto lfalse;
		*u1=signV*sign1*d1*radiusDiv+0.5f;
		*u2=signV*sign2*d2*radiusDiv+0.5f;*/
	}
	else
	{	//if (exit&&((y1>y)&&(y2>y))||((y1<y)&&(y2<y)))
		if (exit&&((y1>y)==(y2>y)))
			//return false;
			goto lfalse;
		if (y2>y1)
		{	if (y1>y)
				*u1=d1*radiusDiv+0.5f;
			else
				*u1=-d1*radiusDiv+0.5f;
			if (y2>y)
				*u2=d2*radiusDiv+0.5f;
			else
				*u2=-d2*radiusDiv+0.5f;
		}
		else
		{	if (y1>y)
				*u1=-d1*radiusDiv+0.5f;
			else
				*u1=d1*radiusDiv+0.5f;
			if (y2>y)
				*u2=-d2*radiusDiv+0.5f;
			else
				*u2=d2*radiusDiv+0.5f;
		}
	}

	*v1=(radius-z1+z3)*radiusDiv;
	*v2=1.0f+(z3-z2-radius)*radiusDiv;

#ifdef LRASTER
	if (g_bLightRaster)
		QueryPerformanceCounter(&PerformanceCountEnd);
	LightPerf.LowPart+=PerformanceCountEnd.LowPart-PerformanceCountStart.LowPart;
#endif
	return true;

lfalse:
#ifdef LRASTER
	if (g_bLightRaster)
		QueryPerformanceCounter(&PerformanceCountEnd);
	LightPerf.LowPart+=PerformanceCountEnd.LowPart-PerformanceCountStart.LowPart;
#endif
	return false;

}

void GL_DrawLightsOnPolygon(float x1,float y1,float z1,float x2,float y2,float z2,GLboolean backface)
{ int i;
  GLDynamicLight *p_stGLLight;
  float u1,u2,v1,v2;

	(*glBindTexture_s) (GL_TEXTURE_2D, g_iCorona);
	//(*glBindTexture_s) (GL_TEXTURE_2D, g_iCorona+i);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);

	(*glDepthFunc_s) (GL_LEQUAL);
	//(*glEnable_s) (GL_ALPHA_TEST);
	(*glEnable_s) (GL_BLEND);	
	//(*glBlendFunc_s) (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	//(*glBlendFunc_s) (GL_DST_COLOR, GL_SRC_COLOR);
	//(*glBlendFunc_s) (GL_SRC_ALPHA, GL_SRC_COLOR);
	//(*glBlendFunc_s) (GL_SRC_COLOR, GL_ONE_MINUS_SRC_ALPHA);
	//(*glBlendFunc_s) (GL_ONE_MINUS_DST_ALPHA, GL_DST_ALPHA);

	//(*glBlendFunc_s) (GL_ONE, GL_ONE);
	(*glBlendFunc_s) (GL_DST_COLOR, GL_ONE);

	/*(*glEnable_s) (GL_ALPHA_TEST);
	(*glAlphaFunc_s) (GL_NOTEQUAL,0.0f);*/
	for (i=0;i<iGLNbLightSources;i++)
	{	p_stGLLight=&a_stGLLight[i];
		// MR1907 (version optimise)
		//if (fn_bComputeLightUV(p_stGLLight->fFar,x1,y1,z1,x2,y2,z2,p_stGLLight->x,p_stGLLight->z,p_stGLLight->y,&u1,&u2,&v1,&v2))
		if (fn_bComputeLightUV(p_stGLLight->fFar2,x1,y1,z1,x2,y2,z2,p_stGLLight->x,p_stGLLight->z,p_stGLLight->y,&u1,&u2,&v1,&v2))
		{	
			(*glBegin_s) (GL_QUADS);
			//(*glColor3f_s) (1.0f,1.0f,1.0f);
			//(*glColor4f_s) (0.668f,0.668f,1.0f,0.2f);

			(*glColor3f_s) (p_stGLLight->fRed,p_stGLLight->fGreen,p_stGLLight->fBlue);
			//(*glColor4f_s) (p_stGLLight->fRed,p_stGLLight->fGreen,p_stGLLight->fBlue,0.2f);			
			if (!backface)
			{	(*glTexCoord2f_s) (u1, v1); (*glVertex3f_s) ( x1, z1, y1);
				(*glTexCoord2f_s) (u1, v2); (*glVertex3f_s) ( x1, z2, y1);
				(*glTexCoord2f_s) (u2, v2); (*glVertex3f_s) ( x2, z2, y2);
				(*glTexCoord2f_s) (u2, v1); (*glVertex3f_s) ( x2, z1, y2);
			}
			else
			{	(*glTexCoord2f_s) (u1, v1); (*glVertex3f_s) ( x1, z1, y1);
				(*glTexCoord2f_s) (u2, v1); (*glVertex3f_s) ( x2, z1, y2);
				(*glTexCoord2f_s) (u2, v2); (*glVertex3f_s) ( x2, z2, y2);
				(*glTexCoord2f_s) (u1, v2); (*glVertex3f_s) ( x1, z2, y1);
			}
			(*glEnd_s) ();
		}
	}
	//(*glDisable_s) (GL_ALPHA_TEST);
	(*glDisable_s) (GL_BLEND);	
	(*glDepthFunc_s) (GL_LESS);

	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
}

// Floor / Ceiling
typedef struct
{	int index;
	float radius;
} tdRadiusArray;

tdRadiusArray a_fFloorRadius[MAX_LIGHT_SOURCES],a_fCeilingRadius[MAX_LIGHT_SOURCES];

int compare( const void *arg1, const void *arg2 )
{
   if (((tdRadiusArray *)arg1)->radius>((tdRadiusArray *)arg2)->radius)
		return 1;
	else if (((tdRadiusArray *)arg1)->radius<((tdRadiusArray *)arg2)->radius)
		return -1;
	else
		return 0;
}
void fn_vSortFloorCeilingLights()
{  int i;
	for (i=0;i<iGLNbLightSources;i++)
	{	a_fFloorRadius[i].index=i;
		a_fFloorRadius[i].radius=a_stGLLight[i].fLightRadiusFloor;
		a_fCeilingRadius[i].index=i;
		a_fCeilingRadius[i].radius=a_stGLLight[i].fLightRadiusCeiling;
	}
	qsort(a_fFloorRadius,iGLNbLightSources,sizeof(tdRadiusArray),compare);
	qsort(a_fCeilingRadius,iGLNbLightSources,sizeof(tdRadiusArray),compare);
}

void fn_vComputeLightsRadius(float fFloor,float fCeiling)
{ int i;
  float dist;
  GLDynamicLight *p_stGLLight;

#ifdef RASTER		// MR1907
/*	if (g_bLightRaster)
		QueryPerformanceCounter(&PerformanceCountStart);*/
#endif

	for (i=0;i<iGLNbLightSources;i++)
	{	
		p_stGLLight=&a_stGLLight[i];
		dist=fCeiling-p_stGLLight->y;
		if (dist>p_stGLLight->fFar)
			p_stGLLight->fLightRadiusCeiling=-1;
		else
		{	//p_stGLLight->fLightRadiusCeiling=sqrt(p_stGLLight->fFar*p_stGLLight->fFar-dist*dist);
			p_stGLLight->fLightRadiusCeiling=sqrt(p_stGLLight->fFar2-dist*dist);
			fLightUpC[i]=p_stGLLight->z+p_stGLLight->fLightRadiusCeiling;
			fLightDownC[i]=p_stGLLight->z-p_stGLLight->fLightRadiusCeiling;
			fLightLeftC[i]=p_stGLLight->x-p_stGLLight->fLightRadiusCeiling;
			fLightRightC[i]=p_stGLLight->x+p_stGLLight->fLightRadiusCeiling;
		}
		dist=p_stGLLight->y-fFloor;
		if (dist>p_stGLLight->fFar)
			p_stGLLight->fLightRadiusFloor=-1;
		else
		{	//p_stGLLight->fLightRadiusFloor=sqrt(p_stGLLight->fFar*p_stGLLight->fFar-dist*dist);
			p_stGLLight->fLightRadiusFloor=sqrt(p_stGLLight->fFar2-dist*dist);
			fLightUpF[i]=p_stGLLight->z+p_stGLLight->fLightRadiusFloor;
			fLightDownF[i]=p_stGLLight->z-p_stGLLight->fLightRadiusFloor;
			fLightLeftF[i]=p_stGLLight->x-p_stGLLight->fLightRadiusFloor;
			fLightRightF[i]=p_stGLLight->x+p_stGLLight->fLightRadiusFloor;
		}
	}

//	fn_vSortFloorCeilingLights();
#ifdef RASTER
/*	if (g_bLightRaster)
		QueryPerformanceCounter(&PerformanceCountEnd);
	LightPerf.LowPart+=PerformanceCountEnd.LowPart-PerformanceCountStart.LowPart;*/
#endif
}

GLboolean fn_bComputeLightUVFC(float lightRad,float x1,float y1,float x2,float y2,float *u,float *v)
// x1,y1,z1 = point / x2,y2,z2 = light
{  float RadDiv=1/(2*lightRad);

	*u=(x1-x2)*RadDiv+0.5f;
	*v=(y1-y2)*RadDiv+0.5f;
	/**u=(x1-x2)/(2*lightRad)+0.5f;
	*v=(y1-y2)/(2*lightRad)+0.5f;*/
	return true;
}

extern GLFloorCeilingPolygonArray *a_stFCPolygonArray;
#ifdef GL_HEXEN
#define F_SKY	"F_SKY"
#else
#define F_SKY	"F_SKY1"
#endif

GLboolean fn_bIsLightInArray(int s,int i,float fUp,float fDown,float fLeft,float fRight)
{
	if (a_stFCPolygonArray[s].p_stVertexArray[i].fUp<fDown)
		return false;
	if (a_stFCPolygonArray[s].p_stVertexArray[i].fDown>fUp)
		return false;
	if (a_stFCPolygonArray[s].p_stVertexArray[i].fLeft>fRight)
		return false;
	if (a_stFCPolygonArray[s].p_stVertexArray[i].fRight<fLeft)
		return false;
	return true;
}

void _GL_DrawLightForFloorCeiling(int s)
{ int l;
  /* int i, j; */
  /* int k,iNbLights; */
  /* float u,v; */
  GLDynamicLight *p_stGLLight;
  float fFloorHeight;
  /* float fCeilingHeight; */

	(*glDepthFunc_s) (GL_LEQUAL);
	//(*glDepthFunc_s) (GL_EQUAL);
	//(*glEnable_s) (GL_BLEND);	

	//(*glBlendFunc_s) (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	//(*glBlendFunc_s) (GL_ONE, GL_ONE);
	(*glBlendFunc_s) (GL_DST_COLOR, GL_ONE);
	//(*glBindTexture_s) (GL_TEXTURE_2D, g_iCorona+1);
	(*glBindTexture_s) (GL_TEXTURE_2D, g_iCorona);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);

#ifdef GL_HEXEN
	if (a_stFCPolygonArray[s].iNbArrays)
#endif	
	fn_vComputeLightsRadius(a_stFCPolygonArray[s].p_stVertexArray[0].p_fVertex[1],a_stFCPolygonArray[s].p_stVertexArray[0].p_fCeiling[0]);

	if (sectors[s].floorpic==R_FlatNumForName(F_SKY))
	{	
		goto dceiling;
	}
	(*glCullFace_s) (GL_FRONT);

	//iNbLights=iGLNbLightSources<3?iGLNbLightSources:3;
	for (l=0;l<iGLNbLightSources;l++)
	//for (k=0;k<iNbLights;k++)
	{	//l=a_fFloorRadius[k].index;

		p_stGLLight=&a_stGLLight[l];
		if (p_stGLLight->fLightRadiusFloor==-1)
			continue;
		fFloorHeight=a_stFCPolygonArray[s].p_stVertexArray[0].p_fVertex[1];
		/*for (i=0;i<a_stFCPolygonArray[s].iNbArrays;i++)
		{	
			if (!fn_bIsLightInArray(s,i,fLightUpF[l],fLightDownF[l],fLightLeftF[l],fLightRightF[l]))
				continue;
			(*glBegin_s) (a_stFCPolygonArray[s].p_stVertexArray[i].mode);
			for (j=0;j<a_stFCPolygonArray[s].p_stVertexArray[i].iNbVertices;j++)
			{	
				(*glColor3f_s) (p_stGLLight->fRed,p_stGLLight->fGreen,p_stGLLight->fBlue);
				//(*glColor4f_s) (p_stGLLight->fRed,p_stGLLight->fGreen,p_stGLLight->fBlue,0.2f);
				fn_bComputeLightUVFC(p_stGLLight->fLightRadiusFloor,
									 a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3],
									 a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2],
									 p_stGLLight->x,p_stGLLight->z,&u,&v);
				(*glTexCoord2f_s) (u,v);
				(*glVertex3f_s) ( a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3],
							fFloorHeight,
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2] );
			}
			(*glEnd_s) ();
		}*/
		(*glColor3f_s) (p_stGLLight->fRed,p_stGLLight->fGreen,p_stGLLight->fBlue);
		(*glBegin_s) (GL_QUADS);
			(*glTexCoord2f_s) (0,0);  (*glVertex3f_s) (fLightLeftF[l],fFloorHeight,fLightUpF[l]);
			(*glTexCoord2f_s) (0,1);  (*glVertex3f_s) (fLightRightF[l],fFloorHeight,fLightUpF[l]);
			(*glTexCoord2f_s) (1,1);  (*glVertex3f_s) (fLightRightF[l],fFloorHeight,fLightDownF[l]);
			(*glTexCoord2f_s) (1,0);  (*glVertex3f_s) (fLightLeftF[l],fFloorHeight,fLightDownF[l]);
		(*glEnd_s) ();
	}
dceiling:
	// MR090699
	(*glCullFace_s) (GL_BACK);

 	if (sectors[s].ceilingpic==R_FlatNumForName(F_SKY))
	{	
		(*glDisable_s) (GL_BLEND);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
		(*glDepthFunc_s) (GL_LESS);
		return;
	}
	
	for (l=0;l<iGLNbLightSources;l++)
	//for (k=0;k<iNbLights;k++)
	{	//l=a_fCeilingRadius[k].index;

		p_stGLLight=&a_stGLLight[l];
		if (p_stGLLight->fLightRadiusCeiling==-1)
			continue;
/*		for (i=0;i<a_stFCPolygonArray[s].iNbArrays;i++)
		{	
			if (!fn_bIsLightInArray(s,i,fLightUpC[l],fLightDownC[l],fLightLeftC[l],fLightRightC[l]))
				continue;
			(*glBegin_s) (a_stFCPolygonArray[s].p_stVertexArray[i].mode);
			for (j=0;j<a_stFCPolygonArray[s].p_stVertexArray[i].iNbVertices;j++)
			{	
				(*glColor3f_s) (p_stGLLight->fRed,p_stGLLight->fGreen,p_stGLLight->fBlue);
				//(*glColor4f_s) (p_stGLLight->fRed,p_stGLLight->fGreen,p_stGLLight->fBlue,0.2f);
				fn_bComputeLightUVFC(p_stGLLight->fLightRadiusCeiling,
									 a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3],
									 a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2],
									 p_stGLLight->x,p_stGLLight->z,&u,&v);
				(*glTexCoord2f_s) (u,v);
				(*glVertex3f_s) ( a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fCeiling[j],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2] );
			}
			(*glEnd_s) ();
		}		*/
		/*fCeilingHeight=a_stFCPolygonArray[s].p_stVertexArray[0].p_fCeiling[0];
		(*glColor3f_s) (p_stGLLight->fRed,p_stGLLight->fGreen,p_stGLLight->fBlue);
		(*glBegin_s) (GL_QUADS);
			(*glTexCoord2f_s) (0,0);  (*glVertex3f_s) (fLightLeftC[l],fCeilingHeight,fLightUpC[l]);
			(*glTexCoord2f_s) (0,1);  (*glVertex3f_s) (fLightRightC[l],fCeilingHeight,fLightUpC[l]);
			(*glTexCoord2f_s) (1,1);  (*glVertex3f_s) (fLightRightC[l],fCeilingHeight,fLightDownC[l]);
			(*glTexCoord2f_s) (1,0);  (*glVertex3f_s) (fLightLeftC[l],fCeilingHeight,fLightDownC[l]);
		(*glEnd_s) ();*/
	}
	(*glDisable_s) (GL_BLEND);	
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);

	(*glDepthFunc_s) (GL_LESS);
}

void GL_DrawLightForFloorCeiling(int s)
{ int l,i,j;
  /* int k,iNbLights; */
  float u,v;
  GLDynamicLight *p_stGLLight;

	if (!a_stFCPolygonArray[s].iNbArrays)
		return;

	(*glDepthFunc_s) (GL_LEQUAL);
	//(*glEnable_s) (GL_ALPHA_TEST);
	(*glEnable_s) (GL_BLEND);	
	//(*glBlendFunc_s) (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	//(*glBlendFunc_s) (GL_ONE, GL_ONE);
	(*glBlendFunc_s) (GL_DST_COLOR, GL_ONE);
	//(*glBindTexture_s) (GL_TEXTURE_2D, g_iCorona+1);
	(*glBindTexture_s) (GL_TEXTURE_2D, g_iCorona);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);

//#ifdef GL_HEXEN
//#endif	
	fn_vComputeLightsRadius(a_stFCPolygonArray[s].p_stVertexArray[0].p_fVertex[1],a_stFCPolygonArray[s].p_stVertexArray[0].p_fCeiling[0]);

	if (sectors[s].floorpic==R_FlatNumForName(F_SKY))
	{	
		goto dceiling;
	}
	(*glCullFace_s) (GL_FRONT);

	//iNbLights=iGLNbLightSources<3?iGLNbLightSources:3;
	for (l=0;l<iGLNbLightSources;l++)
	//for (k=0;k<iNbLights;k++)
	{	//l=a_fFloorRadius[k].index;

		p_stGLLight=&a_stGLLight[l];
		if (p_stGLLight->fLightRadiusFloor==-1)
			continue;
		for (i=0;i<a_stFCPolygonArray[s].iNbArrays;i++)
		{	
			if (!fn_bIsLightInArray(s,i,fLightUpF[l],fLightDownF[l],fLightLeftF[l],fLightRightF[l]))
				continue;
			(*glBegin_s) (a_stFCPolygonArray[s].p_stVertexArray[i].mode);
			for (j=0;j<a_stFCPolygonArray[s].p_stVertexArray[i].iNbVertices;j++)
			{	
				(*glColor3f_s) (p_stGLLight->fRed,p_stGLLight->fGreen,p_stGLLight->fBlue);
				//(*glColor4f_s) (p_stGLLight->fRed,p_stGLLight->fGreen,p_stGLLight->fBlue,0.2f);
				fn_bComputeLightUVFC(p_stGLLight->fLightRadiusFloor,
									 a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3],
									 a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2],
									 p_stGLLight->x,p_stGLLight->z,&u,&v);
				(*glTexCoord2f_s) (u,v);
				(*glVertex3f_s) ( a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+1],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2] );
			}
			(*glEnd_s) ();
		}
	}
dceiling:
	// MR090699
	(*glCullFace_s) (GL_BACK);

 	if (sectors[s].ceilingpic==R_FlatNumForName(F_SKY))
	{	
		(*glDisable_s) (GL_BLEND);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
		return;
	}
	
	for (l=0;l<iGLNbLightSources;l++)
	//for (k=0;k<iNbLights;k++)
	{	//l=a_fCeilingRadius[k].index;

		p_stGLLight=&a_stGLLight[l];
		if (p_stGLLight->fLightRadiusCeiling==-1)
			continue;
		for (i=0;i<a_stFCPolygonArray[s].iNbArrays;i++)
		{	
			if (!fn_bIsLightInArray(s,i,fLightUpC[l],fLightDownC[l],fLightLeftC[l],fLightRightC[l]))
				continue;
			(*glBegin_s) (a_stFCPolygonArray[s].p_stVertexArray[i].mode);
			for (j=0;j<a_stFCPolygonArray[s].p_stVertexArray[i].iNbVertices;j++)
			{	
				(*glColor3f_s) (p_stGLLight->fRed,p_stGLLight->fGreen,p_stGLLight->fBlue);
				//(*glColor4f_s) (p_stGLLight->fRed,p_stGLLight->fGreen,p_stGLLight->fBlue,0.2f);
				fn_bComputeLightUVFC(p_stGLLight->fLightRadiusCeiling,
									 a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3],
									 a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2],
									 p_stGLLight->x,p_stGLLight->z,&u,&v);
				(*glTexCoord2f_s) (u,v);
				(*glVertex3f_s) ( a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fCeiling[j],
							a_stFCPolygonArray[s].p_stVertexArray[i].p_fVertex[j*3+2] );
			}
			(*glEnd_s) ();
		}		
	}
	(*glDisable_s) (GL_BLEND);	
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
}

// ---------------------------------------------------------------------------------
// CORONAS
// ---------------------------------------------------------------------------------

#ifdef DOOM_GL
#ifndef FLARES
#define NB_LIGHT_SOURCES	14
#else
#define NB_LIGHT_SOURCES	20
#endif
GLCoronaProp g_a_CoronasProp[NB_LIGHT_SOURCES]=
	{ 	// Distances (last 3 values) for MAP_COEFF = 100
		// For another MAP_COEFF: value * = 100/MAP_COEFF
		/*{ 34  , 1.0f,0.90f,0.50f,0.3f, -1, 17,0.5f,10.0f,10.00f },
		{ 35  , 1.0f,0.90f,0.50f,0.3f,-10, 55,0.5f,10.0f,10.00f },
		{ 35  , 1.0f,0.99f,0.50f,0.3f,  0, 60,0.5f,10.0f,10.00f },
		{ 35  , 1.0f,0.90f,0.50f,0.3f, 10, 55,0.5f,10.0f,10.00f },
		{ 44  ,0.13f,0.25f,1.00f,0.5f,  0, 57,1.0f,5.0f,10.0f },
		{ 45  ,0.25f,1.00f,0.25f,0.5f,  0, 57,1.0f,5.0f,10.0f },
		{ 46  , 1.0f,0.45f,0.13f,0.5f,  0, 57,1.5f,4.5f,10.0f },
		{ 55  ,0.13f,0.25f,1.00f,0.5f,  0, 35,1.5f,4.5f,10.0f },
		{ 56  ,0.25f,1.00f,0.25f,0.5f,  0, 35,1.5f,4.5f,10.0f },
		{ 57  , 1.0f,0.45f,0.13f,0.5f,  0, 35,1.0f,5.0f,10.0f },
		{ 70  , 1.0f,0.99f,0.50f,0.3f,  0, 35,1.7f,4.0f,8.00f },
		{ 85  , 1.0f,1.00f,1.00f,0.8f,  0, 70,1.0f,4.0f,10.0f },
		{ 86  , 1.0f,1.00f,1.00f,0.8f,  1, 52,1.0f,4.0f,10.0f },
		{ 2028, 1.0f,1.00f,1.00f,0.8f,  -1, 40,0.5f,5.0f,10.0f } };*/
		{ MT_MISC49  , GL_CORONA, 1.0f,0.90f,0.50f,0.3f, -1, 17,0.5f,10.0f,10.00f },
		{ MT_MISC50  , GL_CORONA, 1.0f,0.90f,0.50f,0.3f,-10, 55,0.5f,10.0f,10.00f },
		{ MT_MISC50  , GL_CORONA, 1.0f,0.99f,0.50f,0.3f,  0, 60,0.5f,10.0f,10.00f },
		{ MT_MISC50  , GL_CORONA, 1.0f,0.90f,0.50f,0.3f, 10, 55,0.5f,10.0f,10.00f },
		{ MT_MISC41  , GL_CORONA,0.13f,0.25f,1.00f,0.5f,  0, 57,1.0f,5.0f,10.0f },
		{ MT_MISC42  , GL_CORONA,0.25f,1.00f,0.25f,0.5f,  0, 57,1.0f,5.0f,10.0f },
		{ MT_MISC43  , GL_CORONA, 1.0f,0.45f,0.13f,0.5f,  0, 57,1.5f,4.5f,10.0f },
		{ MT_MISC44  , GL_CORONA,0.13f,0.25f,1.00f,0.5f,  0, 35,1.5f,4.5f,10.0f },
		{ MT_MISC45  , GL_CORONA,0.25f,1.00f,0.25f,0.5f,  0, 35,1.5f,4.5f,10.0f },
		{ MT_MISC46  , GL_CORONA, 1.0f,0.45f,0.13f,0.5f,  0, 35,1.0f,5.0f,10.0f },
		{ MT_MISC77  , GL_CORONA, 1.0f,0.99f,0.50f,0.3f,  0, 35,1.7f,4.0f,8.00f },
		{ MT_MISC29  , GL_CORONA, 1.0f,1.00f,1.00f,0.8f,  0, 70,1.0f,4.0f,10.0f },
		{ MT_MISC30  , GL_CORONA, 1.0f,1.00f,1.00f,0.8f,  1, 52,1.0f,4.0f,10.0f },
		{ MT_MISC31  , GL_CORONA, 1.0f,1.00f,1.00f,0.6f, -2, 40,0.5f,5.0f,10.0f },
#ifdef FLARES		
		{ MT_PLASMA	 ,   GL_FLARE, 0.4f, 0.4f, 1.0f, 0.3f, 0, 0, 0.5f, 5.0f, 12.0f },
		{ MT_BFG,        GL_FLARE, 0.6f, 1.0f, 0.3f, 0.3f, 0, 0, 0.2f, 5.0f, 12.0f },
		{ MT_TROOPSHOT,  GL_FLARE, 0.7f, 0.2f, 0.1f, 0.6f, 0, 0, 0.6f, 5.0f, 12.0f },
		{ MT_HEADSHOT,   GL_FLARE, 0.8f, 0.0f, 0.4f, 0.5f, 0, 0, 0.9f, 8.0f, 12.0f },
		{ MT_BRUISERSHOT,GL_FLARE, 0.2f, 1.0f, 0.2f, 0.5f, 0, 0, 0.5f, 8.0f, 10.0f },
		{ MT_ROCKET,     GL_FLARE, 0.7f, 0.2f, 0.2f, 0.3f, 0, 0, 0.5f, 8.0f, 10.0f }
#endif
};
#elif GL_HEXEN
#define NB_LIGHT_SOURCES	13
GLCoronaProp g_a_CoronasProp[NB_LIGHT_SOURCES]=
	{ 	
		/*{ 8061, 1.0f,0.80f,0.40f,0.5f,0.5f,  35,0.70f,2.00f,4.0f },
		{ 8066, 0.3f,0.78f,0.97f,0.3f,   3,  24,0.40f,3.10f,5.0f },
		{ 17  , 1.0f,0.60f,0.30f,0.3f, -19,  22,0.25f, 5.0f,5.0f },
		{ 17  , 1.0f,0.60f,0.30f,0.3f,  -2,  27,0.25f, 5.0f,5.0f },
		{ 17  , 1.0f,0.60f,0.30f,0.3f, 4.5f,  20,0.25f, 5.0f,5.0f },
		{ 17  , 1.0f,0.60f,0.30f,0.3f,  22,  24,0.25f, 5.0f,5.0f },
		{ 119 , 1.0f,0.70f,0.30f,0.3f,  -5,  10,0.25f, 5.0f,5.0f },
		{ 119 , 1.0f,0.70f,0.30f,0.3f,   0,  15,0.25f, 5.0f,5.0f },
		{ 119 , 1.0f,0.70f,0.30f,0.3f,   7,   8,0.25f, 5.0f,5.0f },
		{ 8042, 1.0f,0.80f,0.40f,0.48f,  0,  27,0.70f,2.00f,4.0f },
		{ 8060, 1.0f,0.70f,0.36f,0.45f,  2,  25,0.57f,2.50f,4.5f },
		{ 116 , 1.0f,0.70f,0.36f,0.45f,  2,  60,0.77f,2.20f,3.8f },
		{ 54  , 0.9f,0.80f,0.40f,0.5f,1.0f,  30,0.50f,2.60f,4.5f },*/
		{ MT_BRASSTORCH  , GL_CORONA, 1.0f,0.80f,0.40f,0.5f,0.5f,  35,0.70f,2.00f,4.0f },
		{ MT_ZBLUE_CANDLE, GL_CORONA, 0.3f,0.78f,0.97f,0.3f,   3,  24,0.40f,3.10f,5.0f },
		{ MT_MISC5       , GL_CORONA, 1.0f,0.60f,0.30f,0.3f, -19,  22,0.25f, 5.0f,5.0f },
		{ MT_MISC5       , GL_CORONA, 1.0f,0.60f,0.30f,0.3f,  -2,  27,0.25f, 5.0f,5.0f },
		{ MT_MISC5       , GL_CORONA, 1.0f,0.60f,0.30f,0.3f, 4.5f,  20,0.25f, 5.0f,5.0f },
		{ MT_MISC5       , GL_CORONA, 1.0f,0.60f,0.30f,0.3f,  22,  24,0.25f, 5.0f,5.0f },
		{ MT_MISC79      , GL_CORONA, 1.0f,0.70f,0.30f,0.3f,  -5,  10,0.25f, 5.0f,5.0f },
		{ MT_MISC79      , GL_CORONA, 1.0f,0.70f,0.30f,0.3f,   0,  15,0.25f, 5.0f,5.0f },
		{ MT_MISC79      , GL_CORONA, 1.0f,0.70f,0.30f,0.3f,   7,   8,0.25f, 5.0f,5.0f },
		{ MT_ZFIREBULL   , GL_CORONA, 1.0f,0.80f,0.40f,0.48f,  0,  27,0.70f,2.00f,4.0f },
		{ MT_FIRETHING   , GL_CORONA, 1.0f,0.70f,0.36f,0.45f,  2,  25,0.57f,2.50f,4.5f },
		{ MT_ZTWINEDTORCH, GL_CORONA, 1.0f,0.70f,0.36f,0.45f,  2,  60,0.77f,2.20f,3.8f },
		{ MT_ZWALLTORCH  , GL_CORONA, 0.9f,0.80f,0.40f,0.5f,1.0f,  30,0.50f,2.60f,4.5f },
	};
#else
#define NB_LIGHT_SOURCES	11
GLCoronaProp g_a_CoronasProp[NB_LIGHT_SOURCES]=
	{ 	
		{ MT_SERPTORCH   , GL_CORONA, 1.0f,0.90f,0.50f,0.5f,   0,  50,0.35f,2.90f,5.0f },
		{ MT_CHANDELIER  , GL_CORONA, 1.0f,0.60f,0.30f,0.3f, -22,  19,0.25f, 5.0f,5.0f },
		{ MT_CHANDELIER  , GL_CORONA, 1.0f,0.60f,0.30f,0.3f, -17,  16,0.25f, 5.0f,5.0f },
		{ MT_CHANDELIER  , GL_CORONA, 1.0f,0.60f,0.30f,0.3f, -10,  20,0.25f, 5.0f,5.0f },
		{ MT_CHANDELIER  , GL_CORONA, 1.0f,0.60f,0.30f,0.3f,   3,  17,0.25f, 5.0f,5.0f },
		{ MT_CHANDELIER  , GL_CORONA, 1.0f,0.60f,0.30f,0.3f,   8,  20,0.25f, 5.0f,5.0f },
		{ MT_CHANDELIER  , GL_CORONA, 1.0f,0.60f,0.30f,0.3f,  14,  16,0.25f, 5.0f,5.0f },
		{ MT_CHANDELIER  , GL_CORONA, 1.0f,0.60f,0.30f,0.3f,  21,  19,0.25f, 5.0f,5.0f },
		{ MT_MISC10      , GL_CORONA, 0.9f,0.80f,0.40f,0.5f,   0,  77,0.50f,2.60f,5.0f },
		{ MT_MISC6       , GL_CORONA, 1.0f,0.80f,0.40f,0.5f,   0,  45,0.70f,2.00f,4.0f }, 
		{ MT_MISC12      , GL_CORONA, 1.0f,0.50f,0.20f,0.5f,   0,  20,0.50f,2.50f,5.0f } };
#endif

extern fixed_t		shootz;	
extern fixed_t		attackrange;
extern fixed_t		aimslope;
extern mobj_t *shootthing;
extern fixed_t	topslope;
extern fixed_t	bottomslope;	

extern GLuint *texobjs;

mobj_t *lamp;

#define MAX_CORONAS 50
GLCorona p_stCorona[MAX_CORONAS];
int iCoronaIndex=0;

unsigned char *g_p_bCoronaTexture;
unsigned char *g_p_bLightTexture;

// ---------------------------------------------------------------------------------
// CORONAS: Inits
// ---------------------------------------------------------------------------------
void fn_vLoadRAWFile(char *szFileName,unsigned char *Texture,int width,int height)
{ int hFile;
  unsigned char *buffer;
  int x,y;

  buffer=(unsigned char *)malloc(width*height);
	if ((hFile=wadopen(szFileName)) == -1)
		I_Error("Could not open file %s\n",szFileName);
	
	read(hFile, buffer, width*height);
	close(hFile);
	for (x=0;x<width;x++)
	for (y=0;y<height;y++)
	{	if (buffer[(y*width+x)]<40)
			buffer[(y*width+x)]=0;	// a voir...
		Texture[4*(y*width+x)]=buffer[(y*width+x)];
		Texture[4*(y*width+x)+1]=buffer[(y*width+x)];
		Texture[4*(y*width+x)+2]=buffer[(y*width+x)];
		Texture[4*(y*width+x)+3]=buffer[(y*width+x)];
	}
	free(buffer);
}
#if 0	// For corona.raw
void fn_vLoadRAWFile(char *szFileName,unsigned char *Texture,int width,int height)
{ FILE *hFile;
  unsigned char *buffer;
  int x,y;

    buffer=(unsigned char *)malloc(width*height*3);
	hFile=fopen(szFileName,"rb");
	if (!hFile)
		I_Error("Could not open file %s\n",szFileName);
	fread(buffer,1,width*height*3,hFile);
	fclose(hFile);
	for (x=0;x<width;x++)
	for (y=0;y<height;y++)
	{	if (buffer[(y*width+x)]<40)
			buffer[(y*width+x)]=0;	// a voir...
		Texture[4*(y*width+x)]=buffer[3*(y*width+x)];
		Texture[4*(y*width+x)+1]=buffer[3*(y*width+x)+1];
		Texture[4*(y*width+x)+2]=buffer[3*(y*width+x)+2];
		Texture[4*(y*width+x)+3]=buffer[3*(y*width+x)];
	}
	free(buffer);
}
#endif	// 0

void GL_LoadCoronaTexture()
{ int x,y;
	/*p_stGLCorona=(GLTexture *)Malloc(sizeof(GLTexture));

	p_stGLCorona.iWidth=128;
	p_stGLCorona.iHeight=128;

	p_stGLCorona.p_bRGBBuffer=(unsigned char *)Malloc(128*128*4);

	p_stGLCorona.a_stSubTex=(GLSubTexture *)Malloc(sizeof(GLSubTexture));
	p_stGLCorona.a_stFreeSpace=(GLSubTexture *)Malloc(sizeof(GLSubTexture));
	p_stGLCorona.iNbSubTextures=1;
	p_stGLCorona.a_stSubTex[0].iU=0;
	p_stGLCorona.a_stSubTex[0].iV=0;
	p_stGLCorona.a_stSubTex[0].iWidth=128;
	p_stGLCorona.a_stSubTex[0].iHeight=128;
	p_stGLCorona.a_stSubTex[0].bIsNZ=1;

	p_stGLCorona.iNbFreeSpace=0;
	p_stGLCorona.a_stFreeSpace[0].iU=0;
	p_stGLCorona.a_stFreeSpace[0].iV=0;
	p_stGLCorona.a_stFreeSpace[0].iWidth=0;
	p_stGLCorona.a_stFreeSpace[0].iHeight=0;*/
//#ifdef DOOM_GL
	g_p_bCoronaTexture=(unsigned char *)Malloc(128*128*4);

	fn_vLoadRAWFile("haze.raw",g_p_bCoronaTexture,128,128);
	//fn_vLoadRAWFile("corona.raw",g_p_bCoronaTexture,64,64);
//#endif
	// Light texture
	g_p_bLightTexture=(unsigned char *)Malloc(128*128*4);
	for (x=0;x<128;x++)
	for (y=0;y<128;y++)
	{	/*g_p_bLightTexture[4*(x+y*128)]=((int)g_p_bCoronaTexture[4*(x+y*128)]+128>255)?255:g_p_bCoronaTexture[4*(x+y*128)]+128;
		g_p_bLightTexture[4*(x+y*128)+1]=((int)g_p_bCoronaTexture[4*(x+y*128)+1]+128>255)?255:g_p_bCoronaTexture[4*(x+y*128)+1]+128;
		g_p_bLightTexture[4*(x+y*128)+2]=((int)g_p_bCoronaTexture[4*(x+y*128)+2]+128>255)?255:g_p_bCoronaTexture[4*(x+y*128)+2]+128;*/
		
		//g_p_bLightTexture[4*(x+y*128)]=((int)g_p_bCoronaTexture[4*(x+y*128)]+192>255)?255:g_p_bCoronaTexture[4*(x+y*128)]+192;
		//g_p_bLightTexture[4*(x+y*128)+1]=((int)g_p_bCoronaTexture[4*(x+y*128)+1]+192>255)?255:g_p_bCoronaTexture[4*(x+y*128)+1]+192;
		//g_p_bLightTexture[4*(x+y*128)+2]=((int)g_p_bCoronaTexture[4*(x+y*128)+2]+192>255)?255:g_p_bCoronaTexture[4*(x+y*128)+2]+192;
		float fIntensity,fX,fY;

		fX=(float)x-64.0f;
		fY=(float)y-64.0f;
		fIntensity=64.0f-(float)sqrt(fX*fX+fY*fY);
		if (fIntensity<0)
			fIntensity=0.0f;
		g_p_bLightTexture[4*(x+y*128)]=(unsigned char)fIntensity;
		g_p_bLightTexture[4*(x+y*128)+1]=(unsigned char)fIntensity;
		g_p_bLightTexture[4*(x+y*128)+2]=(unsigned char)fIntensity;
	}
		
/*	for (x=0;x<NB_LIGHT_SOURCES;x++)		
	{
		g_a_CoronasProp[x].fDistMin/=2;
		g_a_CoronasProp[x].fDistMed/=2;
		g_a_CoronasProp[x].fDistMax/=2;
	}*/
}

// ---------------------------------------------------------------------------------
// CORONAS: Drawing
// ---------------------------------------------------------------------------------

//GLint GL_iGetDoomednum(int index)	// MR2007
mobjtype_t GL_iGetType(int index)
{
	//return g_a_CoronasProp[index].doomednum;
	return g_a_CoronasProp[index].type;
}

GLint GL_GenerateCorona(int doomednum)
{ int i;

	for (i=0;i<NB_LIGHT_SOURCES;i++)
		//if (doomednum==g_a_CoronasProp[i].doomednum)
		if (doomednum==g_a_CoronasProp[i].type)
			return i;
	return -1;
}

void glCoronaColor(float r,float g,float b,float a,float light)
{
	(*glColor4f_s) (r/**light*/,g/**light*/,b/**light*/,a*light);
}

void GL_DrawCoronas(player_t *player)
{ float fWidthL;
  int i;
  /* int j; */
  float fDistance,fdx,fdy;

//#ifdef DOOM_GL
	float fWidth1=(float)64/(MAP_SCALE>>FRACBITS);
	/* float fStencilWidth=(float)1/(MAP_SCALE>>FRACBITS); */
	/* static GLbyte *StencilBuffer=NULL; */
	//static GLfloat *DepthBuffer=NULL;

	
/*	if (!StencilBuffer)
		StencilBuffer=(GLbyte *)malloc(screenwidth*screenheight);

	//if (!DepthBuffer)
	//	DepthBuffer=(GLfloat *)malloc(sizeof(GLfloat)*screenwidth*screenheight);
	
	// No stencil buffer on 3dfx... Unusable...
	(*glEnable_s) (GL_STENCIL_TEST);
	(*glClearStencil_s) (1);
	(*glClear_s) (GL_STENCIL_BUFFER_BIT);
	(*glStencilOp_s) (GL_KEEP, GL_ZERO, GL_KEEP);
	(*glStencilFunc_s) (GL_ALWAYS, 0x1, 0x1);

	// 1st pass: set stencil buffer
	for (i=0;i<iCoronaIndex;i++)
	{
		(*glMatrixMode_s) (GL_MODELVIEW);
		(*glPushMatrix_s) ();
		(*glTranslatef_s) (p_stCorona[i].x,p_stCorona[i].y,p_stCorona[i].z);

		(*glBegin_s) (GL_QUADS);
			GL_StaticLight3f(1.0f,1.0f,1.0f);
			(*glVertex3f_s) ( -fStencilWidth, -fStencilWidth, 0);
			(*glVertex3f_s) ( -fStencilWidth, fStencilWidth, 0);
			(*glVertex3f_s) ( fStencilWidth, fStencilWidth, 0);
			(*glVertex3f_s) ( fStencilWidth, -fStencilWidth, 0);
		(*glEnd_s) ();

		(*glPopMatrix_s) ();
	}

	(*glReadPixels_s) (0,0,screenwidth,screenheight,GL_STENCIL_INDEX,GL_BYTE,StencilBuffer);

	(*glDisable_s) (GL_STENCIL_TEST);*/
	
	//(*glReadPixels_s) (0,0,screenwidth,screenheight,GL_DEPTH_COMPONENT,GL_FLOAT,DepthBuffer);

	/*{ int x,y;
		for (x=0;x<screenwidth;x++)
		for (y=0;y<screenheight;y++)
			if (StencilBuffer[x+y*screenwidth]!=1)
				printf("prout");
	}*/

	//(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[g_iCorona]);
	(*glBindTexture_s) (GL_TEXTURE_2D, g_iCorona);

	//(*glEnable_s) (GL_ALPHA_TEST);
	(*glDepthFunc_s) (GL_ALWAYS);
	
	(*glEnable_s) (GL_BLEND);
	(*glBlendFunc_s) (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	for (i=0;i<iCoronaIndex;i++)
	{ /* GLboolean bDrawCorona=false; */
	  GLCoronaProp *CoronaProp;
		
// stencil test...
/*		for (j=0;j<p_stCorona[i].iNbVertices;j++)
		{	
			//(*glReadPixels_s) (p_stCorona[i].xV[j],p_stCorona[i].yV[j],1,1,GL_DEPTH_COMPONENT,GL_FLOAT,DepthBuffer);
			if (StencilBuffer[p_stCorona[i].xV[j]+screenwidth*p_stCorona[i].yV[j]])
			{	bDrawCorona=true;
			}
		}
		
		if (!bDrawCorona)
			continue;*/

		//CoronaProp=&g_a_CoronasProp[p_stCorona[i].doomednum];
		CoronaProp=&g_a_CoronasProp[p_stCorona[i].type];

#ifdef FLARES
		if (CoronaProp->lighttype == GL_CORONA)
		{
			(*glBindTexture_s) (GL_TEXTURE_2D, g_iCorona);

			(*glDepthFunc_s) (GL_ALWAYS);
	
			(*glEnable_s) (GL_BLEND);
			(*glBlendFunc_s) (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		}
		else if (CoronaProp->lighttype == GL_FLARE)
		{
			
			// Doink!?
			(*glBindTexture_s) (GL_TEXTURE_2D, g_iShine[P_Random()%9]);

			(*glDepthFunc_s) (GL_ALWAYS);
	
			(*glEnable_s) (GL_BLEND);
			(*glBlendFunc_s) (GL_ONE, GL_ONE);
		}
#endif
		fWidthL=fWidth1;
		
		fdx=(float)(-player->mo->x)/MAP_SCALE-p_stCorona[i].x;
		fdy=(float)(player->mo->y)/MAP_SCALE-p_stCorona[i].z;
		fDistance=(float)sqrt(fdx*fdx+fdy*fdy);
		
		/*if (fDistance<5.0f)
			fWidthL*=fDistance/5.0f;*/
		if (fDistance<CoronaProp->fDistMin)
			fWidthL*=CoronaProp->fDistMin/CoronaProp->fDistMed;
		else
		if (fDistance<CoronaProp->fDistMax)
			fWidthL*=fDistance/CoronaProp->fDistMed;
		else
			fWidthL*=CoronaProp->fDistMax/CoronaProp->fDistMed;

		(*glMatrixMode_s) (GL_MODELVIEW);
		(*glPushMatrix_s) ();
		(*glTranslatef_s) (p_stCorona[i].x,p_stCorona[i].y,p_stCorona[i].z);
		(*glRotatef_s) (-90.0f+(float)(player->mo->angle>>ANGLETOFINESHIFT)*360.0f/FINEANGLES,   0.0f, 1.0f, 0.0f);
		//if (fn_bRotateSprite(CoronaProp->doomednum))
		(*glRotatef_s) (-(float)player->lookdir/2 /* /4 */,   1.0f, 0.0f, 0.0f);
		(*glTranslatef_s) ((float)CoronaProp->offsetX/(MAP_SCALE>>FRACBITS),0.0f,0.0f);
		(*glBegin_s) (GL_QUADS);
#ifdef DOOM_GL
			if (player->fixedcolormap)
				GL_StaticLight4f(CoronaProp->fRed,CoronaProp->fGreen,CoronaProp->fBlue,CoronaProp->fAlpha);
			else
#endif
			//(*glColor4f_s) (CoronaProp->fRed,CoronaProp->fGreen,CoronaProp->fBlue,CoronaProp->fAlpha);
			glCoronaColor (CoronaProp->fRed,CoronaProp->fGreen,CoronaProp->fBlue,CoronaProp->fAlpha,p_stCorona[i].fLightLevel);
			(*glTexCoord2f_s) (0, 0);    (*glVertex3f_s) ( -fWidthL, -fWidthL, 0);
			(*glTexCoord2f_s) (0, 1.0f); (*glVertex3f_s) ( -fWidthL, fWidthL, 0);
			(*glTexCoord2f_s) (1.0f, 1); (*glVertex3f_s) ( fWidthL, fWidthL, 0);
			(*glTexCoord2f_s) (1.0f, 0); (*glVertex3f_s) ( fWidthL, -fWidthL, 0);
		(*glEnd_s) ();

		(*glPopMatrix_s) ();
	}

	(*glDisable_s) (GL_BLEND);
	(*glDepthFunc_s) (GL_LESS);

	//(*glDisable_s) (GL_ALPHA_TEST);
	iCoronaIndex=0;
//#endif
}

void GL_AddCorona(int doomednum,float x,float y,float z,float fLightLevel)
{
	if (iCoronaIndex<MAX_CORONAS)
	{	p_stCorona[iCoronaIndex].x=x/*+(float)g_a_CoronasProp[doomednum].offsetX/(MAP_SCALE>>FRACBITS)*/;
		p_stCorona[iCoronaIndex].y=y+(float)g_a_CoronasProp[doomednum].offsetY/(MAP_SCALE>>FRACBITS);
		p_stCorona[iCoronaIndex].z=z;
		p_stCorona[iCoronaIndex].fLightLevel=fLightLevel;
		//p_stCorona[iCoronaIndex++].doomednum=doomednum;
		p_stCorona[iCoronaIndex++].type=doomednum;
	}
}

// ---------------------------------------------------------------------------------
// CORONAS: Clipping
// ---------------------------------------------------------------------------------


H_boolean PTR_LightTraverse (intercept_t* in)
{
    /* fixed_t		x; */
    /* fixed_t		y; */
    /* fixed_t		z; */
    /* fixed_t		frac; */
    
    /* line_t*		li; */
    
    mobj_t*		th;

    /* fixed_t		slope; */
    fixed_t		dist;
    fixed_t		thingtopslope;
    fixed_t		thingbottomslope;
		
    if (in->isaline)
    {
	// MR1106
	/*li = in->d.line;
	
	if (li->special)
	    P_ShootSpecialLine (shootthing, li);

	if ( !(li->flags & ML_TWOSIDED) )
	    goto hitline;
	
	// crosses a two sided line
	P_LineOpening (li);
		
	dist = FixedMul (attackrange, in->frac);

	if (li->frontsector->floorheight != li->backsector->floorheight)
	{
	    slope = FixedDiv (openbottom - shootz , dist);
	    if (slope > aimslope)
		goto hitline;
	}
		
	if (li->frontsector->ceilingheight != li->backsector->ceilingheight)
	{
	    slope = FixedDiv (opentop - shootz , dist);
	    if (slope < aimslope)
		goto hitline;
	}*/

	// shot continues
	return true;
	
	
	// hit line
      /*
      hitline:
		return false;
		*/
    }
    
    // shoot a thing
    th = in->d.thing;
    if ((th == shootthing)||(th == lamp))
	return true;		// can't shoot self
    		
    // check angles to see if the thing can be aimed at
    dist = FixedMul (attackrange, in->frac);
    thingtopslope = FixedDiv (th->z+th->height - shootz , dist);

    if (thingtopslope < aimslope)
	return true;		// shot over the thing

    thingbottomslope = FixedDiv (th->z - shootz, dist);

    if (thingbottomslope > aimslope)
	return true;		// shot under the thing

    
    // hit thing
    return false;	
}

int offsetZ;

H_boolean
PTR_GetLightSlope (intercept_t* in)
{
    line_t*		li;
    mobj_t*		th;
    fixed_t		slope;
    fixed_t		thingslope;
    fixed_t		dist;
		
    if (in->isaline)
    {
	li = in->d.line;
	
	if ( !(li->flags & ML_TWOSIDED) )
	    return false;		// stop
	
	// Crosses a two sided line.
	// A two sided line will restrict
	// the possible target ranges.
	P_LineOpening (li);
	
// MR1105
/*	if (openbottom >= opentop)
	    return false;		// stop*/
	
	dist = FixedMul (attackrange, in->frac);

	if (li->frontsector->floorheight != li->backsector->floorheight)
	{
	    slope = FixedDiv (openbottom - shootz , dist);
	    if (slope > bottomslope)
		bottomslope = slope;
	}
		
	if (li->frontsector->ceilingheight != li->backsector->ceilingheight)
	{
	    slope = FixedDiv (opentop - shootz , dist);
	    if (slope < topslope)
		topslope = slope;
	}
		
	if (topslope <= bottomslope)
	    return false;		// stop
			
	return true;			// shot continues
    }
    
    // shoot a thing
    th = in->d.thing;
    if (th == shootthing)
	return true;			// can't shoot self
    
	if (th!=lamp)
		return true;

    // check angles to see if the thing can be aimed at
    dist = FixedMul (attackrange, in->frac);
	//thingslope=FixedDiv (th->z/*+offsetZ*/ - shootz , dist);
	thingslope=FixedDiv (th->z+offsetZ - shootz , dist);
    
	if ((thingslope < bottomslope)||(thingslope > topslope))
		return true;

	aimslope=thingslope;
    linetarget = th;

    return false;			// don't go any farther
}

fixed_t
GL_GetSlopeForCorona
( mobj_t*	t1,
  /*mobj_t*	t2*/
  fixed_t   LightX,
  fixed_t   LightY  )
{

    shootthing = t1;
    
    ////shootz = t1->z + (t1->height>>1) + 8*FRACUNIT;
	//shootz = t1->z + t1->height /*- (t1->height>>2)*/;
	shootz = t1->z+VIEWHEIGHT;

    // can't shoot outside view angles
/*    topslope = 100*FRACUNIT/160;	
    bottomslope = -100*FRACUNIT/160;*/
    topslope = 300*FRACUNIT/160;	
    bottomslope = -300*FRACUNIT/160;
    
    attackrange = MISSILERANGE;
    linetarget = NULL;
	
    P_PathTraverse ( t1->x, t1->y,
		     LightX, LightY,
		     PT_ADDLINES|PT_ADDTHINGS,
		     PTR_GetLightSlope );
		
    if (linetarget)
	return aimslope;

    return 0;
}

H_boolean GL_ChechCoronaInSight(int iIndex,mobj_t *t1, mobj_t *t2)		// t1=player / t2=light source
{ fixed_t lightX,lightY;

    lightX=t2->x/*+(g_a_CoronasProp[iIndex].offsetX<<FRACBITS)*/;
	lightY=t2->y;
	offsetZ=(g_a_CoronasProp[iIndex].offsetY<<FRACBITS);
	
	lamp=t2;
	aimslope=GL_GetSlopeForCorona(t1,lightX,lightY);
	//if (!linetarget)
	//	return false;
	
	//shootz = t1->z + t1->height/* - (t1->height>>2)*/;
	shootz = t1->z+VIEWHEIGHT;
    //aimslope = (t2->z/*+offsetZ*/) - shootz;
	//aimslope = 0;
	attackrange = MISSILERANGE;
	shootthing = t1;
	//lamphit=false;

	if (P_PathTraverse(t1->x,t1->y,lightX,lightY,PT_ADDLINES|PT_ADDTHINGS2,PTR_LightTraverse))
		return true;
	return false;
}

#if 0
// Select buffer...
/*#define MAX_CORONAS 50
extern GLCorona p_stCorona[MAX_CORONAS];
extern int iCoronaIndex;*/

void GL_HitCoronas(player_t *player)
{ float fWidthL,fWidth1;
  int i;
  float fDistance,fdx,fdy;

//#ifdef DOOM_GL
	fWidth1=(float)1/(MAP_SCALE>>FRACBITS);
		
	for (i=0;i<iCoronaIndex;i++)
	{
		fWidthL=fWidth1;
		
		(*glMatrixMode_s) (GL_MODELVIEW);
		(*glPushMatrix_s) ();
		(*glTranslatef_s) (p_stCorona[i].x,p_stCorona[i].y,p_stCorona[i].z);
		/*(*glRotatef_s) (-90.0f+(float)(player->mo->angle>>ANGLETOFINESHIFT)*360.0f/FINEANGLES,   0.0f, 1.0f, 0.0f);
		(*glRotatef_s) (-(float)player->lookdir/2,   1.0f, 0.0f, 0.0f);*/

		//(*glLoadName_s) (i+1);		// select buffer
		(*glPassThrough_s) (2*i);		// feedback buffer

		(*glBegin_s) (GL_QUADS);
			(*glColor3f_s) (1.0f,0.0f,0.0f);
			(*glVertex3f_s) ( -fWidthL, -fWidthL, 0);
			(*glVertex3f_s) ( -fWidthL, fWidthL, 0);
			(*glVertex3f_s) ( fWidthL, fWidthL, 0);
			(*glVertex3f_s) ( fWidthL, -fWidthL, 0);
		(*glEnd_s) ();

		(*glPassThrough_s) (2*i+1);		// feedback buffer

		(*glPopMatrix_s) ();
	}
//#endif
}

extern float fSkyRadius;
extern GLfloat aspect;

#define BUFSIZE 2048
void _GL_CheckCoronasPresent(float x,float y,float z,float roll,float pitch,float yaw,player_t *player)
{  GLuint selectBuf[BUFSIZE];
   GLint hits;

   (*glSelectBuffer_s) (BUFSIZE, selectBuf);
   (void) (*glRenderMode_s) (GL_SELECT);

   (*glInitNames_s) ();
   (*glPushName_s) (0);

	(*glMatrixMode_s) (GL_PROJECTION);
	(*glLoadIdentity_s) ();

	gluPerspective(65.0, aspect, 0.01, 2*fSkyRadius);

	(*glRotatef_s) (roll,  0.0f, 0.0f, 1.0f);
	(+glRotatef_s) (pitch, 1.0f, 0.0f, 0.0f);
	(*glRotatef_s) (yaw,   0.0f, 1.0f, 0.0f);
	//(*glRotatef_s) (pitch, 1.0f, 0.0f, 0.0f);
	(*glTranslatef_s) (x, y, z);

	// Sprites
	(*glLoadName_s) (51);
	fn_vDrawSprites(player);

	GL_HitCoronas(player);


   hits = (*glRenderMode_s) (GL_RENDER);
   //processHits (hits, selectBuf);
   printf("[SDLGLdrv/lights] prout\n");
}

// Feedback buffer
#define VERTEX_SIZE	2
void processHits(GLint size, GLfloat *buffer)
{
   GLint count,i;
   GLfloat token;
   static int iCoronaID,iVertex;
   H_boolean bPolyDraw,bStartCorona=false;;

   count = size;
   while (count) {
      token = buffer[size-count]; count--;
      if (token == GL_PASS_THROUGH_TOKEN) {
         //printf ("GL_PASS_THROUGH_TOKEN\n");
         //printf ("  %4.2f\n", buffer[size-count]);
		if (!bStartCorona)
		{	bStartCorona=true;
			bPolyDraw=false;
			iCoronaID=(int)buffer[size-count]/2;
			iVertex=0;
		}
		else
		{	bStartCorona=false;
			p_stCorona[iCoronaID].iNbVertices=iVertex;
			/*if (!bPolyDraw)
				p_stCorona[iCoronaID].bDrawCorona=0;
			else
				p_stCorona[iCoronaID].bDrawCorona=1;*/
		}
         count--;
      }
      else if ((token == GL_POINT_TOKEN)||
				(token == GL_BITMAP_TOKEN) ||
				(token == GL_DRAW_PIXEL_TOKEN) ||
				(token == GL_COPY_PIXEL_TOKEN))
	   {
         //printf ("GL_POINT_TOKEN\n");
         //print3DcolorVertex (size, &count, buffer);
		 count-=VERTEX_SIZE;
      }
      else if (token == GL_LINE_TOKEN) {
         //printf ("GL_LINE_TOKEN\n");
         //print3DcolorVertex (size, &count, buffer);
         //print3DcolorVertex (size, &count, buffer);
		 count-=2*VERTEX_SIZE;
      }
      else if (token == GL_LINE_RESET_TOKEN) {
         //printf ("GL_LINE_RESET_TOKEN\n");
         //print3DcolorVertex (size, &count, buffer);
         //print3DcolorVertex (size, &count, buffer);
		 count-=6;
      }
      else if (token == GL_POLYGON_TOKEN) {
         float nbV;
		 
		 //printf ("GL_POLYGON_TOKEN\n");
         //print3DcolorVertex (size, &count, buffer);
         //print3DcolorVertex (size, &count, buffer);
		 nbV=buffer[size-count--];
		 for (i=0;i<nbV;i++)
		 {	p_stCorona[iCoronaID].xV[iVertex]=(int)buffer[size-count--];
			p_stCorona[iCoronaID].yV[iVertex++]=(int)buffer[size-count--];
		}
		 /*count-=(int)nbV*VERTEX_SIZE;
		 bPolyDraw=true;*/
      }
   }
}


void GL_CheckCoronasPresent(float x,float y,float z,float roll,float pitch,float yaw,player_t *player)
{  GLfloat selectBuf[BUFSIZE];
   GLint hits;

   (*glFeedbackBuffer_s) (BUFSIZE, GL_2D, selectBuf);
   (void) (*glRenderMode_s) (GL_FEEDBACK);


	(*glMatrixMode_s) (GL_PROJECTION);
	(*glLoadIdentity_s) ();

	gluPerspective(65.0, aspect, 0.01, 2*fSkyRadius);

	(*glRotatef_s) (roll,  0.0f, 0.0f, 1.0f);
	(*glRotatef_s) (pitch, 1.0f, 0.0f, 0.0f);
	(*glRotatef_s) (yaw,   0.0f, 1.0f, 0.0f);
	//(*glRotatef_s) (pitch, 1.0f, 0.0f, 0.0f);
	(*glTranslatef_s) (x, y, z);

	(*glEnable_s) (GL_DEPTH_TEST);
	(*glEnable_s) (GL_TEXTURE_2D);

	// Sprites
	fn_vDrawSprites(player);

	GL_HitCoronas(player);


   hits = (*glRenderMode_s) (GL_RENDER);
   processHits (hits, selectBuf);
   //printf("prout\n");
}

#endif	// 0

#endif	// GL_HERETIC
