#ifndef __GL_MEM_H__
#define __GL_MEM_H__

#define MAXALLOCS       10000

#define FIX		0
#define LEVEL	        1
#define OTHER           2

#define Malloc(x)	GLMalloc(x)
#define Free(x)	        GLFree(x)
#define Realloc(x,y)	GLRealloc(x,y)

void *alloc_table_FIX[MAXALLOCS];
void *alloc_table_LEVEL[MAXALLOCS];
void *alloc_table_OTHER[MAXALLOCS];

int table_FIX_allocs;
long table_FIX_allocs_summary;
int table_LEVEL_allocs;
long table_LEVEL_allocs_summary;
int table_OTHER_allocs;
long table_OTHER_allocs_summary;

void fn_vInitMemory(unsigned int dwSize);
void fn_vDesinitMemory();
void fn_vSetMemoryMode(char type);
void *GLMalloc(unsigned int dwNbBytes);
void *GLRealloc(void *lpMem, unsigned int dwBytes);
void GLFree(void *lpMem);

int HeapCreate(int heapType);
void HeapDestroy(int heapHandle);
void *HeapAlloc(int heapHandle, int dummy, long numbAlloc);
void *HeapReAlloc(int heapHandle, int dummy, void *prevMemPtr, long numbAlloc);
void HeapFree(int heapHandle, int dummy, void **memPtr);

#endif   /* __GL_MEM_H__ */
