#ifdef GL_HERETIC

//#define __DOOMTYPE__

#include <stdio.h>
#include <string.h>
#include <math.h>

#include "gl_syms.h"

#include "gl_struct.h"
#include "gl_mem.h"
#ifndef GL_HEXEN
#include "doomdef.h"
#else
#include "h2def.h"
#endif
#include "r_local.h"
#include "p_spec.h"

extern int iNbGLTextures;
extern GLuint *texobjs;
extern GLuint *sprobjs;
extern int		numpatches;
//extern GLTexture *p_stGLSprites;
//extern int	iNbGLSprites;
//extern GLTexArray *p_stGLSprArray;
extern int iLightLevelMin,iLightLevelMax;
extern byte *p_bPalette;

extern player_t *player;

extern char* mlump_filename;
extern char* wlump_filename;

int fn_iGetTexHeightGL(int iHeight);
void fn_vRegisterSpriteOnTheFly(int iSpriteLump);
extern void (*GL_vDrawMD2)(mobj_t *pSpr,float fLightLevel);

// sprites
int SPRITE_WIDTH=128;
int SPRITE_HEIGHT=128;
GLTexture *p_stGLSprites;
int	iNbGLSprites;
GLTexArray *p_stGLSprArray;

GLMapSprite *p_stMapSprites;

GLSprite a_SpriteRendered[MAXVISSPRITES];
int iNbSpriteRendered;

GLboolean g_bDynamicAlloc;

// Sprite compression parameters...
GLboolean g_bSpriteOpti=FALSE,g_bSpriteBilinear=FALSE;
float fScaleSprite=0.5f;
int iMaxSizeBeforeReduction=65536;	//4096;	64x64
#ifndef DOOM_GL
float fSpriteFilterDistanceCoeff=0.00312f;	// DOOM_GL
#else
float fSpriteFilterDistanceCoeff=0.012f;
//float fSpriteFilterDistanceCoeff=0.00312f;
#endif

int __max(int a, int b) {
  if (a>=b) 
    return a;
  else
    return b;
}

// Coronas.
long usecoronas;
void GL_AddCorona(int doomednum,float x,float y,float z,float fLightLevel);

void fn_vSaveRAW(char *szFilename,unsigned char *buffer,int width,int height)
{ FILE *fp;
  int x,y;

	fp=fopen(szFilename,"wb");
	for (x=0;x<width;x++)
		for (y=0;y<height;y++)
		{	fwrite(&buffer[4*(x*height+y)],1,1,fp);
			fwrite(&buffer[4*(x*height+y)+1],1,1,fp);
			fwrite(&buffer[4*(x*height+y)+2],1,1,fp);
		}
	fclose(fp);
}

void fn_vSaveSprites()
{ char szFilename[255];
  int iGLIndex;
	
	for (iGLIndex=0;iGLIndex<iNbGLSprites;iGLIndex++)
	{	
		sprintf(szFilename,"pix%03d.raw",iGLIndex);
		fn_vSaveRAW(szFilename,p_stGLSprites[iGLIndex].p_bRGBBuffer,p_stGLSprites[iGLIndex].iWidth,p_stGLSprites[iGLIndex].iHeight);
	}
}

void ScalePicture(unsigned char *src,int ws,int hs,unsigned char *dst,int wd,int hd)
{
  float dx,dy,ddx,ddy;

  float fA,fB,fC,fD;
  int x,y;
  float r,g,b,a;
  int w,h;
  unsigned char *ptr;
  unsigned char t;

  float fw=(float) ws/ (float) wd;
  float fh=(float) hs/ (float) hd;

  for (h=0;h<hd;h++)
  {
    dy=(float) (h*fh);
    y=(int) dy;
    dy-=(float) y;
    ddy=1.0f-dy;

    for(w=0;w<wd;w++)
    {
      dx=(float) (w*fw);
      x=(int) dx;
      dx-=(float) x;
      ddx=1.0f-dx;

      fA=ddx*ddy;
      fB=dx*ddy;
      fC=dx*dy;
      fD=ddx*dy;

      // A
      ptr=src+(y*ws+x)*4;
	  if (!ptr[3])
	  	fA=0;
	  r=(float) (ptr[0]*fA);
	  g=(float) (ptr[1]*fA);
	  b=(float) (ptr[2]*fA);
	  a=(float) ptr[3]*fA;

      // B
      //ptr=src+(y*ws+x+1)*3;
      ptr+=4;
	  if (!ptr[3])
		fB=0;
		  r+=(float) (ptr[0]*fB);
		  g+=(float) (ptr[1]*fB);
		  b+=(float) (ptr[2]*fB);
		  a+=(float) ptr[3]*fB;

      // C
      //ptr=src+((y+1)*ws+x)*3;
      ptr+=4*(ws-1);
	  if (!ptr[3])
		fC=0;
		  r+=(float) (ptr[0]*fC);
		  g+=(float) (ptr[1]*fC);
		  b+=(float) (ptr[2]*fC);
		  a+=(float) ptr[3]*fC;

      // D
      //ptr=src+((y+1)*ws+x+1)*3;
      ptr+=4;
	  if (!ptr[3])
		fD=0;
		  r+=(float) (ptr[0]*fD);
		  g+=(float) (ptr[1]*fD);
		  b+=(float) (ptr[2]*fD);
		  a+=(float) ptr[3]*fD;
	  		    
      if (fA+fB+fC+fD)
	  {
		  r/=(fA+fB+fC+fD);
		  b/=(fA+fB+fC+fD);
		  g/=(fA+fB+fC+fD);
	  }

	  // clipping to be sure
      if (r<0.0f) t=0; else if (r>255.0f) t=255; else t=(unsigned char) r; *dst++=t;
      if (g<0.0f) t=0; else if (g>255.0f) t=255; else t=(unsigned char) g; *dst++=t;
      if (b<0.0f) t=0; else if (b>255.0f) t=255; else t=(unsigned char) b; *dst++=t; 
	  if (a==0)
		*dst++=0;
	  else
		*dst++=255;
	}
  }
}

// MR2606
/*void GL_vSetSpriteVisible(vissprite_t *vis)
{ int i;
	for (i=0;i<iNbSpriteRendered;i++)
		if (a_SpriteRendered[i].vis==vis)
	{	a_SpriteRendered[i].bIsVisible=true;
		return;
	}
}*/
	
void fn_vAddSprite(mobj_t *pSpr,int lump, H_boolean flip,fixed_t dx,fixed_t dy,fixed_t dz/*,vissprite_t*	vis*/)	// MR2606(vissp)
{ int i,j,iInsert;
  float fDist1,fdx1,fdy1,fdz;
  /* float fdx2, fdy2, fDist2; */

	if (iNbSpriteRendered>=MAXVISSPRITES)	// MR1805
		return;
	// MR2806
	{	fdx1=(float)dx/MAP_SCALE;
		fdy1=(float)dy/MAP_SCALE;
		fdz=(float)dz/MAP_SCALE;
		fDist1=sqrt(fdx1*fdx1+fdy1*fdy1+fdz*fdz);
	}
	iInsert=-1;
	for (i=0;i<iNbSpriteRendered;i++)
	{	/*fdx2=(float)a_SpriteRendered[i].dx/MAP_SCALE;
		fdy2=(float)a_SpriteRendered[i].dy/MAP_SCALE;
		fDist2=sqrt(fdx2*fdx2+fdy2*fdy2);
		if (fDist1>fDist2)*/
		if (pSpr==a_SpriteRendered[i].p_Obj)
			return;		// Consequence de l'anti-bug lookdir (rappel du BSPNode dans r_main.c)
		if ((iInsert==-1)&&(fDist1>a_SpriteRendered[i].fDist))
		{	iInsert=i;
		}
	}
	if (iInsert==-1)
		// MR1707
		//iInsert=0;
		iInsert=iNbSpriteRendered;
	for (j=iNbSpriteRendered;j>iInsert;j--)
	{	/*a_SpriteRendered[j+1].dx=a_SpriteRendered[j].dx;
		a_SpriteRendered[j+1].dy=a_SpriteRendered[j].dy;*/
		a_SpriteRendered[j].fDist=a_SpriteRendered[j-1].fDist;
		a_SpriteRendered[j].p_Obj=a_SpriteRendered[j-1].p_Obj;
		a_SpriteRendered[j].iLump=a_SpriteRendered[j-1].iLump;
		//a_SpriteRendered[j].vis=a_SpriteRendered[j-1].vis;
		//a_SpriteRendered[j].bIsVisible=a_SpriteRendered[j-1].bIsVisible;
		a_SpriteRendered[j].bFlip=a_SpriteRendered[j-1].bFlip;
		a_SpriteRendered[j].fLightLevel=a_SpriteRendered[j-1].fLightLevel;
	}

	// MR2806
	/*a_SpriteRendered[i].dx=dx;
	a_SpriteRendered[i].dy=dy;*/
	a_SpriteRendered[iInsert].fDist=fDist1;
	a_SpriteRendered[iInsert].p_Obj=pSpr;
	a_SpriteRendered[iInsert].iLump=lump;
	//a_SpriteRendered[iInsert].vis=vis;	// MR2606
	//a_SpriteRendered[iInsert].bIsVisible=false;	// MR2606

	/*if (fixedcolormap)
		a_SpriteRendered[iNbSpriteRendered].fLightLevel = fixedcolormap;	// fixed map
	else*/ if (pSpr->frame & FF_FULLBRIGHT)
		a_SpriteRendered[iInsert].fLightLevel = 1.0f;				// full bright
	else
	{	// diminished light		
		// MR0207
		//a_SpriteRendered[iInsert].fLightLevel =(float)(pSpr->subsector->sector->lightlevel+(extralight<<LIGHTSEGSHIFT)-iLightLevelMin)/(float)(iLightLevelMax-iLightLevelMin);
		//a_SpriteRendered[iInsert].fLightLevel =(float)(pSpr->subsector->sector->lightlevel+(extralight<<LIGHTSEGSHIFT))/255.0f;
		//a_SpriteRendered[iInsert].fLightLevel =(float)(pSpr->subsector->sector->lightlevel+(extralight<<LIGHTSEGSHIFT)-iLightLevelMin/2)/255.0f;
		a_SpriteRendered[iInsert].fLightLevel=(1.0f+0.25f*(float)usegamma)*((float)(pSpr->subsector->sector->lightlevel+(extralight<<LIGHTSEGSHIFT))-0.5f)/512.0f;		// MR0706
	}

	a_SpriteRendered[iInsert].bFlip=flip;
	iNbSpriteRendered++;

// Test with select or feedback buffers...
#ifdef DOOM_GL
/*	{ float xi,yi,zi;

		xi=-(float)pSpr->x/MAP_SCALE;
		yi=((float)pSpr->z+(float)spritetopoffset[lump])/MAP_SCALE+(float)3/(MAP_SCALE>>FRACBITS);	// Why +2 ???
		zi=(float)pSpr->y/MAP_SCALE;

		if (pSpr->info->doomednum==2028)
		{	//if (P_CheckSight(player->mo,pSpr))
			//if (GL_ChechCoronaInSight(player->mo,pSpr))
				GL_AddCorona(xi,yi,zi);
		}
	}*/
#endif
}

H_boolean fn_bRotateSprite(int doomednum)
{ 
#ifdef DOOM_GL
	if (((doomednum>0)&&(doomednum<5))||
		((doomednum>24)&&(doomednum<38))||
		((doomednum>43)&&(doomednum<58))||
		((doomednum>58)&&(doomednum<64))||
		((doomednum>72)&&(doomednum<79))||
		(doomednum==-1)||
		(doomednum==11)||
		(doomednum==14)||
		(doomednum==85)||
		(doomednum==86)||
		(doomednum==2025)||
		(doomednum==2028))
#elif GL_HEXEN
	if (
		((doomednum>0)&&(doomednum<6))||
		(doomednum==11)||
		(doomednum==14)||
		(doomednum==17)||
		((doomednum>23)&&(doomednum<28))||
		((doomednum>47)&&(doomednum<53))||
		((doomednum>53)&&(doomednum<58))||
		(doomednum==60)||
		(doomednum==61)||
		((doomednum>62)&&(doomednum<70))||
		((doomednum>70)&&(doomednum<81))||
		((doomednum>86)&&(doomednum<100))||
		(doomednum==103)||
		(doomednum==108)||
		(doomednum==109)||
		(doomednum==116)||
		(doomednum==117)||
		(doomednum==119)||
		(doomednum==140)||
		(doomednum==1090)||
		(doomednum==1091)||
		((doomednum>8041)&&(doomednum<8053))||
		((doomednum>8059)&&(doomednum<8069))||
		((doomednum>8070)&&(doomednum<8078))||
		(doomednum==8103)||
		(doomednum==9011)||
		(doomednum==9012))
#else
	if (
		((doomednum>0)&&(doomednum<5))||
		(doomednum==17)||
		((doomednum>23)&&(doomednum<30))||
		((doomednum>36)&&(doomednum<41))||
		((doomednum>46)&&(doomednum<52))||
		(doomednum==76)||
		((doomednum>93)&&(doomednum<97))
		)
#endif
		return false;
	return true;
}

// MD2 ( virer)
extern long g_bMD2;

extern boolean P_CheckSight(mobj_t *t1, mobj_t *t2);

#ifdef OPTI_SPRITE
void fn_vDrawSpritesCompressed(player_t *player)
{ int i;
  float xi,yi,zi,/*fdx,fdy,*/fDistance,/*x1,*/y1,/*x2,*/y2,z1,z2;
  float fWidthL,fWidthR/*,fWidth,fTang,fTangL,fTangR*/;
  float fU1,fU2,fV1,fV2,fLightLevel;
  mobj_t *pSpr;
  int lump;
  int iCoronaIdx;

#if 0
	for (i=0;i<iNbSpriteRendered;i++)
	{
		pSpr=a_SpriteRendered[i].p_Obj;
		fLightLevel=a_SpriteRendered[i].fLightLevel;
		lump=a_SpriteRendered[i].iLump;

		if (p_stGLSprArray[lump].iTexID==-1)
			fn_vRegisterSpriteOnTheFly(lump);

		xi=-(float)pSpr->x/MAP_SCALE;
		zi=(float)pSpr->y/MAP_SCALE;
		fdx=(float)a_SpriteRendered[i].dx/MAP_SCALE;
		fdy=(float)a_SpriteRendered[i].dy/MAP_SCALE;
		fDistance=(float)sqrt(fdx*fdx+fdy*fdy);
		/*fWidth=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth/(2*(MAP_SCALE>>FRACBITS));
		fTang=fWidth/fDistance;
		x1=xi+fTang*fdy;
		y1=(float)pSpr->z/MAP_SCALE;
		z1=zi+fTang*fdx;
		x2=xi-fTang*fdy;
		y2=(float)pSpr->z/MAP_SCALE+(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iHeight/(MAP_SCALE>>FRACBITS);
		z2=zi-fTang*fdx;*/
		fWidthL=(float)spriteoffset[lump]/MAP_SCALE;
		if (p_stGLSprArray[lump].iFlatID==-2)
			fWidthR=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth*2.0f/(MAP_SCALE>>FRACBITS)-fWidthL;
		else
			fWidthR=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth/(MAP_SCALE>>FRACBITS)-fWidthL;
		fTangL=fWidthL/fDistance;
		fTangR=fWidthR/fDistance;
		x1=xi-fTangL*fdy;
		y1=(float)pSpr->z/MAP_SCALE+(float)spritetopoffset[lump]/MAP_SCALE+(float)3/(MAP_SCALE>>FRACBITS);		// Why +2 ???
		z1=zi-fTangL*fdx;
		x2=xi+fTangR*fdy;
		if (p_stGLSprArray[lump].iFlatID==-2)
			y2=y1-(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iHeight*2.0f/(MAP_SCALE>>FRACBITS);
		else
			y2=y1-(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iHeight/(MAP_SCALE>>FRACBITS);
		z2=zi+fTangR*fdx;

		if (a_SpriteRendered[i].bFlip)
		{
			fU1=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iU/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iWidth;
			fU2=(float)(p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iU+p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth)/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iWidth;
		}
		else
		{
			fU2=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iU/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iWidth;
			fU1=(float)(p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iU+p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth)/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iWidth;
		}
		fV1=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iV/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iHeight;
		fV2=(float)(p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iV+p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iHeight)/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iHeight;

		//(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[p_stGLSprArray[lump].iGLTexIndex+iNbGLTextures]);
		(*glBindTexture_s) (GL_TEXTURE_2D, sprobjs[p_stGLSprArray[lump].iGLTexIndex]);

		//(*glEnable_s) (GL_ALPHA_TEST);
		
		//if(pSpr->flags&MF_SHADOW)
		{	//(*glAlphaFunc_s) (GL_EQUAL,0.5f);
			(*glAlphaFunc_s) (GL_NOTEQUAL,0.0f);
			(*glEnable_s) (GL_BLEND);
			(*glBlendFunc_s) (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		}
		/*else
			(*glAlphaFunc_s) (GL_EQUAL,1.0f);*/

		if (!g_bSpriteBilinear||(fDistance>MAP_COEFF*fSpriteFilterDistanceCoeff))
		{	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
			(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		}

/*		if (pSpr->type==42)		// Wall Torch
			//(*glDepthFunc_s) (GL_ALWAYS);
			(*glDepthFunc_s) (GL_LEQUAL);*/

		(*glBegin_s) (GL_QUADS);
			if(pSpr->flags&MF_SHADOW)
				GL_StaticLight4f(fLightLevel,fLightLevel,fLightLevel,0.5f);
			else
				GL_StaticLight3f(fLightLevel,fLightLevel,fLightLevel);
			(*glTexCoord2f_s) (fU1, fV1); (*glVertex3f_s) ( x1, y1, z1);
			(*glTexCoord2f_s) (fU1, fV2); (*glVertex3f_s) ( x1, y2, z1);
			(*glTexCoord2f_s) (fU2, fV2); (*glVertex3f_s) ( x2, y2, z2);
			(*glTexCoord2f_s) (fU2, fV1); (*glVertex3f_s) ( x2, y1, z2);
		(*glEnd_s) ();

		//if(pSpr->flags&MF_SHADOW)
			(*glDisable_s) (GL_BLEND);

		(*glDisable_s) (GL_ALPHA_TEST);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

/*		if (pSpr->type==42)
			(*glDepthFunc_s) (GL_LESS);*/
	}
#else
	// MR2606
/*    R_SortVisSprites ();

    if (vissprite_p > vissprites)
    { vissprite_t *spr;
		// draw all vissprites back to front
		for (spr = vsprsortedhead.next ;
			 spr != &vsprsortedhead ;
			 spr=spr->next)
			R_DrawSprite (spr);
    }*/
	// End MR2606
	for (i=0;i<iNbSpriteRendered;i++)
	{
		/*if (!a_SpriteRendered[i].bIsVisible)	// MR2806
			continue;*/
		pSpr=a_SpriteRendered[i].p_Obj;
		fLightLevel=a_SpriteRendered[i].fLightLevel;
		
#ifndef GL_HEXEN
		if (pSpr->type==MT_PLAYER)
#else
		if ((pSpr->type==MT_PLAYER_FIGHTER)||
			(pSpr->type==MT_PLAYER_SPEED)||
			(pSpr->type==MT_PLAYER_CLERIC)||
			(pSpr->type==MT_PLAYER_MAGE)||
			(pSpr->type==MT_PIGPLAYER))
#endif
			continue;
		lump=a_SpriteRendered[i].iLump;

		if (p_stGLSprArray[lump].iTexID==-1)
			fn_vRegisterSpriteOnTheFly(lump);

		xi=-(float)pSpr->x/MAP_SCALE;
		yi=((float)pSpr->z+(float)spritetopoffset[lump])/MAP_SCALE+(float)3/(MAP_SCALE>>FRACBITS);	// Why +2 ???
		zi=(float)pSpr->y/MAP_SCALE;
		// MR2806
		/*fdx=(float)a_SpriteRendered[i].dx/MAP_SCALE;
		fdy=(float)a_SpriteRendered[i].dy/MAP_SCALE;
		fDistance=(float)sqrt(fdx*fdx+fdy*fdy);*/
		fDistance=a_SpriteRendered[i].fDist;

		fWidthL=(float)spriteoffset[lump]/MAP_SCALE;
		// MR1206
//#ifdef GL_HEXEN
#if 0
		if (p_stGLSprArray[lump].iFlatID==-2)
			fWidthR=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth*2.0f/(MAP_SCALE>>FRACBITS)-fWidthL;
		else
			fWidthR=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth/(MAP_SCALE>>FRACBITS)-fWidthL;
#endif
//		x1=xi-fWidthL;
		y1=0;
		z1=zi;
//		x2=xi+fWidthR;
		if (p_stGLSprArray[lump].iFlatID==-2)
			y2=y1-(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iHeight*2.0f/(MAP_SCALE>>FRACBITS);
		else
			y2=y1-(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iHeight/(MAP_SCALE>>FRACBITS);
		z2=zi;

		if (a_SpriteRendered[i].bFlip)
		{
			fU1=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iU/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iWidth;
			fU2=(float)(p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iU+p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth)/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iWidth;
		}
		else
		{
			fU2=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iU/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iWidth;
			fU1=(float)(p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iU+p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth)/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iWidth;
		}
		fV1=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iV/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iHeight;
		fV2=(float)(p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iV+p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iHeight)/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iHeight;

		//(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[p_stGLSprArray[lump].iGLTexIndex+iNbGLTextures]);
		(*glBindTexture_s) (GL_TEXTURE_2D, sprobjs[p_stGLSprArray[lump].iGLTexIndex]);

		(*glEnable_s) (GL_ALPHA_TEST);	// MR2806
		
		// MR2806
		/*if(pSpr->flags&MF_SHADOW)
		{	(*glAlphaFunc_s) (GL_EQUAL,0.5f);*/
			(*glAlphaFunc_s) (GL_NOTEQUAL,0.0f);
			(*glEnable_s) (GL_BLEND);
			(*glBlendFunc_s) (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		/*}
		else
			(*glAlphaFunc_s) (GL_EQUAL,1.0f);*/

		if (!g_bSpriteBilinear/*||(fDistance>MAP_COEFF*fSpriteFilterDistanceCoeff)*/)
		{	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
			(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		}

		(*glMatrixMode_s) (GL_MODELVIEW);
		(*glPushMatrix_s) ();
		//glLoadIdentity();
		//(*glTranslatef_s) (xi,(float)pSpr->z/MAP_SCALE,zi);
		(*glTranslatef_s) (xi,yi,zi);
		(*glRotatef_s) (-90.0f+(float)(player->mo->angle>>ANGLETOFINESHIFT)*360.0f/FINEANGLES,   0.0f, 1.0f, 0.0f);
		//if (pSpr->info->speed)
		if (fn_bRotateSprite(pSpr->info->doomednum))
			(*glRotatef_s) (-(float)player->lookdir/2 /* /4 */,   1.0f, 0.0f, 0.0f);
		// MR1206
//#ifndef GL_HEXEN	// A voir...
#if 1
		if (p_stGLSprArray[lump].iFlatID==-2)
			fWidthR=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth*2.0f/(MAP_SCALE>>FRACBITS);
		else
			fWidthR=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth/(MAP_SCALE>>FRACBITS);
		(*glTranslatef_s) (fWidthL,0.0f,0.0f);
#endif
		(*glBegin_s) (GL_QUADS);
			if(pSpr->flags&MF_SHADOW)
				//GL_StaticLight4f(fLightLevel,fLightLevel,fLightLevel,0.5f);
				GL_DynamicLight4f(xi, yi, zi,fLightLevel,0.5f);
			else
				//GL_StaticLight3f(fLightLevel,fLightLevel,fLightLevel);
				GL_DynamicLight4f(xi, yi, zi,fLightLevel,1.0f);
// Back-face culling.
/*			(*glTexCoord2f_s) (fU1, fV1); (*glVertex3f_s) ( -fWidthL, y1, 0);
			(*glTexCoord2f_s) (fU1, fV2); (*glVertex3f_s) ( -fWidthL, y2, 0);
			(*glTexCoord2f_s) (fU2, fV2); (*glVertex3f_s) ( fWidthR, y2, 0);
			(*glTexCoord2f_s) (fU2, fV1); (*glVertex3f_s) ( fWidthR, y1, 0);*/
// MR1206
//#ifdef GL_HEXEN		// A voir...
#if 0
			(*glTexCoord2f_s) (fU1, fV1); (*glVertex3f_s) ( -fWidthL, y1, 0);
			(*glTexCoord2f_s) (fU2, fV1); (*glVertex3f_s) ( fWidthR, y1, 0);
			(*glTexCoord2f_s) (fU2, fV2); (*glVertex3f_s) ( fWidthR, y2, 0);
			(*glTexCoord2f_s) (fU1, fV2); (*glVertex3f_s) ( -fWidthL, y2, 0);
#else
			(*glTexCoord2f_s) (fU1, fV1); (*glVertex3f_s) ( -fWidthR, y1, 0);
			(*glTexCoord2f_s) (fU2, fV1); (*glVertex3f_s) ( 0, y1, 0);
			(*glTexCoord2f_s) (fU2, fV2); (*glVertex3f_s) ( 0, y2, 0);
			(*glTexCoord2f_s) (fU1, fV2); (*glVertex3f_s) ( -fWidthR, y2, 0);
#endif
		(*glEnd_s) ();
	
		(*glPopMatrix_s) ();

		//if(pSpr->flags&MF_SHADOW)	// MR2806
			(*glDisable_s) (GL_BLEND);

		(*glDisable_s) (GL_ALPHA_TEST);	// MR2806
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

		// Corona Test...
		//if (usecoronas&&((iCoronaIdx=GL_GenerateCorona(pSpr->info->doomednum))!=-1))
		if (usecoronas&&((iCoronaIdx=GL_GenerateCorona(pSpr->type))!=-1))	// MR2007
		{	
			if (P_CheckSight(player->mo,pSpr))
			//while (GL_iGetDoomednum(iCoronaIdx)==pSpr->info->doomednum)
			while (GL_iGetType(iCoronaIdx)==pSpr->type)
			{	
				if (GL_ChechCoronaInSight(iCoronaIdx,player->mo,pSpr))
					GL_AddCorona(iCoronaIdx,xi,(float)pSpr->z/MAP_SCALE,zi,fLightLevel);
				iCoronaIdx++;
			}
		}
//#endif
	}
#endif
}
#endif		// OPTI_SPRITE
void fn_vDrawSpritesNonCompressed()
{ int i;
  float xi, zi, fdx=0.0f, fdy=0.0f, fDistance, x1, y1, x2, y2, z1, z2;
  float fWidthL,fTangL,fWidthR,fTangR/*,fWidth,fTang*/;
  float fU1,fU2,fV1,fV2,fLightLevel;
  mobj_t *pSpr;
  int lump;

	for (i=0;i<iNbSpriteRendered;i++)
	{		
		pSpr=a_SpriteRendered[i].p_Obj;
		//fLightLevel=(float)(pSpr->subsector->sector->lightlevel-iLightLevelMin)/(float)(iLightLevelMax-iLightLevelMin);
		fLightLevel=a_SpriteRendered[i].fLightLevel;

		lump=a_SpriteRendered[i].iLump;

		if (p_stGLSprArray[lump].iTexID==-1)
			fn_vRegisterSpriteOnTheFly(lump);

		xi=-(float)pSpr->x/MAP_SCALE;
		zi=(float)pSpr->y/MAP_SCALE;
		// MR2806
/*		fdx=(float)a_SpriteRendered[i].dx/MAP_SCALE;
		fdy=(float)a_SpriteRendered[i].dy/MAP_SCALE;
		fDistance=(float)sqrt(fdx*fdx+fdy*fdy);*/
		fDistance=a_SpriteRendered[i].fDist;
		/*fWidth=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth/(2*(MAP_SCALE>>FRACBITS));
		fTang=fWidth/fDistance;
		x1=xi+fTang*fdy;
		//y1=(float)pSpr->z/MAP_SCALE+(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].topoffset/(MAP_SCALE>>FRACBITS);
		y1=(float)pSpr->z/MAP_SCALE+(float)spritetopoffset[lump]/MAP_SCALE+(float)2/(MAP_SCALE>>FRACBITS);		// Why +2 ???
		z1=zi+fTang*fdx;
		x2=xi-fTang*fdy;
		y2=y1-(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iHeight/(MAP_SCALE>>FRACBITS);
		z2=zi-fTang*fdx;*/
		fWidthL=(float)spriteoffset[lump]/MAP_SCALE;
		fWidthR=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth/(MAP_SCALE>>FRACBITS)-fWidthL;
		fTangL=fWidthL/fDistance;
		fTangR=fWidthR/fDistance;
		x1=xi-fTangL*fdy;
		//y1=(float)pSpr->z/MAP_SCALE+(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].topoffset/(MAP_SCALE>>FRACBITS);
		y1=(float)pSpr->z/MAP_SCALE+(float)spritetopoffset[lump]/MAP_SCALE+(float)3/(MAP_SCALE>>FRACBITS);		// Why +2 ???
		z1=zi-fTangL*fdx;
		x2=xi+fTangR*fdy;
		y2=y1-(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iHeight/(MAP_SCALE>>FRACBITS);
		z2=zi+fTangR*fdx;

		if (a_SpriteRendered[i].bFlip)
		{
			fU1=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iU/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iWidth;
			fU2=(float)(p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iU+p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth)/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iWidth;
		}
		else
		{
			fU2=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iU/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iWidth;
			fU1=(float)(p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iU+p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iWidth)/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iWidth;
		}
		fV1=(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iV/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iHeight;
		fV2=(float)(p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iV+p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].a_stSubTex[p_stGLSprArray[lump].iUVIndex].iHeight)/(float)p_stGLSprites[p_stGLSprArray[lump].iGLTexIndex].iHeight;

		//(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[p_stGLSprArray[lump].iGLTexIndex+iNbGLTextures]);
		(*glBindTexture_s) (GL_TEXTURE_2D, sprobjs[p_stGLSprArray[lump].iGLTexIndex]);

		(*glEnable_s) (GL_ALPHA_TEST);
		if(pSpr->flags&MF_SHADOW)
		{	(*glAlphaFunc_s) (GL_EQUAL,0.5f);
			(*glEnable_s) (GL_BLEND);
			(*glBlendFunc_s) (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		}
		else
			(*glAlphaFunc_s) (GL_EQUAL,1.0f);
		//if (fDistance>0.78f)
		if (!g_bSpriteBilinear/*||fDistance>MAP_COEFF*fSpriteFilterDistanceCoeff*/)
		{	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
			(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		}

		if (pSpr->type==42)		// Wall Torch
			//(*glDepthFunc_s) (GL_ALWAYS);
			(*glDepthFunc_s) (GL_LEQUAL);

		(*glBegin_s) (GL_QUADS);
			if(pSpr->flags&MF_SHADOW)
				GL_StaticLight4f(fLightLevel,fLightLevel,fLightLevel,0.5f);
			else
				GL_StaticLight3f(fLightLevel,fLightLevel,fLightLevel);
			(*glTexCoord2f_s) (fU1, fV1); (*glVertex3f_s) ( x1, y1, z1);
			(*glTexCoord2f_s) (fU1, fV2); (*glVertex3f_s) ( x1, y2, z1);
			(*glTexCoord2f_s) (fU2, fV2); (*glVertex3f_s) ( x2, y2, z2);
			(*glTexCoord2f_s) (fU2, fV1); (*glVertex3f_s) ( x2, y1, z2);
		(*glEnd_s) ();

		if(pSpr->flags&MF_SHADOW)
			(*glDisable_s) (GL_BLEND);
		(*glDisable_s) (GL_ALPHA_TEST);

		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

		if (pSpr->type==42)
			(*glDepthFunc_s) (GL_LESS);
	}
}
//#endif		// OPTI_SPRITE

void fn_vDrawSprites(player_t *player)
{
#ifdef OPTI_SPRITE
	if (g_bSpriteOpti)
		fn_vDrawSpritesCompressed(player);
	else
#endif
		fn_vDrawSpritesNonCompressed();
}

// -----------------------------------------------------------------------
// Sprites
// -----------------------------------------------------------------------
void fn_vAllocSpriteMemory()
{ int i;

	//p_stGLSprites=(GLTexture *)Malloc(numspritelumps*sizeof(GLTexture));
	//p_stMapSprites=(GLMapSprite *)Malloc(numspritelumps*sizeof(GLMapSprite));
	p_stGLSprites=(GLTexture *)Malloc(sizeof(GLTexture));
	p_stMapSprites=(GLMapSprite *)Malloc(sizeof(GLMapSprite));
	p_stGLSprArray=(GLTexArray *)Malloc(numspritelumps*sizeof(GLTexArray));
	for (i=0;i<numspritelumps;i++)
		p_stGLSprArray[i].iTexID=-1;
	p_bPalette=W_CacheLumpName("PLAYPAL", PU_STATIC);
	iNbGLSprites=0;
}

#ifdef OPTI_SPRITE

#define Map(i,x,y) p_stMapSprites[i].p_cTex[x+(y)*p_stGLSprites[i].iWidth]

void fn_vUpdateTextureFreeSpace(GLTexture *p_stGLSprites,GLMapSprite *p_stMapSprites,int iGLIndex,int iSubIndex)
{ int x,y,yNext,u,v,iHeight,iWidth,iFreeSpace;

	for (y=0;y<p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].iHeight;y++)
	for (x=0;x<p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].iWidth;x++)
		Map(iGLIndex,x+p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].iU,y+p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].iV)=iSubIndex+1;

	//yNext=0x7fffffff;
	if (g_bDynamicAlloc)
		p_stGLSprites[iGLIndex].a_stFreeSpace=(GLSubTexture *)Malloc(300*sizeof(GLSubTexture));

	iFreeSpace=0;
	for (y=0;y<p_stGLSprites[iGLIndex].iHeight;y++)
	{	yNext=p_stGLSprites[iGLIndex].iHeight;
		for (x=0;x<p_stGLSprites[iGLIndex].iWidth;x++)
		{	if (!Map(iGLIndex,x,y))
			{ GLboolean bAdd;
			  int k;

				u=x; v=y;
				while ((x<p_stGLSprites[iGLIndex].iWidth)&&(!Map(iGLIndex,x,y))) x++;
				iWidth=x-u;
				x=u;
				while ((y<p_stGLSprites[iGLIndex].iHeight)&&(!Map(iGLIndex,x,y))) y++;
				iHeight=y-v;
				//y=yNext;
				y=v;
				bAdd=TRUE;
				for (k=0;k<iFreeSpace;k++)
				  {
				    if ((p_stGLSprites[iGLIndex].a_stFreeSpace[k].iU<=u)&&
					(p_stGLSprites[iGLIndex].a_stFreeSpace[k].iV<=v)&&
					(p_stGLSprites[iGLIndex].a_stFreeSpace[k].iU+p_stGLSprites[iGLIndex].a_stFreeSpace[k].iWidth>u)&&
					(p_stGLSprites[iGLIndex].a_stFreeSpace[k].iV+p_stGLSprites[iGLIndex].a_stFreeSpace[k].iHeight>v)&&
					(p_stGLSprites[iGLIndex].a_stFreeSpace[k].iU+p_stGLSprites[iGLIndex].a_stFreeSpace[k].iWidth>=u+iWidth)&&
					(p_stGLSprites[iGLIndex].a_stFreeSpace[k].iV+p_stGLSprites[iGLIndex].a_stFreeSpace[k].iHeight>=v+iHeight))
				      bAdd=FALSE;
				  }
				
				if (bAdd)
				{	p_stGLSprites[iGLIndex].a_stFreeSpace[iFreeSpace].iU=u;
					p_stGLSprites[iGLIndex].a_stFreeSpace[iFreeSpace].iV=v;
					p_stGLSprites[iGLIndex].a_stFreeSpace[iFreeSpace].iHeight=iHeight;
					p_stGLSprites[iGLIndex].a_stFreeSpace[iFreeSpace++].iWidth=iWidth;
					if (iFreeSpace>299)
					{	printf("[SDLGLdrv/sprites] Too much free space in texture\n");
						exit(0);
					}
				}
				break;
			}
			/*else
				yNext=__min(yNext,p_stGLSprites[iGLIndex].a_stSubTex[p_stMapSprites[iGLIndex].p_cTex[x][y]-1].iV+
								p_stGLSprites[iGLIndex].a_stSubTex[p_stMapSprites[iGLIndex].p_cTex[x][y]-1].iHeight);*/
		}
	}
	p_stGLSprites[iGLIndex].iNbFreeSpace=iFreeSpace;
			
	if (g_bDynamicAlloc)
		p_stGLSprites[iGLIndex].a_stFreeSpace=(GLSubTexture *)Realloc(p_stGLSprites[iGLIndex].a_stFreeSpace,sizeof(GLSubTexture)*iFreeSpace);
}

int fn_iGetBestGLTex(GLTexture *p_stGLSprites,int width,int height,int *iU,int *iV)
{ int k,j,iGLIndex,surfaceP,surface=0,diffSurface;

	iGLIndex=-1;
	surfaceP=width*height;
	diffSurface=0x7fffffff;
	for (j=0;j<iNbGLSprites;j++)
	{
	  for (k=0;k<p_stGLSprites[j].iNbFreeSpace;k++)
		{	
		  surface=p_stGLSprites[j].a_stFreeSpace[k].iWidth*p_stGLSprites[j].a_stFreeSpace[k].iHeight;
			if ((p_stGLSprites[j].a_stFreeSpace[k].iWidth>=width)&&(p_stGLSprites[j].a_stFreeSpace[k].iHeight>=height)&&
				(abs(surfaceP-surface)<diffSurface))
			{	*iU=p_stGLSprites[j].a_stFreeSpace[k].iU;
				*iV=p_stGLSprites[j].a_stFreeSpace[k].iV;
				iGLIndex=j;
				diffSurface=abs(surfaceP-surface);
				//break;	// a virer pour surface opti
			}
		}
		//if (iGLIndex!=-1)	// a virer pour surface opti
		//	break;
	}
	return iGLIndex;
}

extern GLboolean g_bInitFonts;
int fn_vRegisterSmallSprite(GLTexture **p2_stGLSprites,GLMapSprite **p2_stMapSprites,GLTexArray **p2_stGLSprArray,int iSpriteLump,patch_t *patch)		// RGBA SPRITE ONLY !!
{ int k,iGLIndex,iSubIndex,iFreeSpace,j,iU,iV,iSpriteWidth,iSpriteHeight;
  unsigned char *p_bRGBBuffer1,*p_bRGBBuffer2;
  int iGLTexW,iGLTexH;
  GLTexture *p_stGLSprites=*p2_stGLSprites;
  GLMapSprite *p_stMapSprites=*p2_stMapSprites;
  GLTexArray *p_stGLSprArray=*p2_stGLSprArray;
  int start;

	if (p_stGLSprArray[iSpriteLump].iTexID!=-1)
		return -1;

	// MR3006
	if (g_bInitFonts)
	{	iSpriteWidth=(int)((float)SHORT(patch->width)*fScaleSprite);
		iSpriteHeight=(int)((float)SHORT(patch->height)*fScaleSprite);
		start=0;
	}
	else
	{
		iSpriteWidth=(int)((float)SHORT(patch->width)*fScaleSprite)+2;
		iSpriteHeight=(int)((float)SHORT(patch->height)*fScaleSprite)+2;
		start=1;
	}

	printf("[SDLGLdrv/sprites] [%x, %x]\n",(unsigned int)SHORT(patch->width),(unsigned int)SHORT(patch->height));
	iGLIndex=fn_iGetBestGLTex(p_stGLSprites,iSpriteWidth,iSpriteHeight,&iU,&iV);
	p_bRGBBuffer1=(unsigned char *)Malloc(4*SHORT(patch->width)*SHORT(patch->height));
	p_bRGBBuffer2=(unsigned char *)Malloc(4*(iSpriteWidth-2*start)*(iSpriteHeight-2*start));
	for (j=0;j<SHORT(patch->width);j++)
	for (k=0;k<SHORT(patch->height);k++)
	{	// MR2806
		/*p_bRGBBuffer1[4*(j+k*SHORT(patch->width))]=255;
		p_bRGBBuffer1[4*(j+k*SHORT(patch->width))+1]=255;
		p_bRGBBuffer1[4*(j+k*SHORT(patch->width))+2]=255;*/
		p_bRGBBuffer1[4*(j+k*SHORT(patch->width))]=0;
		p_bRGBBuffer1[4*(j+k*SHORT(patch->width))+1]=0;
		p_bRGBBuffer1[4*(j+k*SHORT(patch->width))+2]=0;
		p_bRGBBuffer1[4*(j+k*SHORT(patch->width))+3]=0;
	}

	if (iGLIndex==-1)
	{ 
		iU=0;
		iV=0;

		iGLTexH=__max(fn_iGetTexHeightGL(iSpriteHeight),SPRITE_HEIGHT);
		iGLTexW=__max(fn_iGetTexHeightGL(iSpriteWidth),SPRITE_WIDTH);

		p_stGLSprites=(GLTexture *)Realloc(p_stGLSprites,sizeof(GLTexture)*(iNbGLSprites+1));
		p_stMapSprites=(GLMapSprite *)Realloc(p_stMapSprites,sizeof(GLMapSprite)*(iNbGLSprites+1));
		p_stMapSprites[iNbGLSprites].p_cTex=(char *)Malloc(iGLTexW*iGLTexH);
		memset(p_stMapSprites[iNbGLSprites].p_cTex,0,iGLTexH*iGLTexW);

		p_stGLSprites[iNbGLSprites].iWidth=iGLTexW;
		p_stGLSprites[iNbGLSprites].iHeight=iGLTexH;
		p_stGLSprites[iNbGLSprites].p_bRGBBuffer=(unsigned char *)Malloc(iGLTexH*iGLTexW*4);

		// MR2806
		memset(p_stGLSprites[iNbGLSprites].p_bRGBBuffer,0,iGLTexW*iGLTexH*4);

		if (!g_bDynamicAlloc)
		{	p_stGLSprites[iNbGLSprites].a_stSubTex=(GLSubTexture *)Malloc(300*sizeof(GLSubTexture));
			p_stGLSprites[iNbGLSprites].a_stFreeSpace=(GLSubTexture *)Malloc(300*sizeof(GLSubTexture));
		}
		else
		{	p_stGLSprites[iNbGLSprites].a_stSubTex=(GLSubTexture *)Malloc(sizeof(GLSubTexture));
			p_stGLSprites[iNbGLSprites].a_stFreeSpace=(GLSubTexture *)Malloc(sizeof(GLSubTexture));
		}
		p_stGLSprites[iNbGLSprites].iNbSubTextures=0;
		p_stGLSprites[iNbGLSprites].a_stSubTex[0].iU=0;
		p_stGLSprites[iNbGLSprites].a_stSubTex[0].iV=0;
		p_stGLSprites[iNbGLSprites].a_stSubTex[0].iWidth=0;
		p_stGLSprites[iNbGLSprites].a_stSubTex[0].iHeight=0;
		p_stGLSprites[iNbGLSprites].iNbFreeSpace=1;
		p_stGLSprites[iNbGLSprites].a_stFreeSpace[0].iU=0;
		p_stGLSprites[iNbGLSprites].a_stFreeSpace[0].iV=0;
		p_stGLSprites[iNbGLSprites].a_stFreeSpace[0].iWidth=iGLTexW;
		p_stGLSprites[iNbGLSprites].a_stFreeSpace[0].iHeight=iGLTexH;

		iGLIndex=iNbGLSprites++;
		iFreeSpace=0;
	}
	{ int x;

		iGLTexW=p_stGLSprites[iGLIndex].iWidth;
		iGLTexH=p_stGLSprites[iGLIndex].iHeight;
		iSubIndex=p_stGLSprites[iGLIndex].iNbSubTextures;
		if (!g_bDynamicAlloc)
		{	if (iSubIndex>299)
			{	printf("[SDLGLdrv/sprites] Too much sub textures\n");
				exit(0);
			}
		}
		else
			p_stGLSprites[iGLIndex].a_stSubTex=(GLSubTexture *)Realloc(p_stGLSprites[iGLIndex].a_stSubTex,(iSubIndex+1)*sizeof(GLSubTexture));

		p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].iU=iU;
		p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].iV=iV;
		p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].iWidth=iSpriteWidth;
		p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].iHeight=iSpriteHeight;

		p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].bIsNZ=0;

		fn_vUpdateTextureFreeSpace(p_stGLSprites,p_stMapSprites,iGLIndex,iSubIndex);

		for (x=0;x<SHORT(patch->width);x++)
		{ column_t *p_bColumn_t;
		  byte *p_bColumn;
			
			p_bColumn_t=(column_t *)((byte *)patch+LONG(patch->columnofs[x]));
			for ( ; p_bColumn_t->topdelta != 0xff ; )
			{
				p_bColumn=(byte *)p_bColumn_t + 3;

#undef Y
#define Y (j+p_bColumn_t->topdelta)

				for (j=0;j<p_bColumn_t->length;j++)
				{	
					//if (p_bColumn[j]!=205)
					if (1)		// DOOM_GL
					{	p_bRGBBuffer1[4*(x+Y*SHORT(patch->width))]=p_bPalette[p_bColumn[j]*3];
						p_bRGBBuffer1[4*(x+Y*SHORT(patch->width))+1]=p_bPalette[p_bColumn[j]*3+1];
						p_bRGBBuffer1[4*(x+Y*SHORT(patch->width))+2]=p_bPalette[p_bColumn[j]*3+2];
						p_bRGBBuffer1[4*(x+Y*SHORT(patch->width))+3]=255;
					}
					else
					{	p_bRGBBuffer1[4*(x+Y*SHORT(patch->width))]=255;
						p_bRGBBuffer1[4*(x+Y*SHORT(patch->width))+1]=255;
						p_bRGBBuffer1[4*(x+Y*SHORT(patch->width))+2]=255;
						p_bRGBBuffer1[4*(x+Y*SHORT(patch->width))+3]=0;
					}
				}
				p_bColumn_t = (column_t *)(  (byte *)p_bColumn_t + p_bColumn_t->length + 4);
			}
		}
		
		ScalePicture(p_bRGBBuffer1,SHORT(patch->width),SHORT(patch->height),p_bRGBBuffer2,iSpriteWidth-2*start,iSpriteHeight-2*start);

		for (x=start;x<iSpriteWidth-1;x++)
		{ 	for (j=start;j<iSpriteHeight-1;j++)
			{	p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(j+iV)*iGLTexW)]=p_bRGBBuffer2[4*(x-start+(j-start)*(iSpriteWidth-2*start))];
				p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(j+iV)*iGLTexW)+1]=p_bRGBBuffer2[4*(x-start+(j-start)*(iSpriteWidth-2*start))+1];
				p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(j+iV)*iGLTexW)+2]=p_bRGBBuffer2[4*(x-start+(j-start)*(iSpriteWidth-2*start))+2];
				p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(j+iV)*iGLTexW)+3]=p_bRGBBuffer2[4*(x-start+(j-start)*(iSpriteWidth-2*start))+3];
			}
			/*{	p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(j+iV)*SPRITE_WIDTH)]=p_bRGBBuffer1[4*(x+j*iSpriteWidth)];
				p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(j+iV)*SPRITE_WIDTH)+1]=p_bRGBBuffer1[4*(x+j*iSpriteWidth)+1];
				p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(j+iV)*SPRITE_WIDTH)+2]=p_bRGBBuffer1[4*(x+j*iSpriteWidth)+2];
				p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(j+iV)*SPRITE_WIDTH)+3]=p_bRGBBuffer1[4*(x+j*iSpriteWidth)+3];
			}*/
		}

		Free(p_bRGBBuffer1);
		Free(p_bRGBBuffer2);
		p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].bIsNZ=1;

		p_stGLSprites[iGLIndex].iNbSubTextures++;
		
		if (g_bDynamicAlloc)
			p_stGLSprites[iGLIndex].a_stSubTex=(GLSubTexture *)Realloc(p_stGLSprites[iGLIndex].a_stSubTex,sizeof(GLSubTexture)*p_stGLSprites[iGLIndex].iNbSubTextures);
		
		p_stGLSprArray[iSpriteLump].iTexID=iSpriteLump;
		p_stGLSprArray[iSpriteLump].iFlatID=-2;	// -2 => small sprite
		p_stGLSprArray[iSpriteLump].iGLTexIndex=iGLIndex;
		p_stGLSprArray[iSpriteLump].iUVIndex=iSubIndex;
	}

	*p2_stGLSprites=p_stGLSprites;
	*p2_stMapSprites=p_stMapSprites;
	*p2_stGLSprArray=p_stGLSprArray;

	return iGLIndex;
}

typedef struct _tdstSpriteList
{	int lump;
	int surface;
	struct _tdstSpriteList *p_stNext;
} tdstSpriteList;

tdstSpriteList *g_stSprLst=NULL;

void fn_vAddSpriteToList(int iSpriteLump,patch_t *patch)
{ int surface;
  tdstSpriteList *p_stTmp,*p_stTmp1,*p_stSprLst;

	surface=SHORT(patch->width)*SHORT(patch->height);
	if (surface>iMaxSizeBeforeReduction)
		surface=(int)((float)surface*fScaleSprite*fScaleSprite);

	if (!g_stSprLst)
	{	g_stSprLst=(tdstSpriteList *)Malloc(sizeof(tdstSpriteList));
		g_stSprLst->lump=iSpriteLump;
		g_stSprLst->surface=surface;
		g_stSprLst->p_stNext=NULL;
	}
	else
	{
		p_stSprLst=(tdstSpriteList *)Malloc(sizeof(tdstSpriteList));
		p_stSprLst->lump=iSpriteLump;
		p_stSprLst->surface=surface;
		p_stSprLst->p_stNext=NULL;
		p_stTmp=g_stSprLst;
		p_stTmp1=NULL;
		while (p_stTmp!=NULL)
		{	if (iSpriteLump==p_stTmp->lump)
			{	Free(p_stSprLst);
				return;
			}
			if (surface>p_stTmp->surface)
			{	if (p_stTmp1==NULL)
				{	p_stSprLst->p_stNext=g_stSprLst;
					g_stSprLst=p_stSprLst;
				}
				else
				{	p_stTmp1->p_stNext=p_stSprLst;
					p_stSprLst->p_stNext=p_stTmp;
				}
				break;
			}
			p_stTmp1=p_stTmp;
			p_stTmp=p_stTmp->p_stNext;
		}
		if (p_stTmp==NULL)
			p_stTmp1->p_stNext=p_stSprLst;
	}
}

int fn_vRegisterSpriteCompressed(GLTexture **p2_stGLSprites,GLMapSprite **p2_stMapSprites,GLTexArray **p2_stGLSprArray,int iSpriteLump,patch_t *patch)
{ int iGLIndex,iSubIndex,iFreeSpace,j,iU,iV;
  int iGLTexW,iGLTexH;
  GLTexture *p_stGLSprites=*p2_stGLSprites;
  GLMapSprite *p_stMapSprites=*p2_stMapSprites;
  GLTexArray *p_stGLSprArray=*p2_stGLSprArray;
  int iWidth,iHeight;	// MR3006
  int start;

	if (g_bInitFonts)
	{	iWidth=SHORT(patch->width);
		iHeight=SHORT(patch->height);
	}
	else
	{	iWidth=SHORT(patch->width)+2;
		iHeight=SHORT(patch->height)+2;
	}
	if (p_stGLSprArray[iSpriteLump].iTexID!=-1)
		return -1;

	if (SHORT(patch->width)*SHORT(patch->height)>iMaxSizeBeforeReduction)
		return fn_vRegisterSmallSprite(p2_stGLSprites,p2_stMapSprites,p2_stGLSprArray,iSpriteLump,patch);

	//iGLIndex=fn_iGetBestGLTex(p_stGLSprites,SHORT(patch->width),SHORT(patch->height),&iU,&iV);
	iGLIndex=fn_iGetBestGLTex(p_stGLSprites,iWidth,iHeight,&iU,&iV);
	
	if (iGLIndex==-1)
	{	iU=0;
		iV=0;

/*		iGLTexH=__max(fn_iGetTexHeightGL(SHORT(patch->height)),SPRITE_HEIGHT);
		iGLTexW=__max(fn_iGetTexHeightGL(SHORT(patch->width)),SPRITE_WIDTH);*/
		iGLTexH=__max(fn_iGetTexHeightGL(iHeight),SPRITE_HEIGHT);
		iGLTexW=__max(fn_iGetTexHeightGL(iWidth),SPRITE_WIDTH);

		p_stGLSprites=(GLTexture *)Realloc(p_stGLSprites,sizeof(GLTexture)*(iNbGLSprites+1));
		p_stMapSprites=(GLMapSprite *)Realloc(p_stMapSprites,sizeof(GLMapSprite)*(iNbGLSprites+1));
		p_stMapSprites[iNbGLSprites].p_cTex=(char *)Malloc(iGLTexW*iGLTexH);
		memset(p_stMapSprites[iNbGLSprites].p_cTex,0,iGLTexW*iGLTexH);
		
		p_stGLSprites[iNbGLSprites].iWidth=iGLTexW;
		p_stGLSprites[iNbGLSprites].iHeight=iGLTexH;
		p_stGLSprites[iNbGLSprites].p_bRGBBuffer=(unsigned char *)Malloc(iGLTexW*iGLTexH*4);
#ifdef PALETTED_SPRITE
		memset(p_stGLSprites[iNbGLSprites].p_bRGBBuffer,205,iGLTexW*iGLTexH);
#else	// MR2806
		memset(p_stGLSprites[iNbGLSprites].p_bRGBBuffer,0,iGLTexW*iGLTexH*4);
#endif

		if (!g_bDynamicAlloc)
		{	p_stGLSprites[iNbGLSprites].a_stSubTex=(GLSubTexture *)Malloc(300*sizeof(GLSubTexture));
			p_stGLSprites[iNbGLSprites].a_stFreeSpace=(GLSubTexture *)Malloc(300*sizeof(GLSubTexture));
		}
		else
		{	p_stGLSprites[iNbGLSprites].a_stSubTex=(GLSubTexture *)Malloc(sizeof(GLSubTexture));
			p_stGLSprites[iNbGLSprites].a_stFreeSpace=(GLSubTexture *)Malloc(sizeof(GLSubTexture));
		}
		p_stGLSprites[iNbGLSprites].iNbSubTextures=0;
		p_stGLSprites[iNbGLSprites].a_stSubTex[0].iU=0;
		p_stGLSprites[iNbGLSprites].a_stSubTex[0].iV=0;
		p_stGLSprites[iNbGLSprites].a_stSubTex[0].iWidth=0;
		p_stGLSprites[iNbGLSprites].a_stSubTex[0].iHeight=0;
		p_stGLSprites[iNbGLSprites].iNbFreeSpace=1;
		p_stGLSprites[iNbGLSprites].a_stFreeSpace[0].iU=0;
		p_stGLSprites[iNbGLSprites].a_stFreeSpace[0].iV=0;
		p_stGLSprites[iNbGLSprites].a_stFreeSpace[0].iWidth=iGLTexW;
		p_stGLSprites[iNbGLSprites].a_stFreeSpace[0].iHeight=iGLTexH;

		iGLIndex=iNbGLSprites++;
		iFreeSpace=0;
	}
	{ int x;

		iGLTexW=p_stGLSprites[iGLIndex].iWidth;
		iGLTexH=p_stGLSprites[iGLIndex].iHeight;

		iSubIndex=p_stGLSprites[iGLIndex].iNbSubTextures;
		if (!g_bDynamicAlloc)
		{	if (iSubIndex>299)
			{	printf("[SDLGLdrv/sprites] Too much sub textures\n");
				exit(0);
			}
		}
		else
			p_stGLSprites[iGLIndex].a_stSubTex=(GLSubTexture *)Realloc(p_stGLSprites[iGLIndex].a_stSubTex,(iSubIndex+1)*sizeof(GLSubTexture));

		p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].iU=iU;
		p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].iV=iV;
		/*p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].iWidth=SHORT(patch->width);
		p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].iHeight=SHORT(patch->height);*/
		p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].iWidth=iWidth;
		p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].iHeight=iHeight;

		p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].bIsNZ=0;

		fn_vUpdateTextureFreeSpace(p_stGLSprites,p_stMapSprites,iGLIndex,iSubIndex);

		// MR3006
		if (g_bInitFonts)
			start=0;
		else
			start=1;
		//for (x=0;x<SHORT(patch->width);x++)
		for (x=start;x<SHORT(patch->width);x++)
		{ column_t *p_bColumn_t;
		  byte *p_bColumn;
			
			// MR3006	
			//p_bColumn_t=(column_t *)((byte *)patch+patch->columnofs[x]);
			p_bColumn_t=(column_t *)((byte *)patch+LONG(patch->columnofs[x-start]));
			for ( ; p_bColumn_t->topdelta != 0xff ; )
			{
				p_bColumn=(byte *)p_bColumn_t + 3;

#undef Y
// MR3006
//#define Y j+p_bColumn_t->topdelta
#define Y j+p_bColumn_t->topdelta+start

				for (j=0;j<p_bColumn_t->length;j++)
				{	
#ifndef PALETTED_SPRITE
					//if (p_bColumn[j]!=205)
					if (1)	// DOOM_GL
					{	p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexW)]=p_bPalette[p_bColumn[j]*3];
						p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexW)+1]=p_bPalette[p_bColumn[j]*3+1];
						p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexW)+2]=p_bPalette[p_bColumn[j]*3+2];
						p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexW)+3]=255;
					}
					else
					{	p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexW)]=0;
						p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexW)+1]=0;
						p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexW)+2]=0;
						p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexW)+3]=0;
						p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].bIsNZ=1;
					}
#else
					p_stGLSprites[iGLIndex].p_bRGBBuffer[(x+iU)+(Y+iV)*iGLTexW]=p_bColumn[j];
#endif
				}
				p_bColumn_t = (column_t *)(  (byte *)p_bColumn_t + p_bColumn_t->length + 4);
			}
		}
		p_stGLSprites[iGLIndex].iNbSubTextures++;
		
		if (g_bDynamicAlloc)
			p_stGLSprites[iGLIndex].a_stSubTex=(GLSubTexture *)Realloc(p_stGLSprites[iGLIndex].a_stSubTex,sizeof(GLSubTexture)*p_stGLSprites[iGLIndex].iNbSubTextures);
		
		p_stGLSprArray[iSpriteLump].iTexID=iSpriteLump;
		p_stGLSprArray[iSpriteLump].iFlatID=-1;
		p_stGLSprArray[iSpriteLump].iGLTexIndex=iGLIndex;
		p_stGLSprArray[iSpriteLump].iUVIndex=iSubIndex;
	}

	*p2_stGLSprites=p_stGLSprites;
	*p2_stMapSprites=p_stMapSprites;
	*p2_stGLSprArray=p_stGLSprArray;

	return iGLIndex;
}
#endif	// OPTI_SPRITE

int fn_vRegisterSpriteNonCompressed(int iSpriteLump,patch_t *patch)
{ int iGLIndex,iSubIndex,iFreeSpace,j,iU,iV,iGLTexWidth,iGLTexHeight;

	if (p_stGLSprArray[iSpriteLump].iTexID!=-1)
		return -1;
	iGLIndex=-1;
/*	for (j=0;j<iNbGLSprites;j++)
	{	
		for (k=0;k<p_stGLSprites[j].iNbFreeSpace;k++)
		if ((p_stGLSprites[j].a_stFreeSpace[k].iWidth>=SHORT(patch->width))&&(p_stGLSprites[j].a_stFreeSpace[k].iHeight>=SHORT(patch->height)))
		{	iU=p_stGLSprites[j].a_stFreeSpace[k].iU;
			iV=p_stGLSprites[j].a_stFreeSpace[k].iV;
			iGLIndex=j;
			iFreeSpace=k;
			break;
		}
		if (iGLIndex!=-1)
			break;
	}*/
	
	if (iGLIndex==-1)
	{	iU=0;
		iV=0;

		p_stGLSprites=(GLTexture *)Realloc(p_stGLSprites,sizeof(GLTexture)*(iNbGLSprites+1));

		iGLTexWidth=fn_iGetTexHeightGL(SHORT(patch->width));
		iGLTexHeight=fn_iGetTexHeightGL(SHORT(patch->height));
		p_stGLSprites[iNbGLSprites].iWidth=iGLTexWidth;
		p_stGLSprites[iNbGLSprites].iHeight=iGLTexHeight;
		p_stGLSprites[iNbGLSprites].p_bRGBBuffer=(unsigned char *)Malloc(iGLTexWidth*iGLTexHeight*4);
		memset(p_stGLSprites[iNbGLSprites].p_bRGBBuffer,205,iGLTexWidth*iGLTexHeight*4);

		p_stGLSprites[iNbGLSprites].a_stSubTex=(GLSubTexture *)Malloc(1*sizeof(GLSubTexture));
		p_stGLSprites[iNbGLSprites].a_stFreeSpace=(GLSubTexture *)Malloc(1*sizeof(GLSubTexture));
		p_stGLSprites[iNbGLSprites].iNbSubTextures=1;
		p_stGLSprites[iNbGLSprites].a_stSubTex[0].iU=0;
		p_stGLSprites[iNbGLSprites].a_stSubTex[0].iV=0;
		p_stGLSprites[iNbGLSprites].a_stSubTex[0].iWidth=SHORT(patch->width);
		p_stGLSprites[iNbGLSprites].a_stSubTex[0].iHeight=SHORT(patch->height);
		//p_stGLSprites[iNbGLSprites].a_stSubTex[0].leftoffset=SHORT(patch->leftoffset);
		//p_stGLSprites[iNbGLSprites].a_stSubTex[0].topoffset=SHORT(patch->topoffset);
		p_stGLSprites[iNbGLSprites].iNbFreeSpace=0;
		/*p_stGLSprites[iNbGLSprites].a_stFreeSpace[0].iU=0;
		p_stGLSprites[iNbGLSprites].a_stFreeSpace[0].iV=0;
		p_stGLSprites[iNbGLSprites].a_stFreeSpace[0].iWidth=0;
		p_stGLSprites[iNbGLSprites].a_stFreeSpace[0].iHeight=0;*/

		iGLIndex=iNbGLSprites++;
		iFreeSpace=0;
	}
	{ int x;

		iSubIndex=0;

		p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].bIsNZ=0;
		//fn_vStretchTexture(SHORT(patch->width),SHORT(patch->height),iGLTexWidth,iGLTexHeight);

		//for (y=0;y<iGLTexHeight;y++)
		for (x=0;x<SHORT(patch->width);x++)
		{ column_t *p_bColumn_t;
		  byte *p_bColumn;
			
			p_bColumn_t=(column_t *)((byte *)patch+LONG(patch->columnofs[x]));
//			y=0;
			for ( ; p_bColumn_t->topdelta != 0xff ; )
			//for (x=0;x<iGLTexWidth;x++)
			{
				//p_bColumn=R_GetColumn(iSpriteLump,x);
/*				p_bColumn_t=(column_t *)patch+patch->columnofs[xS[x]];
				p_bColumn=(byte *)patch+patch->columnofs[xS[x]]+3;
				if ((p_bColumn[yS[y]]!=205)||(yS[y]<p_bColumn_t->length))
				{	p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)]=p_bPalette[p_bColumn[yS[y]]*3];
					p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+1]=p_bPalette[p_bColumn[yS[y]]*3+1];
					p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+2]=p_bPalette[p_bColumn[yS[y]]*3+2];
					p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+3]=255;
				}*/
				p_bColumn=(byte *)p_bColumn_t + 3;

#undef Y
#define Y j+p_bColumn_t->topdelta

				for (j=0;j<p_bColumn_t->length;j++)
				{	//if (p_bColumn[j]!=205)
					if (1)	// DOOM_GL
					{	p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)]=p_bPalette[p_bColumn[j]*3];
						p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+1]=p_bPalette[p_bColumn[j]*3+1];
						p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+2]=p_bPalette[p_bColumn[j]*3+2];
						p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+3]=255;
					}
					else
					{	p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)]=255;
						p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+1]=0;
						p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+2]=0;
						p_stGLSprites[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+3]=0;
						p_stGLSprites[iGLIndex].a_stSubTex[iSubIndex].bIsNZ=1;
					}
				}
				p_bColumn_t = (column_t *)(  (byte *)p_bColumn_t + p_bColumn_t->length + 4);
			}
		}

/*		if (!iSpriteLump)
			p_stGLSprArray=(GLTexArray *)Malloc((iSpriteLump+1)*sizeof(GLTexArray));
		else
			p_stGLSprArray=(GLTexArray *)Realloc(p_stGLSprArray,(iSpriteLump+1)*sizeof(GLTexArray));*/

		p_stGLSprArray[iSpriteLump].iTexID=iSpriteLump;
		p_stGLSprArray[iSpriteLump].iFlatID=-1;
		p_stGLSprArray[iSpriteLump].iGLTexIndex=iGLIndex;
		p_stGLSprArray[iSpriteLump].iUVIndex=iSubIndex;
	}

	return iGLIndex;
}

int fn_vRegisterSprite(int iSpriteLump,patch_t *patch)
{
#ifdef OPTI_SPRITE
	if (g_bSpriteOpti)
		return fn_vRegisterSpriteCompressed(&p_stGLSprites,&p_stMapSprites,&p_stGLSprArray,iSpriteLump,patch);
	else
#endif	// OPTI_SPRITE
		return fn_vRegisterSpriteNonCompressed(iSpriteLump,patch);
}

extern GLboolean g_b3Dfx;
void fn_vOptimizeSpriteMemory()
{ int i;
  tdstSpriteList *p_stSprLst,*p_stTmp;
  patch_t *patch;
  FILE *hFile;
  int iPrevMax;
  float fPrevScale;

	// Load "missings" lumps
	/* printf("DEBUG-M: %s\n", mlump_filename); */
	hFile=fopen(mlump_filename,"r");
	if (hFile)
	{ int iSpriteLump;

		while (!feof(hFile))
		{	fscanf(hFile,"%d",&iSpriteLump);
			patch = W_CacheLumpNum (firstspritelump+iSpriteLump, PU_CACHE);
#ifdef OPTI_SPRITE
			fn_vAddSpriteToList(iSpriteLump,patch);
#else
			fn_vRegisterSprite(p_stSprLst->lump,patch);
#endif
		}			
		fclose(hFile);
	}
#ifdef OPTI_SPRITE
	p_stSprLst=g_stSprLst;
	while (p_stSprLst!=NULL)
	{	patch = W_CacheLumpNum (firstspritelump+p_stSprLst->lump, PU_CACHE);
		fn_vRegisterSprite(p_stSprLst->lump,patch);
		p_stTmp=p_stSprLst;
		p_stSprLst=p_stSprLst->p_stNext;
		Free(p_stTmp);
	}
	g_stSprLst=NULL;
#endif
	
	// Load Weapons lumps
	iPrevMax=iMaxSizeBeforeReduction;
	iMaxSizeBeforeReduction=65536;
	fPrevScale=fScaleSprite;

	/* printf("DEBUG-W: %s\n", wlump_filename); */
	hFile=fopen(wlump_filename,"r");
	if (hFile)
	{ int iSpriteLump;

		while (!feof(hFile))
		{	fscanf(hFile,"%d",&iSpriteLump);
			patch = W_CacheLumpNum (firstspritelump+iSpriteLump, PU_CACHE);
//#ifdef OPTI_SPRITE
//			fn_vAddSpriteToList(iSpriteLump,patch);
//#else
			if ((SHORT(patch->width)>256)&&g_b3Dfx)
			{	iMaxSizeBeforeReduction=2;
				//fScaleSprite=256.0f/SHORT(patch->width);
				fScaleSprite=256.0f/(SHORT(patch->width)+2);	// MR1307
			}
			else
			{	iMaxSizeBeforeReduction=65536;
				fScaleSprite=fPrevScale;
			}
			fn_vRegisterSprite(iSpriteLump,patch);
//#endif
		}			
		fclose(hFile);
	}
	iMaxSizeBeforeReduction=iPrevMax;
	fScaleSprite=fPrevScale;

	for (i=0;i<iNbGLSprites;i++)
	{	p_stGLSprites[i].a_stFreeSpace=(GLSubTexture *)Realloc(p_stGLSprites[i].a_stFreeSpace,sizeof(GLSubTexture)*p_stGLSprites[i].iNbFreeSpace);
		p_stGLSprites[i].a_stSubTex=(GLSubTexture *)Realloc(p_stGLSprites[i].a_stSubTex,sizeof(GLSubTexture)*p_stGLSprites[i].iNbSubTextures);
	}
}

extern void **lumpcache;

#ifdef DOOM_GL
extern int		numflats;
#endif

void fn_vRegisterSpriteOnTheFly(int iSpriteLump)
{ patch_t *patch;
  int iOldNbGLSprites,iGLTex;
  FILE *hFile;

	//lumpcache[firstspritelump+iSpriteLump]=0;
	g_bDynamicAlloc=TRUE;
		
	/* printf("DEBUG-M: %s\n", mlump_filename); */
	hFile=fopen(mlump_filename,"a+");
	fprintf(hFile,"%d\n",iSpriteLump); fflush(hFile);
	fclose(hFile);
	patch = W_CacheLumpNum (firstspritelump+iSpriteLump, PU_CACHE);
	iOldNbGLSprites=iNbGLSprites;
	iGLTex=fn_vRegisterSprite(iSpriteLump,patch);
	if (iNbGLSprites==iOldNbGLSprites)
	{	//(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iGLTex+iNbGLTextures]);
		(*glBindTexture_s) (GL_TEXTURE_2D, sprobjs[iGLTex]);
		(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, p_stGLSprites[iGLTex].iWidth, p_stGLSprites[iGLTex].iHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, p_stGLSprites[iGLTex].p_bRGBBuffer);
		return;
	}
	//texobjs=(GLuint *)Realloc(texobjs,(iNbGLTextures+iNbGLSprites)*sizeof(GLuint));
	//texobjs[iNbGLSprites-1+iNbGLTextures] = iNbGLSprites+iNbGLTextures;
	sprobjs=(GLuint *)Realloc(sprobjs,iNbGLSprites*sizeof(GLuint));
	sprobjs[iNbGLSprites-1] = iNbGLSprites+numflats+numpatches;
	
	(*glBindTexture_s) (GL_TEXTURE_2D, sprobjs[iNbGLSprites-1]);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
#ifdef BILINEAR
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
#else
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
#endif
	(*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE /*GL_DECAL*/);

	(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, p_stGLSprites[iNbGLSprites-1].iWidth, p_stGLSprites[iNbGLSprites-1].iHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, p_stGLSprites[iNbGLSprites-1].p_bRGBBuffer);
	
	g_bDynamicAlloc=FALSE;
}


#endif GL_HERETIC
