#ifndef __GL_STRUCT_H__
#define __GL_STRUCT_H__

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <GL/gl.h>
#include <GL/glu.h>

#include "doomdef.h"
#include "r_local.h"
#include "gl_mem.h"

#ifndef MAXINT
#define MAXINT		((int)0x7fffffff)	
#endif
#ifndef MININT
#define MININT		((int)0x80000000)	
#endif

extern byte *screen; /* off screen work buffer, from V_video.c- */

#define BILINEAR
#define OPTI_SPRITE		/* Several sprites in one GLTexture */
#define RASTER
#define PALETTED_TEXTURE	/* Walls & floor have paletted textures */

extern int MAP_COEFF;
#define MAP_SCALE	(MAP_COEFF<<FRACBITS)

#define FLAT_TEX_SIZE	64
#define WALL_TEX_SIZE	128
#define TEX_SKY_W	256
#define TEX_SKY_H	256

extern int SPRITE_WIDTH;
extern int SPRITE_HEIGHT;

typedef struct {
    int		originx;	/* block origin (allways UL), which has allready */
    int		originy;	/* accounted  for the patch's internal origin */
    int		patch;
} texpatch_t;

/*
 * a maptexturedef_t describes a rectangular texture, which is composed of one
 * or more mappatch_t structures that arrange graphic patches
 */
typedef struct {
    char	name[8];	/* for switch changing, etc */
    short	width;
    short	height;
    short	patchcount;
    texpatch_t	patches[1];	/* [patchcount] drawn back to front */
    /*  into the cached texture */
} texture_t;

typedef struct {
    int iU,iV;
    int iWidth,iHeight;
    unsigned char bIsNZ;
} GLSubTexture;

typedef struct {
    int iWidth, iHeight;
    unsigned char *p_bRGBBuffer;
    /* Nb of sub-textures */
    int iNbSubTextures;
    GLSubTexture *a_stSubTex;
    /* Nb of Free space */
    int iNbFreeSpace;
    GLSubTexture *a_stFreeSpace;
} GLTexture;

typedef struct {
    int iTexID;
    int iFlatID;
    int iGLTexIndex;
    int iUVIndex;
} GLTexArray;

typedef struct {
    GLuint iFloorCallList;
    GLuint iCeilingCallList;
} GLFloorCeiling;

typedef struct {
    GLenum mode;
    int iNbVertices;
    GLfloat *p_fVertex;		/* contains floor height */
    GLfloat *p_fUV;
    GLfloat *p_fCeiling;	/* corresponding ceiling height */
    GLfloat fUp,fDown, fLeft, fRight;
} GLVertexArray;

typedef struct {
    int iNbArrays;
    int iFloorTexture, iCeilingTexture;
    GLVertexArray *p_stVertexArray;
} GLFloorCeilingPolygonArray;

typedef struct {	
    int iNbPoints;
    GLfloat *p_fVertex;
    GLfloat *p_fNormals;
    GLfloat *p_fV;
    GLfloat xMapCenter, yMapCenter, zMapCenter;
    GLint slices, stacks;    
} GLSky;

typedef struct {
    GLfloat a_fVertex[6];
    GLfloat a_fUV[4];
    GLint iTex;
    sector_t *pSector;
    GLbyte cWallType;
} GLWallQuad;

typedef struct {	
    int iNbQuads;
    float fWallWidth;
    GLWallQuad *p_stWallQuad;
} GLWallPolygonArray;

typedef struct {
    char *p_cTex;
} GLMapSprite;

typedef struct {
    float fDist;
    int iLump;
    H_boolean bFlip;
    float fLightLevel;
    mobj_t *p_Obj;	
} GLSprite;

/* Coronas */
typedef struct {	
    mobjtype_t type;
    int lighttype;
    GLfloat fRed, fGreen, fBlue, fAlpha;
    GLint offsetX, offsetY;
    GLfloat fDistMin, fDistMed, fDistMax;
} GLCoronaProp;

typedef struct {	
    float x, y, z;
    float fLightLevel;
    mobjtype_t type;
    int iNbVertices;
    int xV[12], yV[12];
} GLCorona;

/* DynLight */
typedef struct {
    mobj_t *thing;
    float x, y, z;
    float fFar, fNear, fFar2;
    float fRed, fGreen, fBlue;
    float fLightRadiusFloor, fLightRadiusCeiling;	/* Disc radius on floor/ceiling */
    int tic;
    char update;
} GLDynamicLight;

/* DarkFang */
typedef struct {
    mobjtype_t type;
    float fRed;
    float fGreen;
    float fBlue;
    float fNear;
    float fFar;
    char update;    
} GLdynamic_prop;

typedef struct {
    mobjtype_t	type;
    statenum_t	state;
    float	fRed;
    float	fGreen;
    float	fBlue;
    float	fNear;
    float	fFar;
} GLdynamic_effect;

/*
 * GL_EFFECTS.C	
 */

void AGL_HandleEffects(int i);

#define MAX_LIGHT_SOURCES	1000

#define UPDATE_TRUE		213
#define UPDATE_FALSE		111

GLDynamicLight a_stGLLight[MAX_LIGHT_SOURCES];
int iGLNbLightSources;
float fLightUpF[MAX_LIGHT_SOURCES],fLightDownF[MAX_LIGHT_SOURCES],fLightLeftF[MAX_LIGHT_SOURCES],fLightRightF[MAX_LIGHT_SOURCES];
float fLightUpC[MAX_LIGHT_SOURCES],fLightDownC[MAX_LIGHT_SOURCES],fLightLeftC[MAX_LIGHT_SOURCES],fLightRightC[MAX_LIGHT_SOURCES];
/* End DarkFang */

/* Wall impacts */
#define MAX_IMPACTS	10

typedef struct {
    int iNbImpacts;
    float *x1,*y1,*z1,*x2,*y2,*z2;
    char *type;
} GLWallImpact;

void fn_vRegisterWallTextures(int iTexNum, texture_t *texture);
void fn_vRegisterFlatTexture(int flattex);
GLvoid initializeGL(GLsizei width, GLsizei height);
void fn_vAllocTextureMemory();
void fn_vInitGLTextures();
void I_GL_InitGraphics(void);
int fn_iGetGLFlatTexturef(int flattex);
int fn_iGetGLTexturef(short texture,short xOffset,short yOffset,float *fU1,float *fU2,float *fV1,float *fV2,float *fU1Off,float *fV1Off,int *iSubTextIndex);
void fn_vCreateWalls();
void fn_vCreateFloorCeilingPolygons();
void fn_vLoadSkyTexture();
void fn_vDrawSky(int index);
void fn_vCreateSky();
GLvoid GLdrawScene(player_t *player);
void R_glAddFloorCeiling();
void fn_vAddSector(int ucSectorID);
void fn_vInitglDrawScene();
void fn_vGlAddLine(int iLineID);
void fn_vCreateWallsPolygons(int i);
void fn_vRenderSector(int s);
void fn_vGLUpdateSector(sector_t *sector);
void GL_vSetFloorTexture(int iSectorID,int texture);
void fn_vDisplayWall(int line);
void fn_vUpdateWallsPolygons(int i);
void fn_vCheckIfFlatIsAnimated(int tex);
void fn_vCheckIfTextureIsAnimated(int tex);
void fn_vUpdateWallTexture(int iLine,int iWallType,int iSwitch);
void fn_vScrollWallTexture(int iLine,int xOffset);
void fn_vScrollWallTextureV(int iLine,int yOffset);
void fn_vAllocSpriteMemory();
void fn_vCheckAndRegisterSprite(spritenum_t sprite);
void fn_vOptimizeSpriteMemory();
void fn_vAddSprite(mobj_t *pSpr,int lump, H_boolean flip,fixed_t dx,fixed_t dy,fixed_t dz);
void GL_vSetSpriteVisible(vissprite_t *vis);
void fn_vDrawSprites();
int fn_vRegisterSprite(int iSpriteLump,patch_t *patch);
int fn_vRegisterSpriteCompressed(GLTexture **p2_stGLSprites,GLMapSprite **p2_stMapSprites,GLTexArray **p2_stGLSprArray,int iSpriteLump,patch_t *patch);
void fn_vAddSpriteToList(int iSpriteLump,patch_t *patch);
GLvoid GLdrawWeapons();
GLvoid fn_vGLInitFonts();
void fn_vInitGLTexFonts();
void GL_DrTextA(char *text, int x, int y);
void GL_DrTextAY(char *text, int x, int y);
void GL_DrTextB(char *text, int x, int y);
int GL_DrawShadowedLetterB(int x,int y,int lump);
void GL_DrawPatch(int x, int y, int iLump);
void GL_DrawCompressedPatch(int x, int y, int iWidth, int iHeight,int iLump);
int GL_GetNumForName(char *szName);
int GL_iPatchWidth(int lump);
int GL_iPatchHeight(int lump);
GLvoid GL_DrawPatchScreen(patch_t *patch);
GLvoid GL_DrawLine(int X0, int Y0, int X1, int Y1, byte BaseColor);
GLvoid GLRegisterScreens();
GLvoid GL_DumpScreen();
GLvoid GLDrawScreen(int i);
GLvoid GLDrawScreenFromName(char *name);
void GL_DrawStatBack(char *name);
void GL_InitCommandLine();
void GL_Finish();
GLvoid GLSet2DMode();
void fn_vSaveRAW(char *szFilename,unsigned char *buffer,int width,int height);
void GL_StaticLight3f(GLfloat fRed,GLfloat fGreen,GLfloat fBlue);
void GL_StaticLight4f(GLfloat fRed,GLfloat fGreen,GLfloat fBlue,GLfloat fAlpha);
void GL_PaletteFlash();
GLint GL_GenerateCorona(int doomednum);
mobjtype_t GL_iGetType(int index);
void GL_DrawCoronas(player_t *player);
H_boolean GL_ChechCoronaInSight(int iIndex,mobj_t *t1, mobj_t *t2);
/* DynLight */
void GL_DynamicLight4f(GLfloat x, GLfloat y,GLfloat z,GLfloat fLightLevel,GLfloat fAlpha);
void GL_AddLightSource(mobj_t *obj,float x,float y,float z,float fRed,float fGreen,float fBlue,float fNear, float fFar, char update);
void GL_SpawnLight(mobj_t *th,fixed_t x,fixed_t y,fixed_t z);
void GL_RemoveLightSource(int ID);
void GL_UpdateLights();
void GL_DrawLightsOnPolygon(float x1,float y1,float z1,float x2,float y2,float z2,GLboolean backface);
void A_GL_StartLightEffect(mobj_t *mo);
void GL_DrawLightForFloorCeiling(int s);
/* MD2 */
void GL_vSetTics(mobj_t *mobj,int md2);
/* Wall impacts */
void GL_vGenerateWallImpact(line_t *line,float x,float y,float z,char type,float size);
void GL_CheckForBloodSplash(fixed_t x,fixed_t y,fixed_t z,int damage);
void GL_vDrawWallImpacts(int line);
void GL_ArchiveWallImpacts();
void GL_UnArchiveWallImpacts();


#endif   /* __GL_STRUCT_H__ */
