#ifdef GL_HERETIC

//#define __DOOMTYPE__

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <unistd.h>

#include "gl_syms.h"

#include "gl_struct.h"
#include "gl_mem.h"
#ifndef GL_HEXEN
#include "doomdef.h"
#else
#include "h2def.h"
#endif
#include "r_local.h"
#if defined(DOOM_GL) /*|| defined(GL_HEXEN)*/
#include "p_spec.h"
#endif

#include "p_local.h"

/*extern int numvertexes;
extern vertex_t *vertexes;
extern int numsectors;
extern sector_t *sectors;
extern int numsides;
extern side_t *sides;
extern int numlines;
extern line_t *lines;*/

extern GLTexture *p_stGLTextures;
extern int			iNbTexturesInMap;

extern GLuint *texobjs;
extern int iLightLevelMin,iLightLevelMax;

extern int *a_iGlDrawLine;

extern int *a_iGLTexTranslation;
extern int	glSwitchList[MAXSWITCHES * 2];

extern int g_iMovingSector;
GLWallImpact *g_a_stWallImpacts;
long g_iMaxImpacts=10;

#ifndef WALL_ARRAY
int *iWall;
int startWallList;

void fn_vRenderWall(short sTexture,short xOffset,short yOffset,float fCeilingHeight,float fFloorHeight,float x1,float y1,float z1,float x2,float y2,float z2,float fWallWidth,char cWallType,float fLightLevel,short flags)
// CWallType&0x80 ==1 => back-face
// CWallType&0x0F ==0 => MidTex
// CWallType&0x0F ==1 => TopTex
// CWallType&0x0F ==2 => BotTex
{ 	
	float fU1,fU2,fV1,fV2,fU1Off,fV1Off;
	int iSubTex;
	int iGLTex;
	
	//iGLTex=fn_iGetGLTexturef(szTexName,xOffset,yOffset,&fU1,&fU2,&fV1,&fV2,&fU1Off,&fV1Off,&iSubTex);
	iGLTex=fn_iGetGLTexturef(sTexture,xOffset,yOffset,&fU1,&fU2,&fV1,&fV2,&fU1Off,&fV1Off,&iSubTex);
	
	if (iGLTex==-1)
		printf("[SDLGLdrv/walls] Prout");

	if (xOffset>=p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iWidth)
		xOffset=0;
	if (yOffset>=p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight)
		yOffset=0;
		
	
	(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iGLTex]);
#ifdef BILINEAR
	if (p_stGLTextures[iGLTex].a_stSubTex[iSubTex].bIsNZ)
	{
		(*glEnable_s) (GL_ALPHA_TEST);
// MR3006
		(*glAlphaFunc_s) (GL_NOTEQUAL,0.0f);
		(*glEnable_s) (GL_BLEND);
		(*glBlendFunc_s) (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
/*		(*glAlphaFunc_s) (GL_EQUAL,1.0f);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);*/
	}
#endif
	(*glBegin_s) (GL_QUADS);

			GL_StaticLight3f(fLightLevel,fLightLevel,fLightLevel);
			
			fU2=fU1Off+(float)fWallWidth/p_stGLTextures[iGLTex].iWidth;

			if (((cWallType&0x0F)==2)&&(flags & ML_DONTPEGBOTTOM))
			{
				fV1=fV1Off;
				//fV1Off=fV1+(float)(fabs(fCeilingHeight-y1)*MAP_SCALE)/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
				fV1Off=fV1+(float)(fabs(fCeilingHeight-y1)*(MAP_SCALE>>FRACBITS))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
				//fV2=fV1+(float)(fabs(fCeilingHeight-fFloorHeight)*MAP_SCALE)/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
				fV2=fV1+(float)(fabs(fCeilingHeight-fFloorHeight)*(MAP_SCALE>>FRACBITS))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
			}
			else
			if ((((cWallType&0x0f)==0)&&(flags & ML_DONTPEGBOTTOM)&&(!(flags & ML_DONTPEGTOP)))||
				(((cWallType&0x0f)==1)&&(!(flags & ML_DONTPEGTOP))))
			{	fV2=fV1Off;
				//fV1Off=fV2-((float)(fabs(y2-y1)*MAP_SCALE))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
				fV1Off=fV2-((float)(fabs(y2-y1)*(MAP_SCALE>>FRACBITS)))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
			}
			else
				//fV2=fV1Off+((float)(fabs(y2-y1)*MAP_SCALE))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
				fV2=fV1Off+((float)(fabs(y2-y1)*(MAP_SCALE>>FRACBITS)))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;

			(*glTexCoord2f_s) (fU1Off, fV1Off); (*glVertex3f_s) ( x1, y1, z1);
			(*glTexCoord2f_s) (fU1Off, fV2); (*glVertex3f_s) ( x1, y2, z1);
			(*glTexCoord2f_s) (fU2, fV2); (*glVertex3f_s) ( x2, y2, z2);
			(*glTexCoord2f_s) (fU2, fV1Off); (*glVertex3f_s) ( x2, y1, z2);
	(*glEnd_s) ();
	
#ifdef BILINEAR
	if (p_stGLTextures[iGLTex].a_stSubTex[iSubTex].bIsNZ)
	{
		(*glDisable_s) (GL_ALPHA_TEST);
// MR3006
		(*glDisable_s) (GL_BLEND);
		/*(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);*/
	}
#endif
}
#else	// WALL_ARRAY
GLWallPolygonArray *a_stWallPoly;
int iCurrentWall;
sector_t *pCurrentSector;

void fn_vRenderWall(short sTexture,short xOffset,short yOffset,float fCeilingHeight,float fFloorHeight,float x1,float y1,float z1,float x2,float y2,float z2,float fWallWidth,char cWallType,float fLightLevel,short flags)
// CWallType&0x80 ==1 => back-face
// CWallType&0x0F ==0 => MidTex
// CWallType&0x0F ==1 => TopTex
// CWallType&0x0F ==2 => BotTex
{ 	
	float fU1,fU2,fV1,fV2,fU1Off,fV1Off;
	int iSubTex;
	int iGLTex;
		
	iGLTex=fn_iGetGLTexturef(sTexture,xOffset,yOffset,&fU1,&fU2,&fV1,&fV2,&fU1Off,&fV1Off,&iSubTex);

	if (iGLTex==-1)
	{	//printf("Prout");
		iGLTex=0;	// !!! anti-bug (cf waggle in Hexen)
	}

//	if (iGLTex==15)
//		fn_vSaveRAW("prout2.raw",p_stGLTextures[15].p_bRGBBuffer,p_stGLTextures[15].iWidth,p_stGLTextures[15].iHeight);

	if (xOffset>=p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iWidth)
	        xOffset=0;
	if (yOffset>=p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight)
		yOffset=0;

				
	GL_StaticLight3f(fLightLevel,fLightLevel,fLightLevel);
	
	//fU2=fU1Off+(float)fWallWidth/p_stGLTextures[iGLTex].iWidth;	// DOOM_GL
	fU2=fU1Off+(float)fWallWidth/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iWidth;

	if (((cWallType&0x0f)==2)&&(flags & ML_DONTPEGBOTTOM))
	{
		fV1=fV1Off;
		//fV1Off=fV1+(float)(fabs(fCeilingHeight-y1)*MAP_SCALE)/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
		fV1Off=fV1+(float)(fabs(fCeilingHeight-y1)*(MAP_SCALE>>FRACBITS))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
		//fV2=fV1+(float)(fabs(fCeilingHeight-fFloorHeight)*MAP_SCALE)/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
		fV2=fV1+(float)(fabs(fCeilingHeight-fFloorHeight)*(MAP_SCALE>>FRACBITS))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
	}
	else
	if ((((cWallType&0x0f)==0)&&(flags & ML_DONTPEGBOTTOM)&&(!(flags & ML_DONTPEGTOP)))||
		(((cWallType&0x0f)==1)&&(!(flags & ML_DONTPEGTOP))))
	{	fV2=fV1Off;
		//fV1Off=fV2-((float)(fabs(y2-y1)*MAP_SCALE))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
		fV1Off=fV2-((float)(fabs(y2-y1)*(MAP_SCALE>>FRACBITS)))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
	}
	else
		//fV2=fV1Off+((float)(fabs(y2-y1)*MAP_SCALE))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
		fV2=fV1Off+((float)(fabs(y2-y1)*(MAP_SCALE>>FRACBITS)))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;

	a_stWallPoly[iCurrentWall].iNbQuads++;
	a_stWallPoly[iCurrentWall].p_stWallQuad=(GLWallQuad *)Realloc(a_stWallPoly[iCurrentWall].p_stWallQuad,a_stWallPoly[iCurrentWall].iNbQuads*sizeof(GLWallQuad));
	
	a_stWallPoly[iCurrentWall].p_stWallQuad[a_stWallPoly[iCurrentWall].iNbQuads-1].a_fVertex[0]=x1;
	a_stWallPoly[iCurrentWall].p_stWallQuad[a_stWallPoly[iCurrentWall].iNbQuads-1].a_fVertex[1]=y1;
	a_stWallPoly[iCurrentWall].p_stWallQuad[a_stWallPoly[iCurrentWall].iNbQuads-1].a_fVertex[2]=z1;
	a_stWallPoly[iCurrentWall].p_stWallQuad[a_stWallPoly[iCurrentWall].iNbQuads-1].a_fVertex[3]=x2;
	a_stWallPoly[iCurrentWall].p_stWallQuad[a_stWallPoly[iCurrentWall].iNbQuads-1].a_fVertex[4]=y2;
	a_stWallPoly[iCurrentWall].p_stWallQuad[a_stWallPoly[iCurrentWall].iNbQuads-1].a_fVertex[5]=z2;
	a_stWallPoly[iCurrentWall].p_stWallQuad[a_stWallPoly[iCurrentWall].iNbQuads-1].a_fUV[0]=fU1Off;
	a_stWallPoly[iCurrentWall].p_stWallQuad[a_stWallPoly[iCurrentWall].iNbQuads-1].a_fUV[1]=fV1Off;
	a_stWallPoly[iCurrentWall].p_stWallQuad[a_stWallPoly[iCurrentWall].iNbQuads-1].a_fUV[2]=fU2;
	a_stWallPoly[iCurrentWall].p_stWallQuad[a_stWallPoly[iCurrentWall].iNbQuads-1].a_fUV[3]=fV2;
	a_stWallPoly[iCurrentWall].p_stWallQuad[a_stWallPoly[iCurrentWall].iNbQuads-1].iTex=iGLTex;
	a_stWallPoly[iCurrentWall].p_stWallQuad[a_stWallPoly[iCurrentWall].iNbQuads-1].pSector=pCurrentSector;
	a_stWallPoly[iCurrentWall].p_stWallQuad[a_stWallPoly[iCurrentWall].iNbQuads-1].cWallType=cWallType;
}

#ifdef GL_HEXEN
void GL_UpdateWallCoordinates(int iLineID,float fCeiling,float fFloor)
{ float x1,z1,x2,z2;

	x1=-(float)lines[iLineID].v1->x/MAP_SCALE;
	x2=-(float)lines[iLineID].v2->x/MAP_SCALE;
	z1=(float)lines[iLineID].v1->y/MAP_SCALE;
	z2=(float)lines[iLineID].v2->y/MAP_SCALE;

	a_stWallPoly[iLineID].p_stWallQuad[0].a_fVertex[0]=x1;
	a_stWallPoly[iLineID].p_stWallQuad[0].a_fVertex[1]=fCeiling;
	a_stWallPoly[iLineID].p_stWallQuad[0].a_fVertex[2]=z1;
	a_stWallPoly[iLineID].p_stWallQuad[0].a_fVertex[3]=x2;
	a_stWallPoly[iLineID].p_stWallQuad[0].a_fVertex[4]=fFloor;
	a_stWallPoly[iLineID].p_stWallQuad[0].a_fVertex[5]=z2;		
}
#endif	// GL_HEXEN
#endif	// WALL_ARRAY

void fn_vComputeLightLevels()
{ int s;
	for (s=0;s<numsectors;s++)
	{	if (sectors[s].lightlevel>iLightLevelMax)
			iLightLevelMax=sectors[s].lightlevel;
		if (sectors[s].lightlevel<iLightLevelMin)
			iLightLevelMin=sectors[s].lightlevel;
	}
	iLightLevelMin-=10;
	iLightLevelMax+=10;
	if (iLightLevelMin<0)
		iLightLevelMin=0;
	if (iLightLevelMax>255)
		iLightLevelMax=255;

	// MR
	//iLightLevelMin=-1;
	iLightLevelMin=0;
	iLightLevelMax=255;
}

void fn_vCreateWallsPolygons(int i)
{ 	
	float x1,y1,x2,y2,z1,z2;	  
	float fWallWidth;
	short xOffset,yOffset;
	GLboolean bDrawWallMid,bDrawWallBot,bDrawWallUp;
	float fLightLevel, fCeilingHeight0, fFloorHeight0, fCeilingHeight1=0.0f, fFloorHeight1=0.0f;

#ifndef WALL_ARRAY
	glNewList(startWallList+i, GL_COMPILE);
	iWall[i]=startWallList+i;
#else
/*	if (a_stWallPoly[i].iNbQuads)	// GL_HEXEN (Cf waggle)
		return;*/
	iCurrentWall=i;
	a_stWallPoly[iCurrentWall].iNbQuads=0;
	a_stWallPoly[iCurrentWall].p_stWallQuad=(GLWallQuad *)Malloc(sizeof(GLWallQuad));
#endif

	x1=-(float)lines[i].v1->x/MAP_SCALE;
	x2=-(float)lines[i].v2->x/MAP_SCALE;
	z1=(float)lines[i].v1->y/MAP_SCALE;
	z2=(float)lines[i].v2->y/MAP_SCALE;
		
	/*fWallWidth=(float)sqrt(
		  (float)(lines[i].v1->x-lines[i].v2->x)*(lines[i].v1->x-lines[i].v2->x)+
		  (float)(lines[i].v1->y-lines[i].v2->y)*(lines[i].v1->y-lines[i].v2->y));		*/
	fWallWidth=(float)sqrt(
		  (float)((lines[i].v1->x>>FRACBITS)-(lines[i].v2->x>>FRACBITS))*((lines[i].v1->x>>FRACBITS)-(lines[i].v2->x>>FRACBITS))+
		  (float)((lines[i].v1->y>>FRACBITS)-(lines[i].v2->y>>FRACBITS))*((lines[i].v1->y>>FRACBITS)-(lines[i].v2->y>>FRACBITS)));

	bDrawWallMid=FALSE;
	bDrawWallBot=FALSE;
	bDrawWallUp=FALSE;
	
	//xOffset=sides[lines[i].sidenum[0]].textureoffset;
	//yOffset=sides[lines[i].sidenum[0]].rowoffset;
	xOffset=sides[lines[i].sidenum[0]].textureoffset>>FRACBITS;
	yOffset=sides[lines[i].sidenum[0]].rowoffset>>FRACBITS;

	fLightLevel=(float)(sides[lines[i].sidenum[0]].sector->lightlevel-iLightLevelMin)/(float)(iLightLevelMax-iLightLevelMin);
#ifdef WALL_ARRAY
	pCurrentSector=sides[lines[i].sidenum[0]].sector;
	a_stWallPoly[iCurrentWall].fWallWidth=fWallWidth;
#endif

// GL_HEXEN
/*	fCeilingHeight0=(float)sides[lines[i].sidenum[0]].sector->ceilingheight/MAP_SCALE;
	fFloorHeight0=(float)sides[lines[i].sidenum[0]].sector->floorheight/MAP_SCALE;
	fCeilingHeight1=(float)sides[lines[i].sidenum[1]].sector->ceilingheight/MAP_SCALE;
	fFloorHeight1=(float)sides[lines[i].sidenum[1]].sector->floorheight/MAP_SCALE;
*/	
	fCeilingHeight0=(float)lines[i].frontsector->ceilingheight/MAP_SCALE;
	fFloorHeight0=(float)lines[i].frontsector->floorheight/MAP_SCALE;
	if (lines[i].backsector)
	{	fCeilingHeight1=(float)lines[i].backsector->ceilingheight/MAP_SCALE;
		fFloorHeight1=(float)lines[i].backsector->floorheight/MAP_SCALE;
	}
// End GL_HEXEN

	// MR2506
	if (lines[i].sidenum[1]==-1)
	{	if (sides[lines[i].sidenum[0]].midtexture!=R_TextureNumForName("-"))
		{
			y1=fCeilingHeight0;
			y2=fFloorHeight0;

			fn_vRenderWall(sides[lines[i].sidenum[0]].midtexture,xOffset,yOffset,fCeilingHeight0,fFloorHeight0,x1,y1,z1,x2,y2,z2,fWallWidth,0,fLightLevel,lines[i].flags);
			bDrawWallMid=TRUE;
		}
	}
	// MR2506
	else
	{	if (sides[lines[i].sidenum[0]].midtexture!=R_TextureNumForName("-"))
		{
			/*y1=fCeilingHeight1;
			y2=fFloorHeight1;*/
			y1=fCeilingHeight1>fCeilingHeight0?fCeilingHeight0:fCeilingHeight1;
			y2=fFloorHeight1>fFloorHeight0?fFloorHeight1:fFloorHeight0;

			fn_vRenderWall(sides[lines[i].sidenum[0]].midtexture,xOffset,yOffset,fCeilingHeight0,fFloorHeight0,x1,y1,z1,x2,y2,z2,fWallWidth,0,fLightLevel,lines[i].flags);
			bDrawWallMid=TRUE;
		}
	}

	if (sides[lines[i].sidenum[0]].bottomtexture!=R_TextureNumForName("-"))
	{
		y2=fFloorHeight0;
		y1=fFloorHeight1;

		fn_vRenderWall(sides[lines[i].sidenum[0]].bottomtexture,xOffset,yOffset,fCeilingHeight0,fFloorHeight0,x1,y1,z1,x2,y2,z2,fWallWidth,2,fLightLevel,lines[i].flags);
		bDrawWallBot=TRUE;
	}

#ifndef GL_HEXEN
	if ((sides[lines[i].sidenum[0]].toptexture!=R_TextureNumForName("-"))&&
		!((lines[i].frontsector->ceilingpic==R_FlatNumForName("F_SKY1"))&&
			 lines[i].backsector&&
			(lines[i].backsector->ceilingpic==R_FlatNumForName("F_SKY1"))))	// DOOM_GL (cf E1M1 line 251)
#else
	if ((sides[lines[i].sidenum[0]].toptexture!=R_TextureNumForName("-"))&&
		!((lines[i].frontsector->ceilingpic==R_FlatNumForName("F_SKY"))&&
			 lines[i].backsector&&
			(lines[i].backsector->ceilingpic==R_FlatNumForName("F_SKY"))))	// DOOM_GL (cf E1M1 line 251)
#endif
	{

		y1=fCeilingHeight0;
		y2=fCeilingHeight1;

		fn_vRenderWall(sides[lines[i].sidenum[0]].toptexture,xOffset,yOffset,fCeilingHeight0,fFloorHeight0,x1,y1,z1,x2,y2,z2,fWallWidth,1,fLightLevel,lines[i].flags);
		bDrawWallUp=TRUE;
	}
	
	if (lines[i].sidenum[1]!=-1)
	{	xOffset=sides[lines[i].sidenum[1]].textureoffset>>FRACBITS;
		yOffset=sides[lines[i].sidenum[1]].rowoffset>>FRACBITS;
		//fLightLevel=(float)sectors[sides[lines[i].sidenum[1]].sector].lightlevel/255;
		fLightLevel=(float)(sides[lines[i].sidenum[1]].sector->lightlevel-iLightLevelMin)/(float)(iLightLevelMax-iLightLevelMin);
#ifdef WALL_ARRAY
		pCurrentSector=sides[lines[i].sidenum[1]].sector;
#endif
		{	if (sides[lines[i].sidenum[1]].midtexture!=R_TextureNumForName("-"))
			{
				/*y1=fCeilingHeight1;
				y2=fFloorHeight1;*/
				y1=fCeilingHeight1>fCeilingHeight0?fCeilingHeight0:fCeilingHeight1;
				y2=fFloorHeight1>fFloorHeight0?fFloorHeight1:fFloorHeight0;
				if (!bDrawWallMid)
					fn_vRenderWall(sides[lines[i].sidenum[1]].midtexture,xOffset,yOffset,fCeilingHeight1,fFloorHeight1,x1,y1,z1,x2,y2,z2,fWallWidth,0,fLightLevel,lines[i].flags);
				// No back-face for midText... (Cf spider webs)
				else	// back-face
				{ //float fDFaces=0.5f/MAP_SCALE;		// Distance between 2 faces...
				  float x1b,z1b,x2b,z2b/*,fWidth*/;

					//fWidth=fWallWidth/(MAP_SCALE>>FRACBITS);
					//x1b=fDFaces*(z2-z1)/fWidth+x1;
					//z1b=fDFaces*(x2-x1)/fWidth+z1;
					//x2b=fDFaces*(z2-z1)/fWidth+x2;
					//z2b=fDFaces*(x2-x1)/fWidth+z2;

					x1b=x1; z1b=z1; x2b=x2; z2b=z2;
					//x1b=x2; z1b=z1; x2b=x1; z2b=z2;
					fn_vRenderWall(sides[lines[i].sidenum[1]].midtexture,xOffset,yOffset,fCeilingHeight1,fFloorHeight1,x1b,y1,z1b,x2b,y2,z2b,fWallWidth,(char)0x80,fLightLevel,lines[i].flags);
				}
			}
		}

		if (sides[lines[i].sidenum[1]].bottomtexture!=R_TextureNumForName("-"))
		{
			y2=fFloorHeight1;
			y1=fFloorHeight0;

			if (!bDrawWallBot)
				fn_vRenderWall(sides[lines[i].sidenum[1]].bottomtexture,xOffset,yOffset,fCeilingHeight1,fFloorHeight1,x1,y1,z1,x2,y2,z2,fWallWidth,0x82,fLightLevel,lines[i].flags);
			else	// back-face
			{ //float fDFaces=0.5f/(MAP_SCALE>>FRACBITS);		// Distance between 2 faces...
			  /* float fDFaces=1.0f/(MAP_SCALE>>FRACBITS); */	// Distance between 2 faces...
			  float x1b,z1b,x2b,z2b/*,fWidth*/;

				//fWidth=fWallWidth/(MAP_SCALE>>FRACBITS);
				// DOOM_GL
/*				x1b=fDFaces*(z2-z1)/fWidth+x1;
				z1b=-fDFaces*(x2-x1)/fWidth+z1;
				x2b=fDFaces*(z2-z1)/fWidth+x2;
				z2b=-fDFaces*(x2-x1)/fWidth+z2;*/
				////fn_vRenderWall(sides[lines[i].sidenum[1]].bottomtexture,xOffset,yOffset,fCeilingHeight1,fFloorHeight1,x1b,y1,z1b,x2b,y2,z2b,fWallWidth,2,fLightLevel,lines[i].flags);
				x1b=x1; z1b=z1; x2b=x2; z2b=z2;
				fn_vRenderWall(sides[lines[i].sidenum[1]].bottomtexture,xOffset,yOffset,fCeilingHeight1,fFloorHeight1,x1b,y1,z1b,x2b,y2,z2b,fWallWidth,(char)0x82,fLightLevel,lines[i].flags);
			}
		}

		if (sides[lines[i].sidenum[1]].toptexture!=R_TextureNumForName("-"))
		{
			y1=fCeilingHeight1;
			y2=fCeilingHeight0;

			if (!bDrawWallUp)
				fn_vRenderWall(sides[lines[i].sidenum[1]].toptexture,xOffset,yOffset,fCeilingHeight1,fFloorHeight1,x1,y1,z1,x2,y2,z2,fWallWidth,0x81,fLightLevel,lines[i].flags);
			else	// back-face
			{ //float fDFaces=0.5f/(MAP_SCALE>>FRACBITS);		// Distance between 2 faces...
			  /* float fDFaces=1.0f/(MAP_SCALE>>FRACBITS); */	// Distance between 2 faces...
			  float x1b,z1b,x2b,z2b/*,fWidth*/;

				//fWidth=fWallWidth/(MAP_SCALE>>FRACBITS);
				// DOOM_GL
/*				x1b=fDFaces*(z2-z1)/fWidth+x1;
				z1b=-fDFaces*(x2-x1)/fWidth+z1;
				x2b=fDFaces*(z2-z1)/fWidth+x2;
				z2b=-fDFaces*(x2-x1)/fWidth+z2;*/
				x1b=x1; z1b=z1; x2b=x2; z2b=z2;
				////fn_vRenderWall(sides[lines[i].sidenum[1]].toptexture,xOffset,yOffset,fCeilingHeight1,fFloorHeight1,x1b,y1,z1b,x2b,y2,z2b,fWallWidth,1,fLightLevel,lines[i].flags);
				fn_vRenderWall(sides[lines[i].sidenum[1]].toptexture,xOffset,yOffset,fCeilingHeight1,fFloorHeight1,x1b,y1,z1b,x2b,y2,z2b,fWallWidth,(char)0x81,fLightLevel,lines[i].flags);
			}
		}
	}
	
#ifndef WALL_ARRAY
	(*glEnd_s) List();
#endif
}

void fn_vCreateWalls()
{ 	int i;

//	GL_fn_vInitLights();
	fn_vComputeLightLevels();

#ifndef WALL_ARRAY
	iWall=(int *)Malloc(sizeof(int)*numlines);
#else
	a_stWallPoly=(GLWallPolygonArray *)Malloc(sizeof(GLWallPolygonArray)*numlines);
	for (i=0;i<numlines;i++)
		a_stWallPoly[i].iNbQuads=0;
#endif
	a_iGlDrawLine=(int *)Malloc(sizeof(int)*numlines);

#ifndef WALL_ARRAY
	startWallList = glGenLists(numlines);
#endif
	for (i=0;i<numlines;i++)
	{
		//if (i==87)
		//if (i==793)
		//if (i==705)
		//if (i==472)
		//if (i==91)
		//	printf("pouet");

		fn_vCreateWallsPolygons(i);
	}
}

#ifdef WALL_ARRAY
extern long g_bDynLight;

void fn_vDisplayWall(int line)
{ GLfloat fLightLevel;
  int iGLTex,iSubTex=0,i;
  float fU2,fV2,fU1Off,fV1Off;
  float x1,y1,z1,x2,y2,z2;
  float fFloor,fCeil;
  H_boolean bDynLight;

	if (line==-1)
		return;

/*	if (line==1859)
		printf("prout");*/
	for (i=0;i<a_stWallPoly[line].iNbQuads;i++)
	{
		// MR0207
		//fLightLevel=(float)(a_stWallPoly[line].p_stWallQuad[i].pSector->lightlevel-iLightLevelMin)/(float)(iLightLevelMax-iLightLevelMin);
		//fLightLevel=(float)a_stWallPoly[line].p_stWallQuad[i].pSector->lightlevel/255.0f;
		//fLightLevel=(float)(a_stWallPoly[line].p_stWallQuad[i].pSector->lightlevel-iLightLevelMin/2)/255.0f;
		//fLightLevel=(1.0f+0.25f*(float)usegamma)*((float)a_stWallPoly[line].p_stWallQuad[i].pSector->lightlevel-0.5f)/512.0f;	// MR0706
		fLightLevel=(1.0f+0.25f*(float)usegamma)*((float)(a_stWallPoly[line].p_stWallQuad[i].pSector->lightlevel+(extralight<<LIGHTSEGSHIFT))-0.5f)/512.0f;		// MR0706
		//fLightLevel=(1.0f+0.25f*(float)usegamma)*(float)(a_stWallPoly[line].p_stWallQuad[i].pSector->lightlevel-iLightLevelMin)/(float)(iLightLevelMax-iLightLevelMin);

		x1=a_stWallPoly[line].p_stWallQuad[i].a_fVertex[0];
		y1=a_stWallPoly[line].p_stWallQuad[i].a_fVertex[1];
		z1=a_stWallPoly[line].p_stWallQuad[i].a_fVertex[2];
		x2=a_stWallPoly[line].p_stWallQuad[i].a_fVertex[3];
		y2=a_stWallPoly[line].p_stWallQuad[i].a_fVertex[4];
		z2=a_stWallPoly[line].p_stWallQuad[i].a_fVertex[5];
		fU1Off=a_stWallPoly[line].p_stWallQuad[i].a_fUV[0];
		fV1Off=a_stWallPoly[line].p_stWallQuad[i].a_fUV[1];
		fU2=a_stWallPoly[line].p_stWallQuad[i].a_fUV[2];
		fV2=a_stWallPoly[line].p_stWallQuad[i].a_fUV[3];
		iGLTex=a_iGLTexTranslation[a_stWallPoly[line].p_stWallQuad[i].iTex];

		/* sector == 1 wall !*/
		/* if ((line>=23) && (line<=28)) { */
		/* if ((line>=5) && (line<=9)) { */
		/* if (a_iGLTexTranslation[a_stWallPoly[line].p_stWallQuad[i].iTex]==5) { */
		  
		/* fprintf(stderr, "!!!!!!!!! painting wall: iLineID: %d !!!!!!!!!\n", line); */
		/* fprintf(stderr, "v1[%.4f, %.4f, %.4f], v2[%.4f, %.4f, %.4f], fU1Off: %.4f, fV1Off: %.4f, fU2: %.4f, fV2: %.4f, iGLTex: %d\n", x1, y1, z1, x2, y2, z2, fU1Off, fV1Off, fU2, fV2, iGLTex); */
		

		(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iGLTex]);
#ifdef BILINEAR

		if (p_stGLTextures[iGLTex].a_stSubTex[iSubTex].bIsNZ)
		{ float fTexHeight;

			(*glEnable_s) (GL_ALPHA_TEST);
			// MR3006: il faudrait trier ces faces....
			/*
			  (*glAlphaFunc_s) (GL_NOTEQUAL,0.0f);
			  (*glEnable_s) (GL_BLEND);
			  (*glBlendFunc_s) (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
			*/

			//(*glAlphaFunc_s) (GL_EQUAL,1.0f);
			(*glAlphaFunc_s) (GL_NOTEQUAL,0.0f);		// MR1807
			(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
			(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
			
			/* ANDRE !!! */
			//(*glDisable_s) (GL_CULL_FACE);	// DOOM_GL
			// MR1806: pour DoomGL E1M3 au dbut de la map...
			fTexHeight=(float)p_stGLTextures[iGLTex].a_stSubTex[0].iHeight/(float)MAP_COEFF;
			if ((y1-y2)>fTexHeight)
			{	if (lines[line].flags & ML_DONTPEGBOTTOM)
					y1=y2+fTexHeight;
				else
					y2=y1-fTexHeight;
				fV1Off=0.0f; fV2=1.0f;
			}
			/*if (lines[line].flags & ML_DONTPEGBOTTOM)	// MR2506
			{	fV1Off=1.0f-fV2;
				fV2=1.0f;
			}*/
			bDynLight=g_bDynLight!=0?1:0;
		}
		else
			bDynLight=g_bDynLight;
#endif
		// if (y1 ou y2 < sol) ou (y1 ou y2 > plafond) alors trace rien !	// DOOM_GL (a voir)
		fFloor=(float)a_stWallPoly[line].p_stWallQuad[i].pSector->floorheight/MAP_SCALE;
		fCeil=(float)a_stWallPoly[line].p_stWallQuad[i].pSector->ceilingheight/MAP_SCALE;

		/* ANDRE !!! This caused the "missing walls" problem !!!!!!!! */
#if 0
		if (((a_stWallPoly[line].p_stWallQuad[i].cWallType&0x0f)==2)&&
			(( y1 < fFloor )||
			( y2 < fFloor ))) {
				/* fprintf(stderr, "iLineID: %d, y1:%.4f, y2: %.4f, fFloor: %.4f\n", line, y1, y2, fFloor); */
			   continue;
			}
		if (((a_stWallPoly[line].p_stWallQuad[i].cWallType&0x0f)==1)&&
			(( y1 > fCeil )||
			( y2 > fCeil ))) {
				/* fprintf(stderr, "iLineID: %d, y1:%.4f, y2: %.4f, fCeil: %.4f\n", line, y1, y2, fCeil); */
			   continue;
			}
#endif

		if (bDynLight==1)
		{
			if (a_stWallPoly[line].p_stWallQuad[i].cWallType&0x80)	// it is a back-face
			{	
			  /* fprintf(stderr, "dynlight - backface !\n"); */
				(*glBegin_s) (GL_QUADS);
				GL_DynamicLight4f(x1, y1, z1,fLightLevel,1.0f);
				(*glTexCoord2f_s) (fU2, fV1Off); (*glVertex3f_s) ( x1, y1, z1);
				GL_DynamicLight4f(x2, y1, z2,fLightLevel,1.0f);
				(*glTexCoord2f_s) (fU1Off, fV1Off); (*glVertex3f_s) ( x2, y1, z2);
				GL_DynamicLight4f(x2, y2, z2,fLightLevel,1.0f);
				(*glTexCoord2f_s) (fU1Off, fV2); (*glVertex3f_s) ( x2, y2, z2);
				GL_DynamicLight4f(x1, y2, z1,fLightLevel,1.0f);
				(*glTexCoord2f_s) (fU2, fV2); (*glVertex3f_s) ( x1, y2, z1);
				(*glEnd_s) ();
			}
			else
			{	
			  /* fprintf(stderr, "dynlight - frontface !\n"); */
				(*glBegin_s) (GL_QUADS);
				GL_DynamicLight4f(x1, y1, z1,fLightLevel,1.0f);
				(*glTexCoord2f_s) (fU1Off, fV1Off); (*glVertex3f_s) ( x1, y1, z1);
				GL_DynamicLight4f(x1, y2, z1,fLightLevel,1.0f);
				(*glTexCoord2f_s) (fU1Off, fV2); (*glVertex3f_s) ( x1, y2, z1);
				GL_DynamicLight4f(x2, y2, z2,fLightLevel,1.0f);
				(*glTexCoord2f_s) (fU2, fV2); (*glVertex3f_s) ( x2, y2, z2);
				GL_DynamicLight4f(x2, y1, z2,fLightLevel,1.0f);
				(*glTexCoord2f_s) (fU2, fV1Off); (*glVertex3f_s) ( x2, y1, z2);
				(*glEnd_s) ();
			}
		}
		else
		{
			GL_StaticLight3f(fLightLevel,fLightLevel,fLightLevel);
			if (a_stWallPoly[line].p_stWallQuad[i].cWallType&0x80)	// it is a back-face
			{
			   /* fprintf(stderr, "staticlight - backface !\n"); */
			  /* fprintf(stderr, "paint wall(bf): 1[%.4f, %.4f, %.4f], 2[%.4f, %.4f, %.4f]\n",
			     x1, y1, z1, x2, y1, z2); */
			  /* fprintf(stderr, "paint wall(bf): 3[%.4f, %.4f, %.4f], 4[%.4f, %.4f, %.4f]\n\n",
			     x2, y2, z2, x1, y2, z1); */
				(*glBegin_s) (GL_QUADS);
				(*glTexCoord2f_s) (fU2, fV1Off); (*glVertex3f_s) ( x1, y1, z1);
				(*glTexCoord2f_s) (fU1Off, fV1Off); (*glVertex3f_s) ( x2, y1, z2);
				(*glTexCoord2f_s) (fU1Off, fV2); (*glVertex3f_s) ( x2, y2, z2);
				(*glTexCoord2f_s) (fU2, fV2); (*glVertex3f_s) ( x1, y2, z1);
				(*glEnd_s) ();
				if (bDynLight==2)
					GL_DrawLightsOnPolygon(x1,z1,y1,x2,z2,y2,true);
			}
			else
			{	
			  /* fprintf(stderr, "staticlight - frontface !\n"); */
			  /* fprintf(stderr, "paint wall(ff): 1[%.4f, %.4f, %.4f], 2[%.4f, %.4f, %.4f]\n",
			     x1, y1, z1, x1, y2, z1); */
			  /* fprintf(stderr, "paint wall(ff): 3[%.4f, %.4f, %.4f], 4[%.4f, %.4f, %.4f]\n\n",
			     x2, y2, z2, x2, y1, z2); */
				(*glBegin_s) (GL_QUADS);
				(*glTexCoord2f_s) (fU1Off, fV1Off); (*glVertex3f_s) ( x1, y1, z1);
				(*glTexCoord2f_s) (fU1Off, fV2); (*glVertex3f_s) ( x1, y2, z1);
				(*glTexCoord2f_s) (fU2, fV2); (*glVertex3f_s) ( x2, y2, z2);
				(*glTexCoord2f_s) (fU2, fV1Off); (*glVertex3f_s) ( x2, y1, z2);
				(*glEnd_s) ();
				if (bDynLight==2)
					GL_DrawLightsOnPolygon(x1,z1,y1,x2,z2,y2,false);
			}
		}
#ifdef BILINEAR
		if (p_stGLTextures[iGLTex].a_stSubTex[iSubTex].bIsNZ)
		{
			(*glDisable_s) (GL_ALPHA_TEST);
			// MR3006
			//(*glDisable_s) (GL_BLEND);
			(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		}
#endif
		/* } */
	}

	// Wall impacts
	GL_vDrawWallImpacts(line);
}

void fn_vUpdateWall(int iLineId,int iQuad,int iGLTex,short yOffset,float fCeilingHeight,float fFloorHeight,float y1,float y2,char cWallType,short flags)
// CWallType&0x80 ==1 => back-face
// CWallType&0x0F ==0 => MidTex
// CWallType&0x0F ==1 => TopTex
// CWallType&0x0F ==2 => BotTex
{ 	
	float fV1,fV2,fV1Off;
	int iSubTex=0;
	float yMove;
	int i;

	if (yOffset>=p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight)
		yOffset=0;

	fV1Off=(float)(p_stGLTextures[iGLTex].a_stSubTex[0].iV+yOffset)/(float)p_stGLTextures[iGLTex].iHeight;
				
	if (((cWallType&0x0f)==2)&&(flags & ML_DONTPEGBOTTOM))
	{
		fV1=fV1Off;
		fV1Off=fV1+(float)(fabs(fCeilingHeight-y1)*(MAP_SCALE>>FRACBITS))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
		fV2=fV1+(float)(fabs(fCeilingHeight-fFloorHeight)*(MAP_SCALE>>FRACBITS))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
	}
	else
	if ((((cWallType&0x0f)==0)&&(flags & ML_DONTPEGBOTTOM)&&(!(flags & ML_DONTPEGTOP)))||
		(((cWallType&0x0f)==1)&&(!(flags & ML_DONTPEGTOP))))
	{	fV2=fV1Off;
		fV1Off=fV2-((float)(fabs(y2-y1)*(MAP_SCALE>>FRACBITS)))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
	}
	else
		fV2=fV1Off+((float)(fabs(y2-y1)*(MAP_SCALE>>FRACBITS)))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;

	// Impacts
	if ((!iQuad)&&lines[iLineId].backsector&&(lines[iLineId].backsector->iSectorID==g_iMovingSector))
	{	if (a_stWallPoly[iLineId].p_stWallQuad[iQuad].a_fVertex[4]!=y2)
			yMove=a_stWallPoly[iLineId].p_stWallQuad[iQuad].a_fVertex[4]-y2;
		else
			yMove=a_stWallPoly[iLineId].p_stWallQuad[iQuad].a_fVertex[1]-y1;
		for (i=0;i<g_a_stWallImpacts[iLineId].iNbImpacts;i++)
		{	g_a_stWallImpacts[iLineId].y1[i]-=yMove;
			g_a_stWallImpacts[iLineId].y2[i]-=yMove;
		}
	}
	a_stWallPoly[iLineId].p_stWallQuad[iQuad].a_fVertex[1]=y1;
	a_stWallPoly[iLineId].p_stWallQuad[iQuad].a_fVertex[4]=y2;
	a_stWallPoly[iLineId].p_stWallQuad[iQuad].a_fUV[1]=fV1Off;
	a_stWallPoly[iLineId].p_stWallQuad[iQuad].a_fUV[3]=fV2;
}

#ifndef GL_HEXEN
void fn_vUpdateWallTexture(int iLine,int iWallType,int iSwitch)
#else
void fn_vUpdateSwitchTexture(int iLine,int iWallType,int iSwitch)
#endif
{ int i;

	for (i=0;i<a_stWallPoly[iLine].iNbQuads;i++)
		if (a_stWallPoly[iLine].p_stWallQuad[i].cWallType==iWallType)
		{	a_stWallPoly[iLine].p_stWallQuad[i].iTex=glSwitchList[iSwitch];
			return;
		}
}

#ifdef GL_HEXEN
void fn_vUpdateWallTexture(int iLine,int iWallType,int iTex)
{ int i;

	for (i=0;i<a_stWallPoly[iLine].iNbQuads;i++)
		if (a_stWallPoly[iLine].p_stWallQuad[i].cWallType==iWallType)
		{	a_stWallPoly[iLine].p_stWallQuad[i].iTex=iTex;
			return;
		}
	// MR2007: wall does not exist...
	fn_vCreateWallsPolygons(iLine);	
}

void fn_vUpdateWallsTexturesFromSavedGame()
{ int i,iLine;
  int side;

	//for (i=0;i<a_stWallPoly[iLine].iNbQuads;i++)
	for (iLine=0;iLine<numlines;iLine++)
	{	
		for (i=0;i<a_stWallPoly[iLine].iNbQuads;i++)
		{
			if (a_stWallPoly[iLine].p_stWallQuad[i].cWallType&0x80)
				side=1;
			else
				side=0;
			if ((a_stWallPoly[iLine].p_stWallQuad[i].cWallType&0x0F)==0)
				a_stWallPoly[iLine].p_stWallQuad[i].iTex=GL_vRegisterWallTextureOnTheFly(sides[lines[iLine].sidenum[side]].midtexture);
			else if ((a_stWallPoly[iLine].p_stWallQuad[i].cWallType&0x0F)==1)
				a_stWallPoly[iLine].p_stWallQuad[i].iTex=GL_vRegisterWallTextureOnTheFly(sides[lines[iLine].sidenum[side]].toptexture);
			else if ((a_stWallPoly[iLine].p_stWallQuad[i].cWallType&0x0F)==2)
				a_stWallPoly[iLine].p_stWallQuad[i].iTex=GL_vRegisterWallTextureOnTheFly(sides[lines[iLine].sidenum[side]].bottomtexture);
		}
	}
}
#endif

void fn_vScrollWallTexture(int iLine,int xOffset)
{ int i,iGLTexIndex;

	for (i=0;i<a_stWallPoly[iLine].iNbQuads;i++)
	{
		iGLTexIndex=a_stWallPoly[iLine].p_stWallQuad[i].iTex;

		xOffset=(xOffset>>FRACBITS);
		/*if (xOffset>=p_stGLTextures[iGLTexIndex].a_stSubTex[0].iWidth)
			xOffset=0;*/

		a_stWallPoly[iLine].p_stWallQuad[i].a_fUV[0]=(float)(p_stGLTextures[iGLTexIndex].a_stSubTex[0].iU+xOffset)/(float)p_stGLTextures[iGLTexIndex].iWidth;
		a_stWallPoly[iLine].p_stWallQuad[i].a_fUV[2]=a_stWallPoly[iLine].p_stWallQuad[i].a_fUV[0]+(float)a_stWallPoly[iLine].fWallWidth/p_stGLTextures[iGLTexIndex].iWidth;
	}
}

#ifdef GL_HEXEN
void fn_vScrollWallTextureV(int iLine,int yOffset)
{ int i,iGLTexIndex;
  float fV1Off,fV2,y1,y2;
  short flags;
  char cWallType;

	flags=lines[iLine].flags;
	for (i=0;i<a_stWallPoly[iLine].iNbQuads;i++)
	{
		iGLTexIndex=a_stWallPoly[iLine].p_stWallQuad[i].iTex;
		y1=a_stWallPoly[iLine].p_stWallQuad[i].a_fVertex[1];
		y2=a_stWallPoly[iLine].p_stWallQuad[i].a_fVertex[4];
		cWallType=a_stWallPoly[iLine].p_stWallQuad[i].cWallType;

		yOffset=(yOffset>>FRACBITS);
		fV1Off=(float)(p_stGLTextures[iGLTexIndex].a_stSubTex[0].iV+yOffset)/(float)p_stGLTextures[iGLTexIndex].iHeight;
/*		if (((cWallType&0x0f)==2)&&(flags & ML_DONTPEGBOTTOM))
		{
			fV1Off=fV1+(float)(fabs(fCeilingHeight-y1)*(MAP_SCALE>>FRACBITS))/p_stGLTextures[iGLTex].a_stSubTex[0].iHeight;
			fV2=fV1+(float)(fabs(fCeilingHeight-fFloorHeight)*(MAP_SCALE>>FRACBITS))/p_stGLTextures[iGLTex].a_stSubTex[0].iHeight;
		}
		else*/
		if ((((cWallType&0x0f)==0)&&(flags & ML_DONTPEGBOTTOM)&&(!(flags & ML_DONTPEGTOP)))||
			(((cWallType&0x0f)==1)&&(!(flags & ML_DONTPEGTOP))))
		{	fV2=fV1Off;
			fV1Off=fV2-((float)(fabs(y2-y1)*(MAP_SCALE>>FRACBITS)))/p_stGLTextures[iGLTexIndex].a_stSubTex[0].iHeight;
		}
		else
			fV2=fV1Off+((float)(fabs(y2-y1)*(MAP_SCALE>>FRACBITS)))/p_stGLTextures[iGLTexIndex].a_stSubTex[0].iHeight;


		a_stWallPoly[iLine].p_stWallQuad[i].a_fUV[1]=fV1Off;
		a_stWallPoly[iLine].p_stWallQuad[i].a_fUV[3]=fV2;
	}
}
#endif	// GL_HEXEN

void fn_vUpdateWallsPolygons(int i)
{ 	
	float y1=0.0f, y2=0.0f;	
	short yOffset;
	float fCeilingHeight0, fFloorHeight0, fCeilingHeight1=0.0f, fFloorHeight1=0.0f;	
	int j;
	
	if (i==-1)		// DOOM_GL
		return;

	yOffset=sides[lines[i].sidenum[0]].rowoffset>>FRACBITS;

	pCurrentSector=sides[lines[i].sidenum[0]].sector;

	fCeilingHeight0=(float)lines[i].frontsector->ceilingheight/MAP_SCALE;
	fFloorHeight0=(float)lines[i].frontsector->floorheight/MAP_SCALE;
	if (lines[i].backsector)
	{	fCeilingHeight1=(float)lines[i].backsector->ceilingheight/MAP_SCALE;
		fFloorHeight1=(float)lines[i].backsector->floorheight/MAP_SCALE;
	}
	
#ifdef GL_HEXEN	// MR2007
	if (((fCeilingHeight0!=fFloorHeight0)||(fCeilingHeight1!=fFloorHeight1))&&
		(a_stWallPoly[i].iNbQuads==0))
	{	fn_vCreateWallsPolygons(i);
		return;
	}
#endif
	for (j=0;j<a_stWallPoly[i].iNbQuads;j++)
	{	//if (lines[i].frontsector==a_stWallPoly[i].p_stWallQuad[j].pSector)
	  if (!(a_stWallPoly[i].p_stWallQuad[j].cWallType&0x80))	// DOOM_GL
		{	switch((a_stWallPoly[i].p_stWallQuad[j].cWallType&0x0f))
			{	case 0:		// Mid
					if (lines[i].backsector)
					{	y1=fCeilingHeight1;
						y2=fFloorHeight1;
					}
					else
					{	y1=fCeilingHeight0;
						y2=fFloorHeight0;
					}
				break;
				case 1:		// Top
					y1=fCeilingHeight0;
					y2=fCeilingHeight1;
				break;
				case 2:		// Bot
					y2=fFloorHeight0;
					y1=fFloorHeight1;
			}
					
			fn_vUpdateWall(i,j,a_stWallPoly[i].p_stWallQuad[j].iTex,yOffset,fCeilingHeight0,fFloorHeight0,y1,y2,a_stWallPoly[i].p_stWallQuad[j].cWallType,lines[i].flags);
		}
		else	// back-faces...
		{
			yOffset=sides[lines[i].sidenum[1]].rowoffset>>FRACBITS;
	
			switch(a_stWallPoly[i].p_stWallQuad[j].cWallType&0x0f)
			{	case 0:
					/*y1=fCeilingHeight0;
					y2=fFloorHeight0;*/
					y1=fCeilingHeight1;
					y2=fFloorHeight1;
				break;
				case 1:
					y1=fCeilingHeight1;
					y2=fCeilingHeight0;
				break;
				case 2:
					y2=fFloorHeight1;
					y1=fFloorHeight0;
			}
					
			fn_vUpdateWall(i,j,a_stWallPoly[i].p_stWallQuad[j].iTex,yOffset,fCeilingHeight1,fFloorHeight1,y1,y2,a_stWallPoly[i].p_stWallQuad[j].cWallType,lines[i].flags);
		}
	}
}

void GL_vAddWallsForWaggle(sector_t *sector)
{ int i,j,iLineID,back;

	for (i=0;i<sector->linecount;i++)
	{	iLineID=sector->lines[i]->iLineID;
		if (sector->lines[i]->flags&ML_TWOSIDED)
		{	if (sector->lines[i]->frontsector==sector)
			{	if (sides[lines[iLineID].sidenum[0]].bottomtexture==R_TextureNumForName("-"))
					sides[lines[iLineID].sidenum[0]].bottomtexture=R_TextureNumForName("BOOKS01");
				else
					continue;
				back=0;
			}
			else
			if (sector->lines[i]->backsector==sector)
			{	if (sides[lines[iLineID].sidenum[1]].bottomtexture==R_TextureNumForName("-"))
					sides[lines[iLineID].sidenum[1]].bottomtexture=R_TextureNumForName("BOOKS01");
				else
					continue;
				back=1;
			}
			
			fn_vCreateWallsPolygons(iLineID);
			for (j=0;j<a_stWallPoly[iLineID].iNbQuads;j++)
				a_stWallPoly[iLineID].p_stWallQuad[j].iTex=fn_iGetGLFlatTexturef(sector->floorpic);
			//if (back)
			//	sides[lines[iLineID].sidenum[1]].bottomtexture=R_TextureNumForName("-");
			//else
			//	sides[lines[iLineID].sidenum[0]].bottomtexture=R_TextureNumForName("-");
		}
	}
}

void GL_vUpdateWallsForWaggle(sector_t *sector)
{ int i,j,iLineID/*,back*/;

	for (i=0;i<sector->linecount;i++)
	{	iLineID=sector->lines[i]->iLineID;
		if (sector->lines[i]->flags&ML_TWOSIDED)
		{	if (((sector->lines[i]->frontsector==sector)&&
				(sides[lines[iLineID].sidenum[0]].bottomtexture==R_TextureNumForName("BOOKS01")))
				||
			   ((sector->lines[i]->backsector==sector)&&
				 (sides[lines[iLineID].sidenum[1]].bottomtexture==R_TextureNumForName("BOOKS01"))))
			{
				if (a_stWallPoly[iLineID].iNbQuads==2)
					continue;
				fn_vCreateWallsPolygons(iLineID);
				for (j=0;j<a_stWallPoly[iLineID].iNbQuads;j++)
					a_stWallPoly[iLineID].p_stWallQuad[j].iTex=fn_iGetGLFlatTexturef(sector->floorpic);
			}
		}
	}
}
#endif	// WALL_ARRAY

/*void fn_vRemoveBadWalls()		// DOOM_GL
{ int i;
  line_t *ld;

    ld = lines;
    for (i=0 ; i<numlines ; i++,ld++)
    {
		if ((ld->frontsector->ceilingpic==R_FlatNumForName("F_SKY1"))&&
			(sides[ld->sidenum[0]].toptexture!=R_TextureNumForName("-"))&&
			 ld->backsector&&
			(ld->backsector->ceilingpic==R_FlatNumForName("F_SKY1")))	// DOOM_GL (cf E1M1 line 251)
			ld->iLineID=-1;
	}
}*/

// Wall impacts
unsigned char *g_p_bImpactTexture[7];
int g_iImpact;
float g_fThingX,g_fThingY,g_fThingZ;
int g_iThingDamage;

void fn_vLoadImpactRAWFile(char *szFileName,unsigned char *Texture,int width,int height,unsigned char transp)
{ int hFile;
  unsigned char *buffer;
  int x,y;

  buffer=(unsigned char *)malloc(width*height*3);
	if ((hFile=wadopen(szFileName)) == -1)
		I_Error("Could not open file %s\n",szFileName);
	
	read(hFile, buffer, width*height*3);
	close(hFile);
	for (x=0;x<width;x++)
	for (y=0;y<height;y++)
	{	if (((buffer[3*(y*width+x)]==transp)&&
			 (buffer[3*(y*width+x)+1]==transp)&&
			 (buffer[3*(y*width+x)+2]==transp))/*||
			((buffer[3*(y*width+x)]==0)&&
			 (buffer[3*(y*width+x)+1]==0)&&
			 (buffer[3*(y*width+x)+2]==0))*/)
		{
			Texture[4*(y*width+x)]=0;
			Texture[4*(y*width+x)+1]=0;
			Texture[4*(y*width+x)+2]=0;
			Texture[4*(y*width+x)+3]=0;
		}
		else
		{
			Texture[4*(y*width+x)]=buffer[3*(y*width+x)];
			Texture[4*(y*width+x)+1]=buffer[3*(y*width+x)+1];
			Texture[4*(y*width+x)+2]=buffer[3*(y*width+x)+2];
			if (!transp)
			{ 
			  int iAlpha;

				//iAlpha=(int)(buffer[3*(y*width+x)]*3);
				iAlpha=(int)(buffer[3*(y*width+x)]*2);
				if (iAlpha<100)
					iAlpha=0;
				if (iAlpha>255)
					iAlpha=255;
				Texture[4*(y*width+x)+3]=(unsigned char)iAlpha;
			}
			else
			{	//Texture[4*(y*width+x)+3]=255;
				int iAlpha;
#ifndef DOOM_GL
				iAlpha=255-(int)(buffer[3*(y*width+x)])*2;
				if (iAlpha<0)
					iAlpha=0;
#else
				iAlpha=255-(int)(buffer[3*(y*width+x)]);
#endif
				if (iAlpha>255)
					iAlpha=255;
				Texture[4*(y*width+x)+3]=(unsigned char)iAlpha;
			}
		}
	}
	free(buffer);
}

void GL_LoadImpactTextures()
{ /* int x,y; */

	//g_p_bImpactTexture[0]=(unsigned char *)Malloc(64*64*4);

	//fn_vLoadImpactRAWFile("bullet1.raw",g_p_bImpactTexture[0],64,64,255);
	g_p_bImpactTexture[0]=(unsigned char *)Malloc(32*32*4);

	fn_vLoadImpactRAWFile("bullet1.raw",g_p_bImpactTexture[0],32,32,255);

	g_p_bImpactTexture[1]=(unsigned char *)Malloc(64*64*4);
	fn_vLoadImpactRAWFile("blood1.raw",g_p_bImpactTexture[1],64,64,0);
	g_p_bImpactTexture[2]=(unsigned char *)Malloc(64*64*4);
	fn_vLoadImpactRAWFile("blood2.raw",g_p_bImpactTexture[2],64,64,0);
	g_p_bImpactTexture[3]=(unsigned char *)Malloc(32*32*4);
	fn_vLoadImpactRAWFile("blood3.raw",g_p_bImpactTexture[3],32,32,0);
	g_p_bImpactTexture[4]=(unsigned char *)Malloc(32*32*4);
	fn_vLoadImpactRAWFile("blood4.raw",g_p_bImpactTexture[4],32,32,0);
	g_p_bImpactTexture[5]=(unsigned char *)Malloc(32*32*4);
	fn_vLoadImpactRAWFile("blood5.raw",g_p_bImpactTexture[5],32,32,0);
	//g_p_bImpactTexture[6]=(unsigned char *)Malloc(64*32*4);
	//fn_vLoadImpactRAWFile("blood6.raw",g_p_bImpactTexture[6],64,32,0);
	g_p_bImpactTexture[6]=(unsigned char *)Malloc(32*32*4);
	fn_vLoadImpactRAWFile("blood6.raw",g_p_bImpactTexture[6],32,32,0);
}

void fn_vAddImpact(int line,float xA,float yA,float xB,float yB,float z,float d,char type)
{ int iNbImpacts;

	if (g_a_stWallImpacts[line].iNbImpacts>=g_iMaxImpacts)
		return;
	
	iNbImpacts=g_a_stWallImpacts[line].iNbImpacts;
	if (iNbImpacts==0)
	{
		g_a_stWallImpacts[line].x1=(float *)Malloc(sizeof(float));
		g_a_stWallImpacts[line].y1=(float *)Malloc(sizeof(float));
		g_a_stWallImpacts[line].z1=(float *)Malloc(sizeof(float));
		g_a_stWallImpacts[line].x2=(float *)Malloc(sizeof(float));
		g_a_stWallImpacts[line].y2=(float *)Malloc(sizeof(float));
		g_a_stWallImpacts[line].z2=(float *)Malloc(sizeof(float));
		g_a_stWallImpacts[line].type=(char *)Malloc(1);
	}
	else
	{
		g_a_stWallImpacts[line].x1=(float *)Realloc(g_a_stWallImpacts[line].x1,(iNbImpacts+1)*sizeof(float));
		g_a_stWallImpacts[line].y1=(float *)Realloc(g_a_stWallImpacts[line].y1,(iNbImpacts+1)*sizeof(float));
		g_a_stWallImpacts[line].z1=(float *)Realloc(g_a_stWallImpacts[line].z1,(iNbImpacts+1)*sizeof(float));
		g_a_stWallImpacts[line].x2=(float *)Realloc(g_a_stWallImpacts[line].x2,(iNbImpacts+1)*sizeof(float));
		g_a_stWallImpacts[line].y2=(float *)Realloc(g_a_stWallImpacts[line].y2,(iNbImpacts+1)*sizeof(float));
		g_a_stWallImpacts[line].z2=(float *)Realloc(g_a_stWallImpacts[line].z2,(iNbImpacts+1)*sizeof(float));
		g_a_stWallImpacts[line].type=(char *)Realloc(g_a_stWallImpacts[line].type,iNbImpacts+1);
	}
	g_a_stWallImpacts[line].x1[iNbImpacts]=xA;
	g_a_stWallImpacts[line].y1[iNbImpacts]=z+d;
	g_a_stWallImpacts[line].z1[iNbImpacts]=yA;
	g_a_stWallImpacts[line].x2[iNbImpacts]=xB;
	g_a_stWallImpacts[line].y2[iNbImpacts]=z-d;
	g_a_stWallImpacts[line].z2[iNbImpacts]=yB;
	g_a_stWallImpacts[line].type[iNbImpacts]=type;

	g_a_stWallImpacts[line].iNbImpacts++;
}

void GL_vGenerateWallImpact(line_t *line,float x,float y,float z,char type,float size)
//void GL_vGenerateWallImpact(line_t *line,double x,double y,double z,char type,float size)
{ float x1,y1,/*z1,*/x2,y2/*,z2*/;
  float a,b,A,B,C;
  float xA,yA,xB,yB;
  float d=size;
  /*double x1,y1,z1,x2,y2,z2;
  double a,b,A,B,C;
  double xA,yA,xB,yB;
  double d=size;*/
  

	x/=-MAP_SCALE;
	y/=MAP_SCALE;
	z/=MAP_SCALE;
	/*x1=-(double)line->v1->x/MAP_SCALE;
	y1=(double)line->v1->y/MAP_SCALE;
	x2=-(double)line->v2->x/MAP_SCALE;
	y2=(double)line->v2->y/MAP_SCALE;*/
	x1=-(float)line->v1->x/MAP_SCALE;
	y1=(float)line->v1->y/MAP_SCALE;
	x2=-(float)line->v2->x/MAP_SCALE;
	y2=(float)line->v2->y/MAP_SCALE;

	if (x1==x2)
	{
		xA=xB=x1;
		yA=y-d;
		yB=y+d;
	}
	else
	if (y1==y2)
	{
		yA=yB=y1;
		xA=x-d;
		xB=x+d;
	}
	else
	{ float u;

		a=(y2-y1)/(x2-x1);
		b=y1-a*x1;
		//y=a*x+b;
		u=((x-x1)*(x2-x1)+(y-y1)*(y2-y1))/((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
		x=x1+u*(x2-x1);
		y=y1+u*(y2-y1);

		A=1+a*a; B=2*a*b-2*a*y-2*x; C=b*b+x*x-2*b*y+y*y-d*d;

		xA=(-B+sqrt(fabs(B*B-4*A*C)))/(2*A);
		xB=(-B-sqrt(fabs(B*B-4*A*C)))/(2*A);
		yA=a*xA+b;
		yB=a*xB+b;
	}

	fn_vAddImpact(line->iLineID,(float)xA,(float)yA,(float)xB,(float)yB,(float)z,d,type);
}

void GL_vDrawWallImpacts(int line)
{ int i;

	(*glDepthFunc_s) (GL_EQUAL);
	(*glEnable_s) (GL_ALPHA_TEST);
	(*glAlphaFunc_s) (GL_NOTEQUAL,0.0f);
	(*glEnable_s) (GL_BLEND);
	(*glBlendFunc_s) (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
	/* ANDRE !!! */
	(*glDisable_s) (GL_CULL_FACE);

	for (i=0;i<g_a_stWallImpacts[line].iNbImpacts;i++)
	{	
	  (*glBindTexture_s) (GL_TEXTURE_2D, g_iImpact+g_a_stWallImpacts[line].type[i]);
	  
	  (*glBegin_s) (GL_QUADS);
	  (*glTexCoord2f_s) (0, 0); (*glVertex3f_s) ( g_a_stWallImpacts[line].x1[i], g_a_stWallImpacts[line].y1[i], g_a_stWallImpacts[line].z1[i]);
	  (*glTexCoord2f_s) (0, 1); (*glVertex3f_s) ( g_a_stWallImpacts[line].x2[i], g_a_stWallImpacts[line].y1[i], g_a_stWallImpacts[line].z2[i]);
	  (*glTexCoord2f_s) (1, 1); (*glVertex3f_s) ( g_a_stWallImpacts[line].x2[i], g_a_stWallImpacts[line].y2[i], g_a_stWallImpacts[line].z2[i]);
	  (*glTexCoord2f_s) (1, 0); (*glVertex3f_s) ( g_a_stWallImpacts[line].x1[i], g_a_stWallImpacts[line].y2[i], g_a_stWallImpacts[line].z1[i]);
	  (*glEnd_s) ();
	}
		
	(*glDepthFunc_s) (GL_LESS);
	(*glDisable_s) (GL_ALPHA_TEST);
	(*glDisable_s) (GL_BLEND);
	
	/* ANDRE !!! */
	(*glEnable_s) (GL_CULL_FACE);
}

extern fixed_t		attackrange;
extern fixed_t		shootz;
extern fixed_t		aimslope;


H_boolean
PTR_BloodTraverse (intercept_t* in)
{
    fixed_t		x;
    fixed_t		y;
    fixed_t		z;
    fixed_t		frac;
    
    line_t*		li;
    
    /* mobj_t*		th; */

    fixed_t		slope;
    fixed_t		dist;
    /* fixed_t		thingtopslope; */
    /* fixed_t		thingbottomslope; */

	float fX,fY,fZ,dist2,fBloodSize;
		
    if (in->isaline)
    {
	li = in->d.line;
	
	if ( !(li->flags & ML_TWOSIDED) )
	    goto hitline;
	
	// crosses a two sided line
	P_LineOpening (li);
		
	dist = FixedMul (attackrange, in->frac);

	if (li->frontsector->floorheight != li->backsector->floorheight)
	{
	    slope = FixedDiv (openbottom - shootz , dist);
	    if (slope > aimslope)
		goto hitline;
	}
		
	if (li->frontsector->ceilingheight != li->backsector->ceilingheight)
	{
	    slope = FixedDiv (opentop - shootz , dist);
	    if (slope < aimslope)
		goto hitline;
	}

	// shot continues
	return true;
	
	
	// hit line
      hitline:
	// position a bit closer
	frac = in->frac - FixedDiv (4*FRACUNIT,attackrange);
	x = trace.x + FixedMul (trace.dx, frac);
	y = trace.y + FixedMul (trace.dy, frac);
	z = shootz + FixedMul (aimslope, FixedMul(frac, attackrange));

	if (li->frontsector->ceilingpic == skyflatnum)
	{
	    // don't shoot the sky!
	    if (z > li->frontsector->ceilingheight)
		return false;
	    
	    // it's a sky hack wall
	    if	(li->backsector && li->backsector->ceilingpic == skyflatnum)
		return false;		
	}

	// Blood impact...
	fX=-(float)x/MAP_SCALE;
	fY=(float)y/MAP_SCALE;
	fZ=(float)z/MAP_SCALE;
	dist2=sqrt((fX-g_fThingX)*(fX-g_fThingX)+(fY-g_fThingY)*(fY-g_fThingY)+(fZ-g_fThingZ)*(fZ-g_fThingZ));
#ifdef DOOM_GL
	if (dist2>2.0f)
#else
	if (dist2>1.0f)
#endif
		return false;
	else
	{	dist2+=1.0f;
#ifdef DOOM_GL
		fBloodSize=0.2f*(float)g_iThingDamage/(15.0f*dist2);
#else
		fBloodSize=0.1f*(float)g_iThingDamage/(15.0f*dist2);
#endif
		//GL_vGenerateWallImpact(li,(float)x,(float)y,(float)z,(P_Random()%5)+1,fBloodSize);
		GL_vGenerateWallImpact(li,(float)x,(float)y,(float)z,(rand()%5)+1,fBloodSize);
		/*
		if ((z && li->backsector && z<li->backsector->floorheight)||
			(z && li->backsector && z>li->backsector->ceilingheight))
			
		*/
	}
	
	// don't go any farther
	return false;	
    }

	return true;
}

GLboolean g_bBloodSplash;
void GL_CheckForBloodSplash(fixed_t x,fixed_t y,fixed_t z,int damage)
{
	g_bBloodSplash=true;
	g_fThingX=-(float)x/MAP_SCALE;
	g_fThingY=(float)y/MAP_SCALE;
	g_fThingZ=(float)z/MAP_SCALE;
	g_iThingDamage=damage;
}

GLboolean GL_bBloodSplash()
{ GLboolean ret;

	ret=g_bBloodSplash;
	g_bBloodSplash=false;

	return ret;

}

#ifndef GL_HEXEN
extern byte*		save_p;
void GL_ArchiveWallImpacts()
{ int *iPut;
  float *fPut;
  int i,j;

	iPut=(int *)save_p;
	for (i=0;i<numlines;i++)
	{
		*iPut++=g_a_stWallImpacts[i].iNbImpacts;
		if (!g_a_stWallImpacts[i].iNbImpacts)
		{	save_p=(byte *)iPut;
			continue;
		}
		fPut=(float *)iPut;
		for (j=0;j<g_a_stWallImpacts[i].iNbImpacts;j++)
		{	*fPut++=g_a_stWallImpacts[i].x1[j];
			*fPut++=g_a_stWallImpacts[i].y1[j];
			*fPut++=g_a_stWallImpacts[i].z1[j];
			*fPut++=g_a_stWallImpacts[i].x2[j];
			*fPut++=g_a_stWallImpacts[i].y2[j];
			*fPut++=g_a_stWallImpacts[i].z2[j];
			save_p=(byte *)fPut;
			*save_p++=g_a_stWallImpacts[i].type[j];
			fPut=(float *)save_p;
		}
		iPut=(int *)save_p;
	}
}

void GL_UnArchiveWallImpacts()
{ int *iGet;
  float *fGet;
  int i,j;

	iGet=(int *)save_p;
	for (i=0;i<numlines;i++)
	{
		g_a_stWallImpacts[i].iNbImpacts=*iGet++;
		if (!g_a_stWallImpacts[i].iNbImpacts)
		{	save_p=(byte *)iGet;
			continue;
		}
		fGet=(float *)iGet;
		g_a_stWallImpacts[i].x1=(float *)Malloc(g_a_stWallImpacts[i].iNbImpacts*sizeof(float));
		g_a_stWallImpacts[i].y1=(float *)Malloc(g_a_stWallImpacts[i].iNbImpacts*sizeof(float));
		g_a_stWallImpacts[i].z1=(float *)Malloc(g_a_stWallImpacts[i].iNbImpacts*sizeof(float));
		g_a_stWallImpacts[i].x2=(float *)Malloc(g_a_stWallImpacts[i].iNbImpacts*sizeof(float));
		g_a_stWallImpacts[i].y2=(float *)Malloc(g_a_stWallImpacts[i].iNbImpacts*sizeof(float));
		g_a_stWallImpacts[i].z2=(float *)Malloc(g_a_stWallImpacts[i].iNbImpacts*sizeof(float));
		g_a_stWallImpacts[i].type=(char *)Malloc(g_a_stWallImpacts[i].iNbImpacts*sizeof(char));
		for (j=0;j<g_a_stWallImpacts[i].iNbImpacts;j++)
		{	g_a_stWallImpacts[i].x1[j]=*fGet++;
			g_a_stWallImpacts[i].y1[j]=*fGet++;
			g_a_stWallImpacts[i].z1[j]=*fGet++;
			g_a_stWallImpacts[i].x2[j]=*fGet++;
			g_a_stWallImpacts[i].y2[j]=*fGet++;
			g_a_stWallImpacts[i].z2[j]=*fGet++;
			save_p=(byte *)fGet;
			g_a_stWallImpacts[i].type[j]=*save_p++;
			fGet=(float *)save_p;
		}
		iGet=(int *)save_p;
	}
}
#endif
void GL_InitWallImpacts(int numlines)
{ int i;

	g_a_stWallImpacts=(GLWallImpact *)Malloc(numlines*sizeof(GLWallImpact));
	for (i=0 ; i<numlines ; i++)
	{
		g_a_stWallImpacts[i].iNbImpacts=0;
		g_a_stWallImpacts[i].x1=NULL;
		g_a_stWallImpacts[i].y1=NULL;
		g_a_stWallImpacts[i].z1=NULL;
		g_a_stWallImpacts[i].x2=NULL;
		g_a_stWallImpacts[i].y2=NULL;
		g_a_stWallImpacts[i].z2=NULL;
		g_a_stWallImpacts[i].type=NULL;
	}
}
#endif // GL_HERETIC
