#ifdef GL_HERETIC
//#define __DOOMTYPE__

#include <stdio.h>
#include <math.h>

#include "gl_syms.h"

#include <SDL/SDL.h>

#include "gl_struct.h"

#ifndef GL_HEXEN
#include "doomdef.h"
#else
#include "h2def.h"
#endif
#include "r_local.h"

#ifdef DOOM_GL
int MAP_COEFF=100;
#else
int MAP_COEFF=200;
//int MAP_COEFF=100;
#endif

extern void R_DrawPlayerSprites (void);
extern GLfloat aspect;
extern int xMapMin,xMapMax,yMapMin,yMapMax,iAltitudeMin,iAltitudeMax;
extern int *iWall;
extern int iSkyList;
extern float fSkyRadius;
extern Window OGL_win;
extern Display *OGL_dpy;
extern GLFloorCeiling *a_stFloorCeiling;
extern int startCeilingList,startFloorList;
extern int startWallList;
//extern FloorCeilVertexesArray *a_stFloorVertexesArray;
extern GLFloorCeilingPolygonArray *a_stFCPolygonArray;
extern int iNbSpriteRendered;

extern int yWeapon;

extern drawseg_t	drawsegs[MAXDRAWSEGS], *ds_p;
int *a_iGlDrawFloorCeil;
int iNbSect;
int *a_iGlDrawLine;
int iNbLine;
long g_bSmoothSprite;

#ifdef RASTER
GLboolean g_bGlobalRaster=FALSE,g_bDisplayRaster=FALSE,g_bLightRaster=FALSE;
float fps=0.0f;
long lNbFrames=0;
GLvoid fn_vDisplayRaster()
{
	int i;
	static float log2=0.69314718056f;

	#define LENGTH(w,a) (GLfloat) ((w)*(1.0-exp(-(a)*log2)))

	GLfloat t=0.0f, T, a, w, h, l;
	GLfloat x0=0.0f;
	GLfloat y0=0.0f;

	if (t)
	{	fps+=1/t;
		lNbFrames++;
	}
	T=1.0f/60.0f;
	a=t/T;
	w=(GLfloat)screenwidth;
	h=10.0f;
	l=LENGTH(w,a); //w*(1.0-exp(-a*log(2.0)));

	// projection
	(*glMatrixMode_s) (GL_PROJECTION);
	(*glLoadIdentity_s) ();
	(*glOrtho_s) ( (GLdouble) 0, (GLdouble) screenwidth, (GLdouble) 0, (GLdouble) screenheight, (GLdouble) -1.0, (GLdouble) 1.0 );
	(*glMatrixMode_s) (GL_MODELVIEW);
	(*glPushMatrix_s) ();
	(*glLoadIdentity_s) ();
	(*glTranslatef_s) (x0, y0, 1.0f);

	/*
	(*glColor4f_s) (1.0f, 1.0f, 1.0f, 0.7f);
	(*glBegin_s) (GL_QUADS);
	(*glNormal3f_s) (0.0f,0.0f,1.0f);
	(*glVertex2f_s) ( 0.0f, h);
	(*glVertex2f_s) ( w, h);
	(*glVertex2f_s) ( w, 0.0f);
	(*glVertex2f_s) ( 0.0f, 0.0f);
	(*glEnd_s) ();
	*/

	(*glColor4f_s) (1.0f, 0.2f, 0.5f, 0.6f);
	(*glBegin_s) (GL_QUADS);
	(*glNormal3f_s) (0.0f,0.0f,1.0f);
	(*glVertex2f_s) ( 0.0f, h);
	(*glVertex2f_s) ( l, h);
	(*glVertex2f_s) ( l, 0.0f);
	(*glVertex2f_s) ( 0.0f, 0.0f);
	(*glEnd_s) ();

	(*glColor4f_s) (1.0f, 1.0f, 1.0f, 0.7f);
	for (i=0;i<8;i++)
	{
		l=LENGTH(w,(GLfloat) i);
		
		(*glBegin_s) (GL_QUADS);
		(*glNormal3f_s) (0.0f,0.0f,1.0f);
		(*glVertex2f_s) ( l-1.0f,0.0f);
		(*glVertex2f_s) ( l+1.0f,0.0f);
		(*glVertex2f_s) ( l+1.0f,h+5);
		(*glVertex2f_s) ( l-1.0f,h+5);
		(*glEnd_s) ();
	}

	(*glPopMatrix_s) ();
}
#endif

GLvoid GLSet2DMode()
{
	(*glMatrixMode_s) (GL_PROJECTION);
	(*glLoadIdentity_s) ();
	(*glOrtho_s) ( (GLdouble) 0, (GLdouble) screenwidth, (GLdouble) 0, (GLdouble) screenheight, (GLdouble) -1.0, (GLdouble) 1.0 );

	(*glDisable_s) (GL_DEPTH_TEST);

	(*glEnable_s) (GL_ALPHA_TEST);
	//MR1807
	//(*glAlphaFunc_s) (GL_EQUAL,1.0f);
	(*glAlphaFunc_s) (GL_NOTEQUAL,0.0f);
	// MR2106
	(*glEnable_s) (GL_TEXTURE_2D);
}

void GL_CheckCoronasPresent(float x,float y,float z,float roll,float pitch,float yaw,player_t *player);

#ifdef GL_HEXEN
extern H_boolean DoubleSky;
extern int iSkyList1,iSkyList2;
extern char GLCurrentSky;
extern fixed_t		viewx, viewy, viewz;
#endif

GLvoid GLdrawScene(player_t *player)
{
  GLdouble xmin, xmax, ymin, ymax;
  
  static float roll  = 0.0f;
  static float yaw   = 0.0f;
  static float pitch = 0.0f;
  /* static float trZ = -5.0f; */
  static float trY /*= -0.32f*/;
  static float xCamera,yCamera;
  int i;
  //float fSkyRadius;
  drawseg_t *ds;
  /* GLfloat lightPos[4]; */
  /* GLfloat lightColor[4]={ 1.0f,0.5f,0.0f,1.0f}; */
  /* GLfloat lightColorD[4]={ 1.0f,1.0f,0.0f,1.0f}; */
  
  /* GLfloat width=(float)screenwidth,height=(float)screenheight; */
  //GLfloat aspect = (GLfloat)width/(GLfloat)height;
  

	// Player coordinates
#ifndef GL_HEXEN
	xCamera=(float)player->mo->x/MAP_SCALE;
	yCamera=-(float)player->mo->y/MAP_SCALE;
#else
	xCamera=(float)viewx/MAP_SCALE;
	yCamera=-(float)viewy/MAP_SCALE;
#endif
	trY=(float)player->viewz/MAP_SCALE;
	
	yaw=270.0f-(float)(player->mo->angle>>ANGLETOFINESHIFT)*360.0f/FINEANGLES;
// DOOM_GL
//#ifndef DOOM_GL
	//pitch=-(float)player->lookdir/4;	// /2
	pitch=-(float)player->lookdir/2;	// /2
//#endif
	
	// MR0906 (commentaires)
//#ifdef GL_HEXEN	// Why ???
	(*glClear_s) (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
//#endif
	(*glEnable_s) (GL_DEPTH_TEST);
	(*glDisable_s) (GL_ALPHA_TEST);

	// Test with select or feedback buffers...
	//GL_CheckCoronasPresent(xCamera, -trY, yCamera,roll,pitch,yaw,player);
	// MR3006: DynLight
//	GL_MoveLight(0,-xCamera,trY,-yCamera);

	// test light
	/*(*glMatrixMode_s) (GL_MODELVIEW);
	  (*glLoadIdentity_s) ();
	//(*glPushMatrix_s) ();
	//lightPos[0]=xCamera;
	//lightPos[1]=-trY;
	//lightPos[2]=yCamera;
	//lightPos[3]=1.0f;
	lightPos[0]=0.0f;
	lightPos[1]=0.0f;
	lightPos[2]=0.0f;
	lightPos[3]=1.0f;
	(*glLightfv_s) (GL_LIGHT0, GL_POSITION, lightPos);
	(*glLightfv_s) (GL_LIGHT0, GL_AMBIENT, lightColor);
	(*glLightfv_s) (GL_LIGHT0, GL_DIFFUSE, lightColor);
	(*glLightf_s) (GL_LIGHT0, GL_LINEAR_ATTENUATION, 0.1f);	//0.5f
	(*glEnable_s) (GL_LIGHTING);
	(*glEnable_s) (GL_LIGHT0);
	//(*glPopMatrix_s) ();
	//(*glMatrixMode_s) (GL_PROJECTION);*/
	// End test light

	(*glMatrixMode_s) (GL_PROJECTION);
	(*glLoadIdentity_s) ();

	/* ---------------------------------------------------------- */
	/* gluPerspective(65.0, aspect, 0.01, 2*fSkyRadius); */
	
	ymax = 0.01 * tan( 65.0 * M_PI / 360.0 );
	ymin = -ymax;

	xmin = ymin * aspect;
	xmax = ymax * aspect;

	(*glFrustum_s) (xmin, xmax, ymin, ymax, 0.01, 2*fSkyRadius);
	/* ---------------------------------------------------------- */
	
	(*glRotatef_s) (roll,  0.0f, 0.0f, 1.0f);
	(*glRotatef_s) (pitch, 1.0f, 0.0f, 0.0f);
	(*glRotatef_s) (yaw,   0.0f, 1.0f, 0.0f);
	(*glTranslatef_s) (xCamera, -trY, yCamera);

	(*glEnable_s) (GL_TEXTURE_2D);

	// WALLS
/*	for (i=0;i<numlines;i++)
	{	(*glCallList_s) (iWall[i]);
	}

	// FLOORS & CEILINGS
	for (i=0;i<numsectors;i++)
	{
		(*glCallList_s) (a_stFloorCeiling[i].iFloorCallList);
		(*glCallList_s) (a_stFloorCeiling[i].iCeilingCallList);
	}*/
	
	/* ANDRE !!! */
	// WALLS
	(*glEnable_s) (GL_CULL_FACE);		// DOOM_GL
	//(*glCullFace_s) (GL_FRONT);
	//(*glFrontFace_s) (GL_CW);
	
	// MR0906
	(*glDepthFunc_s) (GL_ALWAYS);
	// SKY
	GL_StaticLight3f(1.0f,1.0f,1.0f);
#ifndef GL_HEXEN
	//(*glCallList_s) (iSkyList);
	fn_vDrawSky(1);
#else
	if (DoubleSky)
	{	//(*glCallList_s) (iSkyList2);
		fn_vDrawSky(2);
		(*glDepthFunc_s) (GL_LEQUAL);
		(*glEnable_s) (GL_ALPHA_TEST);
		(*glAlphaFunc_s) (GL_EQUAL,1);	// MR0109
		//(*glCallList_s) (iSkyList1);
		fn_vDrawSky(1);
		(*glDisable_s) (GL_ALPHA_TEST);
	}
	else
	{	//(*glCallList_s) (iSkyList1);	// a voir (affichage sky2 seul)
		if (player->mo->subsector->sector->special==200)
			fn_vDrawSky(2);
		else
			fn_vDrawSky(GLCurrentSky);
	}
#endif
	(*glDepthFunc_s) (GL_LESS);
	// End MR0906

	GL_UpdateLights();

	for (ds=ds_p-1 ; ds >= drawsegs ; ds--)
	{
#ifndef WALL_ARRAY
		(*glCallList_s) (iWall[ds->curline->linedef->iLineID]);
#else
		//fn_vDisplayWall(ds->curline->linedef->iLineID);
		fn_vGlAddLine(ds->curline->linedef->iLineID);
#endif
	}
	i=0;
	while (a_iGlDrawLine[i]!=-1)
	{
#ifndef WALL_ARRAY
		(*glCallList_s) (iWall[a_iGlDrawLine[i++]]);
#else
		fn_vDisplayWall(a_iGlDrawLine[i++]);
#endif
	}
    

	/* ANDRE !!! */
	//(*glDisable_s) (GL_CULL_FACE);
	//(*glFrontFace_s) (GL_CW);
	(*glEnable_s) (GL_CULL_FACE);
	
	// FLOORS & CEILINGS
	i=0;
	
	while (a_iGlDrawFloorCeil[i]!=-1)
	{
	  /* ANDRE !!! */
	  /* printf("\nGLDRAW a_iGlDrawFloorCeil[%d]: %d\n", i, a_iGlDrawFloorCeil[i]); */

	  //(*glCallList_s) (a_stFloorCeiling[a_iGlDrawFloorCeil[i]].iFloorCallList);
	  fn_vRenderSector(a_iGlDrawFloorCeil[i++]);
	  //(*glCallList_s) (a_stFloorCeiling[a_iGlDrawFloorCeil[i++]].iCeilingCallList);
	}
	
	//(*glFrontFace_s) (GL_CCW);
	
	
	// Sprites
	if (g_bSmoothSprite)
		(*glEnable_s) (GL_POLYGON_SMOOTH);	// MR2806
	fn_vDrawSprites(player);
	if (g_bSmoothSprite)
		(*glDisable_s) (GL_POLYGON_SMOOTH);

	(*glDisable_s) (GL_CULL_FACE);

	// MR0906 (commentaires)
	// SKY
/*	GL_StaticLight3f(1.0f,1.0f,1.0f);
	(*glCallList_s) (iSkyList);*/
/*	if (DoubleSky)
	{	//(*glCallList_s) (iSkyList2);
		fn_vDrawSky(2);
		(*glDepthFunc_s) (GL_LEQUAL);
		(*glEnable_s) (GL_ALPHA_TEST);
		//(*glCallList_s) (iSkyList1);
		fn_vDrawSky(1);
		(*glDisable_s) (GL_ALPHA_TEST);
	}
	else
	{	//(*glCallList_s) (iSkyList1);	// a voir (affichage sky2 seul)
		if (player->mo->subsector->sector->special==200)
			fn_vDrawSky(2);
		else
			fn_vDrawSky(GLCurrentSky);
	}*/

	GL_DrawCoronas(player);

	//(*glDisable_s) (GL_LIGHTING);
	GLSet2DMode();

#ifndef WEAP_DRAWPIX
	if (viewangleoffset <= 1024<<ANGLETOFINESHIFT || viewangleoffset >=
			-1024<<ANGLETOFINESHIFT)
  	{	// don't draw on side views
		(*glEnable_s) (GL_DEPTH_TEST);
		R_DrawPlayerSprites ();
		(*glDisable_s) (GL_DEPTH_TEST);
	}
#endif
	(*glColor3f_s) (1.0f,1.0f,1.0f);

#ifdef WEAP_DRAWPIX
	(*glDisable_s) (GL_TEXTURE_2D);
	GLdrawWeapons();
#endif
}

void GL_Finish()
{
	(*glEnable_s) (GL_DEPTH_TEST);
	(*glDisable_s) (GL_ALPHA_TEST);

	(*glDisable_s) (GL_TEXTURE_2D);
#ifdef RASTER
	if ((g_bDisplayRaster)||(g_bGlobalRaster)||(g_bLightRaster))	// MR1907
	{	(*glFinish_s) ();
		fn_vDisplayRaster();
	}
#endif

    (*glFinish_s) ();
	
    SDL_GL_SwapBuffers();
}

void fn_vInitglDrawScene()
{ int i;

	iNbSect=0;
	for (i=0;i<numsectors;i++)
		a_iGlDrawFloorCeil[i]=-1;

	iNbLine=0;
	for (i=0;i<numlines;i++)
		a_iGlDrawLine[i]=-1;
	
	iNbSpriteRendered=0;

	yWeapon=0x7fffffff;

}

void fn_vAddSector(int ucSectorID)
{ int i,j;

	i=0;
	while (a_iGlDrawFloorCeil[i]!=-1)
	{	if (a_iGlDrawFloorCeil[i]==ucSectorID)
			return;
		if (a_iGlDrawFloorCeil[i]>ucSectorID)
		{	for (j=iNbSect+1;j>i;j--)
			{	a_iGlDrawFloorCeil[j]=a_iGlDrawFloorCeil[j-1];
			}
			a_iGlDrawFloorCeil[j]=a_iGlDrawFloorCeil[j-1];
			a_iGlDrawFloorCeil[i]=ucSectorID;
			iNbSect++;
			break;
		}
		i++;
	}
	if (a_iGlDrawFloorCeil[i]==-1)
	{	a_iGlDrawFloorCeil[i]=ucSectorID;
		iNbSect=i;
	}
}

void fn_vGlAddLine(int iLineID)
{ int i,j;

	i=0;
	while (a_iGlDrawLine[i]!=-1)
	{	if (a_iGlDrawLine[i]==iLineID)
			return;
		if (a_iGlDrawLine[i]>iLineID)
		{	for (j=iNbLine+1;j>i;j--)
			{	a_iGlDrawLine[j]=a_iGlDrawLine[j-1];
			}
			a_iGlDrawLine[j]=a_iGlDrawLine[j-1];
			a_iGlDrawLine[i]=iLineID;
			iNbLine++;
			break;
		}
		i++;
	}
	if (a_iGlDrawLine[i]==-1)
	{	a_iGlDrawLine[i]=iLineID;
		iNbLine=i;
	}
}

void R_glAddFloorCeiling()
{
  return;	// DOOM_GL (cf R_subsector dans r_bsp.c)
  fn_vAddSector(curline->frontsector->iSectorID);
  if (curline->backsector)
    fn_vAddSector(curline->backsector->iSectorID);
}

void fn_vUpdateCeilFloorHeights(int sector,fixed_t floorheight,fixed_t ceilingheight)
{ int i,j;

	for (i=0;i<a_stFCPolygonArray[sector].iNbArrays;i++)
		for (j=0;j<a_stFCPolygonArray[sector].p_stVertexArray[i].iNbVertices;j++)
		{	a_stFCPolygonArray[sector].p_stVertexArray[i].p_fVertex[j*3+1]=(float)floorheight/MAP_SCALE;
			a_stFCPolygonArray[sector].p_stVertexArray[i].p_fCeiling[j]=(float)ceilingheight/MAP_SCALE;
		}
}

#ifdef WALL_ARRAY
extern GLWallPolygonArray *a_stWallPoly;
void fn_vUpdateWallsHeights(int iLineID,fixed_t Prevfloorheight,fixed_t Prevceilingheight,fixed_t floorheight,fixed_t ceilingheight)
{ float fFloor,fCeiling,fPrevFloor,fPrevCeiling;
  int i;

	fFloor=(float)floorheight/MAP_SCALE;
	fCeiling=(float)ceilingheight/MAP_SCALE;
	fPrevFloor=(float)Prevfloorheight/MAP_SCALE;
	fPrevCeiling=(float)Prevceilingheight/MAP_SCALE;

	for (i=0;i<a_stWallPoly[iLineID].iNbQuads;i++)
	{	/*if (a_stWallPoly[iLineID].p_stWallQuad[i].a_fVertex[1]==fPrevFloor)
		{	a_stWallPoly[iLineID].p_stWallQuad[i].a_fVertex[1]=fFloor;
			a_stWallPoly[iLineID].p_stWallQuad[i].a_fUV[1]*=fFloor/fPrevFloor;
			//continue;
		}
		if (a_stWallPoly[iLineID].p_stWallQuad[i].a_fVertex[4]==fPrevCeiling)
		{	a_stWallPoly[iLineID].p_stWallQuad[i].a_fVertex[4]=fCeiling;
			a_stWallPoly[iLineID].p_stWallQuad[i].a_fUV[3]*=fCeiling/fPrevCeiling;
			//continue;
		}*/

		/*if (lines[iLineID]->frontsector==sector)
		{	fCeilingHeight=lines[iLineID]
		
		fV1=a_stWallPoly[iLineID].p_stWallQuad[i].a_fVertex[1];
		fV2=a_stWallPoly[iLineID].p_stWallQuad[i].a_fVertex[3];
		y1=
		if ((a_stWallPoly[iLineID].cWallType==2)&&(lines[iLineID].flags & ML_DONTPEGBOTTOM))
		{
			fV1=fV1Off;
			fV1Off=fV1+(float)(fabs(fCeilingHeight-y1)*(MAP_SCALE>>FRACBITS))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
			fV2=fV1+(float)(fabs(fCeilingHeight-fFloorHeight)*(MAP_SCALE>>FRACBITS))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
		}
		else
		if (((a_stWallPoly[iLineID].cWallType==0)&&(lines[iLineID].flags & ML_DONTPEGBOTTOM)&&(!(lines[iLineID].flags & ML_DONTPEGTOP)))||
			((a_stWallPoly[iLineID].cWallType==1)&&(!(lines[iLineID].flags & ML_DONTPEGTOP))))
		{	fV2=fV1Off;
			fV1Off=fV2-((float)(fabs(y2-y1)*(MAP_SCALE>>FRACBITS)))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;
		}
		else
			fV2=fV1Off+((float)(fabs(y2-y1)*(MAP_SCALE>>FRACBITS)))/p_stGLTextures[iGLTex].a_stSubTex[iSubTex].iHeight;*/
	}
}
#endif
int g_iMovingSector;

void fn_vGLUpdateSector(sector_t *sector)
{ int i;

	/*(*glDeleteLists_s) (startFloorList+sector->iSectorID,1);
	(*glDeleteLists_s) (startCeilingList+sector->iSectorID,1);
	fn_vCreateFloorPolygonsForSector(sector->iSectorID);*/
	//fn_vCreateCeilingPolygonsForSector(sector->iSectorID);

	g_iMovingSector=sector->iSectorID;
	fn_vUpdateCeilFloorHeights(sector->iSectorID,sector->floorheight,sector->ceilingheight);

#ifndef WALL_ARRAY
	for (i=0;i<sector->linecount;i++)
	{	iLine=sector->lines[i]->iLineID;
		(*glDeleteLists_s) (startWallList+iLine,1);
		fn_vCreateWallsPolygons(iLine);
	}
#else
	for (i=0;i<sector->linecount;i++)
		//fn_vUpdateWallsHeights(sector->lines[i]->iLineID,sector->Prevfloorheight,sector->Prevceilingheight,sector->floorheight,sector->ceilingheight);
		fn_vUpdateWallsPolygons(sector->lines[i]->iLineID);
#endif
}

extern GLTexture *p_stGLTextures;
extern int			iNbTexturesInMap,iNbGLTextures;

void GL_ScreenShot()
{
	(*glReadPixels_s) (0,0,screenwidth,screenheight,GL_RGBA,GL_UNSIGNED_BYTE,screen);
	fn_vSaveRAW("GLshot.raw",screen,screenwidth,screenheight);

//	fn_vSaveRAW("sky.raw",p_stGLTextures[iNbGLTextures-1].p_bRGBBuffer,p_stGLTextures[iNbGLTextures-1].iWidth,p_stGLTextures[iNbGLTextures-1].iHeight);
}

void GL_AddExtraLines(player_t *player)
{ sector_t *sector;
  int i;
	
	//return;	// MR2705
	sector=player->mo->subsector->sector;
	for (i=0;i<sector->linecount;i++)
		fn_vGlAddLine(sector->lines[i]->iLineID);
}

#if 0
void Oldfn_vUpdateCeilFloorHeights(int sector,fixed_t floorheight,fixed_t ceilingheight)
{ int i;

	for (i=0;i<a_stFloorVertexesArray[sector].iNbPoints;i++)
	{	*(a_stFloorVertexesArray[sector].p_fCeiling[i])=(float)ceilingheight/MAP_SCALE;
		*(a_stFloorVertexesArray[sector].p_fFloor[i])=(float)floorheight/MAP_SCALE;
	}
}
#endif	// 0

#endif GL_HERETIC
