
#include <stdio.h>
#include <math.h>
#include <signal.h>
#include <string.h>

#include <SDL/SDL.h>

#include "gl_struct.h"

#include "doomdef.h"


/* ---------------------------------------------- */
/* --------- OpenGL function signatures --------- */
/* ---------------------------------------------- */

void (*glBindTexture_s)    (GLenum target, GLuint texture);
void (*glMatrixMode_s)     (GLenum mode);
void (*glPushMatrix_s)     (void);
void (*glLoadIdentity_s)   (void);
void (*glRotatef_s)        (GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
void (*glTranslatef_s)     (GLfloat x, GLfloat y, GLfloat z);
void (*glBegin_s)          (GLenum mode);
void (*glNormal3f_s)       (GLfloat nx, GLfloat ny, GLfloat nz);
void (*glTexCoord2f_s)     (GLfloat s, GLfloat t);
void (*glVertex3f_s)       (GLfloat x, GLfloat y, GLfloat z);
void (*glEnd_s)            (void);
void (*glPopMatrix_s)      (void);
void (*glCullFace_s)       (GLenum mode);
void (*glVertex2f_s)       (GLfloat x, GLfloat y);
void (*glColor3f_s)        (GLfloat red, GLfloat green, GLfloat blue);
void (*glDisable_s)        (GLenum cap);
void (*glEnable_s)         (GLenum cap);
void (*glClear_s)          (GLbitfield mask);
void (*glRasterPos2i_s)    (GLint x, GLint y);
void (*glColorTableEXT_s)  (GLenum target, GLenum internalformat, GLsizei width,
			                      GLenum format, GLenum type, const GLvoid *table);
void (*glDrawPixels_s)     (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void (*glTexParameterf_s)  (GLenum target, GLenum pname, GLfloat param);
void (*glTexEnvf_s)        (GLenum target, GLenum pname, GLfloat param);
void (*glTexImage2D_s)     (GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height,
			                      GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void (*glOrtho_s)          (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top,
			                      GLdouble near_val, GLdouble far_val);
void (*glColor4f_s)        (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
void (*glAlphaFunc_s)      (GLenum func, GLclampf ref);
void (*glDepthFunc_s)      (GLenum func);
void (*glFinish_s)         (void);
void (*glReadPixels_s)     (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format,
			                      GLenum type, GLvoid *pixels);
const GLubyte*
     (*glGetString_s)      (GLenum name);
void (*glViewport_s)       (GLint x, GLint y, GLsizei width, GLsizei height);
void (*glClearColor_s)     (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
void (*glClearDepth_s)     (GLclampf depth);
void (*glShadeModel_s)     (GLenum mode);
void (*glPixelStorei_s)    (GLenum pname, GLint param);
void (*glHint_s)           (GLenum target, GLenum mode);
void (*glBlendFunc_s)      (GLenum sfactor, GLenum dfactor);
void (*glDeleteTextures_s) (GLsizei n, const GLuint *textures);
void (*glMultMatrixd_s)    (const GLdouble *m);
void (*glTranslated_s)     (GLdouble x, GLdouble y, GLdouble z);
void (*glScalef_s)         (GLfloat x, GLfloat y, GLfloat z);
void (*glFrustum_s)        (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top,
			    GLdouble near_val, GLdouble far_val);


extern int             *a_iLineArray,*a_iLinePresent;

#ifdef RASTER
extern float           fps;
extern long            lNbFrames;
extern GLboolean       g_bGlobalRaster;
#endif

extern byte            *p_bPalette;

char                   szAppName[]="GLHeretic";

char                   *gl_Driver="libGL.so";

int                    gldrv;

extern char            *homedir;
char                   *mlump_filename;
char                   *wlump_filename;

GLfloat                aspect;

extern long            do_fullscreen;

extern long            mouseLook;

void                   fn_vChangeScreenResolution();

GLboolean              g_b3Dfx=FALSE;
extern GLboolean       g_bPaletteTexture, g_bSpriteOpti, g_bSpriteBilinear;
extern GLboolean       g_bGlobalRaster, g_bDisplayRaster;
extern float           fScaleSprite;
extern int             iMaxSizeBeforeReduction;
extern float           fSpriteFilterDistanceCoeff;

extern int             windowActive;
extern H_boolean       g_bMlook;

extern void            GL_fn_vInitLights();


/*
 * This function initializes all gl/glx functions.
 */

/* helper function */
void sym_error(void) {
  exit(1);
}

void fsym_error(char* func) {
  printf("[SDLGLDrv/init] an OpenGL-library without the \"%s\" function? :", func);
  sym_error();
}

void load_init_gl_lib(char* driverlib_path) {
  printf("[SDLGLDrv/init] Loading OpenGL-library: %s ...\n", driverlib_path);
  
  gldrv = SDL_GL_LoadLibrary(driverlib_path);
  
  printf("[SDLGLDrv/init] loaded OpenGL-library: %d \n", gldrv);
  
  if (gldrv != 0) {
    printf("[SDLGLDrv/init] OpenGL-library \"%s\" couldn't be loaded !\n", driverlib_path);
    sym_error();
    printf("\n");
  }
  
  glBindTexture_s=SDL_GL_GetProcAddress( "glBindTexture" );
  if (!glBindTexture_s)
  	fsym_error( "glBindTexture" );

  glMatrixMode_s=SDL_GL_GetProcAddress( "glMatrixMode" );
  if (!glMatrixMode_s)
  	fsym_error( "glMatrixMode" );

  glPushMatrix_s=SDL_GL_GetProcAddress( "glPushMatrix" );
  if (!glPushMatrix_s)
  	fsym_error( "glPushMatrix" );

  glLoadIdentity_s=SDL_GL_GetProcAddress( "glLoadIdentity" );
  if (!glLoadIdentity_s)
  	fsym_error( "glLoadIdentity" );

  glRotatef_s=SDL_GL_GetProcAddress( "glRotatef" );
  if (!glRotatef_s)
  	fsym_error( "glRotatef" );

  glTranslatef_s=SDL_GL_GetProcAddress( "glTranslatef" );
  if (!glTranslatef_s)
  	fsym_error( "glTranslatef" );

  glBegin_s=SDL_GL_GetProcAddress( "glBegin" );
  if (!glBegin_s)
  	fsym_error( "glBegin" );

  glNormal3f_s=SDL_GL_GetProcAddress( "glNormal3f" );
  if (!glNormal3f_s)
  	fsym_error( "glNormal3f" );

  glTexCoord2f_s=SDL_GL_GetProcAddress( "glTexCoord2f" );
  if (!glTexCoord2f_s)
  	fsym_error( "glTexCoord2f" );

  glVertex3f_s=SDL_GL_GetProcAddress( "glVertex3f" );
  if (!glVertex3f_s)
  	fsym_error( "glVertex3f" );

  glEnd_s=SDL_GL_GetProcAddress( "glEnd" );
  if (!glEnd_s)
  	fsym_error( "glEnd" );

  glPopMatrix_s=SDL_GL_GetProcAddress( "glPopMatrix" );
  if (!glPopMatrix_s)
  	fsym_error( "glPopMatrix" );

  glCullFace_s=SDL_GL_GetProcAddress( "glCullFace" );
  if (!glCullFace_s)
  	fsym_error( "glCullFace" );

  glVertex2f_s=SDL_GL_GetProcAddress( "glVertex2f" );
  if (!glVertex2f_s)
  	fsym_error( "glVertex2f" );

  glColor3f_s=SDL_GL_GetProcAddress( "glColor3f" );
  if (!glColor3f_s)
  	fsym_error( "glColor3f" );

  glDisable_s=SDL_GL_GetProcAddress( "glDisable" );
  if (!glDisable_s)
  	fsym_error( "glDisable" );

  glEnable_s=SDL_GL_GetProcAddress( "glEnable" );
  if (!glEnable_s)
  	fsym_error( "glEnable" );

  glClear_s=SDL_GL_GetProcAddress( "glClear" );
  if (!glClear_s)
  	fsym_error( "glClear" );

  glRasterPos2i_s=SDL_GL_GetProcAddress( "glRasterPos2i" );
  if (!glRasterPos2i_s)
  	fsym_error( "glRasterPos2i" );

  glColorTableEXT_s=SDL_GL_GetProcAddress( "glColorTableEXT" );
  if (!glColorTableEXT_s)
     /*fsym_error( "glColorTableEXT" )*/; /* kludge solaris ogl */

  glDrawPixels_s=SDL_GL_GetProcAddress( "glDrawPixels" );
  if (!glDrawPixels_s)
  	fsym_error( "glDrawPixels" );

  glTexParameterf_s=SDL_GL_GetProcAddress( "glTexParameterf" );
  if (!glTexParameterf_s)
  	fsym_error( "glTexParameterf" );

  glTexEnvf_s=SDL_GL_GetProcAddress( "glTexEnvf" );
  if (!glTexEnvf_s)
  	fsym_error( "glTexEnvf" );

  glTexImage2D_s=SDL_GL_GetProcAddress( "glTexImage2D" );
  if (!glTexImage2D_s)
  	fsym_error( "glTexImage2D" );

  glOrtho_s=SDL_GL_GetProcAddress( "glOrtho" );
  if (!glOrtho_s)
  	fsym_error( "glOrtho" );

  glColor4f_s=SDL_GL_GetProcAddress( "glColor4f" );
  if (!glColor4f_s)
  	fsym_error( "glColor4f" );

  glAlphaFunc_s=SDL_GL_GetProcAddress( "glAlphaFunc" );
  if (!glAlphaFunc_s)
  	fsym_error( "glAlphaFunc" );

  glDepthFunc_s=SDL_GL_GetProcAddress( "glDepthFunc" );
  if (!glDepthFunc_s)
  	fsym_error( "glDepthFunc" );

  glFinish_s=SDL_GL_GetProcAddress( "glFinish" );
  if (!glFinish_s)
  	fsym_error( "glFinish" );

  glReadPixels_s=SDL_GL_GetProcAddress( "glReadPixels" );
  if (!glReadPixels_s)
  	fsym_error( "glReadPixels" );

  glGetString_s=SDL_GL_GetProcAddress( "glGetString" );
  if (!glGetString_s)
  	fsym_error( "glGetString" );

  glViewport_s=SDL_GL_GetProcAddress( "glViewport" );
  if (!glViewport_s)
  	fsym_error( "glViewport" );

  glClearColor_s=SDL_GL_GetProcAddress( "glClearColor" );
  if (!glClearColor_s)
  	fsym_error( "glClearColor" );

  glClearDepth_s=SDL_GL_GetProcAddress( "glClearDepth" );
  if (!glClearDepth_s)
  	fsym_error( "glClearDepth" );

  glShadeModel_s=SDL_GL_GetProcAddress( "glShadeModel" );
  if (!glShadeModel_s)
  	fsym_error( "glShadeModel" );

  glPixelStorei_s=SDL_GL_GetProcAddress( "glPixelStorei" );
  if (!glPixelStorei_s)
  	fsym_error( "glPixelStorei" );

  glHint_s=SDL_GL_GetProcAddress( "glHint" );
  if (!glHint_s)
  	fsym_error( "glHint" );

  glBlendFunc_s=SDL_GL_GetProcAddress( "glBlendFunc" );
  if (!glBlendFunc_s)
  	fsym_error( "glBlendFunc" );

  glDeleteTextures_s=SDL_GL_GetProcAddress( "glDeleteTextures" );
  if (!glDeleteTextures_s)
  	fsym_error( "glDeleteTextures" );

  glMultMatrixd_s=SDL_GL_GetProcAddress( "glMultMatrixd" );
  if (!glMultMatrixd_s)
  	fsym_error( "glMultMatrixd" );

  glTranslated_s=SDL_GL_GetProcAddress( "glTranslated" );
  if (!glTranslated_s)
  	fsym_error( "glTranslated" );

  glScalef_s=SDL_GL_GetProcAddress( "glScalef" );
  if (!glScalef_s)
  	fsym_error( "glScalef" );

  glClearDepth_s=SDL_GL_GetProcAddress( "glClearDepth" );
  if (!glClearDepth_s)
  	fsym_error( "glClearDepth" );

  glFrustum_s=SDL_GL_GetProcAddress( "glFrustum" );
	if (!glFrustum_s)
		fsym_error( "glFrustum" );
}


/*
 * ----------------------------------------------------------------
 * Memory (this Code should work for all systems now)
 * ----------------------------------------------------------------
 */

int g_hHeap=-1, g_hHeapFix=-1;
char g_cMemMode=FIX;

void fn_vSetMemoryMode(char type) {
  g_cMemMode=type;
  /* fprintf(stderr, "fn_vSetMemoryMode: g_cMemMode: %d\n", g_cMemMode); */
}

void fn_vInitMemory(unsigned int dwSize) {
  /* fprintf(stderr, "fn_vInitMemory -begin- g_cMemMode: %d.\n", g_cMemMode); */
  if (g_cMemMode==FIX)
    g_hHeapFix=HeapCreate(FIX);
  else
    g_hHeap=HeapCreate(LEVEL);

  /* fprintf(stderr, "fn_vInitMemory -end- g_cMemMode: %d.\n", g_cMemMode); */
}

void fn_vDesinitMemory() {
  int hHeap=(g_cMemMode==FIX ? g_hHeapFix : g_hHeap);
  
  /*fprintf(stderr, "fn_vDesinitMemory: hHeap: %d  ; g_cMemMode: %d  ; g_hHeapFix: %d  ; g_hHeap: %d\n",
	  hHeap, g_cMemMode, g_hHeapFix, g_hHeap); */

  if (hHeap==-1)
    return;
  HeapDestroy(hHeap);
  if (g_cMemMode==FIX)
    g_hHeapFix=-1;
  else
    g_hHeap=-1;

  /* fprintf(stderr, "fn_vDesinitMemory called.\n"); */
}

void *GLMalloc(unsigned int dwNbBytes)	/* Heap */
{
  void *memory = NULL;
  int hHeap=(g_cMemMode==FIX ? g_hHeapFix : g_hHeap);
  
  memory=HeapAlloc(hHeap, 0, dwNbBytes);
  
  /* fprintf(stderr, "GLMalloc called.\n"); */
  return memory;
}

void *GLRealloc(void *lpMem, unsigned int dwBytes) {
  void *memory = NULL;
  int hHeap=(g_cMemMode==FIX ? g_hHeapFix : g_hHeap);
  
  if (!lpMem) {
    fprintf(stderr, "[SDLGLdrv/init] Attempt to realloc NULL pointer");
    return FALSE;
  }
  else {
    memory=HeapReAlloc(hHeap, 0, lpMem, dwBytes);
    
    /* fprintf(stderr, "GLRealloc called.\n"); */
    return memory;
  }
}

void GLFree(void *lpMem) {
  int hHeap=(g_cMemMode==FIX ? g_hHeapFix : g_hHeap);
  return HeapFree(hHeap, 0, &lpMem);
  
  /* fprintf(stderr, "GLFree called.\n"); */
}


void I_GL_InitGraphics(void) {
  int value, flags;

  if( SDL_Init( SDL_INIT_VIDEO ) < 0 ) {
    fprintf(stderr,"[SDLGLDrv] Couldn't initialize SDL: %s\n",SDL_GetError());
    exit( 1 );
  }
  
  /* do fullscreen ? */
  if (do_fullscreen)
    flags = SDL_OPENGL | SDL_FULLSCREEN;
  else
    flags = SDL_OPENGL;

  /*
   * load and init OpenGL driver
   */
  load_init_gl_lib(gl_Driver);

  /* set OpenGL attributes */
  SDL_GL_SetAttribute( SDL_GL_RED_SIZE, 5 );
  SDL_GL_SetAttribute( SDL_GL_GREEN_SIZE, 6 );
  SDL_GL_SetAttribute( SDL_GL_BLUE_SIZE, 5 );
  SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16 );
  SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );

  signal(SIGINT, (void (*)(int)) I_Quit);
  
  mlump_filename=(char*)malloc(strlen(homedir)+strlen("Mlump.txt")+1);
  sprintf(mlump_filename, "%sMlump.txt", homedir);
  
  wlump_filename=(char*)malloc(strlen(homedir)+strlen("Wlump.txt")+1);
  sprintf(wlump_filename, "%sWlump.txt", homedir);
  
  if ( SDL_SetVideoMode( screenwidth, screenheight, 16, flags ) == NULL ) {
    fprintf(stderr, "[SDLGLdrv/init] Couldn't set GL mode: %s\n",
	    SDL_GetError());
    SDL_Quit();
    exit(1);
  }

  /* check request results */
  SDL_GL_GetAttribute( SDL_GL_RED_SIZE, &value );
  printf( "[SDLGLDrv/init] red_size: requested 5 bits, got %d\n", value );
  SDL_GL_GetAttribute( SDL_GL_GREEN_SIZE, &value );
  printf( "[SDLGLDrv/init] green_size: requested 6 bits, got %d\n", value);
  SDL_GL_GetAttribute( SDL_GL_BLUE_SIZE, &value );
  printf( "[SDLGLDrv/init] blue_size: requested 5 bits, got %d\n", value );
  SDL_GL_GetAttribute( SDL_GL_DEPTH_SIZE, &value );
  printf( "[SDLGLDrv/init] depth_size: requested 16 bits, got %d\n", value );
  SDL_GL_GetAttribute( SDL_GL_DOUBLEBUFFER, &value );
  printf( "[SDLGLDrv/init] OpenGL_doublebuffer: requested 1, got %d\n", value );
  
  /* Set the window manager title bar */
  SDL_WM_SetCaption( "GLHeretic v1.1", "GLHeretic" );

  /* hide the mouse-cursor */
  SDL_ShowCursor( 0 );

  initializeGL(screenwidth, screenheight);
}


/*
 * ----------------------------------------------------------------
 * OpenGL code
 * ----------------------------------------------------------------
 */

void DisplayGLInfo() {
    const unsigned char *vendor=(*glGetString_s) (GL_VENDOR);
    const unsigned char *version=(*glGetString_s) (GL_VERSION);
    unsigned char str[1]={0};
    const unsigned char *renderer=(*glGetString_s) (GL_RENDERER);
    const unsigned char *extension=str;
	
    extension=(*glGetString_s) (GL_EXTENSIONS);
    printf("[SDLGLdrv/init] OpenGL driver: %s (%s) %s\n", version, vendor, renderer);
    printf("[SDLGLdrv/init] OpenGL Extensions: %s\n", extension);
    if (!strstr((char *)extension,"GL_EXT_paletted_texture")) {
      g_bPaletteTexture=FALSE;
      printf("[SDLGLdrv/init] OpenGL driver doesn't support paletted textures\n");
    }
}

GLvoid resize( GLsizei width, GLsizei height ) {
  (*glViewport_s) (0, 0, width, height);
}

GLvoid initializeGL(GLsizei width, GLsizei height) {
  
  aspect = (GLfloat)width/(GLfloat)height;
  
  DisplayGLInfo();
  
  p_bPalette=W_CacheLumpName("PLAYPAL", PU_STATIC); /* DOOM_GL */
  
  (*glClearColor_s) (0.0f, 0.0f, 0.0f, 0.0f);
  (*glClearDepth_s) (1.0);
  (*glDepthFunc_s) (GL_LEQUAL);
  (*glShadeModel_s) (GL_SMOOTH);
  
  /* enable */
  (*glEnable_s) (GL_DEPTH_TEST);
  
  (*glPixelStorei_s) (GL_UNPACK_ALIGNMENT, 1);
  
  (*glHint_s) (GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
  
  /* if you want it really NICE (and have a fast OpenGL-card) ! */
#ifdef NICE_GL
  (*glHint_s) (GL_POLYGON_SMOOTH_HINT, GL_NICEST);
#else
  (*glHint_s) (GL_POLYGON_SMOOTH_HINT, GL_FASTEST);
#endif
  
  fn_vInitGLTexFonts();
  
  if (!screen)
    screen=(byte *)malloc(screenwidth*screenheight*4);
  
  
  GL_fn_vInitLights();
#ifdef WEAP_DRAWPIX
  fn_vAllocWeaponMemory();
#endif
  /* MR3006: DynLight (test) */
  /* GL_AddLightSource(0,0,0,0,0,1,0,0,10.0f); */
  
  /* Fog... */
  /* (*glEnable_s) (GL_FOG); */
}

extern H_boolean g_bLightEffects;

void GL_InitCommandLine() {
  int p;
  
  if ((p=M_CheckParm("-gl_driver"))) {
    gl_Driver=(char*)malloc(strlen(myargv[p+1])+1);
    strcpy(gl_Driver, myargv[p+1]);
    printf("[SDLGLDrv] OpenGL: using %s as gl_Driver.\n", gl_Driver);
  }
  
  if (M_CheckParm("-paltex")) {
    g_bPaletteTexture=TRUE;
    printf("[SDLGLDrv] OpenGL: Paletted textures enabled\n");
  }
  
  g_bSpriteBilinear=TRUE;
  printf("[SDLGLDrv] OpenGL: Sprite filtering enabled\n");
  
  g_bSpriteOpti=TRUE;
  printf("[SDLGLDrv] OpenGL: Sprite compression enabled\n");
  
  if ((p=M_CheckParm("-sprscale")))
    fScaleSprite=(float)atof(myargv[p+1]);
  
  if ((p=M_CheckParm("-sprmaxsurf"))) {
    iMaxSizeBeforeReduction=atoi(myargv[p+1]);
    printf("[SDLGLDrv] OpenGL: Sprite maximum surface: %d\n",iMaxSizeBeforeReduction);
    printf("[SDLGLDrv] OpenGL: Sprite factor scale: %f\n",fScaleSprite);
  }
  
  if ((p=M_CheckParm("-raster"))) {
    g_bGlobalRaster=TRUE;
  }
  
  if ((p=M_CheckParm("-dspraster"))) {
    g_bDisplayRaster=TRUE;
  }
  
  if ((p=M_CheckParm("-3dfx"))) {
    g_b3Dfx=TRUE;
    printf("[SDLGLDrv] OpenGL: Max texture size is 256x256\n");
  }
  
  if ((p=M_CheckParm("-fullscreen"))) {
    do_fullscreen=1;
    printf("[SDLGLDrv] OpenGL: running in fullscreen mode\n");
  }
  
  if ((p=M_CheckParm("-window"))) {
    do_fullscreen=0;
    printf("[SDLGLDrv] OpenGL: running in windowed mode\n");
  }
  
  if (mouseLook)
     g_bMlook = TRUE;
  else
     g_bMlook = FALSE;  
  
  if (!M_CheckParm("-noeffects"))	/* DarkFang */
    g_bLightEffects=TRUE;
  else
    g_bLightEffects=FALSE;
}
