#include <stdlib.h>
#include <stdio.h>

#include "gl_mem.h"

extern void I_Error (char *error, ...);

int HeapCreate(int heapType) {
  int i;
  
  if (heapType>2) {
    I_Error("Unknowm heap type: %d !\n", heapType);
  }

  switch (heapType) {
  case FIX:
    printf("[SDLGLDrv/glmem] initializing heap-system: FIX\n");
    for(i=0; i<MAXALLOCS; i++)
      alloc_table_FIX[i]=NULL;
    table_FIX_allocs=0;
    table_FIX_allocs_summary=0;
    return FIX;
    break;

  case LEVEL:
    printf("[SDLGLDrv/glmem] initializing heap-system: LEVEL\n");
    for(i=0; i<MAXALLOCS; i++)
      alloc_table_LEVEL[i]=NULL;
    table_LEVEL_allocs=0;
    table_LEVEL_allocs_summary=0;
    return LEVEL;
    break;

  case OTHER:
    printf("[SDLGLDrv/glmem] initializing heap-system: OTHER\n");
    for(i=0; i<MAXALLOCS; i++)
      alloc_table_OTHER[i]=NULL;
    table_OTHER_allocs=0;
    table_OTHER_allocs_summary=0;
    return OTHER;
    break;
  }
  return -1;
}

void HeapDestroy(int heapHandle) {
  int i;

  switch(heapHandle) {
  case FIX:
    for(i=0; i<MAXALLOCS; i++) {
      if (alloc_table_FIX[i]) {
	/* printf("FIX-Heap(HeapDestroy): freeing at: %d\n", i); */
	free(alloc_table_FIX[i]);
	alloc_table_FIX[i]=NULL;
      }
    }
    table_FIX_allocs=0;
    table_FIX_allocs_summary=0;
    break;
    
  case LEVEL:
    for(i=0; i<MAXALLOCS; i++) {
      if (alloc_table_LEVEL[i]) {
	/* printf("LEVEL-Heap(HeapDestroy): freeing at: %d\n", i); */
	free(alloc_table_LEVEL[i]);
	alloc_table_LEVEL[i]=NULL;
      }
    }
    table_LEVEL_allocs=0;
    table_LEVEL_allocs_summary=0;
    break;

  case OTHER:
    for(i=0; i<MAXALLOCS; i++) {
      if (alloc_table_OTHER[i]) {
	/* printf("OTHER-Heap(HeapDestroy): freeing %u at: %d\n", alloc_table_OTHER[i], i); */
	free(alloc_table_OTHER[i]);
	alloc_table_OTHER[i]=NULL;
      }
    }
    table_OTHER_allocs=0;
    table_OTHER_allocs_summary=0;
    break;
  }
}

void *HeapAlloc(int heapHandle, int dummy, long numbAlloc) {
  int i;

  switch (heapHandle) {
  case FIX:
    i=0;
    /* try to find the next empty place where to alloc */
    while((alloc_table_FIX[i]) && (i<=MAXALLOCS)) i++;
    
    if (i>=MAXALLOCS) {
      I_Error("FIX-Heap(HeapAlloc): MaxAllocs reached !!!!\n");
    }
    
    /* alloc_table_FIX[i]=malloc(numbAlloc); */
    alloc_table_FIX[i]=calloc(numbAlloc, 1);
    if (alloc_table_FIX[i]==NULL) {
      I_Error("FIX-Heap(HeapAlloc): couldn't allocate %u bytes of memory !\n", numbAlloc);
    }
    table_FIX_allocs++;
    table_FIX_allocs_summary += numbAlloc;
    return alloc_table_FIX[i];
    break;

  case LEVEL:
    i=0;
    /* try to find the next empty place where to alloc */
    while((alloc_table_LEVEL[i]) && (i<=MAXALLOCS)) i++;
    
    if (i>=MAXALLOCS) {
      I_Error("LEVEL-Heap(HeapAlloc): MaxAllocs reached !!!!\n");
    }

    /* alloc_table_LEVEL[i]=malloc(numbAlloc); */
    alloc_table_LEVEL[i]=calloc(numbAlloc, 1);
    if (alloc_table_LEVEL[i]==NULL) {
      I_Error("LEVEL-Heap(HeapAlloc): couldn't allocate %u bytes of memory !\n", numbAlloc);
    }
    table_LEVEL_allocs++;
    table_LEVEL_allocs_summary += numbAlloc;
    return alloc_table_LEVEL[i];
    break;

  case OTHER:
    i=0;
    /* try to find the next empty place where to alloc */
    while((alloc_table_OTHER[i]) && (i<=MAXALLOCS)) i++;
    
    if (i>=MAXALLOCS) {
      I_Error("OTHER-Heap(HeapAlloc): MaxAllocs reached !!!!\n");
    }

    /* alloc_table_OTHER[i]=malloc(numbAlloc); */
    alloc_table_OTHER[i]=calloc(numbAlloc, 1);
    if (alloc_table_OTHER[i]==NULL) {
      I_Error("OTHER-Heap(HeapAlloc): couldn't allocate %u bytes of memory !\n", numbAlloc);
    }
    /* printf("OTHER-Heap(HeapAlloc): allocating %lu bytes in OTHER-Heap.\n", numbAlloc); */
    table_OTHER_allocs++;
    table_OTHER_allocs_summary += numbAlloc;
    return alloc_table_OTHER[i];
    break;
  }
  return NULL;
}
      
void *HeapReAlloc(int heapHandle, int dummy, void *prevMemPtr, long numbAlloc) {
  int i;
  void *holder;

  switch (heapHandle) {
  case FIX:
    i=0;
    /* try to find the existing pointer in the array */
    while((alloc_table_FIX[i] != prevMemPtr) && (i<=MAXALLOCS)) i++;

    if (i>=MAXALLOCS) {
      I_Error("FIX-Heap(HeapReAlloc): the memptr to realloc wasn't in the ptr-array !\n");
    }

    holder=realloc(prevMemPtr, numbAlloc);
    if (holder==NULL) {
      I_Error("FIX-Heap(HeapReAlloc): couldn't reallocate to %u bytes of memory !\n", numbAlloc);
    }
    alloc_table_FIX[i]=holder;
    /* printf("FIX-Heap(HeapReAlloc): %d %d\n", alloc_table_FIX[i], holder); */
    return alloc_table_FIX[i];
    break;
  case LEVEL:
    i=0;
    /* try to find the existing pointer in the array */
    while((alloc_table_LEVEL[i] != prevMemPtr) && (i<=MAXALLOCS)) i++;

    if (i>=MAXALLOCS) {
      I_Error("LEVEL-Heap(HeapReAlloc): the memptr to realloc wasn't in the ptr-array !\n");
    }
   
    if (numbAlloc==0)
       HeapFree(heapHandle, 0, &prevMemPtr);
 
    holder=realloc(prevMemPtr, numbAlloc);
    if (holder==NULL) {
      I_Error("LEVEL-Heap(HeapReAlloc): couldn't reallocate to %u bytes of memory !\n", numbAlloc);
    }
    alloc_table_LEVEL[i]=holder;
    /* printf("LEVEL-Heap(HeapReAlloc): %d %d\n", alloc_table_LEVEL[i], holder); */
    return alloc_table_LEVEL[i];
    break;
  case OTHER:
    i=0;
    /* try to find the existing pointer in the array */
    while((alloc_table_OTHER[i] != prevMemPtr) && (i<=MAXALLOCS)) i++;
    
    if (i>=MAXALLOCS) {
      I_Error("OTHER-Heap(HeapReAlloc): the memptr to realloc wasn't in the ptr-array !\n");
    }
    
    holder=realloc(prevMemPtr, numbAlloc);
    if (holder==NULL) {
      I_Error("OTHER-Heap(HeapReAlloc): couldn't reallocate to %u bytes of memory !\n", numbAlloc);
    }
    alloc_table_OTHER[i]=holder;
    /* printf("OTHER-Heap(HeapReAlloc): %d %d\n", alloc_table_OTHER[i], holder); */
    return alloc_table_OTHER[i];
    break;
  }
  return NULL;
}

void HeapFree(int heapHandle, int dummy, void **memPtr) {
  int i;

  switch(heapHandle) {
  case FIX:
    i=0;
    /* try to find the existing pointer in the array */
    while((alloc_table_FIX[i] != *memPtr) && (i<=MAXALLOCS)) i++;

    if (i>=MAXALLOCS) {
      I_Error("FIX-Heap(HeapFree): the memptr to free wasn't in the ptr-array !\n");
    }

    /* printf("FIX-Heap(HeapFree): freeing at %d\n", i); */

    table_FIX_allocs--;
    /* this means: free(memPtr); */
    free(alloc_table_FIX[i]);
    /* one of them is redundant ! */
    alloc_table_FIX[i]=NULL; *memPtr=NULL;
    break;
  case LEVEL:
    i=0;
    /* try to find the existing pointer in the array */
    while((alloc_table_LEVEL[i] != *memPtr) && (i<=MAXALLOCS)) i++;
    
    if (i>=MAXALLOCS) {
      I_Error("LEVEL-Heap(HeapFree): the memptr to free wasn't in the ptr-array !\n");
    }

    /* printf("LEVEL-Heap(HeapFree): freeing at %d\n", i); */

    table_LEVEL_allocs--;
    /* this means: free(memPtr); */
    free(alloc_table_LEVEL[i]);
    /* one of them is redundant ! */
    alloc_table_LEVEL[i]=NULL; *memPtr=NULL;
    break;
  case OTHER:
    i=0;
    /* try to find the existing pointer in the array */
    while((alloc_table_OTHER[i] != *memPtr) && (i<=MAXALLOCS)) i++;
    
    if (i>=MAXALLOCS) {
      I_Error("OTHER-Heap(HeapFree): the memptr to free wasn't in the ptr-array !\n");
    }

    /* printf("OTHER-Heap(HeapFree): freeing at %d\n", i); */
    table_OTHER_allocs--;
    /* this means: free(memPtr); */
    free(alloc_table_OTHER[i]);
    /* one of them is redundant ! */
    alloc_table_OTHER[i]=NULL; *memPtr=NULL;
    break;
  }
}


