#ifndef __GL_SYMS_H__
#define __GL_SYMS_H__

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glx.h>

/* ---------------------------------------------- */
/* --------- OpenGL function signatures --------- */
/* ---------------------------------------------- */

extern void (*glBindTexture_s)    (GLenum target, GLuint texture);
extern void (*glMatrixMode_s)     (GLenum mode);
extern void (*glPushMatrix_s)     (void);
extern void (*glLoadIdentity_s)   (void);
extern void (*glRotatef_s)        (GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
extern void (*glTranslatef_s)     (GLfloat x, GLfloat y, GLfloat z);
extern void (*glBegin_s)          (GLenum mode);
extern void (*glNormal3f_s)       (GLfloat nx, GLfloat ny, GLfloat nz);
extern void (*glTexCoord2f_s)     (GLfloat s, GLfloat t);
extern void (*glVertex3f_s)       (GLfloat x, GLfloat y, GLfloat z);
extern void (*glEnd_s)            (void);
extern void (*glPopMatrix_s)      (void);
extern void (*glCullFace_s)       (GLenum mode);
extern void (*glVertex2f_s)       (GLfloat x, GLfloat y);
extern void (*glColor3f_s)        (GLfloat red, GLfloat green, GLfloat blue);
extern void (*glDisable_s)        (GLenum cap);
extern void (*glEnable_s)         (GLenum cap);
extern void (*glClear_s)          (GLbitfield mask);
extern void (*glRasterPos2i_s)    (GLint x, GLint y);
extern void (*glColorTableEXT_s)  (GLenum target, GLenum internalformat, GLsizei width,
				 													 GLenum format, GLenum type, const GLvoid *table);
extern void (*glDrawPixels_s)     (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
extern void (*glTexParameterf_s)  (GLenum target, GLenum pname, GLfloat param);
extern void (*glTexEnvf_s)        (GLenum target, GLenum pname, GLfloat param);
extern void (*glTexImage2D_s)     (GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height,
				 													 GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void (*glOrtho_s)          (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top,
				 													 GLdouble near_val, GLdouble far_val);
extern void (*glColor4f_s)        (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
extern void (*glAlphaFunc_s)      (GLenum func, GLclampf ref);
extern void (*glDepthFunc_s)      (GLenum func);
extern void (*glFinish_s)         (void);
extern void (*glReadPixels_s)     (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format,
				                           GLenum type, GLvoid *pixels);
extern const GLubyte*
            (*glGetString_s)      (GLenum name);
extern void (*glViewport_s)       (GLint x, GLint y, GLsizei width, GLsizei height);
extern void (*glClearColor_s)     (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
extern void (*glClearDepth_s)     (GLclampf depth);
extern void (*glShadeModel_s)     (GLenum mode);
extern void (*glPixelStorei_s)    (GLenum pname, GLint param);
extern void (*glHint_s)           (GLenum target, GLenum mode);
extern void (*glBlendFunc_s)      (GLenum sfactor, GLenum dfactor);
extern void (*glDeleteTextures_s) (GLsizei n, const GLuint *textures);
extern void (*glMultMatrixd_s)    (const GLdouble *m);
extern void (*glTranslated_s)     (GLdouble x, GLdouble y, GLdouble z);
extern void (*glScalef_s)         (GLfloat x, GLfloat y, GLfloat z);
extern void (*glFrustum_s)        (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top,
				   GLdouble near_val, GLdouble far_val);



#endif
