#ifdef GL_HERETIC

//#define __DOOMTYPE__

#include <stdio.h>
#include <string.h>

#include "gl_syms.h"

#include "gl_struct.h"
#include "gl_mem.h"
#ifndef GL_HEXEN
#include "doomdef.h"
#else
#include "h2def.h"
#endif
#include "p_spec.h"

extern GLboolean g_b3Dfx;

// Coronas...
extern unsigned char *g_p_bCoronaTexture;
extern int g_iCorona;
extern unsigned char *g_p_bLightTexture;

// Flares
/*extern unsigned char *flareTex[6];
extern unsigned char *shineTex[10];
extern int g_iFlare[6];*/
extern int g_iShine[10];

// Wall impacts
extern unsigned char *g_p_bImpactTexture[7];
extern int g_iImpact;

extern int		firstflat, lastflat, numflats;
extern int		firstpatch, lastpatch, numpatches;
extern int		firstspritelump, lastspritelump, numspritelumps;

extern int			numtextures;

extern int		flatmemory, texturememory, spritememory;
extern texture_t	**textures;
extern byte *R_GetColumn (int tex, int col);
// sprites
extern GLTexture *p_stGLSprites;
extern int	iNbGLSprites;
extern GLTexArray *p_stGLSprArray;

// Fonts
extern GLTexture *p_stGLFontA;
extern int	iNbGLFontA;
extern GLTexture *p_stGLFontB;
extern int	iNbGLFontB;
GLuint *FontAobjs=NULL,*FontBobjs;

// textures animations
#ifndef GL_HEXEN
extern anim_t anims[MAXANIMS];
extern anim_t *lastanim;
extern animdef_t animdefs[];
#else	// GL_HEXEN
extern animDef_t AnimDefs[MAX_ANIM_DEFS];
extern frameDef_t FrameDefs[MAX_FRAME_DEFS];
extern int AnimDefCount;

int GL_Sky1Texture,GL_Sky2Texture;
#endif	// GL_HEXEN
extern switchlist_t alphSwitchList[];
int *a_iGLTexTranslation;
int	glSwitchList[MAXSWITCHES * 2];

GLTexture *p_stGLTextures;
int			iNbTexturesInMap,iNbGLTextures;
GLuint *texobjs;
GLuint *sprobjs;
GLTexArray *p_stGLTexArray;

byte *p_bPalette;
#ifdef PALETTED_TEXTURE
GLubyte p_bGLPalette[256][4];
GLfloat p_fAlpha[256];
GLfloat p_fRed[256],p_fGreen[256],p_fBlue[256];
#endif

int xS[512],yS[512];
int xD[512],yD[512];

GLboolean g_bPaletteTexture=FALSE;

GLboolean g_bOnTheFly;
GLint GL_vRegisterFlatTextureOnTheFly(int iTexNum);

void fn_vStretchTexture(long lWidthS,long lHeightS,long lWidthD,long lHeightD)
{ int x,y;
  float fXRatio,fYRatio;

	fXRatio=(float)lWidthS/(float)lWidthD;
	fYRatio=(float)lHeightS/(float)lHeightD;
	for (y=0;y<lHeightD;y++)
	{
		yS[y]=(int)(fYRatio*(float)y);
	}	
	for (x=0;x<lWidthD;x++)
	{
		xS[x]=(int)(fXRatio*(float)x);
	}
	// MR2506
	for (y=0;y<lHeightS;y++)
	{
		yD[y]=(int)((float)y/fYRatio);
	}	
	for (x=0;x<lWidthS;x++)
	{
		xD[x]=(int)((float)x/fXRatio);
	}
}

void fn_vInitGLTexFonts()
{ int i,iTexMemory;
#ifdef PALETTED_TEXTURE

	if (g_bPaletteTexture)
	{	for (i=0;i<256;i++)
		{	p_bGLPalette[i][0]=p_bPalette[3*i];
			p_bGLPalette[i][1]=p_bPalette[3*i+1];
			p_bGLPalette[i][2]=p_bPalette[3*i+2];
			p_fRed[i]=(float)p_bPalette[3*i]/255;
			p_fGreen[i]=(float)p_bPalette[3*i+1]/255;
			p_fBlue[i]=(float)p_bPalette[3*i+2]/255;
			if (i==205)
			{	p_bGLPalette[i][3]=0;
				p_fAlpha[i]=0.0f;
			}
			else
			{	p_bGLPalette[i][3]=255;
				p_fAlpha[i]=1.0f;
			}
		}
		/*for (i=0;i<256;i++)
		{	p_bGLPalette[4*i]=(p_bPalette[3*i]>>3);
			p_bGLPalette[4*i+1]=(p_bPalette[3*i+1]>>3);
			p_bGLPalette[4*i+2]=(p_bPalette[3*i+2]>>3);
			if (i==205)
				p_bGLPalette[4*i+3]=0;
			else
				p_bGLPalette[4*i+3]=1;
		}*/

		/*glPixelMapfv(GL_PIXEL_MAP_I_TO_R,256,p_fRed);
		glPixelMapfv(GL_PIXEL_MAP_I_TO_G,256,p_fGreen);
		glPixelMapfv(GL_PIXEL_MAP_I_TO_B,256,p_fBlue);
		glPixelMapfv(GL_PIXEL_MAP_I_TO_A,256,p_fAlpha);*/

	}
#endif

	// FontA
	FontAobjs=(GLuint *)Malloc((iNbGLFontA)*sizeof(GLuint));
	iTexMemory=0;

	for (i = 0; i < iNbGLFontA; i++) 
	{
#ifndef GL_HEXEN
		FontAobjs[i] = numspritelumps+numflats+numtextures+numpatches+i;
#else
		FontAobjs[i] = 10000+i;
#endif
		(*glBindTexture_s) (GL_TEXTURE_2D, FontAobjs[i]);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
//#ifdef BILINEAR
//		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
//		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
//#else
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
//#endif
		(*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

#ifdef PALETTED_SPRITE
		if (g_bPaletteTexture)
		{	
			(*glColorTableEXT_s) (GL_TEXTURE_2D,GL_RGB8,256,GL_RGB,GL_UNSIGNED_BYTE,p_bPalette);
			(*glTexImage2D_s) (GL_TEXTURE_2D, 0, GL_COLOR_INDEX8_EXT, p_stGLFontA[i].iWidth, p_stGLFontA[i].iHeight, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, p_stGLFontA[i].p_bRGBBuffer);
		}
		else
#endif
		(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, p_stGLFontA[i].iWidth, p_stGLFontA[i].iHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, p_stGLFontA[i].p_bRGBBuffer);

		iTexMemory+=p_stGLFontA[i].iWidth*p_stGLFontA[i].iHeight*4;
	}
//	fn_vSaveRAW("FontA.raw",p_stGLFontA[0].p_bRGBBuffer,p_stGLFontA[0].iWidth,p_stGLFontA[0].iHeight);
	// SCREENS
	GLRegisterScreens();
}

extern void GL_LoadCoronaTexture(void);
extern void GL_LoadImpactTextures(void);

void fn_vInitGLTextures()
{ int i,j;
  int iTexMemory=0,iRealSprMemory=0;
#ifdef FLARES
  unsigned char *buf;	
  char filename[256];
  int width, height, components;
  GLenum minFilter, maxFilter;

  minFilter = GL_LINEAR_MIPMAP_LINEAR;
  maxFilter = GL_LINEAR;
#endif

	texobjs=(GLuint *)Malloc(iNbGLTextures*sizeof(GLuint));
	for (i = 0; i < iNbGLTextures; i++)
		texobjs[i] = i+1;
   
	for (i = 0; i < iNbGLTextures; i++) 
	{
		(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[i]);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
#ifdef BILINEAR
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
#else
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
#endif
		(*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE /*GL_DECAL*/);

#ifdef PALETTED_TEXTURE
		if ((g_bPaletteTexture)&&(!p_stGLTextures[i].a_stSubTex[0].bIsNZ))
		{	(*glColorTableEXT_s) (GL_TEXTURE_2D,GL_RGB8,256,GL_RGB,GL_UNSIGNED_BYTE,p_bPalette);
			(*glTexImage2D_s) (GL_TEXTURE_2D, 0, GL_COLOR_INDEX8_EXT, p_stGLTextures[i].iWidth, p_stGLTextures[i].iHeight, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, p_stGLTextures[i].p_bRGBBuffer);
			iTexMemory+=p_stGLTextures[i].iWidth*p_stGLTextures[i].iHeight;
		}
		else
#endif
		{	(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, p_stGLTextures[i].iWidth, p_stGLTextures[i].iHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, p_stGLTextures[i].p_bRGBBuffer);

			iTexMemory+=p_stGLTextures[i].iWidth*p_stGLTextures[i].iHeight*4;
		}
    }
	printf("[SDLGLdrv/textures] GL Map Texture memory: %d bytes (%d kb)\n", iTexMemory, iTexMemory / 1024);
	
	// Sprites
	iTexMemory=0;
	sprobjs=(GLuint *)Malloc(iNbGLSprites*sizeof(GLuint));
	for (i = 0; i < iNbGLSprites; i++)
		//sprobjs[i+iNbGLTextures] = i+iNbGLTextures+1;
		sprobjs[i] = i+numtextures+numpatches+1;
   
	for (i = 0; i < iNbGLSprites; i++) 
	{
		(*glBindTexture_s) (GL_TEXTURE_2D, sprobjs[i]);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
#ifdef BILINEAR
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
#else
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
#endif
		(*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

#ifdef PALETTED_SPRITE
		if (g_bPaletteTexture)
		{	//(*glColorTableEXT_s) (GL_TEXTURE_2D,GL_RGBA8,256,GL_RGBA,GL_UNSIGNED_BYTE,p_bGLPalette);
			(*glColorTableEXT_s) (GL_TEXTURE_2D,GL_RGB8,256,GL_RGB,GL_UNSIGNED_BYTE,p_bPalette);
			//glGetColorTableParameterivEXT(GL_PROXY_TEXTURE_2D,GL_COLOR_TABLE_WIDTH_EXT,&width);
			(*glTexImage2D_s) (GL_TEXTURE_2D, 0, GL_COLOR_INDEX8_EXT, p_stGLSprites[i].iWidth, p_stGLSprites[i].iHeight, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, p_stGLSprites[i].p_bRGBBuffer);
			//(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, p_stGLSprites[i].iWidth, p_stGLSprites[i].iHeight, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, p_stGLSprites[i].p_bRGBBuffer);
		}
		else
#endif
		(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, p_stGLSprites[i].iWidth, p_stGLSprites[i].iHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, p_stGLSprites[i].p_bRGBBuffer);

		iTexMemory+=p_stGLSprites[i].iWidth*p_stGLSprites[i].iHeight*4;
		for (j=0;j<p_stGLSprites[i].iNbSubTextures;j++)
			iRealSprMemory+=p_stGLSprites[i].a_stSubTex[j].iWidth*p_stGLSprites[i].a_stSubTex[j].iHeight*4;
		
//#define SHOW_GL_SPRITES
#ifdef SHOW_GL_SPRITES
		for (j=0;j<p_stGLSprites[i].iNbFreeSpace;j++)
		{ int x,y,iU,iV;
			iU=p_stGLSprites[i].a_stFreeSpace[j].iU;
			iV=p_stGLSprites[i].a_stFreeSpace[j].iV;
			for (x=0;x<p_stGLSprites[i].a_stFreeSpace[j].iWidth;x++)
			for (y=0;y<p_stGLSprites[i].a_stFreeSpace[j].iHeight;y++)
			{	p_stGLSprites[i].p_bRGBBuffer[4*((x+iU)+(y+iV)*SPRITE_WIDTH)]=255;
				p_stGLSprites[i].p_bRGBBuffer[4*((x+iU)+(y+iV)*SPRITE_WIDTH)+1]=0;
				p_stGLSprites[i].p_bRGBBuffer[4*((x+iU)+(y+iV)*SPRITE_WIDTH)+2]=0;
				p_stGLSprites[i].p_bRGBBuffer[4*((x+iU)+(y+iV)*SPRITE_WIDTH)+3]=255;
			}
		}
#endif
    }
	printf("[SDLGLdrv/textures] GL Sprite Texture memory: %d bytes (%d kb)\n", iTexMemory, iTexMemory / 1024);
	printf("[SDLGLdrv/textures] Sprite Texture memory (original): %d bytes (%d kb)\n", iRealSprMemory, iRealSprMemory / 1024);
//	fn_vSaveSprites();	// Save all the GLSprites

// Coronas...
	GL_LoadCoronaTexture();
	//g_iCorona=iNbGLTextures+iNbGLSprites+50;
	g_iCorona=sprobjs[iNbGLSprites-1]+50;

	//(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iNbGLTextures+iNbGLSprites]);
	(*glBindTexture_s) (GL_TEXTURE_2D, g_iCorona);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	(*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, 128, 128, 0, GL_RGBA, GL_UNSIGNED_BYTE, g_p_bCoronaTexture);
	//(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, 64, 64, 0, GL_RGBA, GL_UNSIGNED_BYTE, g_p_bCoronaTexture);
// Light
	(*glBindTexture_s) (GL_TEXTURE_2D, g_iCorona+1);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	(*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, 128, 128, 0, GL_RGBA, GL_UNSIGNED_BYTE, g_p_bLightTexture);

#ifdef FLARES
// Flares
	/*for (i = 0; i < 6; i++) 
	{
	iNbGLSprites++;
	g_iFlare[i] = sprobjs[iNbGLSprites-1]+50+i+2;
	
    (*glBindTexture_s) (GL_TEXTURE_2D, g_iFlare[i]);
    (*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, minFilter);
    (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, maxFilter);
    
	sprintf(filename, "Flare%d.BW", i+1);
	
	buf = load_luminance(filename, &width, &height, &components);
    gluBuild2DMipmaps(GL_TEXTURE_2D, 1, width, height, GL_LUMINANCE, GL_UNSIGNED_BYTE, buf);
    
	free(buf);

	printf("DEBG - SET: g_iFlare %d\n", i);
	}
	*/
	
for (i = 0; i < 10; i++) 
  {
    iNbGLSprites++;
	 g_iShine[i] = sprobjs[iNbGLSprites-1]+50+i+2;

	 //(*glBindTexture_s) (GL_TEXTURE_2D, shineTex[i]);
	 (*glBindTexture_s) (GL_TEXTURE_2D, g_iShine[i]);
    (*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, minFilter);
    (*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, maxFilter);
    
	sprintf(filename, "Shine%d.BW", i);

	buf = load_luminance(filename, &width, &height, &components);
    gluBuild2DMipmaps(GL_TEXTURE_2D, 1, width, height, GL_LUMINANCE, GL_UNSIGNED_BYTE, buf);
    
	free(buf);
	
	printf("[SDLGLdrv/textures] DEBG: g_iShine %d ; width: %d ; height: %d\n", i, width, height);
  }
#endif
// Bullet impact
	GL_LoadImpactTextures();
	//g_iCorona=iNbGLTextures+iNbGLSprites+50;
	g_iImpact=sprobjs[iNbGLSprites-1]+70;

	for (i=0;i<7;i++)
	{	(*glBindTexture_s) (GL_TEXTURE_2D, g_iImpact+i);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		(*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

		if (i==0)
			(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, 32, 32, 0, GL_RGBA, GL_UNSIGNED_BYTE, g_p_bImpactTexture[i]);
		else
		if (i<3)
			(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, 64, 64, 0, GL_RGBA, GL_UNSIGNED_BYTE, g_p_bImpactTexture[i]);
		else //if (i<6)
			(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, 32, 32, 0, GL_RGBA, GL_UNSIGNED_BYTE, g_p_bImpactTexture[i]);
		/*else
			(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, 64, 32, 0, GL_RGBA, GL_UNSIGNED_BYTE, g_p_bImpactTexture[i]);*/

		//Free(g_p_bImpactTexture[i]);
	}
	
	g_bOnTheFly=TRUE;
}

void fn_vAllocTextureMemory()
{
//	p_stGLTextures=(GLTexture *)Malloc((numtextures+numflats)*sizeof(GLTexture));
//	a_iGLTexTranslation=(int *)Malloc((numtextures+numflats)*sizeof(int));
	p_stGLTextures=(GLTexture *)Malloc(sizeof(GLTexture));
	a_iGLTexTranslation=(int *)Malloc(sizeof(int));
	p_bPalette=W_CacheLumpName("PLAYPAL", PU_STATIC);
	iNbGLTextures=0;
	iNbTexturesInMap=0;
#ifndef GL_HEXEN
	lastanim = anims;	// animated textures
#endif
	g_bOnTheFly=FALSE;
}

//void fn_vRegisterFlatTexture(char *szName)
void fn_vRegisterFlatTexture(int flattex)
{ unsigned char *p_bTexture;
  int i,lump,x,y;

	//i=R_FlatNumForName(szName);
	i=flattex;
	/*if (!strncmp(szName,"F_SKY1",8))
		return;*/		// a voir
	//flatmemory = 0;
	lump = firstflat + i;
	flatmemory += lumpinfo[lump].size;
	p_bTexture=(unsigned char *)W_CacheLumpNum(lump, PU_CACHE);

	p_stGLTextures=(GLTexture *)Realloc(p_stGLTextures,sizeof(GLTexture)*(iNbGLTextures+1));
	a_iGLTexTranslation=(int *)Realloc(a_iGLTexTranslation,sizeof(int)*(iNbGLTextures+1));

	p_stGLTextures[iNbGLTextures].iWidth=FLAT_TEX_SIZE;
	p_stGLTextures[iNbGLTextures].iHeight=FLAT_TEX_SIZE;

#ifdef PALETTED_TEXTURE
	if (g_bPaletteTexture)
		p_stGLTextures[iNbGLTextures].p_bRGBBuffer=(unsigned char *)Malloc(FLAT_TEX_SIZE*FLAT_TEX_SIZE);
	else
#endif
	p_stGLTextures[iNbGLTextures].p_bRGBBuffer=(unsigned char *)Malloc(FLAT_TEX_SIZE*FLAT_TEX_SIZE*4);

	p_stGLTextures[iNbGLTextures].a_stSubTex=(GLSubTexture *)Malloc(sizeof(GLSubTexture));
	p_stGLTextures[iNbGLTextures].a_stFreeSpace=(GLSubTexture *)Malloc(sizeof(GLSubTexture));
	p_stGLTextures[iNbGLTextures].iNbSubTextures=1;
	p_stGLTextures[iNbGLTextures].a_stSubTex[0].iU=0;
	p_stGLTextures[iNbGLTextures].a_stSubTex[0].iV=0;
	p_stGLTextures[iNbGLTextures].a_stSubTex[0].iWidth=FLAT_TEX_SIZE;
	p_stGLTextures[iNbGLTextures].a_stSubTex[0].iHeight=FLAT_TEX_SIZE;
	p_stGLTextures[iNbGLTextures].a_stSubTex[0].bIsNZ=0;
	p_stGLTextures[iNbGLTextures].iNbFreeSpace=0;
	p_stGLTextures[iNbGLTextures].a_stFreeSpace[0].iU=0;
	p_stGLTextures[iNbGLTextures].a_stFreeSpace[0].iV=0;
	p_stGLTextures[iNbGLTextures].a_stFreeSpace[0].iWidth=0;
	p_stGLTextures[iNbGLTextures].a_stFreeSpace[0].iHeight=0;

	for (x=0;x<FLAT_TEX_SIZE;x++)
	{ 
#define Y y
		for (y=0;y<FLAT_TEX_SIZE;y++)
		{	
#ifdef PALETTED_TEXTURE
			if (g_bPaletteTexture)
				p_stGLTextures[iNbGLTextures].p_bRGBBuffer[x*FLAT_TEX_SIZE+Y]=p_bTexture[y+x*FLAT_TEX_SIZE];
			else
#endif
			{	p_stGLTextures[iNbGLTextures].p_bRGBBuffer[4*(x*FLAT_TEX_SIZE+Y)]=p_bPalette[p_bTexture[y+x*FLAT_TEX_SIZE]*3];
				p_stGLTextures[iNbGLTextures].p_bRGBBuffer[4*(x*FLAT_TEX_SIZE+Y)+1]=p_bPalette[p_bTexture[y+x*FLAT_TEX_SIZE]*3+1];
				p_stGLTextures[iNbGLTextures].p_bRGBBuffer[4*(x*FLAT_TEX_SIZE+Y)+2]=p_bPalette[p_bTexture[y+x*FLAT_TEX_SIZE]*3+2];
				p_stGLTextures[iNbGLTextures].p_bRGBBuffer[4*(x*FLAT_TEX_SIZE+Y)+3]=255;
			}
		}
	}

	a_iGLTexTranslation[iNbGLTextures]=iNbGLTextures;
	
	p_stGLTexArray=(GLTexArray *)Realloc(p_stGLTexArray,++iNbTexturesInMap*sizeof(GLTexArray));
	/*for (k=0;k<8;k++)
		p_stGLTexArray[iNbTexturesInMap-1].szTexName[k]=szName[k];*/
	p_stGLTexArray[iNbTexturesInMap-1].iFlatID=flattex;
	p_stGLTexArray[iNbTexturesInMap-1].iTexID=-1;
	p_stGLTexArray[iNbTexturesInMap-1].iGLTexIndex=iNbGLTextures++;
	p_stGLTexArray[iNbTexturesInMap-1].iUVIndex=0;
}

int fn_iGetTexHeightGL(int iHeight)
{
	if (g_b3Dfx&&(iHeight>256))	// MR0709
		return 256;
	if ((iHeight==2)||(iHeight==4)||(iHeight==8)||(iHeight==16)||(iHeight==32)||(iHeight==64)||(iHeight==128)||(iHeight==256)||(iHeight==512)||(iHeight==1024))
		return iHeight;
	if (iHeight<2)		// DOOM_GL: Bug in 3Dfx beta 2.1 drivers. Tex Width<16 => White!!
		return 2;
	if (iHeight<4)
		return 4;
	if (iHeight<8)
		return 8;
	if (iHeight<16)
		return 16;
	if (iHeight<32)
		return 32;
	if (iHeight<64)
		return 64;
	if (iHeight<128)
		return 128;
	if (iHeight<256)
		return 256;
	if (iHeight<512)
		return 512;
	if (iHeight<1024)
		return 1024;
	
	fprintf(stderr, "[SDLGLdrv/textures] iHeight: %d\n", iHeight);	
	return 1024;		/* shoot up compiler warning ! */
}

#ifdef DOOM_GL
#define NB_NON_TRANSP_TEX 14
char szNonTranspTex[NB_NON_TRANSP_TEX][8]= { "COMPTILE","LITEBLU4","COMPSTA1","DOORBLU","DOORBLU2","SW2SKIN","COMPBLUE","SW1BLUE",
	"SW2BLUE","TEKGREN3","PLAT1", "SKINEDGE","PANBLUE","COMPUTE1" };
// MR2506
#define NB_TRANSP_TEX 17
char szTranspTex[NB_TRANSP_TEX][8]= { "BRNBIGC","BRNBIGL","BRNBIGR","BRNSMAL1","BRNSMAL2","BRNSMALC","BRNSMALL","BRNSMALR","MIDBRN1",
	"MIDGRATE","MIDVINE1","MIDVINE2","MIDBARS1","MIDBARS3","MIDBRONZ","MIDSPACE","IIEBLOD1"  };

#elif GL_HEXEN
#define NB_NON_TRANSP_TEX 7
char szNonTranspTex[NB_NON_TRANSP_TEX][8]= { "FOREST01","GLASS01","GLASS02","GLASS03","GLASS04","GLASS05","GLASS06" };

#define NB_TRANSP_TEX 31
char szTranspTex[NB_TRANSP_TEX][8]= { "GATE01","GATE02","GATE03","GATE04","GATE51","GATE52","GATE53","VILL06","VILL07","VILL08",
	"WEB1_L","WEB1_R","WEB2_L","WEB2_R","WEB3","GLASS07","TOMB18","BLANK","CASTLE09","CAVE11","FIRE16","FOREST12","MONK24","PRTL07",
	"SEWER14","SWAMP07","TOMB13","TPORTX","SEWER03","SEWER04","FOREST06"  };

#else
#define NB_NON_TRANSP_TEX 8
char szNonTranspTex[NB_NON_TRANSP_TEX][8]= { "MOSAIC1","MOSAIC2","MOSAIC3","MOSAIC4","MOSAIC5","STNGLS1","STNGLS2","STNGLS3"};

#define NB_TRANSP_TEX 11
char szTranspTex[NB_TRANSP_TEX][8]= { "GATMETL","GATMETL2","GATMETL3","GATMETL4","GATMETL5","WDGAT64","WEB1_B","WEB1_F","WEB2_B","WEB2_F",
	"WEB3_M"  };

#endif
GLboolean fn_bTexIsNotTransp(char *szName)
{ int i;

	for (i=0;i<NB_NON_TRANSP_TEX;i++)
		if (!strncmp(szName,szNonTranspTex[i],8))
			return TRUE;
	return FALSE;
}

GLboolean fn_bTexIsTransp(char *szName)
{ int i;
	
	for (i=0;i<NB_TRANSP_TEX;i++)
		if (!strncmp(szName,szTranspTex[i],8))
			return TRUE;
	return FALSE;
}

// MR0709
GLboolean fn_bTextureIsTransp(texture_t *texture)
{ int x,i;
  patch_t *patch;
  GLboolean bExtern,bTransp;

	/*if (texture->width<=256)	// original doom texture are < 256 and original transp texture are in the szTranspTex array.
		return FALSE;*/

	bExtern=FALSE;
	bTransp=FALSE;
	for (i=0;i<texture->patchcount;i++)
	{	patch = W_CacheLumpNum (texture->patches[i].patch, PU_CACHE);
		if (lumpinfo[texture->patches[i].patch].handle!=lumpinfo[0].handle)
			bExtern=TRUE;
		for (x=0;x<SHORT(patch->width);x++)
		{ column_t *p_bColumn_t;
		  byte *p_bColumn;
			
			p_bColumn_t=(column_t *)((byte *)patch+LONG(patch->columnofs[x]));
			if (p_bColumn_t->length!=SHORT(patch->height))
				//return TRUE;
				bTransp=TRUE;
			for ( ; p_bColumn_t->topdelta != 0xff ; )
			{
				p_bColumn=(byte *)p_bColumn_t + 3;
				p_bColumn_t = (column_t *)(  (byte *)p_bColumn_t + p_bColumn_t->length + 4);
			}
		}
	}
	//return FALSE;
	return bTransp & bExtern;
}

GLboolean fn_bWTAlreadyRegistered(int iTexNum)	// MR2606
{ int i;

	for (i=0;i<iNbTexturesInMap;i++)
		if (p_stGLTexArray[i].iTexID==iTexNum)
		return true;
	return false;
}

void fn_vRegisterWallTextures(int iTexNum,texture_t	*texture)
{ int iGLIndex,iU,iV,iFreeSpace,iSubIndex;
  int iGLTexHeight;
  int iGLTexWidth;	// DOOM_GL
  //int i;
	
	if (fn_bWTAlreadyRegistered(iTexNum))
		return;

/*	if (!strncmp(texture->name,"WFALL1",8))
		printf("prout");*/

	//for (i=0 ; i<numtextures ; i++)
	{ 
		iGLIndex=-1;
		
		if (iGLIndex==-1)
		{	iU=0;
			iV=0;
			iGLTexWidth=fn_iGetTexHeightGL(texture->width);
			iGLTexHeight=fn_iGetTexHeightGL(texture->height);

			p_stGLTextures=(GLTexture *)Realloc(p_stGLTextures,sizeof(GLTexture)*(iNbGLTextures+1));
			a_iGLTexTranslation=(int *)Realloc(a_iGLTexTranslation,sizeof(int)*(iNbGLTextures+1));

			//p_stGLTextures[iNbGLTextures].iWidth=texture->width;
			p_stGLTextures[iNbGLTextures].iWidth=iGLTexWidth;
			p_stGLTextures[iNbGLTextures].iHeight=iGLTexHeight;
			p_stGLTextures[iNbGLTextures].p_bRGBBuffer=(unsigned char *)Malloc(iGLTexHeight*iGLTexWidth*4);
			memset(p_stGLTextures[iNbGLTextures].p_bRGBBuffer,0,iGLTexHeight*iGLTexWidth*4);

			p_stGLTextures[iNbGLTextures].a_stSubTex=(GLSubTexture *)Malloc(sizeof(GLSubTexture));
			p_stGLTextures[iNbGLTextures].a_stFreeSpace=(GLSubTexture *)Malloc(sizeof(GLSubTexture));
			p_stGLTextures[iNbGLTextures].iNbSubTextures=0;
			p_stGLTextures[iNbGLTextures].a_stSubTex[0].iU=0;
			p_stGLTextures[iNbGLTextures].a_stSubTex[0].iV=0;
			p_stGLTextures[iNbGLTextures].a_stSubTex[0].iWidth=texture->width;
			p_stGLTextures[iNbGLTextures].a_stSubTex[0].iHeight=texture->height;

			p_stGLTextures[iNbGLTextures].iNbFreeSpace=0;
			iGLIndex=iNbGLTextures++;
			iFreeSpace=0;
		}
					
		{ int x,y;

			iSubIndex=0;
			p_stGLTextures[iGLIndex].a_stSubTex[iSubIndex].bIsNZ=0;

			//fn_vStretchTexture(texture->width,texture->height,texture->width,iGLTexHeight);
			fn_vStretchTexture(texture->width,texture->height,iGLTexWidth,iGLTexHeight);
				
			if (!fn_bTexIsTransp(texture->name)&&!fn_bTextureIsTransp(texture))// MR0709
			{
				for (y=0;y<iGLTexHeight;y++)
				{ byte *p_bColumn;
					
#define Y y
					//for (x=0;x<texture->width;x++)
					for (x=0;x<iGLTexWidth;x++)
					{
						p_bColumn=R_GetColumn(iTexNum,xS[x]);
// MR2506
//						if ((p_bColumn[yS[y]]!=205)||fn_bTexIsNotTransp(texture->name))
						{	p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)]=p_bPalette[p_bColumn[yS[y]]*3];
							p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+1]=p_bPalette[p_bColumn[yS[y]]*3+1];
							p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+2]=p_bPalette[p_bColumn[yS[y]]*3+2];
							p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+3]=255;
						}
// MR2506
/*						else
						{	p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)]=255;
							p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+1]=0;
							p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+2]=0;
							p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+3]=0;
							p_stGLTextures[iGLIndex].a_stSubTex[iSubIndex].bIsNZ=1;
						}*/
					}
				}
#ifdef PALETTED_TEXTURE
				if ((g_bPaletteTexture)&&(!p_stGLTextures[iGLIndex].a_stSubTex[iSubIndex].bIsNZ))
				{
					p_stGLTextures[iGLIndex].p_bRGBBuffer=(unsigned char *)Realloc(p_stGLTextures[iGLIndex].p_bRGBBuffer,iGLTexHeight*iGLTexWidth);
					for (y=0;y<iGLTexHeight;y++)
					{ byte *p_bColumn;
						
						for (x=0;x<iGLTexWidth;x++)
						{
							p_bColumn=R_GetColumn(iTexNum,xS[x]);
							p_stGLTextures[iGLIndex].p_bRGBBuffer[(x+iU)+(Y+iV)*iGLTexWidth]=p_bColumn[yS[y]];
						}
					}
				}
#endif
			}
			else	// tex is transp
			// MR0709
			{ patch_t *patch;
			  int i,j;
			  unsigned char *p_bRGBBuffer1;

				p_stGLTextures[iGLIndex].a_stSubTex[iSubIndex].bIsNZ=1;
				p_bRGBBuffer1=(unsigned char *)Malloc(4*texture->width*texture->height);
				memset(p_bRGBBuffer1,0,4*texture->width*texture->height);
				for (i=0;i<texture->patchcount;i++)
				{	patch = W_CacheLumpNum (texture->patches[i].patch, PU_CACHE);
					for (x=0;x<SHORT(patch->width);x++)
					{ column_t *p_bColumn_t;
					  byte *p_bColumn;
						
						p_bColumn_t=(column_t *)((byte *)patch+LONG(patch->columnofs[x]));
						for ( ; p_bColumn_t->topdelta != 0xff ; )
						{
							p_bColumn=(byte *)p_bColumn_t + 3;

	#undef Y
	#define Y (j+p_bColumn_t->topdelta)

							for (j=0;j<p_bColumn_t->length;j++)
								if ((texture->patches[i].originx+x<texture->width)&&(Y<texture->height))
								{	p_bRGBBuffer1[4*(texture->patches[i].originx+x+Y*texture->width)]=p_bPalette[p_bColumn[j]*3];
									p_bRGBBuffer1[4*(texture->patches[i].originx+x+Y*texture->width)+1]=p_bPalette[p_bColumn[j]*3+1];
									p_bRGBBuffer1[4*(texture->patches[i].originx+x+Y*texture->width)+2]=p_bPalette[p_bColumn[j]*3+2];
									p_bRGBBuffer1[4*(texture->patches[i].originx+x+Y*texture->width)+3]=255;
								}
							p_bColumn_t = (column_t *)(  (byte *)p_bColumn_t + p_bColumn_t->length + 4);
						}
					}
				 }

#undef Y
#define Y y
				for (x=0;x<iGLTexWidth;x++)
				for (y=0;y<iGLTexHeight;y++)
				if ((xS[x]+yS[y]*texture->width)<texture->width*texture->height)
				{	p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)]=p_bRGBBuffer1[4*(xS[x]+yS[y]*texture->width)];
					p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+1]=p_bRGBBuffer1[4*(xS[x]+yS[y]*texture->width)+1];
					p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+2]=p_bRGBBuffer1[4*(xS[x]+yS[y]*texture->width)+2];
					p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+3]=p_bRGBBuffer1[4*(xS[x]+yS[y]*texture->width)+3];
				}

				Free(p_bRGBBuffer1);
			}	// end tex transp
			/*{ patch_t *patch;
			  int j;
			  unsigned char *p_bRGBBuffer1;

				p_stGLTextures[iGLIndex].a_stSubTex[iSubIndex].bIsNZ=1;
				patch = W_CacheLumpNum (texture->patches->patch, PU_CACHE);
				p_bRGBBuffer1=(unsigned char *)Malloc(4*SHORT(patch->width)*SHORT(patch->height));
				memset(p_bRGBBuffer1,0,4*SHORT(patch->width)*SHORT(patch->height));
				for (x=0;x<SHORT(patch->width);x++)
				{ column_t *p_bColumn_t;
				  byte *p_bColumn;
					
					p_bColumn_t=(column_t *)((byte *)patch+patch->columnofs[x]);
					for ( ; p_bColumn_t->topdelta != 0xff ; )
					{
						p_bColumn=(byte *)p_bColumn_t + 3;

#undef Y
#define Y (j+p_bColumn_t->topdelta)

						for (j=0;j<p_bColumn_t->length;j++)
						{	p_bRGBBuffer1[4*(x+Y*SHORT(patch->width))]=p_bPalette[p_bColumn[j]*3];
							p_bRGBBuffer1[4*(x+Y*SHORT(patch->width))+1]=p_bPalette[p_bColumn[j]*3+1];
							p_bRGBBuffer1[4*(x+Y*SHORT(patch->width))+2]=p_bPalette[p_bColumn[j]*3+2];
							p_bRGBBuffer1[4*(x+Y*SHORT(patch->width))+3]=255;
						}
						p_bColumn_t = (column_t *)(  (byte *)p_bColumn_t + p_bColumn_t->length + 4);
					}
				}
				
#undef Y
#define Y y
				for (x=0;x<iGLTexWidth;x++)
				for (y=0;y<iGLTexHeight;y++)
				if ((xS[x]+yS[y]*SHORT(patch->width))<SHORT(patch->width)*SHORT(patch->height))
				{	p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)]=p_bRGBBuffer1[4*(xS[x]+yS[y]*SHORT(patch->width))];
					p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+1]=p_bRGBBuffer1[4*(xS[x]+yS[y]*SHORT(patch->width))+1];
					p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+2]=p_bRGBBuffer1[4*(xS[x]+yS[y]*SHORT(patch->width))+2];
					p_stGLTextures[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+3]=p_bRGBBuffer1[4*(xS[x]+yS[y]*SHORT(patch->width)y)+3];
				}

				Free(p_bRGBBuffer1);
			}	// end tex transp*/

			p_stGLTextures[iGLIndex].iNbSubTextures++;

			a_iGLTexTranslation[iGLIndex]=iGLIndex;

			if (!iNbTexturesInMap)
				p_stGLTexArray=(GLTexArray *)Malloc(++iNbTexturesInMap*sizeof(GLTexArray));
			else
				p_stGLTexArray=(GLTexArray *)Realloc(p_stGLTexArray,++iNbTexturesInMap*sizeof(GLTexArray));
			//for (k=0;k<8;k++)
			//	p_stGLTexArray[iNbTexturesInMap-1].szTexName[k]=texture->name[k];
			p_stGLTexArray[iNbTexturesInMap-1].iTexID=R_TextureNumForName(texture->name);
			p_stGLTexArray[iNbTexturesInMap-1].iFlatID=-1;
			p_stGLTexArray[iNbTexturesInMap-1].iGLTexIndex=iGLIndex;
			p_stGLTexArray[iNbTexturesInMap-1].iUVIndex=iSubIndex;
		}

	}
/*	if (!strncmp(texture->name,"WFALL1",8))
		fn_vSaveRAW("Debug.raw",p_stGLTextures[iGLIndex].p_bRGBBuffer,iGLTexWidth,iGLTexHeight);*/
}

//#pragma optimize( "", on )

//int fn_iGetGLTexturef(char *szTexName,short xOffset,short yOffset,float *fU1,float *fU2,float *fV1,float *fV2,float *fU1Off,float *fV2Off,int *iSubTextIndex)
int fn_iGetGLTexturef(short sTexture,short xOffset,short yOffset,float *fU1,float *fU2,float *fV1,float *fV2,float *fU1Off,float *fV2Off,int *iSubTextIndex)
{ int i,iUVIndex,iGLTexIndex=-1;

	for (i=0;i<iNbTexturesInMap;i++)
	{
		//if (!strncmp(szTexName,p_stGLTexArray[i].szTexName,8))
		if ((p_stGLTexArray[i].iTexID==sTexture)||
			((p_stGLTexArray[i].iTexID==-1)&&(p_stGLTexArray[i].iFlatID==-1)&&(sTexture==-2)))	// Sky
		{
			iGLTexIndex=p_stGLTexArray[i].iGLTexIndex;
			iUVIndex=p_stGLTexArray[i].iUVIndex;
			*iSubTextIndex=iUVIndex;

			if (xOffset>=p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iWidth)
				xOffset=0;
			if (yOffset>=p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iHeight)
				yOffset=0;

// MR0709			
/*			*fU1Off=(float)(p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iU+xOffset)/(float)p_stGLTextures[iGLTexIndex].iWidth;
			*fU1=(float)(p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iU)/(float)p_stGLTextures[iGLTexIndex].iWidth;
			*fU2=(float)(p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iU+p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iWidth)/(float)p_stGLTextures[iGLTexIndex].iWidth;

			*fV1=0.0f;
			*fV2=1.0f;
			*fV2Off=(float)(p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iV+yOffset)/(float)p_stGLTextures[iGLTexIndex].iHeight;*/
			*fU1Off=(float)(p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iU+xOffset)/(float)p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iWidth;
			*fU1=(float)(p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iU)/(float)p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iWidth;
			*fU2=(float)(p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iU+p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iWidth)/(float)p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iWidth;

			*fV1=0.0f;
			*fV2=1.0f;
			*fV2Off=(float)(p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iV+yOffset)/(float)p_stGLTextures[iGLTexIndex].a_stSubTex[iUVIndex].iHeight;

			return iGLTexIndex;
		}
	}
	return iGLTexIndex;
}


//int fn_iGetGLFlatTexturef(char *szTexName)
int fn_iGetGLFlatTexturef(int flattex)
{ int i,iGLTexIndex=-1;

	for (i=0;i<iNbTexturesInMap;i++)
	{
		//if (!strncmp(szTexName,p_stGLTexArray[i].szTexName,8))
		if (p_stGLTexArray[i].iFlatID==flattex)
		{
			iGLTexIndex=p_stGLTexArray[i].iGLTexIndex;

			return iGLTexIndex;
		}
	}
	return iGLTexIndex;
}

#ifdef DOOM_GL
char szSkyName[5][8]={ "SKY1","SKY2", "SKY3", "SKY4", "SKY3" };
#elif GL_HEXEN

extern fixed_t Sky1ScrollDelta;
extern fixed_t Sky2ScrollDelta;
extern int Sky1Texture;
extern int Sky2Texture;
extern fixed_t Sky1ColumnOffset;
extern fixed_t Sky2ColumnOffset;
extern int skyflatnum;
extern int skytexturemid;
extern fixed_t skyiscale;
extern H_boolean DoubleSky;

#else
char szSkyName[6][8]={ "SKY1","SKY2", "SKY3", "SKY1", "SKY3", "SKY1" };
#endif

void fn_vLoadSkyTexture(int episode)
{ texture_t		*texture;
  int skytexture,j,lump;
  int x,y;
  patch_t		*realpatch = NULL;

#ifdef DOOM_GL
    if ( (gamemode == commercial)
	 /*|| ( gamemode == pack_tnt )
	 || ( gamemode == pack_plut ) */)
    {
	skytexture = R_TextureNumForName ("SKY3");
	if (gamemap < 12)
	    skytexture = R_TextureNumForName ("SKY1");
	else
	    if (gamemap < 21)
		skytexture = R_TextureNumForName ("SKY2");
    }
	else
#endif
#ifndef GL_HEXEN
	skytexture = R_TextureNumForName(szSkyName[episode-1]);
#else
	if (episode==1)
	{	skytexture = Sky1Texture;
		GL_Sky1Texture=iNbGLTextures+1;
	}
	else
	{	skytexture = Sky2Texture;
		GL_Sky2Texture=iNbGLTextures+1;
	}
#endif
	texture = textures[skytexture];
	for (j=0 ; j<texture->patchcount ; j++)
	{ 

		lump = texture->patches[j].patch;
		realpatch = W_CacheLumpNum (lump, PU_CACHE);
	}

	p_stGLTextures=(GLTexture *)Realloc(p_stGLTextures,sizeof(GLTexture)*(iNbGLTextures+1));
	a_iGLTexTranslation=(int *)Realloc(a_iGLTexTranslation,sizeof(int)*(iNbGLTextures+1));

	p_stGLTextures[iNbGLTextures].iWidth=TEX_SKY_W;
	p_stGLTextures[iNbGLTextures].iHeight=TEX_SKY_H;

#ifndef GL_HEXEN
	if (g_bPaletteTexture)	// MR1405
#else
	if (g_bPaletteTexture&&
		(!DoubleSky||
		(DoubleSky&&(episode==2))))
#endif
		p_stGLTextures[iNbGLTextures].p_bRGBBuffer=(unsigned char *)Malloc(TEX_SKY_W*TEX_SKY_H);
	else
		p_stGLTextures[iNbGLTextures].p_bRGBBuffer=(unsigned char *)Malloc(TEX_SKY_W*TEX_SKY_H*4);

	p_stGLTextures[iNbGLTextures].a_stSubTex=(GLSubTexture *)Malloc(sizeof(GLSubTexture));
	p_stGLTextures[iNbGLTextures].a_stFreeSpace=(GLSubTexture *)Malloc(sizeof(GLSubTexture));
	p_stGLTextures[iNbGLTextures].iNbSubTextures=1;
	p_stGLTextures[iNbGLTextures].a_stSubTex[0].iU=0;
	p_stGLTextures[iNbGLTextures].a_stSubTex[0].iV=0;
	p_stGLTextures[iNbGLTextures].a_stSubTex[0].iWidth=TEX_SKY_W;
	p_stGLTextures[iNbGLTextures].a_stSubTex[0].iHeight=TEX_SKY_H;
#ifdef GL_HEXEN
	if (DoubleSky&&(episode==1))
		p_stGLTextures[iNbGLTextures].a_stSubTex[0].bIsNZ=1;
	else
#endif
		p_stGLTextures[iNbGLTextures].a_stSubTex[0].bIsNZ=0;

	p_stGLTextures[iNbGLTextures].iNbFreeSpace=0;
	p_stGLTextures[iNbGLTextures].a_stFreeSpace[0].iU=0;
	p_stGLTextures[iNbGLTextures].a_stFreeSpace[0].iV=0;
	p_stGLTextures[iNbGLTextures].a_stFreeSpace[0].iWidth=0;
	p_stGLTextures[iNbGLTextures].a_stFreeSpace[0].iHeight=0;

	for (x=0;x<TEX_SKY_W;x++)
	{ byte *p_bColumn;
		
		p_bColumn=(byte *)realpatch+LONG(realpatch->columnofs[x])+3;
#undef Y
#define Y y
		for (y=0;y<SHORT(realpatch->height);y++)
#ifndef GL_HEXEN
			if (g_bPaletteTexture)	// MR1405
#else
			if (g_bPaletteTexture&&
				(!DoubleSky||
				(DoubleSky&&(episode==2))))
#endif
				p_stGLTextures[iNbGLTextures].p_bRGBBuffer[Y*TEX_SKY_W+x]=p_bColumn[y];
			else
			{	p_stGLTextures[iNbGLTextures].p_bRGBBuffer[4*(Y*TEX_SKY_W+x)]=p_bPalette[p_bColumn[y]*3];
				p_stGLTextures[iNbGLTextures].p_bRGBBuffer[4*(Y*TEX_SKY_W+x)+1]=p_bPalette[p_bColumn[y]*3+1];
				p_stGLTextures[iNbGLTextures].p_bRGBBuffer[4*(Y*TEX_SKY_W+x)+2]=p_bPalette[p_bColumn[y]*3+2];
#ifdef GL_HEXEN
				if (DoubleSky&&(episode==1)&&!p_bColumn[y])
					p_stGLTextures[iNbGLTextures].p_bRGBBuffer[4*(Y*TEX_SKY_W+x)+3]=0;
				else
#endif
					p_stGLTextures[iNbGLTextures].p_bRGBBuffer[4*(Y*TEX_SKY_W+x)+3]=255;
			}
	}

	p_stGLTexArray=(GLTexArray *)Realloc(p_stGLTexArray,++iNbTexturesInMap*sizeof(GLTexArray));
	/*for (k=0;k<8;k++)
		p_stGLTexArray[iNbTexturesInMap-1].szTexName[k]=szSkyName[episode-1][k];*/

	p_stGLTexArray[iNbTexturesInMap-1].iFlatID=-1;
	p_stGLTexArray[iNbTexturesInMap-1].iTexID=-1;
	p_stGLTexArray[iNbTexturesInMap-1].iGLTexIndex=iNbGLTextures++;
	p_stGLTexArray[iNbTexturesInMap-1].iUVIndex=0;
}

#ifdef GL_HEXEN
void fn_vLoadSkyTextures()
{
	fn_vLoadSkyTexture(1);
	//if (DoubleSky)
	if (Sky1Texture!=Sky2Texture)
		fn_vLoadSkyTexture(2);
}
#endif

void fn_vCheckIfTextureIsAnimated(int tex)
{
  int i,j,basepic;
  texture_t	*texture;
  char bAnim=0;

#ifndef GL_HEXEN
	if (fn_bWTAlreadyRegistered(tex))
//		return;
		goto switches;
  
	for(i = 0; animdefs[i].istexture != -1; i++)		// MR (USave: char)
	{
		// DOOM_GL
/*		if((animdefs[i].istexture)&&(R_CheckTextureNumForName(animdefs[i].startname)==tex))
			bAnim=1;
		if((animdefs[i].istexture)&&(R_CheckTextureNumForName(animdefs[i].endname)==tex))
			bAnim=2;
		// MR0906
		if((animdefs[i].istexture)&&(R_CheckTextureNumForName(animdefs[i].endname)>tex)
			&&(R_CheckTextureNumForName(animdefs[i].startname)<tex))
			bAnim=3;*/
		if((animdefs[i].istexture)&&(R_CheckTextureNumForName(animdefs[i].endname)>=tex)
			&&(R_CheckTextureNumForName(animdefs[i].startname)<=tex))
			bAnim=1;
		if (bAnim)
		{	
			lastanim->picnum = R_TextureNumForName(animdefs[i].endname);
			lastanim->basepic = R_TextureNumForName(animdefs[i].startname);

			lastanim->istexture = animdefs[i].istexture;
			lastanim->numpics = lastanim->picnum-lastanim->basepic+1;
			if(lastanim->numpics < 2)
			{
				I_Error("P_InitPicAnims: bad cycle from %s to %s",
					animdefs[i].startname, animdefs[i].endname);
			}
			lastanim->speed = animdefs[i].speed;

			/*basepic=iNbGLTextures-1;
			if (bAnim==1)
				for (j=lastanim->basepic+1;j<lastanim->basepic+lastanim->numpics;j++)
				{	texture = textures[j];
					fn_vRegisterWallTextures(j,texture);
				}
			if (bAnim==2)
				for (j=lastanim->basepic;j<lastanim->basepic+lastanim->numpics-1;j++)
				{	texture = textures[j];
					fn_vRegisterWallTextures(j,texture);
				}
			if (bAnim==3)	// MR0906
				for (j=lastanim->basepic;j<lastanim->basepic+lastanim->numpics;j++)
				{	if (j!=tex)
					{	texture = textures[j];
						fn_vRegisterWallTextures(j,texture);
					}
				}*/
			basepic=iNbGLTextures;
			for (j=lastanim->basepic;j<lastanim->basepic+lastanim->numpics;j++)
			{	texture = textures[j];
				fn_vRegisterWallTextures(j,texture);
			}

			lastanim->basepic = basepic;
			lastanim->picnum = iNbGLTextures-1;

			lastanim++;
			return;
		}
	}
#else	// GL_HEXEN
	animDef_t *ad;

	for (i=0;i<AnimDefCount;i++)
	{	ad = &AnimDefs[i];

		if ((ad->type==1)&&(ad->indexInit==tex))
			bAnim=1;
		/*else
		for (j=ad->startFrameDef;j<ad->endFrameDef;j++)
		{	if (FrameDefs[j].index==tex)
			{	bAnim=1;
				break;
			}
		}*/
		if ((bAnim)&&(ad->indexInit==ad->index))
		{	ad->index=iNbGLTextures-1;
			ad->iAnimPresentInMap=1;

			for (j=ad->startFrameDef;j<=ad->endFrameDef;j++)
				if (FrameDefs[j].index!=tex)
				{
					texture = textures[FrameDefs[j].index];
					fn_vRegisterWallTextures(FrameDefs[j].index,texture);
					FrameDefs[j].index=iNbGLTextures-1;
				}
				else
					FrameDefs[j].index=ad->index;
			return;
		}
	}
#endif	// GL_HEXEN

switches:
	// If switch load other switch position
	for (i = 0;i < MAXSWITCHES;i++)
	{
#ifndef GL_HEXEN
		if (!alphSwitchList[i].episode)
			break;
#endif
		// DOOM_GL
		//if (tex==R_TextureNumForName(alphSwitchList[i].name1))
		if (tex==R_CheckTextureNumForName(alphSwitchList[i].name1))
		{	glSwitchList[i*2]=iNbGLTextures-1;
			texture = textures[R_TextureNumForName(alphSwitchList[i].name2)];
			tex=R_TextureNumForName(alphSwitchList[i].name2);
			fn_vRegisterWallTextures(tex,texture);
			glSwitchList[i*2+1]=iNbGLTextures-1;
		}
		// MR2606
		if (tex==R_CheckTextureNumForName(alphSwitchList[i].name2))
		{	texture = textures[R_TextureNumForName(alphSwitchList[i].name1)];
			if (fn_bWTAlreadyRegistered(R_CheckTextureNumForName(alphSwitchList[i].name1)))
				return;
			glSwitchList[i*2+1]=iNbGLTextures-1;
			tex=R_TextureNumForName(alphSwitchList[i].name1);
			fn_vRegisterWallTextures(tex,texture);
			glSwitchList[i*2]=iNbGLTextures-1;
		}
	}
}

void fn_vCheckIfFlatIsAnimated(int tex)
{
  int i,j,basepic;
  texture_t	*texture;
  char bAnim=0;
#ifndef GL_HEXEN

	for(i = 0; animdefs[i].istexture != -1; i++)		// MR (USave: char)
	{
		// DOOM_GL
		if((!animdefs[i].istexture)&&(W_CheckNumForName(animdefs[i].startname) != -1)&&
			(R_FlatNumForName(animdefs[i].startname)==tex))
			bAnim=1;
		if((!animdefs[i].istexture)&&(W_CheckNumForName(animdefs[i].endname) != -1)&&
			(R_FlatNumForName(animdefs[i].endname)==tex))
			bAnim=2;
		// MR2606
		if((!animdefs[i].istexture)&&
			(W_CheckNumForName(animdefs[i].endname) != -1)&&
			(W_CheckNumForName(animdefs[i].startname) != -1)
			&&(R_FlatNumForName(animdefs[i].endname)>tex)
			&&(R_FlatNumForName(animdefs[i].startname)<tex))
			bAnim=3;
		if (bAnim)
		{	
			lastanim->picnum = R_FlatNumForName(animdefs[i].endname);
			lastanim->basepic = R_FlatNumForName(animdefs[i].startname);

			lastanim->istexture = animdefs[i].istexture;
			lastanim->numpics = lastanim->picnum-lastanim->basepic+1;
			if(lastanim->numpics < 2)
			{
				I_Error("P_InitPicAnims: bad cycle from %s to %s",
					animdefs[i].startname, animdefs[i].endname);
			}
			lastanim->speed = animdefs[i].speed;

			basepic=iNbGLTextures-1;
			// DOOM_GL
			if (bAnim==1)
				for (j=lastanim->basepic+1;j<lastanim->basepic+lastanim->numpics;j++)
				{	texture = textures[j];
					fn_vRegisterFlatTexture(j);
				}
			if (bAnim==2)
				for (j=lastanim->basepic;j<lastanim->basepic+lastanim->numpics-1;j++)
				{	texture = textures[j];
					fn_vRegisterFlatTexture(j);
				}
			if (bAnim==3)	// MR2606
				for (j=lastanim->basepic;j<lastanim->basepic+lastanim->numpics;j++)
				{	if (j!=tex)
					{	texture = textures[j];
						fn_vRegisterFlatTexture(j);
					}
				}
			lastanim->basepic = basepic;
			lastanim->picnum = iNbGLTextures-1;

			lastanim++;
		}
		bAnim=0;
	}
#else	// GL_HEXEN
	animDef_t *ad;

	for (i=0;i<AnimDefCount;i++)
	{	ad = &AnimDefs[i];

		if ((ad->type==0)&&(ad->indexInit==tex))
			bAnim=1;
		/*else
		for (j=ad->startFrameDef;j<ad->endFrameDef;j++)
		{	if (FrameDefs[j].index==tex)
			{	bAnim=1;
				break;
			}
		}*/
		if ((bAnim)&&(ad->indexInit==ad->index))
		{	ad->index=iNbGLTextures-1;
			ad->iAnimPresentInMap=1;

			for (j=ad->startFrameDef;j<=ad->endFrameDef;j++)
				if (FrameDefs[j].index!=tex)
				{
					//texture = textures[FrameDefs[j].index];
					if (!g_bOnTheFly)
						fn_vRegisterFlatTexture(FrameDefs[j].index);
					else
						GL_vRegisterFlatTextureOnTheFly(FrameDefs[j].index);
					FrameDefs[j].index=iNbGLTextures-1;
				}
				else
					FrameDefs[j].index=ad->index;
			return;
		}
	}
#endif	// GL_HEXEN
}

void GL_PurgeTextures()
{
	//(*glDeleteTextures_s) (iNbGLTextures+iNbGLSprites,texobjs);
	(*glDeleteTextures_s) (iNbGLTextures,texobjs);
	(*glDeleteTextures_s) (iNbGLSprites,sprobjs);
}

#ifdef GL_HEXEN
GLint fn_iIsTextureRegistered(int iTexNum)
{ int i;

	for (i=0;i<iNbTexturesInMap;i++)
	{
		if (p_stGLTexArray[i].iTexID==iTexNum)
			return i;
	}
	return -1;
}

GLint GL_vRegisterWallTextureOnTheFly(int iTexNum)
{ texture_t	*texture;
  GLint iTex;

	if ((iTex=fn_iIsTextureRegistered(iTexNum))!=-1)
		return iTex;
	texture=textures[iTexNum];
	fn_vRegisterWallTextures(iTexNum,texture);
	iTex=iNbGLTextures-1;

	texobjs=(GLuint *)Realloc(texobjs,iNbGLTextures*sizeof(GLuint));
	texobjs[iNbGLTextures-1] = iNbGLTextures;

	(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iNbGLTextures-1]);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

	(*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE /*GL_DECAL*/);

#ifdef PALETTED_TEXTURE
	if ((g_bPaletteTexture)&&(!p_stGLTextures[iNbGLTextures-1].a_stSubTex[0].bIsNZ))
	{	(*glColorTableEXT_s) (GL_TEXTURE_2D,GL_RGB8,256,GL_RGB,GL_UNSIGNED_BYTE,p_bPalette);
		(*glTexImage2D_s) (GL_TEXTURE_2D, 0, GL_COLOR_INDEX8_EXT, p_stGLTextures[iNbGLTextures-1].iWidth, p_stGLTextures[iNbGLTextures-1].iHeight, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, p_stGLTextures[iNbGLTextures-1].p_bRGBBuffer);
	}
	else
#endif
	{	(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, p_stGLTextures[iNbGLTextures-1].iWidth, p_stGLTextures[iNbGLTextures-1].iHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, p_stGLTextures[iNbGLTextures-1].p_bRGBBuffer);
	}
	return iTex;
}

// MR0309
GLint fn_iIsFlatTextureRegistered(int iTexNum)
{ int i;

	for (i=0;i<iNbTexturesInMap;i++)
	{
		if (p_stGLTexArray[i].iFlatID==iTexNum)
			return i;
	}
	return -1;
}

GLint GL_vRegisterFlatTextureOnTheFly(int iTexNum)
{ texture_t	*texture;
  GLint iTex;

	if ((iTex=fn_iIsFlatTextureRegistered(iTexNum))!=-1)
		return iTex;
	texture=textures[iTexNum];
	fn_vRegisterFlatTexture(iTexNum);
	iTex=iNbGLTextures-1;

	texobjs=(GLuint *)Realloc(texobjs,iNbGLTextures*sizeof(GLuint));
	texobjs[iNbGLTextures-1] = iNbGLTextures;

	(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iNbGLTextures-1]);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

	(*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE /*GL_DECAL*/);

#ifdef PALETTED_TEXTURE
	if ((g_bPaletteTexture)&&(!p_stGLTextures[iNbGLTextures-1].a_stSubTex[0].bIsNZ))
	{	(*glColorTableEXT_s) (GL_TEXTURE_2D,GL_RGB8,256,GL_RGB,GL_UNSIGNED_BYTE,p_bPalette);
		(*glTexImage2D_s) (GL_TEXTURE_2D, 0, GL_COLOR_INDEX8_EXT, p_stGLTextures[iNbGLTextures-1].iWidth, p_stGLTextures[iNbGLTextures-1].iHeight, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, p_stGLTextures[iNbGLTextures-1].p_bRGBBuffer);
	}
	else
#endif
	{	(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, p_stGLTextures[iNbGLTextures-1].iWidth, p_stGLTextures[iNbGLTextures-1].iHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, p_stGLTextures[iNbGLTextures-1].p_bRGBBuffer);
	}
	return iTex;
}
#endif

#endif // GL_HERETIC
