#ifdef GL_HERETIC

//#define __DOOMTYPE__		// not include doomtype.h

#include <stdio.h>
#include <string.h>
#include <math.h>

#include "gl_syms.h"

#include "gl_struct.h"
#include "gl_mem.h"
#ifndef GL_HEXEN
#include "doomdef.h"
#else
#include "h2def.h"
#endif
#include "r_local.h"
#include "p_spec.h"

extern H_boolean g_bFullScreen;
extern int xS[512],yS[512];
void fn_vStretchTexture(long lWidthS,long lHeightS,long lWidthD,long lHeightD);
extern int iNbGLTextures;
//extern GLuint *texobjs;
extern GLuint *sprobjs;
extern int		numpatches;
extern int iLightLevelMin,iLightLevelMax;
extern byte *p_bPalette;

extern char* mlump_filename;
extern char* wlump_filename;

// sprites
extern GLTexture *p_stGLSprites;
extern int	iNbGLSprites;
extern GLTexArray *p_stGLSprArray;

extern GLboolean g_bDynamicAlloc;

extern int iMaxSizeBeforeReduction;

int xWeapon,yWeapon,iWidthWeapon,iHeightWeapon,iWeaponLump;
float fLightWeapon;

#ifdef WEAP_DRAWPIX
GLTexture *p_stGLWeapons;
int	iNbGLWeapons;
//GLTexArray *p_stGLWeaponArray;

void fn_vAllocWeaponMemory()
{ //int i;

	p_stGLWeapons=(GLTexture *)Malloc(sizeof(GLTexture));
	//p_stMapSprites=(GLMapSprite *)Malloc(sizeof(GLMapSprite));
	//p_stGLWeaponArray=(GLTexArray *)Malloc(numspritelumps*sizeof(GLTexArray));
	//for (i=0;i<numspritelumps;i++)
	//	p_stGLWeaponArray[i].iTexID=-1;
	iNbGLWeapons=0;
}

int fn_vRegisterWeapon(int iSpriteLump,patch_t *patch)
{ int iGLIndex,iSubIndex,iFreeSpace,j,iU,iV,iGLTexWidth,iGLTexHeight;

	if (p_stGLSprArray[iSpriteLump].iTexID!=-1)
		return -1;
	iGLIndex=-1;
	
	if (iGLIndex==-1)
	{	iU=0;
		iV=0;

		p_stGLWeapons=(GLTexture *)Realloc(p_stGLWeapons,sizeof(GLTexture)*(iNbGLWeapons+1));

/*		iGLTexWidth=fn_iGetTexHeightGL(SHORT(patch->width));
		iGLTexHeight=fn_iGetTexHeightGL(SHORT(patch->height));*/
		iGLTexWidth=(int)((float)SHORT(patch->width)*(float)screenwidth/320.0f);
		iGLTexHeight=(int)((float)SHORT(patch->height)*(float)screenheight/200.0f);

		p_stGLWeapons[iNbGLWeapons].iWidth=iGLTexWidth;
		p_stGLWeapons[iNbGLWeapons].iHeight=iGLTexHeight;
		p_stGLWeapons[iNbGLWeapons].p_bRGBBuffer=(unsigned char *)Malloc(iGLTexWidth*iGLTexHeight*4);
		memset(p_stGLWeapons[iNbGLWeapons].p_bRGBBuffer,205,iGLTexWidth*iGLTexHeight*4);

		p_stGLWeapons[iNbGLWeapons].a_stSubTex=(GLSubTexture *)Malloc(1*sizeof(GLSubTexture));
		p_stGLWeapons[iNbGLWeapons].a_stFreeSpace=(GLSubTexture *)Malloc(1*sizeof(GLSubTexture));
		p_stGLWeapons[iNbGLWeapons].iNbSubTextures=1;
		p_stGLWeapons[iNbGLWeapons].a_stSubTex[0].iU=0;
		p_stGLWeapons[iNbGLWeapons].a_stSubTex[0].iV=0;
		p_stGLWeapons[iNbGLWeapons].a_stSubTex[0].iWidth=iGLTexWidth;
		p_stGLWeapons[iNbGLWeapons].a_stSubTex[0].iHeight=iGLTexHeight;
		p_stGLWeapons[iNbGLWeapons].iNbFreeSpace=0;

		iGLIndex=iNbGLWeapons++;
		iFreeSpace=0;
	}
	{ int x;

		iSubIndex=0;

		p_stGLWeapons[iGLIndex].a_stSubTex[iSubIndex].bIsNZ=0;

		fn_vStretchTexture(SHORT(patch->width),SHORT(patch->height),iGLTexWidth,iGLTexHeight);
		for (x=0;x<iGLTexWidth;x++)
		{ column_t *p_bColumn_t;
		  byte *p_bColumn;
			
			p_bColumn_t=(column_t *)((byte *)patch+LONG(patch->columnofs[xS[x]]));
			for ( ; p_bColumn_t->topdelta != 0xff ; )
			{ int length;

				p_bColumn=(byte *)p_bColumn_t + 3;

#undef Y
#define Y j+(int)((float)p_bColumn_t->topdelta*(float)screenheight/200.0f)

				//for (j=0;j<p_bColumn_t->length;j++)
				length=(int)((float)p_bColumn_t->length*(float)screenheight/200.0f);
				for (j=0;j<length;j++)
				{	//if (p_bColumn[yS[j]]!=205)
					if (1)	// DOOM_GL
					{	p_stGLWeapons[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)]=p_bPalette[p_bColumn[yS[j]]*3];
						p_stGLWeapons[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+1]=p_bPalette[p_bColumn[yS[j]]*3+1];
						p_stGLWeapons[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+2]=p_bPalette[p_bColumn[yS[j]]*3+2];
						p_stGLWeapons[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+3]=255;
					}
					else
					{	p_stGLWeapons[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)]=255;
						p_stGLWeapons[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+1]=0;
						p_stGLWeapons[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+2]=0;
						p_stGLWeapons[iGLIndex].p_bRGBBuffer[4*((x+iU)+(Y+iV)*iGLTexWidth)+3]=0;
						p_stGLWeapons[iGLIndex].a_stSubTex[iSubIndex].bIsNZ=1;
					}
				}
				p_bColumn_t = (column_t *)(  (byte *)p_bColumn_t + p_bColumn_t->length + 4);
			}
		}

		p_stGLSprArray[iSpriteLump].iTexID=iSpriteLump;
		p_stGLSprArray[iSpriteLump].iFlatID=-1;
		p_stGLSprArray[iSpriteLump].iGLTexIndex=iGLIndex;
		p_stGLSprArray[iSpriteLump].iUVIndex=iSubIndex;
	}

	//fn_vSaveRAW("weapon.raw",p_stGLWeapons[iGLIndex].p_bRGBBuffer,iGLTexWidth,iGLTexHeight);

	return iGLIndex;
}

void fn_vRegisterWeaponOnTheFly(int iWeaponLump)
{ patch_t *patch;
  //int iOldNbGLSprites,iGLTex;
  //FILE *hFile;

/*	g_bDynamicAlloc=TRUE;
	hFile=fopen(mlump_filename,"a+");
	fprintf(hFile,"%d\n",iSpriteLump);
	fclose(hFile);*/
	patch = W_CacheLumpNum (firstspritelump+iWeaponLump, PU_CACHE);
	fn_vRegisterWeapon(iWeaponLump,patch);
	/*iOldNbGLSprites=iNbGLWeapons;
	iGLTex=fn_vRegisterSprite(iSpriteLump,patch);
	if (iNbGLWeapons==iOldNbGLSprites)
	{	(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iGLTex+iNbGLTextures]);
		(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, p_stGLWeapons[iGLTex].iWidth, p_stGLWeapons[iGLTex].iHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, p_stGLWeapons[iGLTex].p_bRGBBuffer);
		return;
	}
	texobjs=(GLuint *)Realloc(texobjs,(iNbGLTextures+iNbGLWeapons)*sizeof(GLuint));
	texobjs[iNbGLWeapons-1+iNbGLTextures] = iNbGLWeapons+iNbGLTextures;
	
	(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iNbGLWeapons-1+iNbGLTextures]);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
#ifdef BILINEAR
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
#else
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
#endif
	(*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, p_stGLWeapons[iNbGLWeapons-1].iWidth, p_stGLWeapons[iNbGLWeapons-1].iHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, p_stGLWeapons[iNbGLWeapons-1].p_bRGBBuffer);
	
	g_bDynamicAlloc=FALSE;*/
}

GLvoid GLdrawWeapons()
{ int iTexIndex;
  unsigned char *buffer;

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho( (GLdouble) 0, (GLdouble) screenwidth, (GLdouble) 0, (GLdouble) screenheight, (GLdouble) -1.0, (GLdouble) 1.0 );

	(*glDisable_s) (GL_DEPTH_TEST);
	glRasterPos2i(xWeapon,yWeapon);
	(*glEnable_s) (GL_ALPHA_TEST);
	//glAlphaFunc(GL_EQUAL,1.0f);
	glAlphaFunc(GL_NOTEQUAL,0.0f);	// MR1807
	iTexIndex=p_stGLSprArray[iWeaponLump].iGLTexIndex;
	iWidthWeapon=p_stGLWeapons[iTexIndex].iWidth;
	iHeightWeapon=p_stGLWeapons[iTexIndex].iHeight;
	buffer=p_stGLWeapons[iTexIndex].p_bRGBBuffer;
	glDrawPixels(iWidthWeapon,iHeightWeapon,GL_RGBA,GL_UNSIGNED_BYTE,buffer);
	(*glEnable_s) (GL_DEPTH_TEST);
	(*glDisable_s) (GL_ALPHA_TEST);
}
#else	//WEAP_DRAWPIX

#ifdef DOOM_GL
extern int		numflats;
#endif

void fn_vRegisterWeaponOnTheFly(int iWeaponLump)
{ patch_t *patch;
  int iOldNbGLSprites,iGLTex;
  FILE *hFile;
  int iPrevMax;

	g_bDynamicAlloc=TRUE;
	iPrevMax=iMaxSizeBeforeReduction;
	iMaxSizeBeforeReduction=65536;

	/* printf("DEBUG-W: %s\n", wlump_filename); */
	hFile=fopen(wlump_filename,"a+");
	fprintf(hFile,"%d\n",iWeaponLump); fflush(hFile);
	fclose(hFile);
	patch = W_CacheLumpNum (firstspritelump+iWeaponLump, PU_CACHE);
	iOldNbGLSprites=iNbGLSprites;
	iGLTex=fn_vRegisterSprite(iWeaponLump,patch);
	if (iNbGLSprites==iOldNbGLSprites)
	{	//(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iGLTex+iNbGLTextures]);
		(*glBindTexture_s) (GL_TEXTURE_2D, sprobjs[iGLTex]);
		(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, p_stGLSprites[iGLTex].iWidth, p_stGLSprites[iGLTex].iHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, p_stGLSprites[iGLTex].p_bRGBBuffer);
		return;
	}
	//texobjs=(GLuint *)Realloc(texobjs,(iNbGLTextures+iNbGLSprites)*sizeof(GLuint));
	//texobjs[iNbGLSprites-1+iNbGLTextures] = iNbGLSprites+iNbGLTextures;
	sprobjs=(GLuint *)Realloc(sprobjs,iNbGLSprites*sizeof(GLuint));
	sprobjs[iNbGLSprites-1] = iNbGLSprites+numflats+numpatches;
	
	//(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iNbGLSprites-1+iNbGLTextures]);
	(*glBindTexture_s) (GL_TEXTURE_2D, sprobjs[iNbGLSprites-1]);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
#ifdef BILINEAR
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
#else
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	(*glTexParameterf_s) (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
#endif
	(*glTexEnvf_s) (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE /*GL_DECAL*/);

	(*glTexImage2D_s) (GL_TEXTURE_2D, 0, 4, p_stGLSprites[iNbGLSprites-1].iWidth, p_stGLSprites[iNbGLSprites-1].iHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, p_stGLSprites[iNbGLSprites-1].p_bRGBBuffer);
	
	g_bDynamicAlloc=FALSE;

	iMaxSizeBeforeReduction=iPrevMax;
}

GLvoid GLdrawWeapons()
{ int iTexIndex,iSubIndex;
  float fU1,fU2,fV1,fV2;
  patch_t *patch;

/*	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho( (GLdouble) 0, (GLdouble) screenwidth, (GLdouble) 0, (GLdouble) screenheight, (GLdouble) -1.0, (GLdouble) 1.0 );

	(*glDisable_s) (GL_DEPTH_TEST);
	(*glEnable_s) (GL_ALPHA_TEST);
	glAlphaFunc(GL_EQUAL,1.0f);*/

	if (screenwidth<=512)
		yWeapon-=8;		// Anti-bug
	else
	if (screenwidth<=640)
		yWeapon-=21;		// Anti-bug
	else
	if (screenwidth<=800)
		yWeapon-=40;
	else
		yWeapon-=60;
	if (!g_bFullScreen)		// MR2204
		yWeapon-=60;
	if (p_stGLSprArray[iWeaponLump].iTexID==-1)
		fn_vRegisterWeaponOnTheFly(iWeaponLump);
	iTexIndex=p_stGLSprArray[iWeaponLump].iGLTexIndex;
	iSubIndex=p_stGLSprArray[iWeaponLump].iUVIndex;
	
	patch = W_CacheLumpNum (firstspritelump+iWeaponLump, PU_CACHE);
	iWidthWeapon=(int)((float)SHORT(patch->width)*(float)screenwidth/320.0f);
	iHeightWeapon=(int)((float)SHORT(patch->height)*(float)screenheight/200.0f);
	/*iWidthWeapon=(int)((float)p_stGLSprites[iTexIndex].a_stSubTex[iSubIndex].iWidth*(float)screenwidth/320.0f);
	iHeightWeapon=(int)((float)p_stGLSprites[iTexIndex].a_stSubTex[iSubIndex].iHeight*(float)screenheight/200.0f);*/

	fU1=(float)(p_stGLSprites[iTexIndex].a_stSubTex[iSubIndex].iU+p_stGLSprites[iTexIndex].a_stSubTex[iSubIndex].iWidth)/(float)p_stGLSprites[iTexIndex].iWidth;
	fU2=(float)p_stGLSprites[iTexIndex].a_stSubTex[iSubIndex].iU/(float)p_stGLSprites[iTexIndex].iWidth;
	fV1=(float)p_stGLSprites[iTexIndex].a_stSubTex[iSubIndex].iV/(float)p_stGLSprites[iTexIndex].iHeight;
	fV2=(float)(p_stGLSprites[iTexIndex].a_stSubTex[iSubIndex].iV+p_stGLSprites[iTexIndex].a_stSubTex[iSubIndex].iHeight)/(float)p_stGLSprites[iTexIndex].iHeight;

	//(*glBindTexture_s) (GL_TEXTURE_2D, texobjs[iTexIndex+iNbGLTextures]);
	(*glBindTexture_s) (GL_TEXTURE_2D, sprobjs[iTexIndex]);

#ifndef GL_HEXEN
    if (viewplayer->powers[pw_invisibility] > 4*32	//DOOM_GL
	|| viewplayer->powers[pw_invisibility] & 8)
	{	//glAlphaFunc(GL_EQUAL,0.5f);
		(*glEnable_s) (GL_BLEND);
		(*glBlendFunc_s) (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	}
	//else
		//glAlphaFunc(GL_EQUAL,1.0f);
#endif	// GL_HEXEN

	(*glBegin_s) (GL_QUADS);
	//glNormal3f(0.0f,0.0f,1.0f);
#ifndef GL_HEXEN
		if (viewplayer->powers[pw_invisibility] > 4*32	//DOOM_GL
		|| viewplayer->powers[pw_invisibility] & 8)
			GL_StaticLight4f(fLightWeapon,fLightWeapon,fLightWeapon,0.5f);
		else
#endif	// GL_HEXEN
			GL_StaticLight3f(fLightWeapon,fLightWeapon,fLightWeapon);

		/*(*glTexCoord2f_s) (fU2, fV1); glVertex2i( xWeapon, screenheight-1-yWeapon );
		(*glTexCoord2f_s) (fU2, fV2); glVertex2i( xWeapon, screenheight-1-yWeapon-iHeightWeapon );
		(*glTexCoord2f_s) (fU1, fV2); glVertex2i( xWeapon+iWidthWeapon, screenheight-1-yWeapon-iHeightWeapon );
		(*glTexCoord2f_s) (fU1, fV1); glVertex2i( xWeapon+iWidthWeapon, screenheight-1-yWeapon );*/
		// vertex2f for 3dfx minigl...
		(*glTexCoord2f_s) (fU2, fV1); (*glVertex2f_s) ( (float)xWeapon, (float)(screenheight-1-yWeapon) );
		(*glTexCoord2f_s) (fU2, fV2); (*glVertex2f_s) ( (float)xWeapon, (float)(screenheight-1-yWeapon-iHeightWeapon) );
		(*glTexCoord2f_s) (fU1, fV2); (*glVertex2f_s) ( (float)(xWeapon+iWidthWeapon), (float)(screenheight-1-yWeapon-iHeightWeapon) );
		(*glTexCoord2f_s) (fU1, fV1); (*glVertex2f_s) ( (float)(xWeapon+iWidthWeapon), (float)(screenheight-1-yWeapon) );
	(*glEnd_s) ();

#ifndef GL_HEXEN
    if (viewplayer->powers[pw_invisibility] > 4*32	//DOOM_GL
	|| viewplayer->powers[pw_invisibility] & 8)
	{	(*glDisable_s) (GL_BLEND);
		//glAlphaFunc(GL_EQUAL,1.0f);
	}
#endif	// GL_HEXEN
	
/*	(*glEnable_s) (GL_DEPTH_TEST);
	(*glDisable_s) (GL_ALPHA_TEST);*/
}
#endif	//WEAP_DRAWPIX

#endif // GL_HERETIC
