/*
$Id: gmcal.c,v 1.1.1.1 1999/12/02 08:00:57 zircote Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <string.h>
#include <pwd.h>
#include <getopt.h>

#include <malloc.h>
#include <gtk/gtk.h>
#include <gtk/gtkcalendar.h>
#include <mcal.h>
#include "gmcal.h"

unsigned long *eventlist=NULL;
int eventlistcapacity=0;
int eventlistsize=0;
char myuser[80];
char *mypass;
char version;
char hostname[1000];
const char *months[]={NULL,"January","February","March","April","May","June","July","August","September","October","November","December"};


/* This is a callback function. The data arguments are ignored
 * in this example. More on callbacks below. */
void hello( GtkWidget *widget,
	    gpointer   data )
{
  g_print ("Hello World\n");
}

gint delete_event( GtkWidget *widget,
		   GdkEvent  *event,
		   gpointer   data )
{
  /* If you return FALSE in the "delete_event" signal handler,
   * GTK will emit the "destroy" signal. Returning TRUE means
   * you don't want the window to be destroyed.
   * This is useful for popping up 'are you sure you want to quit?'
   * type dialogs. */

  g_print ("delete event occurred\n");

  /* Change TRUE to FALSE and the main window will be destroyed with
   * a "delete_event". */

  return(TRUE);
}

/* Another callback */
void destroy( GtkWidget *widget,
	      gpointer   data )
{
  gtk_main_quit();
}

void selected( GtkWidget *widget,
	       gpointer   data )
{
  GtkWidget *day,*text;
  GtkCalendar *cal;
  int i,date,month,year;
  datetime_t startdate=DT_INIT,enddate=DT_INIT;
  CALSTREAM *stream;
  char buffer[1024];
  CALEVENT *event;

  cal=GTK_CALENDAR(widget);
  g_print ("date selected %d\n",cal->selected_day);
  day = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  text= gtk_text_new(NULL,NULL);
  gtk_container_add (GTK_CONTAINER (day), text);
  stream=cal_open(NULL,hostname,0);
  if(!stream) printf("Arghh!!! couldnt log in! \n");
  date=GTK_CALENDAR(widget)->selected_day;
  month=GTK_CALENDAR(widget)->month;
  year=GTK_CALENDAR(widget)->year;

  sprintf(buffer,"     %s %2d %d\n",months[month],date,year);

  dt_setdate(&enddate,year,month,date);
  dt_setdate(&startdate,year,month,date);
  gtk_text_insert( GTK_TEXT(text),NULL,NULL,NULL,buffer,-1);
  cal_search_range(stream,&startdate,&enddate);
  for(i=0;i<eventlistsize;i++)
    {
      gtk_text_insert( GTK_TEXT(text),NULL,NULL,NULL,
		       "\n---------------------------------------------\n",-1);
      cal_fetch(stream,eventlist[i],&event);
      gtk_text_insert( GTK_TEXT(text),NULL,NULL,NULL,"Title:",-1);
      gtk_text_insert( GTK_TEXT(text),NULL,NULL,NULL,event->title,-1);
      gtk_text_insert( GTK_TEXT(text),NULL,NULL,NULL,"\n",-1);
      gtk_text_insert( GTK_TEXT(text),NULL,NULL,NULL,"Category:",-1);
      gtk_text_insert( GTK_TEXT(text),NULL,NULL,NULL,event->category,-1);
      gtk_text_insert( GTK_TEXT(text),NULL,NULL,NULL,"\n",-1);
      gtk_text_insert( GTK_TEXT(text),NULL,NULL,NULL,"Public:",-1);
      gtk_text_insert( GTK_TEXT(text),NULL,NULL,NULL,event->public ? "Yes" : "No",-1);
      gtk_text_insert( GTK_TEXT(text),NULL,NULL,NULL,"\n",-1);
      gtk_text_insert( GTK_TEXT(text),NULL,NULL,NULL,"Start:",-1);
      sprintf(buffer,"%s %d %d - %d:%02d:%02d\n",months[event->start.mon],event->start.mday,event->start.year,event->start.hour,event->start.min,event->start.sec);

      calevent_free(event);
    }
  free(eventlist);
  eventlistcapacity=0;
  eventlistsize=0;
  eventlist=NULL;
  gtk_widget_show (text);
  gtk_widget_show (day);
  cal_close(stream,0);
}

void month_change( GtkWidget *widget,
		   gpointer   data )
{
  GtkCalendar *cal;
  int i;
  int year;
  int month;

  CALEVENT *event;

  CALSTREAM *stream;
  datetime_t start_date=DT_INIT,end_date=DT_INIT;
  gtk_calendar_clear_marks(GTK_CALENDAR(widget));
  cal=GTK_CALENDAR(widget);
  g_print ("month changed %d\n",cal->month);
  stream=cal_open(NULL,hostname,0);
  dt_setdate(&start_date,GTK_CALENDAR(widget)->year,GTK_CALENDAR(widget)->month,1);
  dt_setdate(&end_date,GTK_CALENDAR(widget)->year,GTK_CALENDAR(widget)->month,daysinmonth(GTK_CALENDAR(widget)->month,isleapyear(GTK_CALENDAR(widget)->year)));

  cal_search_range(stream,&start_date,&end_date);

  for(i=0;i<eventlistsize;i++)
    {
      cal_fetch(stream,eventlist[i],&event);
      if(event->recur_type!=RECUR_NONE)
	{
	  datetime_t clamp = start_date;
	  calevent_next_recurrence(event,&clamp,SUNDAY);
	  while(dt_hasdate(&clamp) && clamp.year == year && clamp.mon == month)
	    {
	      g_print ("Got Date %d\n",clamp.mday);
	      gtk_calendar_mark_day(GTK_CALENDAR(widget),clamp.mday);
	      clamp.mday++;
	      if(clamp.mday > end_date.mday)
		break;
	      calevent_next_recurrence(event,&clamp,SUNDAY);
	    }
	}
      else {
	g_print ("Got Date %d\n",event->start.mday);
	gtk_calendar_mark_day(GTK_CALENDAR(widget),event->start.mday);
      }
      calevent_free(event);
    }
  free(eventlist);
  eventlistcapacity=0;
  eventlistsize=0;
  eventlist=NULL;
  cal_close(stream,0);

}


int main( int   argc, char *argv[] )
{
	int c;
	GtkWidget *window;
	GtkWidget *button;
  	char *ptr;
    while (1)
	    {
	      int option_index = 0;
	      static struct option long_options[] =
	      {
			{"version", 0, 0, 'v'},
			{"help", 0, 0, 'h'},
			{0, 0, 0, 0}
      	  };

        c = getopt_long (argc, argv, ":hv",
  		       long_options, &option_index);
        if (c == -1)
  	break;

        switch (c)
         {
		 case 'h':
		   	printf("Usage: %s [-h] [-v]\n\n",argv[0]);
			printf("\t-v current version\n");
	 		printf("\t-h this outputs this dialog\n");
		   	exit(0);
  	 			break;
         case 'v':
  	 		printf("GMCAL Version %s\n",GMCAL_VER);
  	 		printf("\tLicensed Under GPL\n");
  	 		printf("\thttp://mcal.chek.com\n");
  	 		printf("\tMark Musone musone@edgeglobal.com\n\n");
  	 		exit(0);
  	 			break;
         }

   }

  /* GtkWidget is the storage type for widgets
  GtkWidget *window;
  GtkWidget *button;
  char *ptr;*/
  /* This is called in all GTK applications. Arguments are parsed
   * from the command line and are returned to the application. */
  gtk_init(&argc, &argv);

  /* create a new window */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  /* When the window is given the "delete_event" signal (this is given
   * by the window manager, usually by the "close" option, or on the
   * titlebar), we ask it to call the delete_event () function
   * as defined above. The data passed to the callback
   * function is NULL and is ignored in the callback function. */
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (delete_event), NULL);

  /* Here we connect the "destroy" event to a signal handler.
   * This event occurs when we call gtk_widget_destroy() on the window,
   * or if we return FALSE in the "delete_event" callback. */
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (destroy), NULL);

  /* Sets the border width of the window. */

  /* Creates a new button with the label "Hello World". */
  button=gtk_calendar_new();

  gtk_container_add (GTK_CONTAINER (window), button);
  /* When the button receives the "clicked" signal, it will call the
   * function hello() passing it NULL as its argument.  The hello()
   * function is defined above. */
  gtk_signal_connect (GTK_OBJECT (button), "day_selected_double_click",
		      GTK_SIGNAL_FUNC (selected), NULL);
  gtk_signal_connect (GTK_OBJECT (button), "month_changed",GTK_SIGNAL_FUNC(month_change),NULL);

  /* This will cause the window to be destroyed by calling
   * gtk_widget_destroy(window) when "clicked".  Again, the destroy
   * signal could come from here, or the window manager. */
  printf("Calendar Store (eg {icap.chek.com} or {/mstore}: ");
  fgets(hostname,900,stdin);
  printf("Username: ");
  fgets(myuser,80,stdin);
  ptr=strchr(myuser,'\n');
  if(ptr) *ptr=0x00;
  else printf("max of 80 chars!\n");
  mypass=getpass("Password:");

  month_change(button,NULL);
  gtk_widget_show (button);
  /* This packs the button into the window (a gtk container). */

  /* The final step is to display this newly created widget. */

  /* and the window */
  gtk_widget_show (window);

  /* All GTK applications must have a gtk_main(). Control ends here
   * and waits for an event to occur (like a key press or
   * mouse event). */
  gtk_main ();

  return(0);
}
/* example-end */


/* Called when a stream driver requires a username/password.  It is
 * only called during cal_open().
 */
void            cc_login(const char **username, const char **password)
{
  *username=myuser;
  *password=mypass;
}

/* Called whenever an ID is returned by the cal_search family of
 * routines.
 */
void            cc_searched(unsigned long id)
{
  if(eventlistsize == eventlistcapacity)
    {
      if(eventlistcapacity==0)
        {
          eventlistcapacity=8;
        }
      eventlistcapacity <<=1;
    }
  eventlist=realloc(eventlist,eventlistcapacity*sizeof(*eventlist));
  eventlist[eventlistsize++]=id;
}

/* normal system logging */
void            cc_vlog(const char *fmt, va_list ap)
{
}

/* debug logging */
void            cc_vdlog(const char *fmt, va_list ap)
{
}

