# Copyright (C) 2005 Michael Gebhart
# 
# This file is part of Gnome-Art.
#
# Gnome-Art is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# Gnome-Art is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Gnome-Art; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

module GnomeArt

  Version = "0.2"
  Title = "GNOME artwork & themes"

  def self.init_directories

    current_path = Dir.pwd

    Dir.chdir()

    file = GnomeArt::Config::Gnome_dir
    if (!FileTest.exist?(file) || !FileTest.directory?(file))
      puts "Create gnome-folder"

      Dir.mkdir(file)   
    end

    Dir.chdir(file)


    file = GnomeArt::Config::Gnome_backgrounds
    if (!FileTest.exist?(file))
      puts "Create Backgrounds-File"
      backgrounds_file = File.new(file, File::CREAT|File::TRUNC|File::RDWR, 0644)
  
      new_backgrounds_file = "<?xml version=\"1.0\"?>\n<!DOCTYPE wallpapers SYSTEM \"gnome-wp-list.dtd\">\n<wallpapers>\n</wallpapers>\n"

      backgrounds_file.write(new_backgrounds_file)
    
      backgrounds_file.close
      
    end


    file = GnomeArt::Config::Program_dir
    if (!FileTest.exist?(file) || !FileTest.directory?(file))
      puts "Create program-folder"
      Dir.mkdir(file)   
    end

    Dir.chdir(file)

    #Thumbnails
    file = "thumbnails"
    if (!FileTest.exist?(file) || !FileTest.directory?(file))
      puts "Create thumbnail-folder"
      Dir.mkdir(file)   
    end

    #Temporary files
    file = "tmp"
    if (!FileTest.exist?(file) || !FileTest.directory?(file))
      puts "Create temp-folder"
      Dir.mkdir(file)   
    end

    #Downloaded files
    file = "download"
    if (!FileTest.exist?(file) || !FileTest.directory?(file))
      puts "Create download-folder"
      Dir.mkdir(file)   
    end

    Dir.chdir(file)


    Config::Category_dirs.each { | key, value |
      file = value
      if (!FileTest.exist?(file) || !FileTest.directory?(file))
        puts "Create #{value}-folder"
        Dir.mkdir(file)   
      end
    }

    Dir.chdir(file)

    Dir.chdir(current_path)

  end


  def self.delete_temporary_files
    #delete temporary files
    current_path = Dir.pwd

    Dir.chdir(Config::Temp_dir)
    Dir["*"].each { |filename| File.delete(filename)}

    Dir.chdir(current_path)
  end


  def self.delete_cached_files
    #delete cached files
    current_path = Dir.pwd

    Dir.chdir(Config::Thumbnail_dir)
    Dir["*"].each { |filename| File.delete(filename)}

    Dir.chdir(current_path)

    delete_temporary_files
  end


	def self.main
    Gtk.init

    init_directories
    
    main_window = MainWindow.new(self)

    Gtk.main

    delete_temporary_files
  
	end

end



