/*
  GNOME Commander - A GNOME based file manager 
  Copyright (C) 2001-2003 Marcus Bjurman

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"
#include "useractions.h"
#include "gnome-cmd-main-win-funcs.h"
#include "gnome-cmd-file-funcs.h"
#include "gnome-cmd-dir-funcs.h"
#include "gnome-cmd-file-selector-funcs.h"
#include "gnome-cmd-file-list.h"
#include "cap.h"
#include "gnome-cmd-prepare-copy-dialog.h"
#include "gnome-cmd-prepare-move-dialog.h"
#include "gnome-cmd-data.h"
#include "gnome-cmd-search-dialog.h"
#include "gnome-cmd-connection-funcs.h"
#include "gnome-cmd-options-dialog.h"
#include "gnome-cmd-bookmark-dialog.h"
#include "gnome-cmd-ftp-dialog.h"
#include "utils.h"


static GnomeCmdFileList *get_current_fl ()
{
	GnomeCmdFileSelector *fs = gnome_cmd_main_win_get_active_fs (main_win);

	if (fs) return fs->list;
	return NULL;
}


static GnomeCmdFileSelector *get_current_fs ()
{
	return gnome_cmd_main_win_get_active_fs (main_win);
}


/**
 * The file returned from this function is not to be unrefed
 */
static GnomeCmdFile *
get_selected_file ()
{
	GnomeCmdFile *finfo = gnome_cmd_file_list_get_selected_file (get_current_fl ());
	
	if (!finfo)
		gnome_error_dialog ("No file selected");
	return finfo;
}



/************** File Menu **************/
void
file_cap_cut                        (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_cap_cut (get_current_fl ());
}


void
file_cap_copy                       (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_cap_copy (get_current_fl ());
}


void
file_cap_paste                      (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_selector_cap_paste (get_current_fs ());
}


void
file_copy                           (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	GnomeCmdFileList *src_fl;
	GnomeCmdFileSelector *dest_fs;

	if (main_win) {
		src_fl = get_current_fl ();
		dest_fs = gnome_cmd_main_win_get_inactive_fs (main_win);
		
		if (src_fl && dest_fs)
			gnome_cmd_prepare_copy_dialog_show (src_fl, dest_fs);
	}
}


void
file_move                           (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	GnomeCmdFileList *src_fl;
	GnomeCmdFileSelector *dest_fs;

	if (main_win) {
		src_fl = get_current_fl ();
		dest_fs = gnome_cmd_main_win_get_inactive_fs (main_win);
		
		if (src_fl && dest_fs)
			gnome_cmd_prepare_move_dialog_show (src_fl, dest_fs);
	}
}


void
file_delete                         (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_show_delete_dialog (get_current_fl ());
}


void
file_view                           (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_view (get_current_fl ());
}


void
file_edit                           (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_edit (get_current_fl ());
}


void
file_chmod                          (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_show_chmod_dialog (get_current_fl ());
}


void
file_chown                          (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_show_chown_dialog (get_current_fl ());
}


void
file_mkdir                          (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_selector_show_mkdir_dialog (get_current_fs ());
}


void
file_create_symlink                 (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	GnomeCmdFile *finfo = gnome_cmd_file_list_get_focused_file (get_current_fl ());
	gnome_cmd_file_selector_create_symlink (
		gnome_cmd_main_win_get_inactive_fs (main_win), finfo);
}


void
file_rename                         (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_show_rename_dialog (get_current_fl ());
}


void
file_advrename                      (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{	
	gnome_cmd_file_list_show_advrename_dialog (get_current_fl ());
}


void
file_properties                     (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_show_properties_dialog (get_current_fl ());
}


void
file_diff                           (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	GnomeCmdFile *finfo = get_selected_file ();

	if (finfo)
	{
		GList *tmp;
		GList *all_files = gnome_cmd_file_list_get_all_files (
			GNOME_CMD_FILE_LIST (gnome_cmd_main_win_get_inactive_fs (main_win)->list));
		tmp = all_files;

		/**
		 * Go through all the files in the other list until we find one with the same name
		 */
		while (tmp)
		{
			GnomeCmdFile *finfo2 = (GnomeCmdFile*)tmp->data;

			if (strcmp (gnome_cmd_file_get_name (finfo),
						gnome_cmd_file_get_name (finfo2)) == 0)
			{
				gchar *cmd = g_strdup_printf (gnome_cmd_data_get_differ (),
											  gnome_cmd_file_get_path (finfo),
											  gnome_cmd_file_get_path (finfo2));

				run_command (cmd, FALSE);
				g_print (_("running \"%s\"\n"), cmd);
				g_free (cmd);
			}
			tmp = tmp->next;
		}
	}
}


void
file_umount                        (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	GnomeCmdConnection *c1, *c2, *home;
	GnomeCmdFileSelector *active, *inactive;

	active = gnome_cmd_main_win_get_active_fs (main_win);
	inactive = gnome_cmd_main_win_get_inactive_fs (main_win);
	
	c1 = gnome_cmd_file_selector_get_connection (active);
	c2 = gnome_cmd_file_selector_get_connection (inactive);
	home = gnome_cmd_connection_get_home ();
	
	gnome_cmd_file_selector_set_connection (active, home, NULL);
	if (c1 == c2)
		gnome_cmd_file_selector_set_connection (inactive, home, NULL);

	if (c1->type == CON_TYPE_DEV)
		gnome_cmd_connection_umount (c1);
	else
		gnome_cmd_connection_free (c1);
}


void
file_exit                           (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gtk_main_quit ();
}


/************** Edit Menu **************/
void
edit_search                         (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	GnomeCmdFileSelector *fs = get_current_fs ();
	GnomeCmdConnection *con = gnome_cmd_file_selector_get_connection (fs);
	GtkWidget *dialog =
		gnome_cmd_search_dialog_new (
			gnome_cmd_connection_get_baseuri (con),
			gnome_cmd_file_selector_get_directory (fs));
	
	gtk_widget_ref (dialog);
	gtk_object_set_data_full (
		GTK_OBJECT (main_win), "gnome_cmd_search_dialog", dialog,
				(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog);
}


void
edit_quick_search                   (GtkMenuItem     *menuitem,
 								     gpointer        not_used)
{
	gnome_cmd_file_list_show_quicksearch (get_current_fl (), 0);
}


/************** Mark Menu **************/
void
mark_toggle                         (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_toggle (get_current_fl ());
}


void
mark_toggle_and_step                (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_toggle_and_step (get_current_fl ());	
}


void
mark_select_all                     (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_select_all (get_current_fl ());
}


void
mark_unselect_all                   (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_unselect_all (get_current_fl ());
}


void
mark_select_with_pattern            (GtkMenuItem    *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_show_selpat_dialog (get_current_fl (), TRUE);
}


void
mark_unselect_with_pattern            (GtkMenuItem    *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_show_selpat_dialog (get_current_fl (), FALSE);
}


void
mark_invert_selection                 (GtkMenuItem    *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_invert_selection (get_current_fl ());
}


void
mark_select_all_with_same_extension   (GtkMenuItem    *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_select_all_with_same_extension (get_current_fl ());
}


void
mark_unselect_all_with_same_extension   (GtkMenuItem    *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_unselect_all_with_same_extension (get_current_fl ());
}


void
mark_restore_selection                 (GtkMenuItem    *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_file_list_restore_selection (get_current_fl ());
}


/************** View Menu **************/

void
view_toolbar                           (GtkCheckMenuItem     *menuitem,
 							            gpointer              not_used)
{
	if (!GTK_WIDGET_REALIZED (main_win))
		return;
	gnome_cmd_main_win_set_toolbar_visibility (
		main_win, menuitem->active);
}


void
view_buttonbar                         (GtkCheckMenuItem     *menuitem,
 							            gpointer              not_used)
{
	if (!GTK_WIDGET_REALIZED (main_win))
		return;
	gnome_cmd_main_win_set_buttonbar_visibility (
		main_win, menuitem->active);
}


void
view_back                              (GtkMenuItem     *menuitem,
										gpointer        not_used)
{
	gnome_cmd_file_selector_back (get_current_fs ());
}


void
view_forward                           (GtkMenuItem     *menuitem,
										gpointer        not_used)
{
	gnome_cmd_file_selector_forward (get_current_fs ());
}


void
view_refresh                           (GtkMenuItem     *menuitem,
										gpointer        not_used)
{
	gnome_cmd_file_selector_reload (get_current_fs ());
}


/************** Options Menu **************/
void
options_edit                        (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	GtkWidget *dialog = gnome_cmd_options_dialog_new ();
	gtk_widget_ref (dialog);
	gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (main_win));
	gtk_widget_show (dialog);
}


void
options_edit_mime_types             (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	run_command ("gnomecc --capplet=file-types-capplet", FALSE);
}


void
options_save_position               (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_data_save_position ();
}



/************** FTP Menu **************/
void
ftp_connect                         (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	GtkWidget *dialog = gnome_cmd_ftp_dialog_new ();
	gtk_widget_ref (dialog);
	gtk_object_set_data_full (
		GTK_OBJECT (main_win), "gnome_cmd_ftp_dialog", dialog,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog);
}


void
ftp_quick_connect                   (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	show_ftp_quick_connect_dialog ();
}


void
ftp_disconnect                      (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	GnomeCmdConnection *con =
		gnome_cmd_file_selector_get_connection (get_current_fs ());

	if (con->type == CON_TYPE_FTP) {
		GnomeCmdFileSelector *fs;
		
		fs = gnome_cmd_main_win_get_right_fs (main_win);
		if (gnome_cmd_file_selector_get_connection (fs) == con)
			gnome_cmd_file_selector_set_connection (
				fs, gnome_cmd_connection_get_home (), NULL);

		fs = gnome_cmd_main_win_get_left_fs (main_win);
		if (gnome_cmd_file_selector_get_connection (fs) == con)
			gnome_cmd_file_selector_set_connection (
				fs, gnome_cmd_connection_get_home (), NULL);
		
		gnome_cmd_connection_free (con);
	}
}



/************** Bookmarks Menu **************/

void
bookmarks_add_current               (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gnome_cmd_bookmark_add_current ();
}


void
bookmarks_edit                      (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	GtkWidget *dialog = gnome_cmd_bookmark_dialog_new ();
	gtk_widget_ref (dialog);
	gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (main_win));
	gtk_widget_show (dialog);
}



/************** Help Menu **************/

void
help_help                           (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gchar *url = g_strdup_printf("file:%s/C/index.html", HELP_DIR);

	gnome_help_goto (NULL, url);	
	g_free(url);	
}


void
help_about                          (GtkMenuItem     *menuitem,
                                     gpointer        not_used)
{
	gchar *authors[] = {
		"Marcus Bjurman <marbj499@student.liu.se>",
		"Piotr Eljasiak <epiotr@use.pl>",
		NULL
	};

	GtkWidget *dialog = gnome_about_new (
		"Gnome Commander",
		VERSION,
		"Copyright: All contributors 2001-2003",
		(const gchar**)authors,
		"This is a GPL licensed program",
		NULL);

	gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
	gtk_widget_ref (dialog);
	gtk_object_set_data_full (
		GTK_OBJECT (main_win), "about_dialog", dialog,
		(GtkDestroyNotify) gtk_widget_unref);

	gtk_widget_show (dialog);
}
