/*
  GNOME Commander - A GNOME based file manager 
  Copyright (C) 2001-2003 Marcus Bjurman

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_CONNECTION_FUNCS_H__
#define __GNOME_CMD_CONNECTION_FUNCS_H__

#include "gnome-cmd-connection-types.h"
#include "gnome-cmd-dir-types.h"
#include "imageloader.h"

GList*
gnome_cmd_connection_get_list (void);

void
gnome_cmd_connection_add (GnomeCmdConnection *con);

void
gnome_cmd_connection_free (GnomeCmdConnection *con);

void
gnome_cmd_connection_free_all (void);

GnomeCmdConnection*
gnome_cmd_connection_new_ftp (const gchar *alias,
							  const gchar *host,
							  gshort port,
							  const gchar *user,
							  const gchar *pw,
							  const gchar *start_dir);

GnomeCmdConnection*
gnome_cmd_connection_new_ftp_from_server (GnomeCmdFtpServer *server,
										  const gchar *start_dir);

void
gnome_cmd_connection_create_local (void);

void
gnome_cmd_connection_create_devices (void);

GnomeCmdConnection*
gnome_cmd_connection_get_home (void);

GnomeCmdConnection*
gnome_cmd_connection_get_root (void);

void
gnome_cmd_connection_device_added (GnomeCmdDevice *dev);

void
gnome_cmd_connection_device_removed (GnomeCmdDevice *dev);

void
gnome_cmd_connection_device_changed (GnomeCmdDevice *dev);

GList*
gnome_cmd_connection_get_all_connections (void);

GnomeCmdDir*
gnome_cmd_connection_get_cwd (GnomeCmdConnection *con);

GnomeCmdDir*
gnome_cmd_connection_get_default_dir (GnomeCmdConnection *con);

GnomeVFSURI*
gnome_cmd_connection_get_baseuri (GnomeCmdConnection *con);

void
gnome_cmd_connection_set_cwd (GnomeCmdConnection *con,
							  GnomeCmdDir *dir);

const gchar*
gnome_cmd_connection_get_alias (GnomeCmdConnection *con);

const gchar*
gnome_cmd_connection_get_desc (GnomeCmdConnection *con);

const gchar*
gnome_cmd_connection_get_tooltip (GnomeCmdConnection *con);

GnomeCmdPixmap *
gnome_cmd_connection_get_pixmap (GnomeCmdConnection *con);

gboolean
gnome_cmd_connection_get_remember_dir (GnomeCmdConnection *con);

void
gnome_cmd_connection_mount (GnomeCmdConnection *con);

gboolean
gnome_cmd_connection_ismounted (GnomeCmdConnection *con);

void
gnome_cmd_connection_umount (GnomeCmdConnection *con);


#endif //__GNOME_CMD_CONNECTION_FUNCS_H__
