// -*- c++ -*-

//  Gnomoradio - gnomoradio/playlist-view.h
//  Copyright (C) 2003-2004  Jim Garrison, Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __PLAYLIST_VIEW_H
#define __PLAYLIST_VIEW_H

#include <gtkmm.h>
#include "playlist-store.h"

namespace Gnomoradio
{
	/* view port for play lists.  must be assigned a PlayListStore
	 * corresponding to the appropriate play list.  the currently viewed
	 * play list can then be changed accordingly
	 */

	class PlaylistView : public Gtk::ScrolledWindow
	{
	public:
		PlaylistView (Wraporadio::Init *wrap, Wraporadio::SongList list);
		virtual ~PlaylistView ();

		void set (Wraporadio::SongList list);
		Wraporadio::SongList current_list () const { return current_store->get_song_list(); }
		Wraporadio::SongList base_list () const { return _base_list; }
		Wraporadio::SongList::iterator get_selected_song ();

		Gtk::TreeView *get_tree_view() { return &view; }

		void scroll_to_song (Wraporadio::SongList::iterator song);

		sigc::signal<void,Wraporadio::SongList> signal_different_list;
		
	protected:
		void on_shuffle_or_repeat_changed (bool tmp);
		void on_drag_data_received (const Glib::RefPtr<Gdk::DragContext> &context, int x, int y, const Gtk::SelectionData &selection_data, guint info, guint time);
		void on_drag_data_get (const Glib::RefPtr<Gdk::DragContext> &context, Gtk::SelectionData &selection_data, guint info, guint time);

		Wraporadio::Init *wr;
		Gtk::TreeView view;
		PlaylistStore *current_store;
		Wraporadio::SongList _base_list;

		sigc::connection shuffle_con, repeat_con;

		void on_double_clicked (const Gtk::TreeModel::Path &p, Gtk::TreeViewColumn *c);
		bool on_clicked (GdkEventButton *event);
		void on_right_click_menu_play_activate (Wraporadio::SongList::iterator song);
		void on_right_click_menu_import_activate (Wraporadio::SongList::iterator song);
		void on_right_click_menu_refresh_activate (Wraporadio::SongList::iterator song);
		void on_right_click_menu_rating_activate (Wraporadio::SongList::iterator song, int rating);
		void on_right_click_menu_remove_activate (Wraporadio::SongList::iterator song);
		void on_right_click_menu_properties_activate (Wraporadio::SongList::iterator song);
	};
}

#endif
