// -*- c++ -*-

//  Gnomoradio - roboradio/audio/mp3.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __ROBORADIO_AUDIO_MP3_H
#define __ROBORADIO_AUDIO_MP3_H

#include "roboradio/audio/prober.h"
#include <glibmm.h>

namespace Roboradio
{
	namespace Audio
	{
		class Mp3 : public Prober
		{
		public:
			Mp3 (const Glib::ustring &file);
			virtual ~Mp3 ();

			void play ();
			void stop ();
			void pause ();
			void unpause ();

			void seek (unsigned int pos);
			int get_position ();

			virtual std::map<Glib::ustring,Glib::ustring> get_info (unsigned int &length);

		protected:
			bool read_id_tag (std::map<Glib::ustring,Glib::ustring> &info);

			Glib::ustring filename;
		};
	}
}

#endif
