
struct smc_info {
	unsigned int capacity;
	unsigned int bytes_used;
	unsigned int bytes_free;
};

struct file_info {
	int is_dir;
	char *name;
	unsigned int size;
};

struct file_info *fileinfo(const char* path);

int gp_connect();

void gp_disconnect();

int gp_run(char *file);
int gp_run_data(unsigned char *exe, unsigned int size);

struct file_info *gp_dir(char *directory);

struct smc_info *gp_info();

int gp_put(char *src, char *dst, int convert);
int gp_put_data(const char* srcdata, char* dst, const char* bname, unsigned int filesize);

int gp_get(char *src, char *dst);

int gp_mkdir(char *path);

int gp_rmdir(char *path);

int gp_rm(char *path);

int gp_format();
int gp_ids();

int gp_end_link_mode();
