
#include <stdio.h>
#include <usb.h>

struct usb_bus *busses;
struct usb_bus *bus;
struct usb_device *dev;
struct usb_device *gp32=NULL;
usb_dev_handle *gp32handle;

int usb_connect() {
	int result;

	usb_init();
	usb_find_busses();
	usb_find_devices();

	busses=usb_get_busses();
	for(bus=busses; bus; bus=bus->next) {
		for(dev=bus->devices; dev; dev=dev->next) {
			if((dev->descriptor.idVendor==0xeb6) &&
					(dev->descriptor.idProduct==0x3232))
				gp32=dev;
		}
	}

	if(gp32==NULL) {
		fprintf(stderr, "error: couldn't find gp32 attached to usb\n");
		return -1;
	}

	gp32handle=usb_open(gp32);

	result=usb_claim_interface(gp32handle, 0x0);
	if(result==-1) {
		fprintf(stderr, "%s\n", usb_strerror());
		fprintf(stderr, "error in usb_claim_interface\n");
		return -1;
	}

	/*result=usb_claim_interface(gp32handle, 0x1);
	if(result==-1) {
		fprintf(stderr, "%s\n", usb_strerror());
		fprintf(stderr, "error in usb_claim_interface\n");
		return -1;
	}

	result=usb_claim_interface(gp32handle, 0x3);
	if(result==-1) {
		fprintf(stderr, "%s\n", usb_strerror());
		fprintf(stderr, "error in usb_claim_interface\n");
		return -1;
	}*/
	return 0;
}

void usb_disconnect() {
	usb_release_interface(gp32handle, 0x0);
	//usb_release_interface(gp32handle, 0x1);
	//usb_release_interface(gp32handle, 0x3);
	usb_close(gp32handle);
}

int usb_read(char *buffer, int buffer_size) {
	int result;

	//result=usb_bulk_read(gp32handle, 0x1, buffer, buffer_size, 10000);
	result=usb_bulk_read(gp32handle, 0x81, buffer, buffer_size, 100000);
	if(result==-1) {
		fprintf(stderr, "%s\n", usb_strerror());
		fprintf(stderr, "error in usb read\n");
		return -1;
	}
	return 0;
}

int usb_write(char *buffer, int buffer_size) {
	int result;

	result=usb_bulk_write(gp32handle, 0x3, buffer, buffer_size, 100000);
	if(result==-1) {
		fprintf(stderr, "%s\n", usb_strerror());
		fprintf(stderr, "error in usb write\n");
		return -1;
	}
	return 0;
}




