"""Greek & math entities for Grail.

These symbols are encoded the same way as the PostScript Symbol font from
Adobe.  The standard symbols font under X11 is from Adobe, so this can be
used for both PostScript and X11 display.
"""
__version__ = '$Revision: 2.11 $'

# Greek & math stuff, ignored if symbol font is not available:
entitydefs = { 'forall': '\x22',
	       'exist': '\x24',
	       'bepsi': '\x27',
	       'lowast': '\x2a',
	       'cong': '\x40',
	       'Agr': '\x41',
	       'Alpha': '\x41',
	       'Beta': '\x42',
	       'Bgr': '\x42',
	       'Chi': '\x43',
	       'KHgr': '\x43',
	       'Delta': '\x44',
	       'Epsi': '\x45',
	       'Epsilon': '\x45',
	       'Egr': '\x45',
	       'Phi': '\x46',
	       'PHgr': '\x46',
	       'Gamma': '\x47',
	       'EEgr': '\x48',
	       'Eta': '\x48',
	       'Igr': '\x49',
	       'Iota': '\x49',
	       'thetav': '\x4a',
	       'Kappa': '\x4b',
	       'Kgr': '\x4b',
	       'Lambda': '\x4c',
	       'Mgr': '\x4d',
	       'Mu': '\x4d',
	       'Ngr': '\x4e',
	       'Nu': '\x4e',
	       'Ogr': '\x4f',
	       'Omicron': '\x4f',
	       'Pi': '\x50',
	       'Theta': '\x51',
	       'Rgr': '\x52',
	       'Rho': '\x52',
	       'Sigma': '\x53',
	       'Tau': '\x54',
	       'Tgr': '\x54',
	       'Upsi': '\x55',
	       'Upsilon': '\x55',
	       'sigmav': '\x56',
	       'vsigma': '\x56',
	       'sfgr': '\x56',
	       'ohm': '\x57',
	       'Omega': '\x57',
	       'Xi': '\x58',
	       'Psi': '\x59',
	       'Zeta': '\x5a',
	       'Zgr': '\x5a',
	       'there4': '\x5c',
	       'perp': '\x5e',
	       'alpha': '\x61',
	       'beta': '\x62',
	       'chi': '\x63',
	       'delta': '\x64',
	       'epsi': '\xce',
	       'epsilon': '\xce',
	       'vepsi': '\x65',
	       'vepsilon': '\x65',
	       'phi': '\x66',
	       'phis': '\x66',
	       'gamma': '\x67',
	       'eta': '\x68',
	       'iota': '\x69',
	       'phiv': '\x6a',
	       'varphi': '\x6a',
	       'kappa': '\x6b',
	       'lambda': '\x6c',
	       'mu': '\x6d',
	       'nu': '\x6e',
	       'ogr': '\x6f',
	       'omicron': '\x6f',
	       'pi': '\x70',
	       'piv': '\x70',
	       'varpi': '\x70',
	       'theta': '\x71',
	       'thetas': '\x71',
	       'thetav': '\x4a',
	       'vtheta': '\x4a',
	       'rho': '\x72',
	       'varrho': '\x72',
	       'sigma': '\x73',
	       'tau': '\x74',
	       'upsi': '\x75',
	       'upsilon': '\x75',
	       'sigmav': '\x76',
	       'omega': '\x77',
	       'xi': '\x78',
	       'psi': '\x79',
	       'zeta': '\x7a',
	       'sim': '\x7e',
	       'prime': '\xa2',
	       'le': '\xa3',
	       'inf': '\xa5',
	       'infin': '\xa5',
	       'fnof': '\xa6',
	       'clubs': '\xa7',
	       'diams': '\xa8',
	       'hearts': '\xa9',
	       'spades': '\xaa',
	       'harr': '\xab',
	       'larr': '\xac',
	       'uarr': '\xad',
	       'rarr': '\xae',
	       'darr': '\xaf',
	       'plusmn': '\xb1',
	       'Prime': '\xb2',
	       'ge': '\xb3',
	       'prop': '\xb5',		# proportional to
	       'bull': '\xb7',
	       'bullet': '\xb7',
	       'ne': '\xb9',
	       'equiv': '\xba',
	       'ap': '\xbb',
	       'ape': '\xbb',
	       'aleph': '\xc0',
	       'image': '\xc1',
	       'real': '\xc2',
	       'weierp': '\xc3',
	       'otimes': '\xc4',
	       'oplus': '\xc5',
	       'empty': '\xc6',
	       'cap': '\xc7',
	       'cup': '\xc8',
	       'sup': '\xc9',
	       'supe': '\xca',
	       'nsub': '\xcb',
	       'sub': '\xcc',
	       'sube': '\xcd',
	       'isin': '\xce',
	       'notin': '\xcf',
	       'ang': '\xd0',
	       'nabla': '\xd1',
	       'prod': '\xd5',
	       'radic': '\xd6',
	       'sdot': '\xd7',
	       'and': '\xd9',
	       'or': '\xda',
	       'hArr': '\xdb',
	       'iff': '\xdb',
	       'lArr': '\xdc',
	       'uArr': '\xdd',
	       'rArr': '\xde',
	       'dArr': '\xdf',
	       'pd': '\xb6',		# partial differential
	       'part': '\xb6',
	       'loz': '\xe0',
	       'lang': '\xe1',
	       'sum': '\xe5',
	       'lceil': '\xe9',
	       'lfloor': '\xeb',
	       'rang': '\xf1',
	       'int': '\xf2',
	       'rceil': '\xf9',
	       'rfloor': '\xfb',
	       'cdots': '\xd7'*3,
	       'ldots': '\xbc',		# overrides default if font available
	       'hellip': '\xbc',
	       'trade': '\xe4',
	       'emdash': '\xbe',	# overrides ...
	       'mdash': '\xbe',		# overrides ...
               0x2122: "\xe4",		# trade mark sign (unicode)
	       }
