/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.26
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif


/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "2"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;


/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (int)(*f1 - *f2);
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}

/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}


/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/***********************************************************************
 * luarun.swg
 *
 *     This file contains the runtime support for Lua modules
 *     and includes code for managing global variables and pointer
 *     type checking.
 *
 * Author : Mark Gossage (mark@gossage.cjb.net)
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#include "lua.h"
#include "stdio.h"	// debug printing
#include <assert.h>	// for a few sanity tests

/* -----------------------------------------------------------------------------
 * global swig types
 * ----------------------------------------------------------------------------- */
/* Constant table */
#define SWIG_LUA_INT     1
#define SWIG_LUA_FLOAT   2
#define SWIG_LUA_STRING  3
#define SWIG_LUA_POINTER 4
#define SWIG_LUA_BINARY  5

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1

/* type for all wrapper fns */
typedef int (*swig_lua_wrapper_func)(lua_State*);

/* Structure for command table */
typedef struct {
  const char *name;
  swig_lua_wrapper_func wrapper;
} swig_lua_command_info;

/* Structure for variable linking table */
typedef struct {
  const char *name;
  swig_lua_wrapper_func get;
  swig_lua_wrapper_func set;
} swig_lua_var_info;

/* Constant information structure */
typedef struct {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_lua_const_info;

typedef struct {
  const char     *name;
  swig_lua_wrapper_func   method;
} swig_lua_method;

typedef struct {
  const char     *name;
  swig_lua_wrapper_func   getmethod;
  swig_lua_wrapper_func   setmethod;
} swig_lua_attribute;

typedef struct swig_lua_class {
  const char         *name;
  swig_type_info   **type;
  swig_lua_wrapper_func       constructor;
  void              (*destructor)(void *);
  swig_lua_method        *methods;
  swig_lua_attribute     *attributes;
  struct swig_lua_class **bases;
} swig_lua_class;

typedef struct {
  void             *ptr;
  swig_type_info   *type;
  int               own;	// 1 if owned & must be destroyed
} swig_lua_userdata;


/* Common SWIG API */
#define SWIG_NewPointerObj(L, ptr, type, owner) \
  SWIG_Lua_NewPointerObj(L, (void *)ptr, type, owner)
#define SWIG_ConvertPtr(L,idx, ptr, type, flags) \
	SWIG_Lua_ConvertPtr(L,idx,ptr,type,flags)
#define SWIG_MustGetPtr(L,idx, type,flags, argnum,fnname) \
	SWIG_Lua_MustGetPtr(L,idx, type,flags, argnum,fnname)

/* Runtime API */
#define SWIG_GetModule(clientdata) SWIG_Lua_GetModule((lua_State*)(clientdata))
#define SWIG_SetModule(clientdata, pointer) SWIG_Lua_SetModule((lua_State*) (clientdata), pointer)
#define SWIG_MODULE_CLIENTDATA_TYPE lua_State*

/* Contract support */
#define SWIG_contract_assert(expr, msg)  \
  if (!(expr)) { lua_pushstring(L, (char *) msg); goto fail; } else



// helper #defines
#define SWIG_fail {goto fail;}
#define SWIG_fail_arg(I) {lua_pushfstring(L,"argument %d incorrect/missing",I);goto fail;}

#define SWIG_Lua_get_table(L,n) \
	(lua_pushstring(L, n), lua_rawget(L,-2))

#define SWIG_Lua_add_function(L,n,f) \
		   (lua_pushstring(L, n), \
			lua_pushcfunction(L, f), \
			lua_rawset(L,-3))



// debug routine
#if 0
#define DEBUG_PRINT(X)	{printf(X);fflush(stdout);}
#define DEBUG_STACK(X)	{swig_print_stack(L);}

void swig_print_stack(lua_State* L)
{
	int i=lua_gettop(L);
	printf("stack is size %d==============\n",i);
	for( ; i>0;i--)
		printf("  %d %p(%s)\n",i,lua_topointer(L,i),lua_typename(L,lua_type(L,i)));
	printf("end stack==============\n");
	fflush(stdout);
}
#else
#define DEBUG_PRINT(X)	{}
#define DEBUG_STACK(X)	{}
#endif

/* -----------------------------------------------------------------------------
 * global variable support code: modules
 * ----------------------------------------------------------------------------- */
// the module.get method used for getting linked data
SWIGINTERN int SWIG_Lua_module_get(lua_State* L)
{
	// there should be 2 params passed in
	// (1) table (not the meta table)
	// (2) string name of the attribute
//	printf("SWIG_Lua_module_get %p(%s) '%s'\n",
//				lua_topointer(L,1),lua_typename(L,lua_type(L,1)),
//				lua_tostring(L,2));

	// get the metatable
	assert(lua_istable(L,1));	// just in case
	lua_getmetatable(L,1);	// get the metatable
	assert(lua_istable(L,-1));	// just in case
	SWIG_Lua_get_table(L,".get");	// get the .get table
	lua_remove(L,3);	// remove metatable
//	printf(" found %p(%s)\n",lua_topointer(L,-1),lua_typename(L,lua_type(L,-1)));
	if (lua_istable(L,-1))
	{
		// look for the key in the .get table
		lua_pushvalue(L,2);  // key
		lua_rawget(L,-2);
		lua_remove(L,3);	// remove .get
		if (lua_iscfunction(L,-1))
		{	// found it so call the fn & return its value
//			printf("calling fn\n");
			lua_call(L,0,1);
			return 1;
		}
		lua_pop(L,1);	// remove the top
	}
	lua_pop(L,1);	// remove the .get
	lua_pushnil(L);	// return a nil
    return 1;
}

// the module.set method used for setting linked data
SWIGINTERN int SWIG_Lua_module_set(lua_State* L)
{
	// there should be 3 params passed in
	// (1) table (not the meta table)
	// (2) string name of the attribute
	// (3) any for the new value
//	printf("SWIG_Lua_module_set %p(%s) '%s' %p(%s)\n",
//				lua_topointer(L,1),lua_typename(L,lua_type(L,1)),
//				lua_tostring(L,2),
//				lua_topointer(L,3),lua_typename(L,lua_type(L,3)));

	// get the metatable
	assert(lua_istable(L,1));	// just in case
	lua_getmetatable(L,1);	// get the metatable
	assert(lua_istable(L,-1));	// just in case
	SWIG_Lua_get_table(L,".set");	// get the .set table
	lua_remove(L,4);	// remove metatable
	if (lua_istable(L,-1))
	{
		// look for the key in the .set table
		lua_pushvalue(L,2);  // key
		lua_rawget(L,-2);
		lua_remove(L,4);	// remove .set
		if (lua_iscfunction(L,-1))
		{	// found it so call the fn & return its value
			lua_pushvalue(L,3);  // value
			lua_call(L,1,0);
			return 0;
		}
		lua_pop(L,1);	// remove the top
	}
	lua_pop(L,1);	// remove the .set
    return 0;
}

// registering a module in lua
SWIGINTERN void  SWIG_Lua_module_begin(lua_State* L,const char* name)
{
	assert(lua_istable(L,-1));	// just in case
	lua_pushstring(L,name);
	lua_newtable(L);				// the table
	// add meta table
	lua_newtable(L);		// the meta table
	SWIG_Lua_add_function(L,"__index",SWIG_Lua_module_get);
	SWIG_Lua_add_function(L,"__newindex",SWIG_Lua_module_set);
	lua_pushstring(L,".get");
	lua_newtable(L);		// the .get table
	lua_rawset(L,-3);       // add .get into metatable
	lua_pushstring(L,".set");
	lua_newtable(L);		// the .set table
	lua_rawset(L,-3);       // add .set into metatable
	lua_setmetatable(L,-2);	// sets meta table in module
	lua_rawset(L,-3);                  // add module into parent
	SWIG_Lua_get_table(L,name);				// get the table back out
}

// ending the register
SWIGINTERN void  SWIG_Lua_module_end(lua_State* L)
{
	lua_pop(L,1);                      // tidy stack (remove module)
}

// adding a linked variable to the module
SWIGINTERN void  SWIG_Lua_module_add_variable(lua_State* L,const char* name,swig_lua_wrapper_func getFn,swig_lua_wrapper_func setFn)
{
	assert(lua_istable(L,-1));	// just in case
	lua_getmetatable(L,-1);	// get the metatable
	assert(lua_istable(L,-1));	// just in case
	SWIG_Lua_get_table(L,".get"); // find the .get table
	assert(lua_istable(L,-1));	// should be a table:
	SWIG_Lua_add_function(L,name,getFn);
	lua_pop(L,1);                      // tidy stack (remove table)
	if (setFn)	// if there is a set fn
	{
		SWIG_Lua_get_table(L,".set"); // find the .set table
		assert(lua_istable(L,-1));	// should be a table:
		SWIG_Lua_add_function(L,name,setFn);
		lua_pop(L,1);                      // tidy stack (remove table)
	}
	lua_pop(L,1);                      // tidy stack (remove meta)
}

// adding a function module
SWIGINTERN void  SWIG_Lua_module_add_function(lua_State* L,const char* name,swig_lua_wrapper_func fn)
{
	SWIG_Lua_add_function(L,name,fn);
}

/* -----------------------------------------------------------------------------
 * global variable support code: classes
 * ----------------------------------------------------------------------------- */
// the class.get method, performs the lookup of class attributes
SWIGINTERN int  SWIG_Lua_class_get(lua_State* L)
{
	// there should be 2 params passed in
	// (1) userdata (not the meta table)
	// (2) string name of the attribute
//	printf("SWIG_Lua_class_get %p(%s) '%s'\n",
//				lua_topointer(L,1),lua_typename(L,lua_type(L,1)),
//				lua_tostring(L,2));
//	DEBUG_STACK(L);
	assert(lua_isuserdata(L,-2));	// just in case
	lua_getmetatable(L,-2);		// get the meta table
	assert(lua_istable(L,-1));	// just in case
	SWIG_Lua_get_table(L,".get"); // find the .get table
	assert(lua_istable(L,-1));	// just in case
	// look for the key in the .get table
	lua_pushvalue(L,2);  // key
	lua_rawget(L,-2);
	lua_remove(L,-2); // stack tidy, remove .get table
	DEBUG_PRINT("check .get\n");
	DEBUG_STACK(L);
	if (lua_iscfunction(L,-1))
	{	// found it so call the fn & return its value
		lua_pushvalue(L,1);  // the userdata
		lua_call(L,1,1);	// 1 value in (userdata),1 out (result)
		lua_remove(L,-2); // stack tidy, remove metatable
		return 1;
	}
	lua_pop(L,1);	// remove whatever was there
	// ok, so try the .fn table
	SWIG_Lua_get_table(L,".fn"); // find the .get table
	assert(lua_istable(L,-1));	// just in case
	lua_pushvalue(L,2);  // key
	lua_rawget(L,-2);	// look for the fn
	lua_remove(L,-2); // stack tidy, remove .fn table
	DEBUG_PRINT("check .fn\n");
	DEBUG_STACK(L);
	if (lua_iscfunction(L,-1))
	{	// found it so return the fn & let lua call it
		lua_remove(L,-2); // stack tidy, remove metatable
		return 1;
	}
	lua_pop(L,1);	// remove whatever was there
	// NEW: looks for the __getitem() fn
	// this is a user provided get fn
	SWIG_Lua_get_table(L,"__getitem"); // find the __getitem fn
	DEBUG_PRINT("check __getitem\n");
	DEBUG_STACK(L);
	if (lua_iscfunction(L,-1))	// if its there
	{	// found it so call the fn & return its value
		lua_pushvalue(L,1);  // the userdata
		lua_pushvalue(L,2);  // the parameter
		lua_call(L,2,1);	// 2 value in (userdata),1 out (result)
		lua_remove(L,-2); // stack tidy, remove metatable
		//DEBUG_STACK(L);
		return 1;
	}


	return 0;	// sorry not known
}

// the class.set method, performs the lookup of class attributes
SWIGINTERN int  SWIG_Lua_class_set(lua_State* L)
{
	// there should be 3 params passed in
	// (1) table (not the meta table)
	// (2) string name of the attribute
	// (3) any for the new value
//	printf("SWIG_Lua_class_set %p(%s) '%s' %p(%s)\n",
//				lua_topointer(L,1),lua_typename(L,lua_type(L,1)),
//				lua_tostring(L,2),
//				lua_topointer(L,3),lua_typename(L,lua_type(L,3)));

	assert(lua_isuserdata(L,1));	// just in case
	lua_getmetatable(L,1);		// get the meta table
	assert(lua_istable(L,-1));	// just in case

	SWIG_Lua_get_table(L,".set"); // find the .set table
	if (lua_istable(L,-1))
	{
		// look for the key in the .set table
		lua_pushvalue(L,2);  // key
		lua_rawget(L,-2);
		if (lua_iscfunction(L,-1))
		{	// found it so call the fn & return its value
			lua_pushvalue(L,1);  // userdata
			lua_pushvalue(L,3);  // value
			lua_call(L,2,0);
			return 0;
		}
		lua_pop(L,1);	// remove the value
	}
	lua_pop(L,1);	// remove the value .set table
	// NEW: looks for the __setitem() fn
	// this is a user provided set fn
	SWIG_Lua_get_table(L,"__setitem"); // find the fn
	if (lua_iscfunction(L,-1))	// if its there
	{	// found it so call the fn & return its value
		lua_pushvalue(L,1);  // the userdata
		lua_pushvalue(L,2);  // the parameter
		lua_pushvalue(L,3);  // the value
		lua_call(L,3,0);	// 3 values in ,0 out
		lua_remove(L,-2); // stack tidy, remove metatable
		return 1;
	}
	return 0;
}

// the class.destruct method called by the interpreter
SWIGINTERN int  SWIG_Lua_class_destruct(lua_State* L)
{
	// there should be 1 params passed in
	// (1) userdata (not the meta table)
	swig_lua_userdata* usr;
	swig_lua_class* clss;
//	printf("SWIG_Lua_class_destruct\n");
//	DEBUG_STACK(L);
	assert(lua_isuserdata(L,-1));	// just in case
	usr=(swig_lua_userdata*)lua_touserdata(L,-1);	// get it
	// if must be destroyed & has a destructor
	if (usr->own) // if must be destroyed
	{
		clss=(swig_lua_class*)usr->type->clientdata;	// get the class
		if (clss && clss->destructor)	// there is a destroy fn
		{
			clss->destructor(usr->ptr);	// bye bye
		}
	}
	return 0;
}

// gets the swig class registry (or creates it)
SWIGINTERN void  SWIG_Lua_get_class_registry(lua_State* L)
{
	// add this all into the swig registry:
	lua_pushstring(L,"SWIG");
	lua_rawget(L,LUA_REGISTRYINDEX);	// get the registry
	if (!lua_istable(L,-1))	// not there
	{	// must be first time, so add it
		lua_pop(L,1);	// remove the result
		lua_pushstring(L,"SWIG");
		lua_newtable(L);
		lua_rawset(L,LUA_REGISTRYINDEX);
		// then get it
		lua_pushstring(L,"SWIG");
		lua_rawget(L,LUA_REGISTRYINDEX);
	}
}

// helper fn to get the classes metatable from the register
SWIGINTERN void  SWIG_Lua_get_class_metatable(lua_State* L,const char* cname)
{
	SWIG_Lua_get_class_registry(L);	// get the registry
	lua_pushstring(L,cname);	// get the name
	lua_rawget(L,-2);		// get it
	lua_remove(L,-2);		// tidy up (remove registry)
}

// helper add a variable to a registered class
SWIGINTERN void  SWIG_Lua_add_class_variable(lua_State* L,const char* name,swig_lua_wrapper_func getFn,swig_lua_wrapper_func setFn)
{
	assert(lua_istable(L,-1));	// just in case
	SWIG_Lua_get_table(L,".get"); // find the .get table
	assert(lua_istable(L,-1));	// just in case
//	if (lua_istable(L,-1))	// should be a table:
	SWIG_Lua_add_function(L,name,getFn);
	lua_pop(L,1);                      // tidy stack (remove table)
	if (setFn)
	{
		SWIG_Lua_get_table(L,".set"); // find the .set table
		assert(lua_istable(L,-1));	// just in case
	//	if (lua_istable(L,-1))	// should be a table:
		SWIG_Lua_add_function(L,name,setFn);
		lua_pop(L,1);                      // tidy stack (remove table)
	}
}

// helper to recursively add class details (attributes & operations)
SWIGINTERN void  SWIG_Lua_add_class_details(lua_State* L,swig_lua_class* clss)
{
	int i;//,j;
	// call all the base classes first: we can then override these later:
	swig_lua_class* base;
	for(i=0;clss->bases[i];i++)
	{
//		printf("add base class feature %s\n",clss->bases[i]->name);	fflush(stdout);
		SWIG_Lua_add_class_details(L,clss->bases[i]);
	}

	// add fns
	for(i=0;clss->attributes[i].name;i++){
		SWIG_Lua_add_class_variable(L,clss->attributes[i].name,clss->attributes[i].getmethod,clss->attributes[i].setmethod);
	}
	// add methods to the metatable
	SWIG_Lua_get_table(L,".fn"); // find the .fn table
	assert(lua_istable(L,-1));	// just in case
	for(i=0;clss->methods[i].name;i++){
		SWIG_Lua_add_function(L,clss->methods[i].name,clss->methods[i].method);
	}
	lua_pop(L,1);                      // tidy stack (remove table)
	// add operator overloads
	// these look ANY method which start with "__" and assume they
	// are operator overloads & add them to the metatable
	// (this might mess up is someone defines a method __gc (the destructor)
	for(i=0;clss->methods[i].name;i++){
		if (clss->methods[i].name[0]=='_' && clss->methods[i].name[1]=='_'){
			SWIG_Lua_add_function(L,clss->methods[i].name,clss->methods[i].method);
		}
	}
}

// performs the entire class registration process
SWIGINTERN void  SWIG_Lua_class_register(lua_State* L,swig_lua_class* clss)
{
	// add its constructor to module with the name of the class
	// so you can do MyClass(...) as well as new_MyClass(...)
	// BUT only if a constructor is defined
	// (this overcomes the problem of pure virtual classes without constructors)
	if (clss->constructor)
		SWIG_Lua_add_function(L,clss->name,clss->constructor);

	SWIG_Lua_get_class_registry(L);	// get the registry
	lua_pushstring(L,clss->name);	// get the name
	lua_newtable(L);		// create the metatable
	// add string of class name called ".type"
	lua_pushstring(L,".type");
	lua_pushstring(L,clss->name);
	lua_rawset(L,-3);
	// add a table called ".get"
	lua_pushstring(L,".get");
	lua_newtable(L);
	lua_rawset(L,-3);
	// add a table called ".set"
	lua_pushstring(L,".set");
	lua_newtable(L);
	lua_rawset(L,-3);
	// add a table called ".fn"
	lua_pushstring(L,".fn");
	lua_newtable(L);
	lua_rawset(L,-3);
	// add accessor fns for using the .get,.set&.fn
	SWIG_Lua_add_function(L,"__index",SWIG_Lua_class_get);
	SWIG_Lua_add_function(L,"__newindex",SWIG_Lua_class_set);
	SWIG_Lua_add_function(L,"__gc",SWIG_Lua_class_destruct);
	// add it
	lua_rawset(L,-3);	// metatable into registry
	lua_pop(L,1);           // tidy stack (remove registry)

	SWIG_Lua_get_class_metatable(L,clss->name);
	SWIG_Lua_add_class_details(L,clss);	// recursive adding of details (atts & ops)
	lua_pop(L,1);           // tidy stack (remove class metatable)
}

/* -----------------------------------------------------------------------------
 * Class/structure conversion fns
 * ----------------------------------------------------------------------------- */

// pushes a new object into the lua stack
SWIGRUNTIME void SWIG_Lua_NewPointerObj(lua_State* L,void* ptr,swig_type_info *type, int own)
{
	if (!ptr){
		lua_pushnil(L);
		return;
	}
	swig_lua_userdata* usr=(swig_lua_userdata*)lua_newuserdata(L,sizeof(swig_lua_userdata));	// get data
	usr->ptr=ptr;	// set the ptr
	usr->type=type;
	usr->own=own;
//	printf("ptr %p type %s class %p\n",ptr,type->name,type->clientdata);
	if (type->clientdata)	// there is clientdata: so add the metatable
	{
		SWIG_Lua_get_class_metatable(L,((swig_lua_class*)(type->clientdata))->name);
		if (lua_istable(L,-1))
		{
//			printf("added metatable for %p %s\n",ptr,type->name);
			lua_setmetatable(L,-2);
		}
		else
		{
//			printf("no metatable for %p %s\n",ptr,type->name);
			lua_pop(L,1);
		}
	}
}

// takes a object from the lua stack & converts it into an object of the correct type
// (if possible)
SWIGRUNTIME int  SWIG_Lua_ConvertPtr(lua_State* L,int index,void** ptr,swig_type_info *type,int flags)
{
	swig_lua_userdata* usr;
	swig_cast_info *cast;
//	assert(lua_isuserdata(L,index));	// just in case
	usr=(swig_lua_userdata*)lua_touserdata(L,index);	// get data

//	printf("SWIG_Lua_ConvertPtr(%p,%p) %s %s\n",usr->type,type,usr->type->name,type->name);

	if (usr)
	{
		cast=SWIG_TypeCheckStruct(usr->type,type);
		if (cast)
		{
			*ptr=SWIG_TypeCast(cast,usr->ptr);
			return 0;	//ok
		}
	}
	return 1;	// error
}

SWIGRUNTIME void* SWIG_Lua_MustGetPtr(lua_State* L,int index,swig_type_info *type,int flags,
						int argnum,const char* func_name){
	void* result;
	if (SWIG_ConvertPtr(L,index,&result,type,flags)){
		lua_pushfstring(L,"Error in %s, expected a %s at argument number %d\n",
			func_name,type->str?type->str:"void*",argnum);
		lua_error(L);
	}
	return result;
}

// lua callable function to get the userdata's type
SWIGRUNTIME int SWIG_Lua_type(lua_State* L)
{
	swig_lua_userdata* usr;
	if (!lua_isuserdata(L,1))	// just in case
		return 0;	// nil reply
	usr=(swig_lua_userdata*)lua_touserdata(L,1);	// get data
	lua_pushstring(L,usr->type->name);
	return 1;
}

// lua callable function to compare userdata's value
// the issue is that two userdata may point to the same thing
// but to lua, they are different objects
SWIGRUNTIME int SWIG_Lua_equal(lua_State* L)
{
	int result;
	swig_lua_userdata *usr1,*usr2;
	if (!lua_isuserdata(L,1) || !lua_isuserdata(L,2))	// just in case
		return 0;	// nil reply
	usr1=(swig_lua_userdata*)lua_touserdata(L,1);	// get data
	usr2=(swig_lua_userdata*)lua_touserdata(L,2);	// get data
	result=(usr1->ptr==usr2->ptr && usr1->type==usr2->type);
	lua_pushboolean(L,result);
	return 1;
}


/* -----------------------------------------------------------------------------
 * global variable support code: class/struct typemap functions
 * ----------------------------------------------------------------------------- */
/* Install Constants */
SWIGINTERN void
SWIG_Lua_InstallConstants(lua_State* L, swig_lua_const_info constants[]) {
  int i;
  for (i = 0; constants[i].type; i++) {
    switch(constants[i].type) {
    case SWIG_LUA_INT:
      lua_pushstring(L,constants[i].name);
      lua_pushnumber(L,(double)constants[i].lvalue);
      lua_rawset(L,-3);
      break;
    case SWIG_LUA_FLOAT:
      lua_pushstring(L,constants[i].name);
      lua_pushnumber(L,(double)constants[i].dvalue);
      lua_rawset(L,-3);
      break;
    case SWIG_LUA_STRING:
      lua_pushstring(L,constants[i].name);
      lua_pushstring(L,(char *) constants[i].pvalue);
      lua_rawset(L,-3);
      break;
    case SWIG_LUA_POINTER:
      lua_pushstring(L,constants[i].name);
      SWIG_NewPointerObj(L,constants[i].pvalue, *(constants[i]).ptype,0);
      lua_rawset(L,-3);
      break;
    case SWIG_LUA_BINARY:
    // TODO??
//      obj = SWIG_NewPackedObj(constants[i].pvalue, constants[i].lvalue, *(constants[i].ptype));
      break;
    default:
      //obj = 0;
      break;
    }
  }
}

/* storing/access of swig_module_info */
SWIGRUNTIME swig_module_info *
SWIG_Lua_GetModule(lua_State* L) {
  swig_module_info *ret = 0;
  lua_pushstring(L,"swig_runtime_data_type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME);
  lua_rawget(L,LUA_REGISTRYINDEX);
  if (lua_islightuserdata(L,-1))
  	ret=(swig_module_info*)lua_touserdata(L,-1);
  lua_pop(L,1);	// tidy
  return ret;
}

SWIGRUNTIME void
SWIG_Lua_SetModule(lua_State* L, swig_module_info *module) {
  // add this all into the Lua registry:
  lua_pushstring(L,"swig_runtime_data_type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME);
  lua_pushlightuserdata(L,(void*)module);
  lua_rawset(L,LUA_REGISTRYINDEX);
}

#ifdef __cplusplus
}
#endif

/*************************** end luarun.swg ******************************/

/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_Agedge_t swig_types[0]
#define SWIGTYPE_p_Agnode_t swig_types[1]
#define SWIGTYPE_p_Agraph_t swig_types[2]
#define SWIGTYPE_p_Agsym_t swig_types[3]
#define SWIGTYPE_p_FILE swig_types[4]
#define SWIGTYPE_p_p_void swig_types[5]
static swig_type_info *swig_types[7];
static swig_module_info swig_module = {swig_types, 6, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Gv_Init
#define SWIG_name    "gv"
#define SWIG_import  luaopen_gv



/* some language headers (e.g. php.h, ruby.h) leave these defined */
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef PACKAGE_NAME

#include "gvc.h"


/** New graphs */
/*** New empty graph */
extern Agraph_t *graph(char *name);
extern Agraph_t *digraph(char *name);
extern Agraph_t *strictgraph(char *name);
extern Agraph_t *strictdigraph(char *name);
/*** New graph from a dot-syntax string or file */
extern Agraph_t *readstring(char *string);
extern Agraph_t *read(char *filename);
extern Agraph_t *read(FILE *f);	
/*** Add new subgraph to existing graph */
extern Agraph_t *graph(Agraph_t *g, char *name);

/** New nodes */
/*** Add new node to existing graph */
extern Agnode_t *node(Agraph_t *g, char *name);

/** New edges */
/*** Add new edge between existing nodes */
extern Agedge_t *edge(Agnode_t *t, Agnode_t *h);
/*** Add a new edge between an existing tail node, and a named head node which will be induced in the graph if it doesn't already exist */
extern Agedge_t *edge(Agnode_t *t, char *hname);
/*** Add a new edge between an existing head node, and a named tail node which will be induced in the graph if it doesn't already exist */
extern Agedge_t *edge(char *tname, Agnode_t *h);
/*** Add a new edge between named tail  and head nodes which will be induced in the graph if they don't already exist */
extern Agedge_t *edge(Agraph_t *g, char *tname, char *hname);

/** Setting attribute values */
/*** Set value of named attribute of graph/node/edge - creating attribute if necessary */
extern char *setv(Agraph_t *g, char *attr, char *val);
extern char *setv(Agnode_t *n, char *attr, char *val);
extern char *setv(Agedge_t *e, char *attr, char *val);

/*** Set value of existing attribute of graph/node/edge (using attribute handle) */
extern char *setv(Agraph_t *g, Agsym_t *a, char *val);
extern char *setv(Agnode_t *n, Agsym_t *a, char *val);
extern char *setv(Agedge_t *e, Agsym_t *a, char *val);

/** Getting attribute values */
/*** Get value of named attribute of graph/node/edge */
extern char *getv(Agraph_t *g, char *attr);
extern char *getv(Agnode_t *n, char *attr);
extern char *getv(Agedge_t *e, char *attr);

/*** Get value of attribute of graph/node/edge (using attribute handle) */
extern char *getv(Agraph_t *g, Agsym_t *a);
extern char *getv(Agnode_t *n, Agsym_t *a);
extern char *getv(Agedge_t *e, Agsym_t *a);

/** Obtain names from handles */
extern char *nameof(Agraph_t *g);
extern char *nameof(Agnode_t *n);
//extern char *nameof(Agedge_t *e);
extern char *nameof(Agsym_t *a);

/** Find handles from names */
extern Agraph_t *findsubg(Agraph_t *g, char *name);
extern Agnode_t *findnode(Agraph_t *g, char *name);
extern Agedge_t *findedge(Agnode_t *t, Agnode_t *h);

/** */
extern Agsym_t *findattr(Agraph_t *g, char *name);
extern Agsym_t *findattr(Agnode_t *n, char *name);
extern Agsym_t *findattr(Agedge_t *e, char *name);

/** Misc graph navigators returning handles */
extern Agnode_t *headof(Agedge_t *e);
extern Agnode_t *tailof(Agedge_t *e);
extern Agraph_t *graphof(Agraph_t *g);
extern Agraph_t *graphof(Agedge_t *e);
extern Agraph_t *graphof(Agnode_t *n);
extern Agraph_t *rootof(Agraph_t *g);

/** Obtain handles of proto node/edge for setting default attribute values */
extern Agnode_t *protonode(Agraph_t *g);
extern Agedge_t *protoedge(Agraph_t *g);

/** Iterators */
/*** Iteration termination tests */
extern bool ok(Agraph_t *g);
extern bool ok(Agnode_t *n);
extern bool ok(Agedge_t *e);
extern bool ok(Agsym_t *a);

/*** Iterate over subgraphs of a graph */
extern Agraph_t *firstsubg(Agraph_t *g);
extern Agraph_t *nextsubg(Agraph_t *g, Agraph_t *sg);

/*** Iterate over supergraphs of a graph (obscure and rarely useful) */
extern Agraph_t *firstsupg(Agraph_t *g);
extern Agraph_t *nextsupg(Agraph_t *g, Agraph_t *sg);

/*** Iterate over edges of a graph */
extern Agedge_t *firstedge(Agraph_t *g);
extern Agedge_t *nextedge(Agraph_t *g, Agedge_t *e);

/*** Iterate over outedges of a graph */
extern Agedge_t *firstout(Agraph_t *g);
extern Agedge_t *nextout(Agraph_t *g, Agedge_t *e);

/*** Iterate over edges of a node */
extern Agedge_t *firstedge(Agnode_t *n);
extern Agedge_t *nextedge(Agnode_t *n, Agedge_t *e);

/*** Iterate over out-edges of a node */
extern Agedge_t *firstout(Agnode_t *n);
extern Agedge_t *nextout(Agnode_t *n, Agedge_t *e);

/*** Iterate over head nodes reachable from out-edges of a node */
extern Agnode_t *firsthead(Agnode_t *n);
extern Agnode_t *nexthead(Agnode_t *n, Agnode_t *h);

/*** Iterate over in-edges of a graph */
extern Agedge_t *firstin(Agraph_t *g);
extern Agedge_t *nextin(Agnode_t *n, Agedge_t *e);

/*** Iterate over in-edges of a node */
extern Agedge_t *firstin(Agnode_t *n);
extern Agedge_t *nextin(Agraph_t *g, Agedge_t *e);

/*** Iterate over tail nodes reachable from in-edges of a node */
extern Agnode_t *firsttail(Agnode_t *n);
extern Agnode_t *nexttail(Agnode_t *n, Agnode_t *t);

/*** Iterate over nodes of a graph */
extern Agnode_t *firstnode(Agraph_t *g);
extern Agnode_t *nextnode(Agraph_t *g, Agnode_t *n);

/*** Iterate over nodes of an edge */
extern Agnode_t *firstnode(Agedge_t *e);
extern Agnode_t *nextnode(Agedge_t *e, Agnode_t *n);

/*** Iterate over attributes of a graph */
extern Agsym_t *firstattr(Agraph_t *g);
extern Agsym_t *nextattr(Agraph_t *g, Agsym_t *a);

/*** Iterate over attributes of an edge */
extern Agsym_t *firstattr(Agedge_t *e);
extern Agsym_t *nextattr(Agedge_t *e, Agsym_t *a);

/*** Iterate over attributes of a node */
extern Agsym_t *firstattr(Agnode_t *n);
extern Agsym_t *nextattr(Agnode_t *n, Agsym_t *a);

/** Remove graph objects */
extern void rm(Agraph_t *g);
extern void rm(Agnode_t *n);
extern void rm(Agedge_t *e);

/** Layout */
/*** Annotate a graph with layout attributes and values using a specific layout engine */
extern void layout(Agraph_t *g, char *engine);

/** Render */
/*** Render a layout into attributes of the graph */
extern void render(Agraph_t *g); 

/*** Render a layout in a specific format */
extern void render(Agraph_t *g, char *format);
extern void render(Agraph_t *g, char *format, char *filename);
extern void render(Agraph_t *g, char *format, FILE *f);
extern void render(Agraph_t *g, char *format, void **data);

#ifdef __cplusplus
extern "C" {
#endif
static int _wrap_graph__SWIG_0(lua_State* L) {
    int SWIG_arg;
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    
    if(!lua_isstring(L,1)) SWIG_fail_arg(1);
    arg1 = (char*)lua_tostring(L, 1);
    result = (Agraph_t *)graph(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_digraph(lua_State* L) {
    int SWIG_arg;
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    
    if(!lua_isstring(L,1)) SWIG_fail_arg(1);
    arg1 = (char*)lua_tostring(L, 1);
    result = (Agraph_t *)digraph(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_strictgraph(lua_State* L) {
    int SWIG_arg;
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    
    if(!lua_isstring(L,1)) SWIG_fail_arg(1);
    arg1 = (char*)lua_tostring(L, 1);
    result = (Agraph_t *)strictgraph(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_strictdigraph(lua_State* L) {
    int SWIG_arg;
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    
    if(!lua_isstring(L,1)) SWIG_fail_arg(1);
    arg1 = (char*)lua_tostring(L, 1);
    result = (Agraph_t *)strictdigraph(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_readstring(lua_State* L) {
    int SWIG_arg;
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    
    if(!lua_isstring(L,1)) SWIG_fail_arg(1);
    arg1 = (char*)lua_tostring(L, 1);
    result = (Agraph_t *)readstring(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_read__SWIG_0(lua_State* L) {
    int SWIG_arg;
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    
    if(!lua_isstring(L,1)) SWIG_fail_arg(1);
    arg1 = (char*)lua_tostring(L, 1);
    result = (Agraph_t *)read(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_read__SWIG_1(lua_State* L) {
    int SWIG_arg;
    FILE *arg1 = (FILE *) 0 ;
    Agraph_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(FILE *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_FILE,0,1,"read");
    result = (Agraph_t *)read(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_read(lua_State* L) {
    int argc;
    int argv[2]={
        1,2
    };
    
    argc = lua_gettop(L);
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_FILE, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_read__SWIG_1(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            _v = lua_isstring(L,argv[0]);
        }
        if (_v) {
            return _wrap_read__SWIG_0(L);
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'read'");
    lua_error(L);return 0;
}


static int _wrap_graph__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agraph_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"graph");
    arg2 = (char*)lua_tostring(L, 2);
    result = (Agraph_t *)graph(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_graph(lua_State* L) {
    int argc;
    int argv[3]={
        1,2,3
    };
    
    argc = lua_gettop(L);
    if (argc == 1) {
        int _v;
        {
            _v = lua_isstring(L,argv[0]);
        }
        if (_v) {
            return _wrap_graph__SWIG_0(L);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                return _wrap_graph__SWIG_1(L);
            }
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'graph'");
    lua_error(L);return 0;
}


static int _wrap_node(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agnode_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"node");
    arg2 = (char*)lua_tostring(L, 2);
    result = (Agnode_t *)node(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agnode_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_edge__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"edge");
    arg2=(Agnode_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agnode_t,0,2,"edge");
    result = (Agedge_t *)edge(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_edge__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"edge");
    arg2 = (char*)lua_tostring(L, 2);
    result = (Agedge_t *)edge(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_edge__SWIG_2(lua_State* L) {
    int SWIG_arg;
    char *arg1 = (char *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isstring(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1 = (char*)lua_tostring(L, 1);
    arg2=(Agnode_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agnode_t,0,2,"edge");
    result = (Agedge_t *)edge(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_edge__SWIG_3(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    if(!lua_isstring(L,3)) SWIG_fail_arg(3);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"edge");
    arg2 = (char*)lua_tostring(L, 2);
    arg3 = (char*)lua_tostring(L, 3);
    result = (Agedge_t *)edge(arg1,arg2,arg3);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_edge(lua_State* L) {
    int argc;
    int argv[4]={
        1,2,3,4
    };
    
    argc = lua_gettop(L);
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_edge__SWIG_0(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                return _wrap_edge__SWIG_1(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = lua_isstring(L,argv[0]);
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_edge__SWIG_2(L);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                {
                    _v = lua_isstring(L,argv[2]);
                }
                if (_v) {
                    return _wrap_edge__SWIG_3(L);
                }
            }
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'edge'");
    lua_error(L);return 0;
}


static int _wrap_setv__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    if(!lua_isstring(L,3)) SWIG_fail_arg(3);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"setv");
    arg2 = (char*)lua_tostring(L, 2);
    arg3 = (char*)lua_tostring(L, 3);
    result = (char *)setv(arg1,arg2,arg3);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_setv__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    if(!lua_isstring(L,3)) SWIG_fail_arg(3);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"setv");
    arg2 = (char*)lua_tostring(L, 2);
    arg3 = (char*)lua_tostring(L, 3);
    result = (char *)setv(arg1,arg2,arg3);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_setv__SWIG_2(lua_State* L) {
    int SWIG_arg;
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    if(!lua_isstring(L,3)) SWIG_fail_arg(3);
    arg1=(Agedge_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agedge_t,0,1,"setv");
    arg2 = (char*)lua_tostring(L, 2);
    arg3 = (char*)lua_tostring(L, 3);
    result = (char *)setv(arg1,arg2,arg3);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_setv__SWIG_3(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    if(!lua_isstring(L,3)) SWIG_fail_arg(3);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"setv");
    arg2=(Agsym_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agsym_t,0,2,"setv");
    arg3 = (char*)lua_tostring(L, 3);
    result = (char *)setv(arg1,arg2,arg3);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_setv__SWIG_4(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    if(!lua_isstring(L,3)) SWIG_fail_arg(3);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"setv");
    arg2=(Agsym_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agsym_t,0,2,"setv");
    arg3 = (char*)lua_tostring(L, 3);
    result = (char *)setv(arg1,arg2,arg3);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_setv__SWIG_5(lua_State* L) {
    int SWIG_arg;
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    if(!lua_isstring(L,3)) SWIG_fail_arg(3);
    arg1=(Agedge_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agedge_t,0,1,"setv");
    arg2=(Agsym_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agsym_t,0,2,"setv");
    arg3 = (char*)lua_tostring(L, 3);
    result = (char *)setv(arg1,arg2,arg3);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_setv(lua_State* L) {
    int argc;
    int argv[4]={
        1,2,3,4
    };
    
    argc = lua_gettop(L);
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = lua_isstring(L,argv[2]);
                }
                if (_v) {
                    return _wrap_setv__SWIG_3(L);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = lua_isstring(L,argv[2]);
                }
                if (_v) {
                    return _wrap_setv__SWIG_4(L);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = lua_isstring(L,argv[2]);
                }
                if (_v) {
                    return _wrap_setv__SWIG_5(L);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                {
                    _v = lua_isstring(L,argv[2]);
                }
                if (_v) {
                    return _wrap_setv__SWIG_0(L);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                {
                    _v = lua_isstring(L,argv[2]);
                }
                if (_v) {
                    return _wrap_setv__SWIG_1(L);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                {
                    _v = lua_isstring(L,argv[2]);
                }
                if (_v) {
                    return _wrap_setv__SWIG_2(L);
                }
            }
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'setv'");
    lua_error(L);return 0;
}


static int _wrap_getv__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"getv");
    arg2 = (char*)lua_tostring(L, 2);
    result = (char *)getv(arg1,arg2);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_getv__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"getv");
    arg2 = (char*)lua_tostring(L, 2);
    result = (char *)getv(arg1,arg2);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_getv__SWIG_2(lua_State* L) {
    int SWIG_arg;
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    arg1=(Agedge_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agedge_t,0,1,"getv");
    arg2 = (char*)lua_tostring(L, 2);
    result = (char *)getv(arg1,arg2);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_getv__SWIG_3(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"getv");
    arg2=(Agsym_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agsym_t,0,2,"getv");
    result = (char *)getv(arg1,arg2);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_getv__SWIG_4(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"getv");
    arg2=(Agsym_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agsym_t,0,2,"getv");
    result = (char *)getv(arg1,arg2);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_getv__SWIG_5(lua_State* L) {
    int SWIG_arg;
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agedge_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agedge_t,0,1,"getv");
    arg2=(Agsym_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agsym_t,0,2,"getv");
    result = (char *)getv(arg1,arg2);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_getv(lua_State* L) {
    int argc;
    int argv[3]={
        1,2,3
    };
    
    argc = lua_gettop(L);
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_getv__SWIG_3(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_getv__SWIG_4(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_getv__SWIG_5(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                return _wrap_getv__SWIG_0(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                return _wrap_getv__SWIG_1(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                return _wrap_getv__SWIG_2(L);
            }
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'getv'");
    lua_error(L);return 0;
}


static int _wrap_nameof__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"nameof");
    result = (char *)nameof(arg1);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nameof__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"nameof");
    result = (char *)nameof(arg1);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nameof__SWIG_2(lua_State* L) {
    int SWIG_arg;
    Agsym_t *arg1 = (Agsym_t *) 0 ;
    char *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agsym_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agsym_t,0,1,"nameof");
    result = (char *)nameof(arg1);
    
    SWIG_arg=0;
    lua_pushstring(L,result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nameof(lua_State* L) {
    int argc;
    int argv[2]={
        1,2
    };
    
    argc = lua_gettop(L);
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_nameof__SWIG_0(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_nameof__SWIG_1(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_nameof__SWIG_2(L);
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'nameof'");
    lua_error(L);return 0;
}


static int _wrap_findsubg(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agraph_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"findsubg");
    arg2 = (char*)lua_tostring(L, 2);
    result = (Agraph_t *)findsubg(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_findnode(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agnode_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"findnode");
    arg2 = (char*)lua_tostring(L, 2);
    result = (Agnode_t *)findnode(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agnode_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_findedge(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"findedge");
    arg2=(Agnode_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agnode_t,0,2,"findedge");
    result = (Agedge_t *)findedge(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_findattr__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agsym_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"findattr");
    arg2 = (char*)lua_tostring(L, 2);
    result = (Agsym_t *)findattr(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agsym_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_findattr__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agsym_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"findattr");
    arg2 = (char*)lua_tostring(L, 2);
    result = (Agsym_t *)findattr(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agsym_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_findattr__SWIG_2(lua_State* L) {
    int SWIG_arg;
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agsym_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    arg1=(Agedge_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agedge_t,0,1,"findattr");
    arg2 = (char*)lua_tostring(L, 2);
    result = (Agsym_t *)findattr(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agsym_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_findattr(lua_State* L) {
    int argc;
    int argv[3]={
        1,2,3
    };
    
    argc = lua_gettop(L);
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                return _wrap_findattr__SWIG_0(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                return _wrap_findattr__SWIG_1(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                return _wrap_findattr__SWIG_2(L);
            }
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'findattr'");
    lua_error(L);return 0;
}


static int _wrap_headof(lua_State* L) {
    int SWIG_arg;
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agnode_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agedge_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agedge_t,0,1,"headof");
    result = (Agnode_t *)headof(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agnode_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_tailof(lua_State* L) {
    int SWIG_arg;
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agnode_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agedge_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agedge_t,0,1,"tailof");
    result = (Agnode_t *)tailof(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agnode_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_graphof__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"graphof");
    result = (Agraph_t *)graphof(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_graphof__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agraph_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agedge_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agedge_t,0,1,"graphof");
    result = (Agraph_t *)graphof(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_graphof__SWIG_2(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agraph_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"graphof");
    result = (Agraph_t *)graphof(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_graphof(lua_State* L) {
    int argc;
    int argv[2]={
        1,2
    };
    
    argc = lua_gettop(L);
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_graphof__SWIG_0(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_graphof__SWIG_1(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_graphof__SWIG_2(L);
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'graphof'");
    lua_error(L);return 0;
}


static int _wrap_rootof(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"rootof");
    result = (Agraph_t *)rootof(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_protonode(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agnode_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"protonode");
    result = (Agnode_t *)protonode(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agnode_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_protoedge(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"protoedge");
    result = (Agedge_t *)protoedge(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_ok__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    bool result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"ok");
    result = (bool)ok(arg1);
    
    SWIG_arg=0;
    lua_pushboolean(L,(int)result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_ok__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    bool result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"ok");
    result = (bool)ok(arg1);
    
    SWIG_arg=0;
    lua_pushboolean(L,(int)result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_ok__SWIG_2(lua_State* L) {
    int SWIG_arg;
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    bool result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agedge_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agedge_t,0,1,"ok");
    result = (bool)ok(arg1);
    
    SWIG_arg=0;
    lua_pushboolean(L,(int)result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_ok__SWIG_3(lua_State* L) {
    int SWIG_arg;
    Agsym_t *arg1 = (Agsym_t *) 0 ;
    bool result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agsym_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agsym_t,0,1,"ok");
    result = (bool)ok(arg1);
    
    SWIG_arg=0;
    lua_pushboolean(L,(int)result); SWIG_arg++;
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_ok(lua_State* L) {
    int argc;
    int argv[2]={
        1,2
    };
    
    argc = lua_gettop(L);
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_ok__SWIG_0(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_ok__SWIG_1(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_ok__SWIG_2(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_ok__SWIG_3(L);
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'ok'");
    lua_error(L);return 0;
}


static int _wrap_firstsubg(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"firstsubg");
    result = (Agraph_t *)firstsubg(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nextsubg(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *arg2 = (Agraph_t *) 0 ;
    Agraph_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"nextsubg");
    arg2=(Agraph_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agraph_t,0,2,"nextsubg");
    result = (Agraph_t *)nextsubg(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstsupg(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"firstsupg");
    result = (Agraph_t *)firstsupg(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nextsupg(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *arg2 = (Agraph_t *) 0 ;
    Agraph_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"nextsupg");
    arg2=(Agraph_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agraph_t,0,2,"nextsupg");
    result = (Agraph_t *)nextsupg(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agraph_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstedge__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"firstedge");
    result = (Agedge_t *)firstedge(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nextedge__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"nextedge");
    arg2=(Agedge_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agedge_t,0,2,"nextedge");
    result = (Agedge_t *)nextedge(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstout__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"firstout");
    result = (Agedge_t *)firstout(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nextout__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"nextout");
    arg2=(Agedge_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agedge_t,0,2,"nextout");
    result = (Agedge_t *)nextout(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstedge__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"firstedge");
    result = (Agedge_t *)firstedge(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstedge(lua_State* L) {
    int argc;
    int argv[2]={
        1,2
    };
    
    argc = lua_gettop(L);
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstedge__SWIG_0(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstedge__SWIG_1(L);
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'firstedge'");
    lua_error(L);return 0;
}


static int _wrap_nextedge__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"nextedge");
    arg2=(Agedge_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agedge_t,0,2,"nextedge");
    result = (Agedge_t *)nextedge(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nextedge(lua_State* L) {
    int argc;
    int argv[3]={
        1,2,3
    };
    
    argc = lua_gettop(L);
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextedge__SWIG_0(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextedge__SWIG_1(L);
            }
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'nextedge'");
    lua_error(L);return 0;
}


static int _wrap_firstout__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"firstout");
    result = (Agedge_t *)firstout(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstout(lua_State* L) {
    int argc;
    int argv[2]={
        1,2
    };
    
    argc = lua_gettop(L);
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstout__SWIG_0(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstout__SWIG_1(L);
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'firstout'");
    lua_error(L);return 0;
}


static int _wrap_nextout__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"nextout");
    arg2=(Agedge_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agedge_t,0,2,"nextout");
    result = (Agedge_t *)nextout(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nextout(lua_State* L) {
    int argc;
    int argv[3]={
        1,2,3
    };
    
    argc = lua_gettop(L);
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextout__SWIG_0(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextout__SWIG_1(L);
            }
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'nextout'");
    lua_error(L);return 0;
}


static int _wrap_firsthead(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"firsthead");
    result = (Agnode_t *)firsthead(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agnode_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nexthead(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agnode_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"nexthead");
    arg2=(Agnode_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agnode_t,0,2,"nexthead");
    result = (Agnode_t *)nexthead(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agnode_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstin__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"firstin");
    result = (Agedge_t *)firstin(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nextin__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"nextin");
    arg2=(Agedge_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agedge_t,0,2,"nextin");
    result = (Agedge_t *)nextin(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstin__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"firstin");
    result = (Agedge_t *)firstin(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstin(lua_State* L) {
    int argc;
    int argv[2]={
        1,2
    };
    
    argc = lua_gettop(L);
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstin__SWIG_0(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstin__SWIG_1(L);
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'firstin'");
    lua_error(L);return 0;
}


static int _wrap_nextin__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"nextin");
    arg2=(Agedge_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agedge_t,0,2,"nextin");
    result = (Agedge_t *)nextin(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agedge_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nextin(lua_State* L) {
    int argc;
    int argv[3]={
        1,2,3
    };
    
    argc = lua_gettop(L);
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextin__SWIG_0(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextin__SWIG_1(L);
            }
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'nextin'");
    lua_error(L);return 0;
}


static int _wrap_firsttail(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"firsttail");
    result = (Agnode_t *)firsttail(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agnode_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nexttail(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agnode_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"nexttail");
    arg2=(Agnode_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agnode_t,0,2,"nexttail");
    result = (Agnode_t *)nexttail(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agnode_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstnode__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agnode_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"firstnode");
    result = (Agnode_t *)firstnode(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agnode_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nextnode__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agnode_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"nextnode");
    arg2=(Agnode_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agnode_t,0,2,"nextnode");
    result = (Agnode_t *)nextnode(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agnode_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstnode__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agnode_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agedge_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agedge_t,0,1,"firstnode");
    result = (Agnode_t *)firstnode(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agnode_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstnode(lua_State* L) {
    int argc;
    int argv[2]={
        1,2
    };
    
    argc = lua_gettop(L);
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstnode__SWIG_0(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstnode__SWIG_1(L);
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'firstnode'");
    lua_error(L);return 0;
}


static int _wrap_nextnode__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agnode_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agedge_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agedge_t,0,1,"nextnode");
    arg2=(Agnode_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agnode_t,0,2,"nextnode");
    result = (Agnode_t *)nextnode(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agnode_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nextnode(lua_State* L) {
    int argc;
    int argv[3]={
        1,2,3
    };
    
    argc = lua_gettop(L);
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextnode__SWIG_0(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextnode__SWIG_1(L);
            }
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'nextnode'");
    lua_error(L);return 0;
}


static int _wrap_firstattr__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agsym_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"firstattr");
    result = (Agsym_t *)firstattr(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agsym_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nextattr__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    Agsym_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"nextattr");
    arg2=(Agsym_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agsym_t,0,2,"nextattr");
    result = (Agsym_t *)nextattr(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agsym_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstattr__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agsym_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agedge_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agedge_t,0,1,"firstattr");
    result = (Agsym_t *)firstattr(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agsym_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nextattr__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    Agsym_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agedge_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agedge_t,0,1,"nextattr");
    arg2=(Agsym_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agsym_t,0,2,"nextattr");
    result = (Agsym_t *)nextattr(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agsym_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstattr__SWIG_2(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agsym_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"firstattr");
    result = (Agsym_t *)firstattr(arg1);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agsym_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_firstattr(lua_State* L) {
    int argc;
    int argv[2]={
        1,2
    };
    
    argc = lua_gettop(L);
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstattr__SWIG_0(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstattr__SWIG_1(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstattr__SWIG_2(L);
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'firstattr'");
    lua_error(L);return 0;
}


static int _wrap_nextattr__SWIG_2(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    Agsym_t *result;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isuserdata(L,2)) SWIG_fail_arg(2);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"nextattr");
    arg2=(Agsym_t *)SWIG_MustGetPtr(L,2,SWIGTYPE_p_Agsym_t,0,2,"nextattr");
    result = (Agsym_t *)nextattr(arg1,arg2);
    
    SWIG_arg=0;
    SWIG_NewPointerObj(L,result,SWIGTYPE_p_Agsym_t,0); SWIG_arg++; 
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_nextattr(lua_State* L) {
    int argc;
    int argv[3]={
        1,2,3
    };
    
    argc = lua_gettop(L);
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextattr__SWIG_0(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextattr__SWIG_1(L);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (lua_isuserdata(L,argv[1])==0 || SWIG_ConvertPtr(L,argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextattr__SWIG_2(L);
            }
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'nextattr'");
    lua_error(L);return 0;
}


static int _wrap_rm__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"rm");
    rm(arg1);
    
    SWIG_arg=0;
    
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_rm__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agnode_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agnode_t,0,1,"rm");
    rm(arg1);
    
    SWIG_arg=0;
    
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_rm__SWIG_2(lua_State* L) {
    int SWIG_arg;
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agedge_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agedge_t,0,1,"rm");
    rm(arg1);
    
    SWIG_arg=0;
    
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_rm(lua_State* L) {
    int argc;
    int argv[2]={
        1,2
    };
    
    argc = lua_gettop(L);
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_rm__SWIG_0(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_rm__SWIG_1(L);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_rm__SWIG_2(L);
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'rm'");
    lua_error(L);return 0;
}


static int _wrap_layout(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"layout");
    arg2 = (char*)lua_tostring(L, 2);
    layout(arg1,arg2);
    
    SWIG_arg=0;
    
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_render__SWIG_0(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"render");
    render(arg1);
    
    SWIG_arg=0;
    
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_render__SWIG_1(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"render");
    arg2 = (char*)lua_tostring(L, 2);
    render(arg1,arg2);
    
    SWIG_arg=0;
    
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_render__SWIG_2(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    if(!lua_isstring(L,3)) SWIG_fail_arg(3);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"render");
    arg2 = (char*)lua_tostring(L, 2);
    arg3 = (char*)lua_tostring(L, 3);
    render(arg1,arg2,arg3);
    
    SWIG_arg=0;
    
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_render__SWIG_3(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    FILE *arg3 = (FILE *) 0 ;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    if(!lua_isuserdata(L,3)) SWIG_fail_arg(3);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"render");
    arg2 = (char*)lua_tostring(L, 2);
    arg3=(FILE *)SWIG_MustGetPtr(L,3,SWIGTYPE_p_FILE,0,3,"render");
    render(arg1,arg2,arg3);
    
    SWIG_arg=0;
    
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_render__SWIG_4(lua_State* L) {
    int SWIG_arg;
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    void **arg3 = (void **) 0 ;
    
    if(!lua_isuserdata(L,1)) SWIG_fail_arg(1);
    if(!lua_isstring(L,2)) SWIG_fail_arg(2);
    if(!lua_isuserdata(L,3)) SWIG_fail_arg(3);
    arg1=(Agraph_t *)SWIG_MustGetPtr(L,1,SWIGTYPE_p_Agraph_t,0,1,"render");
    arg2 = (char*)lua_tostring(L, 2);
    arg3=(void **)SWIG_MustGetPtr(L,3,SWIGTYPE_p_p_void,0,3,"render");
    render(arg1,arg2,arg3);
    
    SWIG_arg=0;
    
    return SWIG_arg;
    
    fail:
    lua_error(L);
}


static int _wrap_render(lua_State* L) {
    int argc;
    int argv[4]={
        1,2,3,4
    };
    
    argc = lua_gettop(L);
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_render__SWIG_0(L);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                return _wrap_render__SWIG_1(L);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                {
                    void *ptr;
                    if (lua_isuserdata(L,argv[2])==0 || SWIG_ConvertPtr(L,argv[2], (void **) &ptr, SWIGTYPE_p_FILE, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    return _wrap_render__SWIG_3(L);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                {
                    void *ptr;
                    if (lua_isuserdata(L,argv[2])==0 || SWIG_ConvertPtr(L,argv[2], (void **) &ptr, SWIGTYPE_p_p_void, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    return _wrap_render__SWIG_4(L);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (lua_isuserdata(L,argv[0])==0 || SWIG_ConvertPtr(L,argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = lua_isstring(L,argv[1]);
            }
            if (_v) {
                {
                    _v = lua_isstring(L,argv[2]);
                }
                if (_v) {
                    return _wrap_render__SWIG_2(L);
                }
            }
        }
    }
    
    lua_pushstring(L,"No matching function for overloaded 'render'");
    lua_error(L);return 0;
}


#ifdef __cplusplus
}
#endif

static swig_lua_command_info swig_commands[] = {
    { "digraph", (swig_lua_wrapper_func) _wrap_digraph},
    { "strictgraph", (swig_lua_wrapper_func) _wrap_strictgraph},
    { "strictdigraph", (swig_lua_wrapper_func) _wrap_strictdigraph},
    { "readstring", (swig_lua_wrapper_func) _wrap_readstring},
    { "read", (swig_lua_wrapper_func) _wrap_read},
    { "graph", (swig_lua_wrapper_func) _wrap_graph},
    { "node", (swig_lua_wrapper_func) _wrap_node},
    { "edge", (swig_lua_wrapper_func) _wrap_edge},
    { "setv", (swig_lua_wrapper_func) _wrap_setv},
    { "getv", (swig_lua_wrapper_func) _wrap_getv},
    { "nameof", (swig_lua_wrapper_func) _wrap_nameof},
    { "findsubg", (swig_lua_wrapper_func) _wrap_findsubg},
    { "findnode", (swig_lua_wrapper_func) _wrap_findnode},
    { "findedge", (swig_lua_wrapper_func) _wrap_findedge},
    { "findattr", (swig_lua_wrapper_func) _wrap_findattr},
    { "headof", (swig_lua_wrapper_func) _wrap_headof},
    { "tailof", (swig_lua_wrapper_func) _wrap_tailof},
    { "graphof", (swig_lua_wrapper_func) _wrap_graphof},
    { "rootof", (swig_lua_wrapper_func) _wrap_rootof},
    { "protonode", (swig_lua_wrapper_func) _wrap_protonode},
    { "protoedge", (swig_lua_wrapper_func) _wrap_protoedge},
    { "ok", (swig_lua_wrapper_func) _wrap_ok},
    { "firstsubg", (swig_lua_wrapper_func) _wrap_firstsubg},
    { "nextsubg", (swig_lua_wrapper_func) _wrap_nextsubg},
    { "firstsupg", (swig_lua_wrapper_func) _wrap_firstsupg},
    { "nextsupg", (swig_lua_wrapper_func) _wrap_nextsupg},
    { "firstedge", (swig_lua_wrapper_func) _wrap_firstedge},
    { "nextedge", (swig_lua_wrapper_func) _wrap_nextedge},
    { "firstout", (swig_lua_wrapper_func) _wrap_firstout},
    { "nextout", (swig_lua_wrapper_func) _wrap_nextout},
    { "firsthead", (swig_lua_wrapper_func) _wrap_firsthead},
    { "nexthead", (swig_lua_wrapper_func) _wrap_nexthead},
    { "firstin", (swig_lua_wrapper_func) _wrap_firstin},
    { "nextin", (swig_lua_wrapper_func) _wrap_nextin},
    { "firsttail", (swig_lua_wrapper_func) _wrap_firsttail},
    { "nexttail", (swig_lua_wrapper_func) _wrap_nexttail},
    { "firstnode", (swig_lua_wrapper_func) _wrap_firstnode},
    { "nextnode", (swig_lua_wrapper_func) _wrap_nextnode},
    { "firstattr", (swig_lua_wrapper_func) _wrap_firstattr},
    { "nextattr", (swig_lua_wrapper_func) _wrap_nextattr},
    { "rm", (swig_lua_wrapper_func) _wrap_rm},
    { "layout", (swig_lua_wrapper_func) _wrap_layout},
    { "render", (swig_lua_wrapper_func) _wrap_render},
    {0,0}
};

static swig_lua_var_info swig_variables[] = {
    {0,0,0}
};

static swig_lua_const_info swig_constants[] = {
    {0,0,0,0,0,0}
};

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_Agedge_t = {"_p_Agedge_t", "Agedge_t *", 0, 0, 0};
static swig_type_info _swigt__p_Agnode_t = {"_p_Agnode_t", "Agnode_t *", 0, 0, 0};
static swig_type_info _swigt__p_Agraph_t = {"_p_Agraph_t", "Agraph_t *", 0, 0, 0};
static swig_type_info _swigt__p_Agsym_t = {"_p_Agsym_t", "Agsym_t *", 0, 0, 0};
static swig_type_info _swigt__p_FILE = {"_p_FILE", "FILE *", 0, 0, 0};
static swig_type_info _swigt__p_p_void = {"_p_p_void", "void **", 0, 0, 0};

static swig_type_info *swig_type_initial[] = {
  &_swigt__p_Agedge_t,
  &_swigt__p_Agnode_t,
  &_swigt__p_Agraph_t,
  &_swigt__p_Agsym_t,
  &_swigt__p_FILE,
  &_swigt__p_p_void,
};

static swig_cast_info _swigc__p_Agedge_t[] = {  {&_swigt__p_Agedge_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_Agnode_t[] = {  {&_swigt__p_Agnode_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_Agraph_t[] = {  {&_swigt__p_Agraph_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_Agsym_t[] = {  {&_swigt__p_Agsym_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_FILE[] = {  {&_swigt__p_FILE, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_void[] = {  {&_swigt__p_p_void, 0, 0, 0},{0, 0, 0, 0}};

static swig_cast_info *swig_cast_initial[] = {
  _swigc__p_Agedge_t,
  _swigc__p_Agnode_t,
  _swigc__p_Agraph_t,
  _swigc__p_Agsym_t,
  _swigc__p_FILE,
  _swigc__p_p_void,
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

/*************************************************************************
 * Type initialization:
 * This problem is tough by the requirement that no dynamic 
 * memory is used. Also, since swig_type_info structures store pointers to 
 * swig_cast_info structures and swig_cast_info structures store pointers back
 * to swig_type_info structures, we need some lookup code at initialization. 
 * The idea is that swig generates all the structures that are needed. 
 * The runtime then collects these partially filled structures. 
 * The SWIG_InitializeModule function takes these initial arrays out of 
 * swig_module, and does all the lookup, filling in the swig_module.types
 * array with the correct data and linking the correct swig_cast_info
 * structures together.

 * The generated swig_type_info structures are assigned staticly to an initial 
 * array. We just loop though that array, and handle each type individually.
 * First we lookup if this type has been already loaded, and if so, use the
 * loaded structure instead of the generated one. Then we have to fill in the
 * cast linked list. The cast data is initially stored in something like a
 * two-dimensional array. Each row corresponds to a type (there are the same
 * number of rows as there are in the swig_type_initial array). Each entry in
 * a column is one of the swig_cast_info structures for that type.
 * The cast_initial array is actually an array of arrays, because each row has
 * a variable number of columns. So to actually build the cast linked list,
 * we find the array of casts associated with the type, and loop through it 
 * adding the casts to the list. The one last trick we need to do is making
 * sure the type pointer in the swig_cast_info struct is correct.

 * First off, we lookup the cast->type name to see if it is already loaded. 
 * There are three cases to handle:
 *  1) If the cast->type has already been loaded AND the type we are adding
 *     casting info to has not been loaded (it is in this module), THEN we
 *     replace the cast->type pointer with the type pointer that has already
 *     been loaded.
 *  2) If BOTH types (the one we are adding casting info to, and the 
 *     cast->type) are loaded, THEN the cast info has already been loaded by
 *     the previous module so we just ignore it.
 *  3) Finally, if cast->type has not already been loaded, then we add that
 *     swig_cast_info to the linked list (because the cast->type) pointer will
 *     be correct.
**/

#ifdef __cplusplus
extern "C" {
#endif
    
    SWIGRUNTIME void
    SWIG_InitializeModule(void *clientdata) {
        swig_type_info *type, *ret;
        swig_cast_info *cast;
        size_t i;
        swig_module_info *module_head;
        static int init_run = 0;
        
        clientdata = clientdata;
        
        if (init_run) return;
        init_run = 1;
        
        /* Initialize the swig_module */
        swig_module.type_initial = swig_type_initial;
        swig_module.cast_initial = swig_cast_initial;
        
        /* Try and load any already created modules */
        module_head = SWIG_GetModule(clientdata);
        if (module_head) {
            swig_module.next = module_head->next;
            module_head->next = &swig_module;
        } else {
            /* This is the first module loaded */
            swig_module.next = &swig_module;
            SWIG_SetModule(clientdata, &swig_module);
        }
        
        /* Now work on filling in swig_module.types */
        for (i = 0; i < swig_module.size; ++i) {
            type = 0;
            
            /* if there is another module already loaded */
            if (swig_module.next != &swig_module) {
                type = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, swig_module.type_initial[i]->name);
            }
            if (type) {
                /* Overwrite clientdata field */
                if (swig_module.type_initial[i]->clientdata) type->clientdata = swig_module.type_initial[i]->clientdata;
            } else {
                type = swig_module.type_initial[i];
            }
            
            /* Insert casting types */
            cast = swig_module.cast_initial[i];
            while (cast->type) {
                /* Don't need to add information already in the list */
                ret = 0;
                if (swig_module.next != &swig_module) {
                    ret = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, cast->type->name);
                }
                if (ret && type == swig_module.type_initial[i]) {
                    cast->type = ret;
                    ret = 0;
                }
                
                if (!ret) {
                    if (type->cast) {
                        type->cast->prev = cast;
                        cast->next = type->cast;
                    }
                    type->cast = cast;
                }
                
                cast++;
            }
            
            /* Set entry in modules->types array equal to the type */
            swig_module.types[i] = type;
        }
        swig_module.types[i] = 0;
    }
    
    /* This function will propagate the clientdata field of type to
    * any new swig_type_info structures that have been added into the list
    * of equivalent types.  It is like calling
    * SWIG_TypeClientData(type, clientdata) a second time.
    */
    SWIGRUNTIME void
    SWIG_PropagateClientData(void) {
        size_t i;
        swig_cast_info *equiv;
        static int init_run = 0;
        
        if (init_run) return;
        init_run = 1;
        
        for (i = 0; i < swig_module.size; i++) {
            if (swig_module.types[i]->clientdata) {
                equiv = swig_module.types[i]->cast;
                while (equiv) {
                    if (!equiv->converter) {
                        if (equiv->type && !equiv->type->clientdata)
                        SWIG_TypeClientData(equiv->type, swig_module.types[i]->clientdata);
                    }
                    equiv = equiv->next;
                }
            }
        }
    }
    
#ifdef __cplusplus
}
#endif



#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT int SWIG_init(lua_State* L)
{
    int i;
    
    // start with global table
    lua_pushvalue(L,LUA_GLOBALSINDEX);
    
    SWIG_InitializeModule((void*)L);
    SWIG_PropagateClientData();
    
    // add a global fn
    SWIG_Lua_add_function(L,"swig_type",SWIG_Lua_type);
    SWIG_Lua_add_function(L,"swig_equals",SWIG_Lua_equal);
    
    // begin the module (its a table with the same name as the module)
    SWIG_Lua_module_begin(L,SWIG_name);
    // add commands/functions
    for (i = 0; swig_commands[i].name; i++){
        SWIG_Lua_module_add_function(L,swig_commands[i].name,swig_commands[i].wrapper);
    }
    // add variables
    for (i = 0; swig_variables[i].name; i++){
        SWIG_Lua_module_add_variable(L,swig_variables[i].name,swig_variables[i].get,swig_variables[i].set);
    }
    
    // additional registration structs & classes in lua:
    for (i = 0; swig_types[i]; i++){
        if (swig_types[i]->clientdata){
            SWIG_Lua_class_register(L,(swig_lua_class*)(swig_types[i]->clientdata));
        }
    }
    
    // constants
    SWIG_Lua_InstallConstants(L,swig_constants);
    
    // end module
    SWIG_Lua_module_end(L);
    
    lua_pop(L,1);                      // tidy stack (remove global table)
    
    return 1;
}

// Lua 5.1 has a different name for importing libraries
// luaopen_XXX, where XXX is the name of the module (not capitalised)
// this function will allow Lua 5.1 to import correctly
#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT int SWIG_import(lua_State* L)
{
    return SWIG_init(L);
}



