
        /*---------------------------------------------------------*
         *               AGNPS/GRASS Interface Project             *
         *  Developed in the Agriculture Engineering Department    *
         *                at Purdue University                     *
         *                        by                               *
         *         Raghavan Srinivasan and Bernard Engel           *
         *                                                         *
         *   (c)Copyright, 1992 Purdue Research Foundation, West   *
         *   Lafayette, Indiana 47907. All Rights Reserved. Unless *
         *   permission is granted, this material shall not be     *
         *   copied, reproduced or coded for reproduction by any   *
         *   electrical, mechanical or chemical processes,  or     *
         *   combinations thereof, now known or later developed.   *
         *---------------------------------------------------------*/

/*	August, 1991  Agricultural Engineering, Purdue University
        Raghavan Srinivasan (srin@ecn.purdue.edu)

        CN_hy_cond()

        To create CN, and hydrologic condition map that is required
        by the r.cn program to generate distributed CN. 
        The hy_Cond map will be generated by reclassing the land use map
        to "good" condition. This is assumed and generally true for 
        mid-west conditions. Then run the r.cn program to generate
        CN map.
*/

/* using r.cn2 now instead of r.cn  12/96  MN
 * replaced r.cn with r.cn2  MN 4/2001        */
 
#include "agnps_input.h"


CN_hy_cond()
{
        char buf[512], *tempfile, *s, *s1, t[5], u[80], v[80],
             landuse_tempfile_name[80];
        int     i, j;
        int     nrow, ncol;
        FILE	*fd, *g, *fopen();
        struct Categories landuse_cats;

        nrow = G_window_rows();
        ncol = G_window_cols();

        strcpy(hy_cond->p,"temp_hy_cond");

/* To create a temp file for reclassing the landuse map into hy_cond layer */

        tempfile = G_tempfile();
        fd = fopen(tempfile,"w");

        /* start of code section added by Dave Peterson, April 1996 */
        strcpy(u, "landuse_temp");
        g = fopen(u, "w");

        if (G_read_cats (landuse->p, landuse->mapset, &landuse_cats) < 0){
                clean_up();
                exit(-1);
                }
        /* end of code section added by Dave Peterson, April 1996 */

        for(i = 0; i < nrow; i++)
        {
        G_get_map_row(landuse->fd,landuse->rbuf,i);

          for(j=0;j < ncol;j++)
           {
                  if(landuse->rbuf[j] > 0)
                   { /* start of code section modified by Dave Peterson, April 1996 */
                     s1 = G_get_cat(landuse->rbuf[j], &landuse_cats);
                     s = G_tolcase(s1);

                     /* look for "pasture (good)", "pasture (fair)", or   */
                     /* "pasture (poor)" and pass back "good", "fair", or */
                     /* "poor" in parameter t                             */
                     if (parse_cat_name(s, t) == 0)
                      { /* "pasture (good)", "pasture (fair)", or             */
                        /* "pasture (poor)" found; replace with "pasture" and */
                        /* write "good", "fair", or "poor" to fd              */
                        fprintf(fd, "%d=%d %s\n", landuse->rbuf[j], landuse->rbuf[j],
                                t);
                         fprintf(g, "%d=%d pasture\n", landuse->rbuf[j],
                                landuse->rbuf[j]);
                      }
                     else
                      { fprintf(fd,"%d=%d good\n",landuse->rbuf[j],landuse->rbuf[j]);
                        fprintf(g, "%d=%d %s\n", landuse->rbuf[j], landuse->rbuf[j],
                                s1);
                      } 
                     /* end of code section modified by Dave Peterson, April 1996 */
                   }
           }
        }

        fclose(g); /* added by Dave Peterson, April 1996 */
        fclose(fd);

        /* start of code section added by Dave Peterson, April 1996 */
        /* make temporary copy of landuse map which has category values such as */
        /* "pasture (good)" replaced with "pasture"                             */
        strcpy(landuse_tempfile_name, landuse->p);
        strcat(landuse_tempfile_name, ".temp");
        sprintf(v, "r.reclass input=%s output=%s < %s", landuse->p,
                landuse_tempfile_name, u);
        G_system(v);
        sprintf(v, "/bin/rm -f %s", u);
        /* use temporary copy in place of original file */
        strcpy(landuse->p, landuse_tempfile_name);
        /* end of code section added by Dave Peterson, April 1996 */

        fprintf (stderr,"Creating hy_cond map\n");
        sprintf(buf,"r.reclass input=%s output=%s < %s",landuse->p, hy_cond->p, tempfile);
        G_system(buf);
        sprintf(buf,"/bin/rm -f %s",tempfile);
        G_system(buf);

        if(amc <=0 || amc>3)
        /* assume default AMC as II */
        amc = 2;
        system("rm -f temp_cn"); /* added by Dave Peterson, April 1996 */
        fprintf (stderr,"Creating CN map\n");
        sprintf(buf,"r.cn sg=%s hc=%s lu=%s pr=%s amc=%d cn=temp_cn",hyg->p,hy_cond->p,landuse->p,mgt_practice->p,amc);
        fprintf (stderr,"%s\n",buf);
        G_system(buf);

        strcpy(temp_cn_map->p, "temp_cn");

}


/* look for "pasture (good)", "pasture (fair)", or "pasture (poor)" and pass */
/* back "good", "fair", or "poor" in second_word; return 0 if one of the     */
/* 3 above strings found; else return 1 */
int parse_cat_name(char *cat_val, char *second_word)
 { int i, j, k, found;

   found = 0; i = 0; j = 0;
   for (; ; )
    { switch (j)
       { case 0: if (cat_val[i] == 'p') j++;
                 break;
         case 1: if (cat_val[i] == 'a') j++;
                 else                   j = 0;
                 break;
         case 2: if (cat_val[i] == 's') j++;
                 else                   j = 0;
                 break;
         case 3: if (cat_val[i] == 't') j++;
                 else                   j = 0;
                 break;
         case 4: if (cat_val[i] == 'u') j++;
                 else                   j = 0;
                 break;
         case 5: if (cat_val[i] == 'r') j++;
                 else                   j = 0;
                 break;
         case 6: if (cat_val[i] == 'e') j++;
                 else                   j = 0;
                 break;
         case 7: if (cat_val[i] == ' ' || cat_val[i] == '\t')
                  j++;
                 else
                  j = 0;
                 break;
       }
      if (j == 8)
       { found = 1;
         break;
       }

      if (cat_val[i] == 0) break;

      i++;
    }

  if (!found) return 1;

  i += 2;

  for (j = i, k = 0; j <= i + 3; j++, k++)
   second_word[k] = cat_val[j];
  second_word[k] = 0;

  return 0;
 }
