/*      Get and Resume Elite EDition source code


Get and Resume Elite EDition (GREED)
Copyright (C) 1999  Anoakie Turner

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

For more information on the GPL, please go to:
http://www.gnu.org/copyleft/gpl.html


        Contact:  Anoakie Turner
                  Anoakie.Turner@asu.edu

                  13240 N. 94th Pl.
                  Scottsdale, AZ 85260
*/

#include "main.h"


bool Parse(URLp URL)
/*************************************
**	bool Parse(URLp URL);
**
**	Parses a URL
**
** Pre:  Assigned (URL->name)
** Post: URL->name parsed, URL->(filename, file, protocol, user, pass, cport, server, port)
**	 set.  Returns 1 if successful.
*************************************/
{	int at = 0;
	int i = 0;
	int alt = 0;
	char *alt_file = NULL;
	char *tempbuf, *tempbuf2;
	dlstat = 0;
	dldots = 0;
	URL->retry = 1;


	if (OUTPUT_LEVEL > 0)
		printf("[ PARSING URL %s ]\n", URL->name);
	tempbuf = strstr(URL->name, "url=");
	if (tempbuf != NULL)
		URL->name = tempbuf + 4;

	tempbuf2 = strstr(URL->name, "...");
	if (tempbuf2 != NULL)
	{	tempbuf2[0] = '\0';
		alt_file = ReadString2(tempbuf2 + 3, '\0');
		alt = 1;
	}


	/* Finds the last '@' in the URL */
	for(i = strlen(URL->name); i > 0 && URL->name[i] != '@'; i--);
	if(URL->name[i] == '@')
	{	at = i;
		for (i = 7; i < at && URL->name[i] != '/'; i++);
		if(i != at)
			at = 0;
	}

	i = 7;

	/* If 'f' starts the URL, it assumes it's FTP, else HTTP */
	if(URL->name[0] == 'f' || URL->name[0] == 'F')
	{	/*	unescape_url(URL->name);	*/
		URL->protocol = FTP, i--;
		URL->cport = "21";
	} else
	{	URL->protocol = HTTP;
		URL->cport = "80";
	}

	if (strstr(URL->name, "tp://") != NULL && at)
		/* If there is an '@' (at is > 0), then it assumes there
			is a password */
	{	if (URL->protocol == HTTP)
		{	URL->pass = ReadString(URL->name, &i, '\0', at), i++;
			URL->user = Base64Encode(URL->pass);
		} else
		{	URL->user = ReadString(URL->name, &i, ':', at), i++;
			URL->pass = ReadString(URL->name, &i, '\0', at), i++;
		}
	} else
	{	URL->user = "anonymous";
		URL->pass = "-anonuser@anonymous.com";
		if (strstr(URL->name, "tp://") == NULL)
			i = 0;
	}

	at = i;
	/* Search for the server ...tp://SERVER:PORT/... */
	tempbuf = ReadString(URL->name, &i, ':', strlen(URL->name));

	/* If there is no ':' then use the default ports, else there is a port! */
	if (URL->name[i] != ':' || strstr(tempbuf, "/") != NULL)
	{	i = at;
		free(tempbuf);
		URL->server = ReadString(URL->name, &i, '/', strlen(URL->name));
	} else
	{	i++;
		URL->server = tempbuf;
		URL->cport = ReadString(URL->name, &i, '/', strlen(URL->name));
	}

	/* Reads the directory and file from the URL */
	URL->file = ReadString(URL->name, &i, '\0', strlen(URL->name));
	tempbuf = strrchr(URL->file, '#');
	if (tempbuf != NULL && strchr(tempbuf, '/') == NULL)
		tempbuf[0] = '\0';

	/* Searches backwards for the filename */
	for (i = strlen(URL->name); i > 0 && URL->name[i] != '/'; i--);

	/* Copies the filename from URL->name */
	i++, URL->filename = ReadString(URL->name, &i, '\0', strlen(URL->name));

	/* if there is no file, then it assumes it's an index.html */
	if (URL->file[0] == '\0')
	{	URL->file = "/";
		if (URL->protocol == HTTP)
			URL->filename = URL->server;
		else
			URL->filename = NULL;
	} else if (URL->file[strlen(URL->file) - 1] == '/')
	{	if (URL->protocol == HTTP)
			URL->filename = URL->server;
		else
			URL->filename = NULL;
	}

	/* If a ? exists in the file name, concatinate the file name
		to the point before the questionmark */
	if (URL->filename != NULL)
		tempbuf = strchr(URL->filename, '?');
	else
		tempbuf = NULL;
	if(tempbuf != NULL)
		tempbuf[0] = '\0';
	if (URL->filename != NULL)
		tempbuf = strchr(URL->filename, '&');
	else
		tempbuf = NULL;
	if(tempbuf != NULL)
		tempbuf[0] = '\0';

	/* If a # exists in the file name, concatinate the file name
		to the point before the pound sign */
	if (URL->filename != NULL)
		tempbuf = strchr(URL->filename, '#');
	else
		tempbuf = NULL;
	if(tempbuf != NULL)
		tempbuf[0] = '\0';

	URL->port = atoi(URL->cport);
	if (alt)
		URL->filename = alt_file;

	return (1);
}
