/* gst-editor
 * Copyright (C) <2001> Steve Baker <stevebaker_org@yahoo.co.uk>
 * Copyright (C) <2002> Andy Wingo <wingo@pobox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include <string.h>

#include "debug-ui.h"

static void
debug_toggle_callback(GtkWidget *widget, gpointer mode_ptr){
	guint32 debug_mode = GPOINTER_TO_INT(mode_ptr);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget))){
		gst_info_enable_category(debug_mode);
		gst_debug_enable_category(debug_mode);
	}
	else {
		gst_info_disable_category(debug_mode);
		gst_debug_disable_category(debug_mode);
	}
}

static void
debug_select_callback(GtkWidget *widget, GSList *debug_list)
{
	gchar *name = gtk_object_get_data(GTK_OBJECT(widget), "name");
	gboolean select = (strstr(name, "deselect all") == NULL);
	while (debug_list){
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(debug_list->data), select);
		debug_list = g_slist_next(debug_list);
	}
}

GtkWidget *gst_debug_ui_new (void)
{
	guint32 debug_mode;
	GtkWidget *debug_box, *debug_buts, *debug_but, *scrolled;
	GSList *debug_list = NULL;
	
	scrolled = gtk_scrolled_window_new(NULL,NULL);
	
	debug_box = gtk_vbox_new(TRUE, 0);
	debug_buts = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(debug_box),debug_buts,FALSE,FALSE,0);
	
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled), debug_box);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	
	for (debug_mode = 0 ; (debug_mode < GST_CAT_MAX_CATEGORY) && 
	                      (gst_get_category_name(debug_mode) != NULL); debug_mode++){
		GtkWidget *debug_enable = gtk_check_button_new_with_label (gst_get_category_name(debug_mode));
		
		debug_list = g_slist_append(debug_list, debug_enable);

		gtk_box_pack_start(GTK_BOX(debug_box),debug_enable,TRUE,TRUE,0);
		gtk_signal_connect (GTK_OBJECT (debug_enable), "toggled",
		                    GTK_SIGNAL_FUNC (debug_toggle_callback), GINT_TO_POINTER(debug_mode));
	}

	debug_but = gtk_button_new_with_label("select all");
	gtk_box_pack_start(GTK_BOX(debug_buts),debug_but,TRUE,TRUE,0);
	gtk_object_set_data(GTK_OBJECT(debug_but), "name", "select all");
	gtk_signal_connect (GTK_OBJECT (debug_but), "clicked",
	                    GTK_SIGNAL_FUNC (debug_select_callback), debug_list);

	debug_but = gtk_button_new_with_label("deselect all");
	gtk_box_pack_start(GTK_BOX(debug_buts),debug_but,TRUE,TRUE,0);
	gtk_object_set_data(GTK_OBJECT(debug_but), "name", "deselect all");
	gtk_signal_connect (GTK_OBJECT (debug_but), "clicked",
	                    GTK_SIGNAL_FUNC (debug_select_callback), debug_list);

        return scrolled;
}
