/* gst-editor
 * Copyright (C) <2001> Steve Baker <stevebaker_org@yahoo.co.uk>
 * Copyright (C) <2002, 2003> Andy Wingo <wingo at pobox dotcom>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <glade/glade.h>

#include "debug-ui.h"
#if (GST_VERSION_MAJOR == 0) && (GST_VERSION_MINOR < 7)
#include "debug-ui-0_6.c"
void editor_debug_init(void)
{
}

#else

enum 
{
  COL_NAME,
  COL_DESCRIPTION,
  COL_LEVEL,
  COL_CATEGORY,
  NUM_COLS
};

GST_DEBUG_CATEGORY(editor_debug_cat);

void editor_debug_init(void)
{
  GST_DEBUG_CATEGORY_INIT (editor_debug_cat, "Application", 0, "Application messages");
}

static void
refresh_categories (GtkWidget *button, GtkWidget *tview)
{
  GtkListStore *lstore;
  GtkTreeIter iter;
  GSList *slist;
  
  lstore = gtk_list_store_new (NUM_COLS, G_TYPE_STRING, G_TYPE_STRING,
                               G_TYPE_STRING, G_TYPE_POINTER);

  slist = gst_debug_get_all_categories ();
  
  while (slist) {
    GstDebugCategory *cat = (GstDebugCategory*)slist->data;
    gchar *level = g_strdup_printf ("%d", gst_debug_category_get_threshold (cat));

    gtk_list_store_append (lstore, &iter);
    gtk_list_store_set (lstore, &iter,
                        COL_NAME, gst_debug_category_get_name (cat),
                        COL_DESCRIPTION, gst_debug_category_get_description (cat),
                        COL_LEVEL, level,
                        COL_CATEGORY, cat,
                        -1);
    g_free (level);
    slist = slist->next;
  }
  
  /* I don't really grok the sorting stuff atm, and I have to do other work
   * now */
  gtk_tree_view_set_model (GTK_TREE_VIEW (tview), 
                           gtk_tree_model_sort_new_with_model (GTK_TREE_MODEL (lstore)));
}

static void
set_default_level (GtkAdjustment *adj, GtkWidget *tview)
{
  gst_debug_set_default_threshold ((int) adj->value);
  refresh_categories (NULL, tview);
}

GtkWidget *gst_debug_ui_new (void)
{
  GladeXML *xml;
  GtkWidget *vbox, *refresh_button, *tview, *default_hscale;
  GtkAdjustment *adj;
  struct stat statbuf;
	
  if (stat (DATADIR "gst-debug-ui.glade2", &statbuf) == 0) {
    xml = glade_xml_new (DATADIR "gst-debug-ui.glade2", "debug-ui-vbox", NULL);
  } else {
    g_print ("loading from %s\n", "src/gst-debug-ui.glade2");
    xml = glade_xml_new ("src/gst-debug-ui.glade2", "debug-ui-vbox", NULL);
  }

  if (!xml) {
    g_critical ("GstDebugUI user interface file %s not found. "
                "Try running from the Gst-Editor source directory.",
                "gst-debug-ui.glade2");
    return NULL;
  }

  vbox = glade_xml_get_widget (xml, "debug-ui-vbox");
  refresh_button = glade_xml_get_widget (xml, "refresh-button");
  tview = glade_xml_get_widget (xml, "custom-levels-treeview");
  default_hscale = glade_xml_get_widget (xml, "default-level-hscale");
  adj = gtk_range_get_adjustment (GTK_RANGE (default_hscale));
  
  g_signal_connect (adj,
                    "value-changed",
                    G_CALLBACK (set_default_level),
                    tview);

  adj->value = gst_debug_get_default_threshold ();
  set_default_level (adj, tview);

  /* ideally, i'd like to render the thresholds with a slider bar. but that
   * would require writing a new cell renderer, and i just don't care that much
   * right now. */
  gtk_tree_view_append_column (GTK_TREE_VIEW (tview),
                               gtk_tree_view_column_new_with_attributes
                               ("Name",
                                gtk_cell_renderer_text_new (),
                                "text", COL_NAME,
                                NULL));
  gtk_tree_view_append_column (GTK_TREE_VIEW (tview),
                               gtk_tree_view_column_new_with_attributes
                               ("Description",
                                gtk_cell_renderer_text_new (),
                                "text", COL_DESCRIPTION,
                                NULL));
  gtk_tree_view_append_column (GTK_TREE_VIEW (tview),
                               gtk_tree_view_column_new_with_attributes
                               ("Level",
                                gtk_cell_renderer_text_new (),
                                "text", COL_LEVEL,
                                NULL));

  return vbox;
}
#endif
