// -*- C++ -*-

/* window_test_boxes.cc
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "window_test_contour.h"
#include <math.h>

Window_Test_Contour::Window_Test_Contour()
: m_VBox(false, 0),
  m_PlotCanvas(GTK_PLOT_LETTER_W, GTK_PLOT_LETTER_H, 1),
  m_Plot3D(0, .50, .50),
  m_Plot(0, .40, .40),
  m_PlotCSurface1((GtkPlotFunc3D) function),
  m_PlotCSurface2((GtkPlotFunc3D) function),
  m_Button1("1"),
  m_Button2("2"),
  m_ButtonRotateX("Rotate X"),
  m_ButtonRotateY("Rotate Y"),
  m_ButtonRotateZ("Rotate Z"),
  m_vecDataSets(5)
{ 
  set_title("GtkExtra::Plot3D Demo");
  set_usize(550, 650);
  m_VBox.set_border_width(0);
  add(m_VBox);

  m_ScrolledWindow.set_border_width(0);
  m_ScrolledWindow.set_policy(GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
  m_VBox.pack_start(m_ScrolledWindow, true, true, 0);
  
  m_PlotCanvas.set_flags(GTK_PLOT_CANVAS_DND_FLAGS);
  m_ScrolledWindow.add_with_viewport(m_PlotCanvas);

  //Plot3D:
  
  m_PlotCanvas.add_plot(m_Plot3D, .16, .02);
 
  
  m_Plot3D.axis_set_minor_ticks(GTK_PLOT_AXIS_X, 3);
  m_Plot3D.axis_set_minor_ticks(GTK_PLOT_AXIS_Y, 3);
  m_Plot3D.minor_grids_set_visible(false, false, false);

  //PlotCSurface is derived from PlotData.
  m_PlotCSurface1.set_xstep(0.025);
  m_PlotCSurface1.set_ystep(0.025);
  m_PlotCSurface1.set_legend("cos ((r-r\\s0\\N)\\S2\\N)");

  m_Plot3D.add_data(&m_PlotCSurface1);
  m_PlotCSurface1.set_gradient(.2, .8, 6);
  m_PlotCSurface1.show();

  m_Plot3D.show();

  //Plot:
  m_PlotCanvas.add_plot(m_Plot, .26, .56);

  //Cast to GtkPlotOrientation cast because function seems to take the wrong type.
  //This bug has been reported. TODO.
  m_Plot.axis_set_minor_ticks((GtkPlotOrientation)GTK_PLOT_AXIS_LEFT, 1);
  m_Plot.axis_set_minor_ticks((GtkPlotOrientation)GTK_PLOT_AXIS_BOTTOM, 1);

  m_PlotCSurface2.set_xstep(0.05);
  m_PlotCSurface2.set_ystep(0.05);

  m_PlotCSurface2.set_legend("cos ((r-r\\s0\\N)\\S2\\N)");
  m_Plot.add_data(&m_PlotCSurface2);
  m_PlotCSurface2.set_gradient(.2, .8, 6);
  m_PlotCSurface2.set_grid_visible(false);
  m_PlotCSurface2.show();

  
  //Buttons:
  m_PlotCanvas.put(m_ButtonRotateX, 80, 0);
  m_ButtonRotateX.clicked.connect(slot(this, &Window_Test_Contour::on_ButtonRotateX_clicked));

  m_PlotCanvas.put(m_ButtonRotateY, 160, 0);
  m_ButtonRotateY.clicked.connect(slot(this, &Window_Test_Contour::on_ButtonRotateY_clicked));

  m_PlotCanvas.put(m_ButtonRotateZ, 240, 0);
  m_ButtonRotateZ.clicked.connect(slot(this, &Window_Test_Contour::on_ButtonRotateZ_clicked));

  
  
  m_PlotCanvas.select_item.connect(slot(this, &Window_Test_Contour::on_PlotCanvas_select_item));

  //1/2 Buttons:
  m_Button1.set_usize(20, 20);
  m_Button2.set_usize(20, 20); 
  m_PlotCanvas.put(m_Button1, 0, 0);
  m_PlotCanvas.put(m_Button2, 20, 0);
   
  m_Button1.toggled.connect(bind<gint>(slot(this, &Window_Test_Contour::on_Button_toggled), 1));
  m_Button2.toggled.connect(bind<gint>(slot(this, &Window_Test_Contour::on_Button_toggled), 2));

  show_all();
  
  // (show the window before printing)
  m_PlotCanvas.export_ps("democsurface.ps", GTK_PLOT_PORTRAIT, false, GTK_PLOT_LETTER);
}

Window_Test_Contour::~Window_Test_Contour()
{
}

gint Window_Test_Contour::delete_event_impl(GdkEventAny*)
{ 
  Gtk::Main::quit();
  return 0; 
}



gint
Window_Test_Contour::on_PlotCanvas_select_item(GdkEventButton* event, GtkPlotCanvasChild* item)
{
  if(item)
  {
	  switch(item->type)
	  {
	    case GTK_PLOT_CANVAS_TEXT:
          printf("Item selected: TEXT\n");
          break;
	    case GTK_PLOT_CANVAS_TITLE:
          printf("Item selected: TITLE\n");
          break;
	    case GTK_PLOT_CANVAS_LEGENDS:
          printf("Item selected: LEGENDS\n");
          break;
	    case GTK_PLOT_CANVAS_PLOT:
          printf("Item selected: PLOT\n");
          break;
	    case GTK_PLOT_CANVAS_AXIS:
          printf("Item selected: AXIS\n");
          break;
	    case GTK_PLOT_CANVAS_DATA:
	    {
          printf("Item selected: DATA\n");

          /* This isn't the same as active_x and active_y - they are always 0.
          gdouble x = 0;
          gdouble y = 0;
          m_PlotCanvas.get_active_point(x, y); 
          */
          printf("Active point: %d -> %f %f\n", 
                m_PlotCanvas.gtkobj()->active_point, //Not wrapped, because I'm not sure that it's really needed.
                m_PlotCanvas.gtkobj()->active_x, //See note above.
                m_PlotCanvas.gtkobj()->active_y //See note above.
                );
           
          break;
        }
	    case GTK_PLOT_CANVAS_NONE:
          printf("Item selected: NONE\n");
          break;
	    case GTK_PLOT_CANVAS_CUSTOM:
          printf("This is a custom child. Isn't it neat?\n");
          break;
        default:
          break;
	  }
  }

  if(item->type == GTK_PLOT_CANVAS_PLOT)
	{
	  //Activate the appropriate button:
	  //This doesn't really work, because the active_plot is the previously active plot,
	  //not the plot that will be active after this signal handler returns true.
	  //However, it doesn't work in the C version either, so this is a faithful transaltion.
	  
	  GtkExtra::Plot* pPlotActive = m_PlotCanvas.get_active_plot();
	  if(pPlotActive)
	  {
	    if(pPlotActive == &m_Plot3D)
	    {
	      if(!m_Button1.get_active())
	      {
	        m_Button1.set_active(true);
	        m_Button2.set_active(false);
	      }
	    }
	    else if(pPlotActive == &m_Plot)
	    {
	      if(!m_Button2.get_active())
	      {
	        m_Button2.set_active(true);
	        m_Button1.set_active(false);
	      }
	    }
	  }
	}

  return true;
}

//iButtonNumber parameter is from a bind<>:
void
Window_Test_Contour::on_Button_toggled(gint iButtonNumber)
{
  //Select the apropriate plot:
  //Activate the appropriate grid:
  //This doesn't seem to do anything. Maybe 'active' != 'selected'.
  //However, it doesn't work in the C version either, so this is a faithful transaltion.
  GtkExtra::Plot* pPlot = 0;
  if(iButtonNumber == 1)
  {
    pPlot = &m_Plot3D;
  }
  else if(iButtonNumber == 2)
  {
    pPlot = &m_Plot;
  }

  if(pPlot)
  {
    m_PlotCanvas.set_active_plot(*pPlot);
  }
}

void
Window_Test_Contour::activate_plot(gint iPlotNumber)
{
  GtkExtra::Plot* pPlot = 0;
  Gtk::ToggleButton* pButton = 0;
  Gtk::ToggleButton* pButtonOther = 0;
  if(iPlotNumber == 1)
  {
    pPlot = &m_Plot3D;
    pButton = &m_Button1;
    pButtonOther = &m_Button2;
  }
  else if(iPlotNumber == 2)
  {
    pPlot = &m_Plot;
    pButton = &m_Button2;
    pButtonOther = &m_Button1;
  }

  if(pPlot && pButton)
  {
    m_PlotCanvas.set_active_plot(*pPlot);
    if(!(pButton->get_active())) pButton->set_active(true);
    //pButton->set_mode(true);
    
    if(pButtonOther->get_active()) pButtonOther->set_active(false);
    //pButtonOther->set_mode(false);

    pButton->queue_draw();
  }
}


void Window_Test_Contour::on_ButtonRotateX_clicked()
{
 GtkExtra::Plot* pActivePlot = m_PlotCanvas.get_active_plot();

  GtkExtra::Plot3D* pPlot3D = dynamic_cast<GtkExtra::Plot3D*>(pActivePlot);
  if(pPlot3D) //If the Plot3D is selected
  {
    pPlot3D->rotate_x(10);
    m_PlotCanvas.paint();
    m_PlotCanvas.refresh();
  }
}

void Window_Test_Contour::on_ButtonRotateY_clicked()
{
  GtkExtra::Plot* pActivePlot = m_PlotCanvas.get_active_plot();

  GtkExtra::Plot3D* pPlot3D = dynamic_cast<GtkExtra::Plot3D*>(pActivePlot);
  if(pPlot3D) //If the Plot3D is selected
  {
    pPlot3D->rotate_y(10);
    m_PlotCanvas.paint();
    m_PlotCanvas.refresh();
  }
}

void Window_Test_Contour::on_ButtonRotateZ_clicked()
{
  GtkExtra::Plot* pActivePlot = m_PlotCanvas.get_active_plot();

  GtkExtra::Plot3D* pPlot3D = dynamic_cast<GtkExtra::Plot3D*>(pActivePlot);
  if(pPlot3D) //If the Plot3D is selected
  {
    pPlot3D->rotate_z(10);
    m_PlotCanvas.paint();
    m_PlotCanvas.refresh();
  }
}


//Global function copied from C example:
gdouble function(GtkPlot *plot, 
                 GtkPlotData *data, 
                 gdouble x, gdouble y, gboolean *err)
{
 gdouble z;
 *err = FALSE;

 z = cos(((x-0.5)*(x-0.5) + (y-0.5)*(y-0.5))*24) / 4. + .5;
 return z;
}
