// -*- C++ -*-

/* sheet_numeric_with_popup.h
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef HEADER_SHEET_NUMERIC_WITHPOPUP
#define HEADER_SHEET_NUMERIC_WITHPOPUP

#include "sheet_numeric.h"
#include "menu_popup.h"

using SigC::bind;
using SigC::slot;

class Sheet_Numeric_WithPopup : public Sheet_Numeric
{
public:
  Sheet_Numeric_WithPopup(gint rows, gint columns, const nstring& title);
  virtual ~Sheet_Numeric_WithPopup();
  
protected:

  //Signal handlers:
  virtual gint on_button_press_event_Popup(GdkEventButton* key);
  
  virtual void on_MenuPopup_activate_AddColumn();
  virtual void on_MenuPopup_activate_AddRow();
  virtual void on_MenuPopup_activate_InsertRow();
  virtual void on_MenuPopup_activate_InsertColumn();
  virtual void on_MenuPopup_activate_DeleteRow();
  virtual void on_MenuPopup_activate_DeleteColumn();
  virtual void on_MenuPopup_activate_ClearCells();

  //Child widgets:
  Menu_Popup m_MenuPopup;
  virtual void configure_menu();

};

#endif //HEADER_SHEET_NUMERIC_WITHPOPUP
