# Configure paths for GtkExtra--
# Erik Andersen	30 May 1998
# Modified by Tero Pulkkinen (added the compiler checks... I hope they work..)
# Modified by Thomas Langen 16 Jan 2000 (corrected CXXFLAGS)
# Adapted to the gtkextra-- library by Cedric Gustin 11 Feb 2000

dnl Test for GTKEXTRAMM, and define GTKEXTRAMM_CFLAGS and GTKEXTRAMM_LIBS
dnl   to be used as follows:
dnl AM_PATH_GTKEXTRAMM([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl
AC_DEFUN(AM_PATH_GTKEXTRAMM,
[dnl 
dnl Get the cflags and libraries from the gtkextramm-config script
dnl
AC_ARG_WITH(gtkextramm-prefix,[  --with-gtkextramm-prefix=PREFIX
                          Prefix where GtkExtra-- is installed (optional)],
            gtkextramm_config_prefix="$withval", gtkextramm_config_prefix="")
AC_ARG_WITH(gtkextramm-exec-prefix,[  --with-gtkextramm-exec-prefix=PREFIX
                          Exec prefix where GtkExtra-- is installed (optional)],
            gtkextramm_config_exec_prefix="$withval", gtkextramm_config_exec_prefix="")
AC_ARG_ENABLE(gtkextrammtest, [  --disable-gtkextrammtest     Do not try to compile and run a test GtkExtra-- program],
		    , enable_gtkextrammtest=yes)

  if test x$gtkextramm_config_exec_prefix != x ; then
     gtkextramm_config_args="$gtkextramm_config_args --exec-prefix=$gtkextramm_config_exec_prefix"
     if test x${GTKEXTRAMM_CONFIG+set} != xset ; then
        GTKEXTRAMM_CONFIG=$gtkextramm_config_exec_prefix/bin/gtkextramm-config
     fi
  fi
  if test x$gtkextramm_config_prefix != x ; then
     gtkextramm_config_args="$gtkextramm_config_args --prefix=$gtkextramm_config_prefix"
     if test x${GTKEXTRAMM_CONFIG+set} != xset ; then
        GTKEXTRAMM_CONFIG=$gtkextramm_config_prefix/bin/gtkextramm-config
     fi
  fi

  AC_PATH_PROG(GTKEXTRAMM_CONFIG, gtkextramm-config, no)
  min_gtkextramm_version=ifelse([$1], ,0.1.1,$1)

  AC_MSG_CHECKING(for GtkExtra-- - version >= $min_gtkextramm_version)
  no_gtkextramm=""
  if test "$GTKEXTRAMM_CONFIG" = "no" ; then
    no_gtkextramm=yes
  else
    AC_LANG_SAVE
    AC_LANG_CPLUSPLUS

    GTKEXTRAMM_CFLAGS=`$GTKEXTRAMM_CONFIG $gtkextramm_config_args --cflags`
    GTKEXTRAMM_LIBS=`$GTKEXTRAMM_CONFIG $gtkextramm_config_args --libs`
    gtkextramm_config_major_version=`$GTKEXTRAMM_CONFIG $gtkextramm_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    gtkextramm_config_minor_version=`$GTKEXTRAMM_CONFIG $gtkextramm_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    gtkextramm_config_micro_version=`$GTKEXTRAMM_CONFIG $gtkextramm_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_gtkextrammtest" = "xyes" ; then
      ac_save_CXXFLAGS="$CXXFLAGS"
      ac_save_LIBS="$LIBS"
      CXXFLAGS="$CXXFLAGS $GTKEXTRAMM_CFLAGS"
      LIBS="$LIBS $GTKEXTRAMM_LIBS"
dnl
dnl Now check if the installed GtkExtra-- is sufficiently new. (Also sanity
dnl checks the results of gtkextramm-config to some extent
dnl
      rm -f conf.gtkextrammtest
      AC_TRY_RUN([
#include <gtkextra--.h>
#include <stdio.h>
#include <stdlib.h>

int 
main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.gtkextrammtest");

  /* HP/UX 0 (%@#!) writes to sscanf strings */
  tmp_version = g_strdup("$min_gtkextramm_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_gtkextramm_version");
     exit(1);
   }

  if ((gtkextramm_major_version != $gtkextramm_config_major_version) ||
      (gtkextramm_minor_version != $gtkextramm_config_minor_version) ||
      (gtkextramm_micro_version != $gtkextramm_config_micro_version))
    {
      printf("\n*** 'gtkextramm-config --version' returned %d.%d.%d, but GtkExtra-- (%d.%d.%d)\n", 
             $gtkextramm_config_major_version, $gtkextramm_config_minor_version, $gtkextramm_config_micro_version,
             gtkextramm_major_version, gtkextramm_minor_version, gtkextramm_micro_version);
      printf ("*** was found! If gtkextramm-config was correct, then it is best\n");
      printf ("*** to remove the old version of GtkExtra--. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If gtkextramm-config was wrong, set the environment variable GTKEXTRAMM_CONFIG\n");
      printf("*** to point to the correct copy of gtkextramm-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    } 
/* GtkExtra-- does not have the GTKEXTRAMM_*_VERSION constants */
/* 
  else if ((gtkextramm_major_version != GTKEXTRAMM_MAJOR_VERSION) ||
	   (gtkextramm_minor_version != GTKEXTRAMM_MINOR_VERSION) ||
           (gtkextramm_micro_version != GTKEXTRAMM_MICRO_VERSION))
    {
      printf("*** GtkExtra-- header files (version %d.%d.%d) do not match\n",
	     GTKEXTRAMM_MAJOR_VERSION, GTKEXTRAMM_MINOR_VERSION, GTKEXTRAMM_MICRO_VERSION);
      printf("*** library (version %d.%d.%d)\n",
	     gtkextramm_major_version, gtkextramm_minor_version, gtkextramm_micro_version);
    }
*/
  else
    {
      if ((gtkextramm_major_version > major) ||
        ((gtkextramm_major_version == major) && (gtkextramm_minor_version > minor)) ||
        ((gtkextramm_major_version == major) && (gtkextramm_minor_version == minor) && (gtkextramm_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of GtkExtra-- (%d.%d.%d) was found.\n",
               gtkextramm_major_version, gtkextramm_minor_version, gtkextramm_micro_version);
        printf("*** You need a version of GtkExtra-- newer than %d.%d.%d. The latest version of\n",
	       major, minor, micro);
        printf("*** GtkExtra-- is always available from ftp://ftp.gtk.org.\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the gtkextramm-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of GtkExtra--, but you can also set the GTKEXTRAMM_CONFIG environment to point to the\n");
        printf("*** correct copy of gtkextramm-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_gtkextramm=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CXXFLAGS="$ac_save_CXXFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_gtkextramm" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$GTKEXTRAMM_CONFIG" = "no" ; then
       echo "*** The gtkextramm-config script installed by GtkExtra-- could not be found"
       echo "*** If GtkExtra-- was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the GTKEXTRAMM_CONFIG environment variable to the"
       echo "*** full path to gtkextramm-config."
       echo "*** The gtkextramm-config script was not available in GtkExtra-- versions"
       echo "*** prior to 0.9.12. Perhaps you need to update your installed"
       echo "*** version to 0.9.12 or later"
     else
       if test -f conf.gtkextrammtest ; then
        :
       else
          echo "*** Could not run GtkExtra-- test program, checking why..."
          CXXFLAGS="$CXXFLAGS $GTKEXTRAMM_CFLAGS"
          LIBS="$LIBS $GTKEXTRAMM_LIBS"
          AC_TRY_LINK([
#include <gtkextra--.h>
#include <stdio.h>
],      [ return ((gtkextramm_major_version) || (gtkextramm_minor_version) || (gtkextramm_micro_version)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding GtkExtra-- or finding the wrong"
          echo "*** version of GtkExtra--. If it is not finding GtkExtra--, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means GtkExtra-- was incorrectly installed"
          echo "*** or that you have moved GtkExtra-- since it was installed. In the latter case, you"
          echo "*** may want to edit the gtkextramm-config script: $GTKEXTRAMM_CONFIG" ])
          CXXFLAGS="$ac_save_CXXFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     GTKEXTRAMM_CFLAGS=""
     GTKEXTRAMM_LIBS=""
     ifelse([$3], , :, [$3])
     AC_LANG_RESTORE
  fi
  AC_SUBST(GTKEXTRAMM_CFLAGS)
  AC_SUBST(GTKEXTRAMM_LIBS)
  rm -f conf.gtkextrammtest
])



# Configure paths for GtkExtra
# Owen Taylor     97-11-3
# Adapted to the gtkextra package by Cedric Gustin Feb. 11 2000
# Temporary stuff (waiting for the maintainers of GtkExtra to write one)
dnl AM_PATH_GTKEXTRA_TMP([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for GTKEXTRA, and define GTKEXTRA_CFLAGS and GTKEXTRA_LIBS
dnl
AC_DEFUN(AM_PATH_GTKEXTRA_TMP,
[dnl 
dnl Get the cflags and libraries from the gtkextra-config script
dnl
AC_ARG_WITH(gtkextra-prefix,[  --with-gtkextra-prefix=PFX   Prefix where GTKEXTRA is installed (optional)],
            gtkextra_config_prefix="$withval", gtkextra_config_prefix="")
AC_ARG_WITH(gtkextra-exec-prefix,[  --with-gtkextra-exec-prefix=PFX Exec prefix where GTKEXTRA is installed (optional)],
            gtkextra_config_exec_prefix="$withval", gtkextra_config_exec_prefix="")
AC_ARG_ENABLE(gtkextratest, [  --disable-gtkextratest       Do not try to compile and run a test GTKEXTRA program],
		    , enable_gtkextratest=yes)

  if test x$gtkextra_config_exec_prefix != x ; then
     gtkextra_config_args="$gtkextra_config_args --exec-prefix=$gtkextra_config_exec_prefix"
     if test x${GTKEXTRA_CONFIG+set} != xset ; then
        GTKEXTRA_CONFIG=$gtkextra_config_exec_prefix/bin/gtkextra-config
     fi
  fi
  if test x$gtkextra_config_prefix != x ; then
     gtkextra_config_args="$gtkextra_config_args --prefix=$gtkextra_config_prefix"
     if test x${GTKEXTRA_CONFIG+set} != xset ; then
        GTKEXTRA_CONFIG=$gtkextra_config_prefix/bin/gtkextra-config
     fi
  fi

  AC_PATH_PROG(GTKEXTRA_CONFIG, gtkextra-config, no)
  min_gtkextra_version=ifelse([$1], ,0.99.0,$1)
  AC_MSG_CHECKING(for GtkExtra - version >= $min_gtkextra_version) 
  no_gtkextra=""
  if test "$GTKEXTRA_CONFIG" = "no" ; then
    no_gtkextra=yes
    AC_MSG_RESULT(no)
  else
    GTKEXTRA_CFLAGS=`$GTKEXTRA_CONFIG $gtkextra_config_args --cflags`
    GTKEXTRA_LIBS=`$GTKEXTRA_CONFIG $gtkextra_config_args --libs`
    gtkextra_config_major_version=`$GTKEXTRA_CONFIG $gtkextra_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    gtkextra_config_minor_version=`$GTKEXTRA_CONFIG $gtkextra_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    gtkextra_config_micro_version=`$GTKEXTRA_CONFIG $gtkextra_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
      if test "x$enable_gtkextratest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $GTKEXTRA_CFLAGS $GTK_CFLAGS"
      LIBS="$GTKEXTRA_LIBS $GTK_LIBS $LIBS"


dnl
dnl Now check if the installed GTK is sufficiently new. (Also sanity
dnl checks the results of gtk-config to some extent
dnl
      rm -f conf.gtkextratest
      AC_TRY_RUN([
#include <gtk/gtk.h>
#include <gtkextra/gtksheet.h>
#include <stdio.h>
#include <stdlib.h>

int 
main (int argc,char *argv[])
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.gtkextratest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = g_strdup("$min_gtkextra_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_gtk_version");
     exit(1);
   }
  if (($gtkextra_config_major_version > major) ||
        (($gtkextra_config_major_version == major) && ($gtkextra_config_minor_version > minor)) ||
        (($gtkextra_config_major_version == major) && ($gtkextra_config_minor_version == minor) && ($gtkextra_config_micro_version >= micro)))
   {
      /* Try to link in a GtkExtra function */
      gtk_init(&argc, &argv);
      gtk_sheet_new(5, 5, "test");	
      return 0;
    }
   else
    {
        printf("\n*** An old version of GtkExtra ($gtkextra_config_major_version.$gtkextra_config_minor_version.$gtkextra_config_micro_version) was found.\n");
        printf("*** You need a version of GtkExtra newer than %d.%d.%d.\n",
	       major, minor, micro);
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the gtkextra-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of GtkExtra.\n");
      }

   return 1;
}
],, no_gtkextra=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
      fi
  fi
  if test "x$no_gtkextra" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])
  else
     AC_MSG_RESULT(no) 
  fi     
  AC_SUBST(GTKEXTRA_CFLAGS)
  AC_SUBST(GTKEXTRA_LIBS)
  rm -f conf.gtkextratest

])

