..
# Configure paths for GTKEXTRA+
# Owen Taylor     97-11-3
# Adapted to the gtkextra package by Cedric Gustin Feb. 11 2000
# Temporary stuff (waiting for the maintainers of gtkextra+ to write one)

dnl AM_PATH_GTKEXTRA([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for GTKEXTRA, and define GTKEXTRA_CFLAGS and GTKEXTRA_LIBS
dnl
AC_DEFUN(AM_PATH_GTKEXTRA,
[dnl 
dnl Get the cflags and libraries from the gtkextra-config script
dnl
AC_ARG_WITH(gtkextra-prefix,[  --with-gtkextra-prefix=PFX   Prefix where GTKEXTRA is installed (optional)],
            gtkextra_config_prefix="$withval", gtkextra_config_prefix="")
AC_ARG_WITH(gtkextra-exec-prefix,[  --with-gtkextra-exec-prefix=PFX Exec prefix where GTKEXTRA is installed (optional)],
            gtkextra_config_exec_prefix="$withval", gtkextra_config_exec_prefix="")
AC_ARG_ENABLE(gtkextratest, [  --disable-gtkextratest       Do not try to compile and run a test GTKEXTRA program],
		    , enable_gtkextratest=yes)

  if test x$gtkextra_config_exec_prefix != x ; then
     gtkextra_config_args="$gtkextra_config_args --exec-prefix=$gtkextra_config_exec_prefix"
     if test x${GTKEXTRA_CONFIG+set} != xset ; then
        GTKEXTRA_CONFIG=$gtkextra_config_exec_prefix/bin/gtkextra-config
     fi
  fi
  if test x$gtkextra_config_prefix != x ; then
     gtkextra_config_args="$gtkextra_config_args --prefix=$gtkextra_config_prefix"
     if test x${GTKEXTRA_CONFIG+set} != xset ; then
        GTKEXTRA_CONFIG=$gtkextra_config_prefix/bin/gtkextra-config
     fi
  fi

  AC_PATH_PROG(GTKEXTRA_CONFIG, gtkextra-config, no)
  min_gtkextra_version=ifelse([$1], ,0.99.0,$1)
  AC_MSG_CHECKING(for GtkExtra - version >= $min_gtkextra_version) 
  no_gtkextra=""
  if test "$GTKEXTRA_CONFIG" = "no" ; then
    no_gtkextra=yes
    AC_MSG_RESULT(no)
  else
    GTKEXTRA_CFLAGS=`$GTKEXTRA_CONFIG $gtkextra_config_args --cflags`
    GTKEXTRA_LIBS=`$GTKEXTRA_CONFIG $gtkextra_config_args --libs`
    gtkextra_config_major_version=`$GTKEXTRA_CONFIG $gtkextra_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    gtkextra_config_minor_version=`$GTKEXTRA_CONFIG $gtkextra_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    gtkextra_config_micro_version=`$GTKEXTRA_CONFIG $gtkextra_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
      if test "x$enable_gtkextratest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $GTKEXTRA_CFLAGS $GTK_CFLAGS"
      LIBS="$GTKEXTRA_LIBS $GTK_LIBS $LIBS"


dnl
dnl Now check if the installed GTK is sufficiently new. (Also sanity
dnl checks the results of gtk-config to some extent
dnl
      rm -f conf.gtkextratest
      AC_TRY_RUN([
     
#include <gtk/gtk.h>
#include <gtkextra/gtksheet.h>
#include <stdio.h>
#include <stdlib.h>

int 
main (int argc, char *argv[])
{
  int major, minor, micro;
  char *tmp_version;

  //system ("touch conf.gtkextratest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  
  tmp_version = g_strdup("$min_gtkextra_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_gtk_version");
     exit(1);
   }
  if (($gtkextra_config_major_version > major) ||
        (($gtkextra_config_major_version == major) && ($gtkextra_config_minor_version > minor)) ||
        (($gtkextra_config_major_version == major) && ($gtkextra_config_minor_version == minor) && ($gtkextra_config_micro_version >= micro)))
   {
      /* Try to link in a GtkExtra function */
	    gtk_init(&argc, &argv);
      gtk_sheet_new(5, 5, "test");
      return 0;
    }
   else
    {
        printf("\n*** An old version of GtkExtra ($gtkextra_config_major_version.$gtkextra_config_minor_version.$gtkextra_config_micro_version) was found.\n");
        printf("*** You need a version of GtkExtra newer than %d.%d.%d.\n",
	       major, minor, micro);
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the gtkextra-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of GtkExtra.\n");
    }
      
   return 1;
}
],, no_gtkextra=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
      fi
  fi
  if test "x$no_gtkextra" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])
  else
     AC_MSG_RESULT(no) 
  fi     
  AC_SUBST(GTKEXTRA_CFLAGS)
  AC_SUBST(GTKEXTRA_LIBS)
  rm -f conf.gtkextratest

])
