/****************\
*                *
*  Align dialog  *
*                *
\****************/

#include <gtk/gtkdialog.h>
#include <gtk/gtkradiobutton.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkhbbox.h>
#include <gtk/gtkframe.h>
#include <gtk/gtksignal.h>

#include "aligndialog.h"

static TCADSheet *ActSheet;
static GtkWidget *Dialog;

static GtkWidget *RBVNone;
static GtkWidget *RBVGrid;
static GtkWidget *RBTops;
static GtkWidget *RBBottoms;
static GtkWidget *RBSameHeight;
static GtkWidget *RBHNone;
static GtkWidget *RBHGrid;
static GtkWidget *RBLefts;
static GtkWidget *RBRights;
static GtkWidget *RBSameWidth;

static void DoAlignment()
{
  THorizAlign HA = HAL_NONE;
  TVertAlign VA = VAL_NONE;

  if (GTK_TOGGLE_BUTTON(RBVGrid)->active) VA = VAL_GRID;
  else if (GTK_TOGGLE_BUTTON(RBTops)->active) VA = VAL_TOPS;
  else if (GTK_TOGGLE_BUTTON(RBBottoms)->active) VA = VAL_BOTTOMS;
  else if (GTK_TOGGLE_BUTTON(RBSameHeight)->active) VA = VAL_SAMEHEIGHT;

  if (GTK_TOGGLE_BUTTON(RBHGrid)->active) HA = HAL_GRID;
  else if (GTK_TOGGLE_BUTTON(RBLefts)->active) HA = HAL_LEFTS;
  else if (GTK_TOGGLE_BUTTON(RBRights)->active) HA = HAL_RIGHTS;
  else if (GTK_TOGGLE_BUTTON(RBSameWidth)->active) HA = HAL_SAMEWIDTH;

  ActSheet->AlignObjects(HA,VA);
}

static void
on_BCancel_clicked (GtkButton *button, gpointer user_data)
{
  button = button;
  user_data = user_data;

  // Make window non-modal
  gtk_grab_remove(Dialog);

  // Close window
  gtk_widget_destroy(Dialog);
  Dialog = NULL;
}

static gboolean
window_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  event=event;

  on_BCancel_clicked(NULL,user_data);
}

static void
on_BOK_clicked (GtkButton *button, gpointer user_data)
{
  // Do alignment
  DoAlignment();

  // Close window
  on_BCancel_clicked(button,user_data);
}

static GtkWidget*
CreateDialog()
{
  GtkWidget *DAlign;
  GtkWidget *dialog_vbox1;
  GtkWidget *hbox1;
  GtkWidget *FAlignH;
  GtkWidget *vbox1;
  GSList *__group = NULL;
  GtkWidget *frame2;
  GtkWidget *vbox2;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbuttonbox1;
  GtkWidget *BOK;
  GtkWidget *BCancel;

  DAlign = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (DAlign), "DAlign", DAlign);
  gtk_window_set_title (GTK_WINDOW (DAlign), "Align");
  gtk_window_set_policy (GTK_WINDOW (DAlign), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (DAlign)->vbox;
  gtk_object_set_data (GTK_OBJECT (DAlign), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  hbox1 = gtk_hbox_new (TRUE, 0);
  gtk_object_set_data (GTK_OBJECT (DAlign), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), hbox1, TRUE, TRUE, 0);

  FAlignH = gtk_frame_new ("Verticaly");
  gtk_object_set_data (GTK_OBJECT (DAlign), "FAlignH", FAlignH);
  gtk_widget_show (FAlignH);
  gtk_box_pack_start (GTK_BOX (hbox1), FAlignH, TRUE, TRUE, 0);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (DAlign), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (FAlignH), vbox1);

  RBVNone = gtk_radio_button_new_with_label (__group, "No change");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBVNone));
  gtk_object_set_data (GTK_OBJECT (DAlign), "RBVNone", RBVNone);
  gtk_widget_show (RBVNone);
  gtk_box_pack_start (GTK_BOX (vbox1), RBVNone, TRUE, TRUE, 0);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (RBVNone), TRUE);

  RBVGrid = gtk_radio_button_new_with_label (__group, "To grid");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBVGrid));
  gtk_object_set_data (GTK_OBJECT (DAlign), "RBVGrid", RBVGrid);
  gtk_widget_show (RBVGrid);
  gtk_box_pack_start (GTK_BOX (vbox1), RBVGrid, TRUE, TRUE, 0);

  RBTops = gtk_radio_button_new_with_label (__group, "Tops");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBTops));
  gtk_object_set_data (GTK_OBJECT (DAlign), "RBTops", RBTops);
  gtk_widget_show (RBTops);
  gtk_box_pack_start (GTK_BOX (vbox1), RBTops, TRUE, TRUE, 0);

  RBBottoms = gtk_radio_button_new_with_label (__group, "Bottoms");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBBottoms));
  gtk_object_set_data (GTK_OBJECT (DAlign), "RBBottoms", RBBottoms);
  gtk_widget_show (RBBottoms);
  gtk_box_pack_start (GTK_BOX (vbox1), RBBottoms, TRUE, TRUE, 0);

  RBSameHeight = gtk_radio_button_new_with_label (__group, "Set same height");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBSameHeight));
  gtk_object_set_data (GTK_OBJECT (DAlign), "RBSameHeight", RBSameHeight);
  gtk_widget_show (RBSameHeight);
  gtk_box_pack_start (GTK_BOX (vbox1), RBSameHeight, TRUE, TRUE, 0);

  frame2 = gtk_frame_new ("Horizontaly");
  gtk_object_set_data (GTK_OBJECT (DAlign), "frame2", frame2);
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (hbox1), frame2, TRUE, TRUE, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (DAlign), "vbox2", vbox2);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (frame2), vbox2);

  __group = NULL;
  RBHNone = gtk_radio_button_new_with_label (__group, "No change");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBHNone));
  gtk_object_set_data (GTK_OBJECT (DAlign), "RBHNone", RBHNone);
  gtk_widget_show (RBHNone);
  gtk_box_pack_start (GTK_BOX (vbox2), RBHNone, TRUE, TRUE, 0);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (RBHNone), TRUE);

  RBHGrid = gtk_radio_button_new_with_label (__group, "To grid");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBHGrid));
  gtk_object_set_data (GTK_OBJECT (DAlign), "RBHGrid", RBHGrid);
  gtk_widget_show (RBHGrid);
  gtk_box_pack_start (GTK_BOX (vbox2), RBHGrid, TRUE, TRUE, 0);

  RBLefts = gtk_radio_button_new_with_label (__group, "Lefts");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBLefts));
  gtk_object_set_data (GTK_OBJECT (DAlign), "RBLefts", RBLefts);
  gtk_widget_show (RBLefts);
  gtk_box_pack_start (GTK_BOX (vbox2), RBLefts, TRUE, TRUE, 0);

  RBRights = gtk_radio_button_new_with_label (__group, "Rights");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBRights));
  gtk_object_set_data (GTK_OBJECT (DAlign), "RBRights", RBRights);
  gtk_widget_show (RBRights);
  gtk_box_pack_start (GTK_BOX (vbox2), RBRights, TRUE, TRUE, 0);

  RBSameWidth = gtk_radio_button_new_with_label (__group, "Set same width");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBSameWidth));
  gtk_object_set_data (GTK_OBJECT (DAlign), "RBSameWidth", RBSameWidth);
  gtk_widget_show (RBSameWidth);
  gtk_box_pack_start (GTK_BOX (vbox2), RBSameWidth, TRUE, TRUE, 0);

  dialog_action_area1 = GTK_DIALOG (DAlign)->action_area;
  gtk_object_set_data (GTK_OBJECT (DAlign), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (DAlign), "hbuttonbox1", hbuttonbox1);
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), hbuttonbox1, TRUE, TRUE, 0);

  BOK = gtk_button_new_with_label ("OK");
  gtk_object_set_data (GTK_OBJECT (DAlign), "BOK", BOK);
  gtk_widget_show (BOK);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), BOK);
  gtk_signal_connect (GTK_OBJECT (BOK), "clicked",
                      GTK_SIGNAL_FUNC (on_BOK_clicked),
                      DAlign);

  BCancel = gtk_button_new_with_label ("Cancel");
  gtk_object_set_data (GTK_OBJECT (DAlign), "BCancel", BCancel);
  gtk_widget_show (BCancel);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), BCancel);
  gtk_signal_connect (GTK_OBJECT (BCancel), "clicked",
                      GTK_SIGNAL_FUNC (on_BCancel_clicked),
                      DAlign);

  gtk_signal_connect ((GtkObject *)(DAlign), "delete_event",
                      GTK_SIGNAL_FUNC (window_delete_event),
                      NULL);

  return DAlign;
}

void ShowAlignDialog(TCADSheet *Sheet)
{
  if (Dialog != NULL) return;

  ActSheet = Sheet;

  Dialog = CreateDialog();

  gtk_widget_show(Dialog);
  gtk_grab_add(Dialog);
}


