/***************************\
*                           *
*  Arrow properties dialog  *
*                           *
\***************************/

#include <gtk/gtk.h>
#include "arrowproperties.h"

static GtkWidget *Dialog;
static TArrowStyle FArr,LArr;
static int FSz,LSz;
static TCADObject *Selected;
static GdkGC *GC;
static GdkColor WhiteColor;
static GdkColor BlackColor;
static GtkWidget *TB_Simple[2],*TB_None[2],*TB_Black[2],*TB_White[2];
static GtkWidget *RB_Small[2],*RB_Medium[2],*RB_Big[2];

static void DoDraw(GtkWidget *widget,TArrowStyle Style)
{
  int W,H;
  GdkPoint First,Last;
  W = widget->allocation.width;
  H = widget->allocation.height;

  if (GC == NULL) return;

  First.x = 5;
  Last.x = W-5;
  First.y = H/2;
  Last.y = H/2;
  gdk_draw_line(widget->window,GC,First.x,First.y,Last.x,Last.y);
  DrawArrow(widget->window,GC,&First,&Last,Style,ARROW_SIZE_SMALL);
}

static void
on_TB_draw                    (GtkWidget       *widget,
                               GdkRectangle    *area,
                               gpointer         user_data)
{
  area=area;
  DoDraw(widget,(TArrowStyle)user_data);
}


static gboolean
on_TB_expose_event            (GtkWidget       *widget,
                               GdkEventExpose  *event,
                               gpointer         user_data)
{
  event = event;
  DoDraw(widget,(TArrowStyle)user_data);
  return FALSE;
}

static void on_BCancel_clicked (GtkButton *button, gpointer user_data)
{
  button = button;
  user_data = user_data;

  // Destroy GC
  if (GC != NULL) gdk_gc_destroy(GC);

  // Make window non-modal
  gtk_grab_remove(Dialog);

  // Close window
  gtk_widget_destroy(Dialog);
}

static void GetSettings(int Phase)
{
  TArrowStyle *Arr;
  int *Sz;

  if (Phase == 0) {
    Arr = &FArr;
    Sz = &FSz;
  }
  else {
    Arr = &LArr;
    Sz = &LSz;
  }

  if (GTK_TOGGLE_BUTTON(TB_Simple[Phase])->active) *Arr = AR_SIMPLE;
  else if (GTK_TOGGLE_BUTTON(TB_None[Phase])->active) *Arr = AR_NONE;
  else if (GTK_TOGGLE_BUTTON(TB_White[Phase])->active) *Arr = AR_WHITE;
  else if (GTK_TOGGLE_BUTTON(TB_Black[Phase])->active) *Arr = AR_BLACK;

  if (GTK_TOGGLE_BUTTON(RB_Small[Phase])->active) *Sz = ARROW_SIZE_SMALL;
  else if (GTK_TOGGLE_BUTTON(RB_Medium[Phase])->active) *Sz = ARROW_SIZE_MEDIUM;
  else if (GTK_TOGGLE_BUTTON(RB_Big[Phase])->active) *Sz = ARROW_SIZE_BIG;
}

static void on_BOK_clicked (GtkButton *button, gpointer user_data)
{
  // Get settings
  GetSettings(0);
  GetSettings(1);

  // Close window
  on_BCancel_clicked(button,user_data);

  // Refresh line arrows
  while(Selected != 0) {
    if (Selected->IsLine()) ((TCADLine *)Selected)->RefreshArrows(FArr,LArr,FSz,LSz);
    Selected = Selected->NextSelected;
  }
}

static void CreateColumn(GtkWidget *dialog1,GtkWidget *hbox2,int Phase,TArrowStyle Arr,int Size)
{
  GSList *__group = NULL;
  GtkWidget *frame2;
  GtkWidget *frame5;
  GtkWidget *table1;
  GtkWidget *frame6;
  GtkWidget *vbox1;
  GtkWidget *DefB;
  GtkWidget *vbox2;

  if (Phase == 0) frame2 = gtk_frame_new ("First arrow");
  else frame2 = gtk_frame_new("Second arrow");
  gtk_object_set_data (GTK_OBJECT (dialog1), "frame2", frame2);
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (hbox2), frame2, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type(GTK_FRAME(frame2),GTK_SHADOW_NONE);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (dialog1), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (frame2), vbox1);

  frame5 = gtk_frame_new ("Type");
  gtk_object_set_data (GTK_OBJECT (dialog1), "frame5", frame5);
  gtk_widget_show (frame5);
  gtk_box_pack_start (GTK_BOX (vbox1), frame5, TRUE, TRUE, 0);

  table1 = gtk_table_new (2, 2, TRUE);
  gtk_object_set_data (GTK_OBJECT (dialog1), "table1", table1);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (frame5), table1);

  TB_Black[Phase] = gtk_radio_button_new_with_label (__group, "");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (TB_Black[Phase]));
  gtk_object_set_data (GTK_OBJECT (dialog1), "TB_Black[Phase]", TB_Black[Phase]);
  gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(TB_Black[Phase]),0);
  gtk_widget_show (TB_Black[Phase]);
  gtk_table_attach (GTK_TABLE (table1), TB_Black[Phase], 1, 2, 1, 2,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_signal_connect_after (GTK_OBJECT (TB_Black[Phase]), "expose_event",
                      GTK_SIGNAL_FUNC (on_TB_expose_event),
                      (gpointer)AR_BLACK);
  gtk_signal_connect_after (GTK_OBJECT (TB_Black[Phase]), "draw",
                      GTK_SIGNAL_FUNC (on_TB_draw),
                      (gpointer)AR_BLACK);

  TB_White[Phase] = gtk_radio_button_new_with_label (__group, "");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (TB_White[Phase]));
  gtk_object_set_data (GTK_OBJECT (dialog1), "TB_White[Phase]", TB_White[Phase]);
  gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(TB_White[Phase]),0);
  gtk_widget_show (TB_White[Phase]);
  gtk_table_attach (GTK_TABLE (table1), TB_White[Phase], 0, 1, 1, 2,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_signal_connect_after (GTK_OBJECT (TB_White[Phase]), "expose_event",
                      GTK_SIGNAL_FUNC (on_TB_expose_event),
                      (gpointer)AR_WHITE);
  gtk_signal_connect_after (GTK_OBJECT (TB_White[Phase]), "draw",
                      GTK_SIGNAL_FUNC (on_TB_draw),
                      (gpointer)AR_WHITE);

  TB_Simple[Phase] = gtk_radio_button_new_with_label (__group, "");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (TB_Simple[Phase]));
  gtk_object_set_data (GTK_OBJECT (dialog1), "TB_Simple[Phase]", TB_Simple[Phase]);
  gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(TB_Simple[Phase]),0);
  gtk_widget_show (TB_Simple[Phase]);
  gtk_table_attach (GTK_TABLE (table1), TB_Simple[Phase], 1, 2, 0, 1,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_signal_connect_after (GTK_OBJECT (TB_Simple[Phase]), "expose_event",
                      GTK_SIGNAL_FUNC (on_TB_expose_event),
                      (gpointer)AR_SIMPLE);
  gtk_signal_connect_after (GTK_OBJECT (TB_Simple[Phase]), "draw",
                      GTK_SIGNAL_FUNC (on_TB_draw),
                      (gpointer)AR_SIMPLE);

  TB_None[Phase] = gtk_radio_button_new_with_label (__group, "");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (TB_None[Phase]));
  gtk_object_set_data (GTK_OBJECT (dialog1), "TB_None[Phase]", TB_None[Phase]);
  gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(TB_None[Phase]),0);
  gtk_widget_show (TB_None[Phase]);
  gtk_table_attach (GTK_TABLE (table1), TB_None[Phase], 0, 1, 0, 1,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_signal_connect_after (GTK_OBJECT (TB_None[Phase]), "expose_event",
                      GTK_SIGNAL_FUNC (on_TB_expose_event),
                      (gpointer)AR_NONE);
  gtk_signal_connect_after (GTK_OBJECT (TB_None[Phase]), "draw",
                      GTK_SIGNAL_FUNC (on_TB_draw),
                      (gpointer)AR_NONE);
 
  switch(Arr) {
    case AR_NONE:
      DefB = TB_None[Phase];
      break;
    case AR_SIMPLE:
      DefB = TB_Simple[Phase];
      break;
    case AR_WHITE:
      DefB = TB_White[Phase];
      break;
    case AR_BLACK:
      DefB = TB_Black[Phase];
      break;
    default:
      DefB = TB_None[Phase];
  }
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (DefB), TRUE);

  frame6 = gtk_frame_new ("Size");
  gtk_object_set_data (GTK_OBJECT (dialog1), "frame6", frame6);
  gtk_widget_show (frame6);
  gtk_box_pack_start (GTK_BOX (vbox1), frame6, TRUE, TRUE, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (dialog1), "vbox2", vbox2);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (frame6), vbox2);

  __group = NULL;
  RB_Small[Phase] = gtk_radio_button_new_with_label (__group, "Small");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RB_Small[Phase]));
  gtk_object_set_data (GTK_OBJECT (dialog1), "RB_Small[Phase]", RB_Small[Phase]);
  gtk_widget_show (RB_Small[Phase]);
  gtk_box_pack_start (GTK_BOX (vbox2), RB_Small[Phase], TRUE, TRUE, 0);

  RB_Medium[Phase] = gtk_radio_button_new_with_label (__group, "Medium");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RB_Medium[Phase]));
  gtk_object_set_data (GTK_OBJECT (dialog1), "RB_Medium[Phase]", RB_Medium[Phase]);
  gtk_widget_show (RB_Medium[Phase]);
  gtk_box_pack_start (GTK_BOX (vbox2), RB_Medium[Phase], TRUE, TRUE, 0);

  RB_Big[Phase] = gtk_radio_button_new_with_label (__group, "Big");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RB_Big[Phase]));
  gtk_object_set_data (GTK_OBJECT (dialog1), "RB_Big[Phase]", RB_Big[Phase]);
  gtk_widget_show (RB_Big[Phase]);
  gtk_box_pack_start (GTK_BOX (vbox2), RB_Big[Phase], TRUE, TRUE, 0);

  DefB = RB_Medium[Phase];
  if (Size == ARROW_SIZE_SMALL) DefB = RB_Small[Phase];
  if (Size == ARROW_SIZE_BIG) DefB = RB_Big[Phase];
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (DefB), TRUE);

}

static GtkWidget *
CreateDialog()
{
  GtkWidget *dialog1;
  GtkWidget *dialog_vbox1;
  GtkWidget *hbox1;
  GtkWidget *hbox2;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbuttonbox1;
  GtkWidget *BOK;
  GtkWidget *BApply;
  GtkWidget *BCancel;


  dialog1 = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (dialog1), "dialog1", dialog1);
  GTK_WINDOW (dialog1)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_title (GTK_WINDOW (dialog1), "Arrow properties");
  gtk_window_set_policy (GTK_WINDOW (dialog1), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (dialog1)->vbox;
  gtk_object_set_data (GTK_OBJECT (dialog1), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (dialog1), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), hbox1, TRUE, TRUE, 0);

  hbox2 = gtk_hbox_new (TRUE, 0);
  gtk_object_set_data (GTK_OBJECT (dialog1), "hbox2", hbox2);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (hbox1), hbox2, TRUE, TRUE, 0);

  CreateColumn(dialog1,hbox2,0,FArr,FSz);
  CreateColumn(dialog1,hbox2,1,LArr,LSz);

  dialog_action_area1 = GTK_DIALOG (dialog1)->action_area;
  gtk_object_set_data (GTK_OBJECT (dialog1), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (dialog1), "hbuttonbox1", hbuttonbox1);
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), hbuttonbox1, TRUE, TRUE, 0);

  BOK = gtk_button_new_with_label ("OK");
  gtk_object_set_data (GTK_OBJECT (dialog1), "BOK", BOK);
  gtk_widget_show (BOK);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), BOK);
  gtk_signal_connect (GTK_OBJECT (BOK), "clicked",
                      GTK_SIGNAL_FUNC (on_BOK_clicked),
                      NULL);

  BApply = gtk_button_new_with_label ("Apply");
  gtk_object_set_data (GTK_OBJECT (dialog1), "BApply", BApply);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), BApply);
  gtk_widget_set_sensitive (BApply, FALSE);

  BCancel = gtk_button_new_with_label ("Cancel");
  gtk_object_set_data (GTK_OBJECT (dialog1), "BCancel", BCancel);
  gtk_widget_show (BCancel);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), BCancel);
  gtk_signal_connect (GTK_OBJECT (BCancel), "clicked",
                      GTK_SIGNAL_FUNC (on_BCancel_clicked),
                      NULL);

  return dialog1;
}

/* Set size to some known size */
static int AlignSize(int Size)
{
  int T,T2;
  int Res;

  T = ABS(Size-ARROW_SIZE_SMALL);
  Res = ARROW_SIZE_SMALL;

  T2 = ABS(Size-ARROW_SIZE_MEDIUM);
  if (T2 < T) Res = ARROW_SIZE_MEDIUM;

  T2 = ABS(Size-ARROW_SIZE_BIG);
  if (T2 < T) Res = ARROW_SIZE_BIG;

  return(Res);
}

void ArrowPropertiesDialog(TArrowStyle FA,TArrowStyle LA,int FS,int LS,TCADObject *Sel)
{
  GdkColormap *ColorMap;

  GC = NULL;
  FArr = FA;
  LArr = LA;
  FSz = AlignSize(FS);
  LSz = AlignSize(LS);
  Selected = Sel;

  Dialog = CreateDialog();

  gtk_widget_show(Dialog);

  GC = gdk_gc_new(Dialog->window);

  // Get colors
  ColorMap = gdk_window_get_colormap(Dialog->window);
  gdk_color_white(ColorMap,&WhiteColor);
  gdk_color_black(ColorMap,&BlackColor);
  gdk_gc_set_background(GC,&WhiteColor);
  gdk_gc_set_foreground(GC,&BlackColor);

  gtk_grab_add(Dialog);

}


