/************************************************\
*                                                *
*  Part of TCADMenu which serves button presses  *
*                                                *
\************************************************/

#include <gtk/gtktogglebutton.h>
#include "main.h"

void TCADMain::ButtonsUp(GtkWidget *Except)
{
  int i;

  for(i=0;i<NUMBUTTONS;i++) {
    if (Buttons[i] != Except) 
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(Buttons[i]),0);
  }
}

void TCADMain::ResetMode(gboolean Force)
{
  if ((StateLocked) && (!Force)) return;

  BBPointerPressed();
}

/*****************************************************************************/

void TCADMain::BBPointerPressed()
{
  StateLocked = FALSE;
  ButtonsUp(BBPointer);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(BBPointer),1);
  State = ST_PICK;
}

void TCADMain::BBLinePressed(gboolean Locked)
{
  StateLocked = Locked;
  ButtonsUp(BBLine);
  State = ST_LINE;
}

void TCADMain::BBAngleLinePressed(gboolean Locked)
{
  StateLocked = Locked;
  ButtonsUp(BBAngleLine);
  State = ST_ANGLELINE;
}

void TCADMain::BBFramePressed(gboolean Locked)
{
  StateLocked = Locked;
  ButtonsUp(BBFrame);
  State = ST_FRAME;
}

void TCADMain::BBTextPressed(gboolean Locked)
{
  StateLocked = Locked;
  ButtonsUp(BBText);
  State = ST_TEXT;
}

void TCADMain::BBFramedTextPressed(gboolean Locked)
{
  StateLocked = Locked;
  ButtonsUp(BBFramedText);
  State = ST_FRAMED_TEXT;
}


