/*****************************\
*                             *
*  Implements TCADFramedText  *
*                             *
\*****************************/

#include <stdlib.h>
#include "framedtext.h"

#define TOP_OFFSET 3
#define BOTTOM_OFFSET 3
#define LEFT_OFFSET 3
#define RIGHT_OFFSET 3

TCADFramedText::TCADFramedText(TCADSheet *Sheet) : TCADText(Sheet)
{
}

void TCADFramedText::Save(TCADSaveStream *Fl)
{
  Fl->SaveObjectName("TCADFramedText");
  SaveProperties(Fl);
  Fl->SaveEndObject();
}

void TCADFramedText::SaveProperties(TCADSaveStream *Fl)
{
  TCADLinePropertiesI::SaveLineProperties(Fl);
  TCADText::SaveProperties(Fl);
}

char TCADFramedText::LoadProperty(TCADLoadStream *Fl,char *ID)
{
  if (TCADLinePropertiesI::LoadProperty(Fl,ID)) return(TRUE);
  else return(TCADText::LoadProperty(Fl,ID));
}

void TCADFramedText::Draw(GdkRegion *Region)
{
  if (Region)
   if (gdk_region_rect_in(Region, &EncapRect) == GDK_OVERLAP_RECTANGLE_OUT) return;

  TCADText::Draw(Region);

  // Draw rectangle
  gdk_draw_rectangle(Sheet->GetDrawable(),Sheet->GC,0,EncapRect.x,EncapRect.y,EncapRect.width-1,EncapRect.height-1);
}

void TCADFramedText::Export(FILE *Fl,TExportFormat Format)
{
  switch(Format) {
    case EF_LATEX:
      int x,y;
      char *Text;
      Text = GetText();
      x = EncapRect.x;
      y = Sheet->EncapRect.height-EncapRect.y-EncapRect.height;
      fprintf(Fl,"\\put(%d,%d){\\framebox(%d,%d){%s}}\n",x,y,EncapRect.width,EncapRect.height,Text);
      free(Text);
      break;
    case EF_FIG:
      ExportFigFrame(Fl);
      ExportFigText(Fl);
      break;
  }
}

void TCADFramedText::GetOffsets(int& TOff,int& BOff,int& LOff,int& ROff)
{
  TOff = TOP_OFFSET;
  BOff = BOTTOM_OFFSET;
  LOff = LEFT_OFFSET;
  ROff = RIGHT_OFFSET;
}

