/*  Note: You are free to use whatever license you want.
    Eventually you will be able to edit it within Glade. */

/*  project1
 *  Copyright (C) <YEAR> <AUTHORS>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gladesig.h"
#include "gladesrc.h"

GtkWidget*
get_widget                             (GtkWidget       *widget,
                                        gchar           *widget_name)
{
  GtkWidget *found_widget;

  if (widget->parent)
    widget = gtk_widget_get_toplevel (widget);
  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
                                                   widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}

/* This is an internally used function to set notebook tab widgets. */
void
set_notebook_tab                       (GtkWidget       *notebook,
                                        gint             page_num,
                                        GtkWidget       *widget)
{
  GtkNotebookPage *page;
  GtkWidget *notebook_page;

  page = (GtkNotebookPage*) g_list_nth (GTK_NOTEBOOK (notebook)->children, page_num)->data;
  notebook_page = page->child;
  gtk_widget_ref (notebook_page);
  gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
  gtk_notebook_insert_page (GTK_NOTEBOOK (notebook), notebook_page,
                            widget, page_num);
  gtk_widget_unref (notebook_page);
}

GtkAccelGroup *accel_group;

GtkWidget*
create_MainWindow ()
{
  GtkWidget *MainWindow;
  GtkWidget *vbox1;
  GtkWidget *menubar1;
  GtkWidget *File;
  GtkWidget *menu46;
  GtkWidget *New;
  GtkWidget *Open;
  GtkWidget *Save;
  GtkWidget *Save_as_;
  GtkWidget *Save_all;
  GtkWidget *MIExport;
  GtkWidget *menu47;
  GtkWidget *MILaTeX;
  GtkWidget *MIEPS;
  GtkWidget *MIFIG;
  GtkWidget *separator1;
  GtkWidget *Exit;
  GtkWidget *MIObject;
  GtkWidget *menu48;
  GtkWidget *MIDelete;
  GtkWidget *MISelectAll;
  GtkWidget *MIAlign;
  GtkWidget *separator3;
  GtkWidget *MIEditText;
  GtkWidget *MITextProperties;
  GtkWidget *MILineProperties;
  GtkWidget *MIArrowProperties;
  GtkWidget *MISheet;
  GtkWidget *menu49;
  GtkWidget *MIGridOptions;
  GtkWidget *MIUseGrid;
  GtkWidget *MIShowGrid;
  GtkWidget *MILineEndAlignment;
  GtkWidget *menu50;
  GSList *__group = NULL;
  GtkWidget *MILAL_None;
  GtkWidget *MILAL_Grid;
  GtkWidget *MILAL_HalfGrid;
  GtkWidget *MIRulerOptions;
  GtkWidget *separator4;
  GtkWidget *Next;
  GtkWidget *Previous;
  GtkWidget *Close;
  GtkWidget *separator2;
  GtkWidget *Help;
  GtkWidget *menu51;
  GtkWidget *About;
  GtkWidget *handlebox1;
  GtkWidget *hbox1;
  GtkWidget *BBPointer;
  GtkWidget *label1;
  GtkWidget *BBLine;
  GtkWidget *BBRightAngleLine;
  GtkWidget *BBFrame;
  GtkWidget *BBText;
  GtkWidget *BBFramedText;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  MainWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MainWindow", MainWindow);
  gtk_widget_grab_focus (MainWindow);
  gtk_signal_connect (GTK_OBJECT (MainWindow), "delete_event",
                      GTK_SIGNAL_FUNC (on_MainWindow_delete_event),
                      NULL);
  gtk_window_set_title (GTK_WINDOW (MainWindow), "GCAD 0.5");
  gtk_window_set_policy (GTK_WINDOW (MainWindow), TRUE, FALSE, TRUE);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (MainWindow), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (MainWindow), vbox1);

  menubar1 = gtk_menu_bar_new ();
  gtk_object_set_data (GTK_OBJECT (MainWindow), "menubar1", menubar1);
  gtk_widget_show (menubar1);
  gtk_box_pack_start (GTK_BOX (vbox1), menubar1, TRUE, TRUE, 0);

  File = gtk_menu_item_new_with_label ("File");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "File", File);
  gtk_widget_show (File);
  gtk_container_add (GTK_CONTAINER (menubar1), File);

  menu46 = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (MainWindow), "menu46", menu46);
  gtk_widget_show (menu46);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (File), menu46);

  New = gtk_menu_item_new_with_label ("New");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "New", New);
  gtk_widget_show (New);
  gtk_container_add (GTK_CONTAINER (menu46), New);
  gtk_signal_connect (GTK_OBJECT (New), "activate",
                      GTK_SIGNAL_FUNC (on_New_activate),
                      NULL);
  accel_group = gtk_accel_group_new ();
  gtk_window_add_accel_group (GTK_WINDOW (MainWindow), accel_group);
  gtk_widget_add_accelerator (New, "activate", accel_group,
                              GDK_N, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  Open = gtk_menu_item_new_with_label ("Open");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "Open", Open);
  gtk_widget_show (Open);
  gtk_container_add (GTK_CONTAINER (menu46), Open);
  gtk_signal_connect (GTK_OBJECT (Open), "activate",
                      GTK_SIGNAL_FUNC (on_Open_activate),
                      NULL);
  gtk_widget_add_accelerator (Open, "activate", accel_group,
                              GDK_O, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  Save = gtk_menu_item_new_with_label ("Save");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "Save", Save);
  gtk_widget_show (Save);
  gtk_container_add (GTK_CONTAINER (menu46), Save);
  gtk_signal_connect (GTK_OBJECT (Save), "activate",
                      GTK_SIGNAL_FUNC (on_Save_activate),
                      NULL);
  gtk_widget_add_accelerator (Save, "activate", accel_group,
                              GDK_S, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  Save_as_ = gtk_menu_item_new_with_label ("Save as ...");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "Save_as_", Save_as_);
  gtk_widget_show (Save_as_);
  gtk_container_add (GTK_CONTAINER (menu46), Save_as_);
  gtk_signal_connect (GTK_OBJECT (Save_as_), "activate",
                      GTK_SIGNAL_FUNC (on_Save_as__activate),
                      NULL);

  Save_all = gtk_menu_item_new_with_label ("Save all");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "Save_all", Save_all);
  gtk_widget_show (Save_all);
  gtk_container_add (GTK_CONTAINER (menu46), Save_all);
  gtk_signal_connect (GTK_OBJECT (Save_all), "activate",
                      GTK_SIGNAL_FUNC (on_Save_all_activate),
                      NULL);

  MIExport = gtk_menu_item_new_with_label ("Export");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MIExport", MIExport);
  gtk_widget_show (MIExport);
  gtk_container_add (GTK_CONTAINER (menu46), MIExport);

  menu47 = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (MainWindow), "menu47", menu47);
  gtk_widget_show (menu47);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (MIExport), menu47);

  MILaTeX = gtk_menu_item_new_with_label ("LaTeX");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MILaTeX", MILaTeX);
  gtk_widget_show (MILaTeX);
  gtk_container_add (GTK_CONTAINER (menu47), MILaTeX);
  gtk_signal_connect (GTK_OBJECT (MILaTeX), "activate",
                      GTK_SIGNAL_FUNC (on_MILaTeX_activate),
                      NULL);

  MIEPS = gtk_menu_item_new_with_label ("EPS");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MIEPS", MIEPS);
  gtk_widget_show (MIEPS);
  gtk_container_add (GTK_CONTAINER (menu47), MIEPS);
  gtk_signal_connect (GTK_OBJECT (MIEPS), "activate",
                      GTK_SIGNAL_FUNC (on_MIEPS_activate),
                      NULL);

  MIFIG = gtk_menu_item_new_with_label ("FIG");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MIFIG", MIFIG);
  gtk_widget_show (MIFIG);
  gtk_container_add (GTK_CONTAINER (menu47), MIFIG);
  gtk_signal_connect (GTK_OBJECT (MIFIG), "activate",
                      GTK_SIGNAL_FUNC (on_MIFIG_activate),
                      NULL);

  separator1 = gtk_menu_item_new ();
  gtk_object_set_data (GTK_OBJECT (MainWindow), "separator1", separator1);
  gtk_widget_show (separator1);
  gtk_container_add (GTK_CONTAINER (menu46), separator1);

  Exit = gtk_menu_item_new_with_label ("Exit");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "Exit", Exit);
  gtk_widget_show (Exit);
  gtk_container_add (GTK_CONTAINER (menu46), Exit);
  gtk_signal_connect (GTK_OBJECT (Exit), "activate",
                      GTK_SIGNAL_FUNC (on_Exit_activate),
                      NULL);
  gtk_widget_add_accelerator (Exit, "activate", accel_group,
                              GDK_X, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  MIObject = gtk_menu_item_new_with_label ("Object(s)");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MIObject", MIObject);
  gtk_widget_show (MIObject);
  gtk_container_add (GTK_CONTAINER (menubar1), MIObject);

  menu48 = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (MainWindow), "menu48", menu48);
  gtk_widget_show (menu48);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (MIObject), menu48);

  MIDelete = gtk_menu_item_new_with_label ("Delete");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MIDelete", MIDelete);
  gtk_widget_show (MIDelete);
  gtk_container_add (GTK_CONTAINER (menu48), MIDelete);
  gtk_signal_connect (GTK_OBJECT (MIDelete), "activate",
                      GTK_SIGNAL_FUNC (on_MIDelete_activate),
                      NULL);

  MISelectAll = gtk_menu_item_new_with_label ("SelectAll");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MISelectAll", MISelectAll);
  gtk_widget_show (MISelectAll);
  gtk_container_add (GTK_CONTAINER (menu48), MISelectAll);
  gtk_signal_connect (GTK_OBJECT (MISelectAll), "activate",
                      GTK_SIGNAL_FUNC (on_MISelectAll_activate),
                      NULL);
  gtk_widget_add_accelerator (MISelectAll, "activate", accel_group,
                              GDK_A, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  MIAlign = gtk_menu_item_new_with_label ("Align");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MIAlign", MIAlign);
  gtk_widget_show (MIAlign);
  gtk_container_add (GTK_CONTAINER (menu48), MIAlign);
  gtk_signal_connect (GTK_OBJECT (MIAlign), "activate",
                      GTK_SIGNAL_FUNC (on_MIAlign_activate),
                      NULL);

  separator3 = gtk_menu_item_new ();
  gtk_object_set_data (GTK_OBJECT (MainWindow), "separator3", separator3);
  gtk_widget_show (separator3);
  gtk_container_add (GTK_CONTAINER (menu48), separator3);

  MIEditText = gtk_menu_item_new_with_label ("EditText");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MIEditText", MIEditText);
  gtk_widget_show (MIEditText);
  gtk_container_add (GTK_CONTAINER (menu48), MIEditText);
  gtk_signal_connect (GTK_OBJECT (MIEditText), "activate",
                      GTK_SIGNAL_FUNC (on_MIEditText_activate),
                      NULL);
  gtk_widget_add_accelerator (MIEditText, "activate", accel_group,
                              GDK_E, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  MITextProperties = gtk_menu_item_new_with_label ("Text properties");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MITextProperties", MITextProperties);
  gtk_widget_show (MITextProperties);
  gtk_container_add (GTK_CONTAINER (menu48), MITextProperties);
  gtk_signal_connect (GTK_OBJECT (MITextProperties), "activate",
                      GTK_SIGNAL_FUNC (on_MITextProperties_activate),
                      NULL);

  MILineProperties = gtk_menu_item_new_with_label ("Line properties");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MILineProperties", MILineProperties);
  gtk_widget_show (MILineProperties);
  gtk_container_add (GTK_CONTAINER (menu48), MILineProperties);
  gtk_signal_connect (GTK_OBJECT (MILineProperties), "activate",
                      GTK_SIGNAL_FUNC (on_MILineProperties_activate),
                      NULL);

  MIArrowProperties = gtk_menu_item_new_with_label ("ArrowProperties");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MIArrowProperties", MIArrowProperties);
  gtk_widget_show (MIArrowProperties);
  gtk_container_add (GTK_CONTAINER (menu48), MIArrowProperties);
  gtk_signal_connect (GTK_OBJECT (MIArrowProperties), "activate",
                      GTK_SIGNAL_FUNC (on_MIArrowProperties_activate),
                      NULL);

  MISheet = gtk_menu_item_new_with_label ("Sheet");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MISheet", MISheet);
  gtk_widget_show (MISheet);
  gtk_container_add (GTK_CONTAINER (menubar1), MISheet);

  menu49 = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (MainWindow), "menu49", menu49);
  gtk_widget_show (menu49);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (MISheet), menu49);

  MIGridOptions = gtk_menu_item_new_with_label ("Grid options");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MIGridOptions", MIGridOptions);
  gtk_widget_show (MIGridOptions);
  gtk_container_add (GTK_CONTAINER (menu49), MIGridOptions);
  gtk_signal_connect (GTK_OBJECT (MIGridOptions), "activate",
                      GTK_SIGNAL_FUNC (on_MIGridOptions_activate),
                      NULL);

  MIUseGrid = gtk_check_menu_item_new_with_label ("Use grid");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MIUseGrid", MIUseGrid);
  gtk_widget_show (MIUseGrid);
  gtk_container_add (GTK_CONTAINER (menu49), MIUseGrid);
  gtk_signal_connect (GTK_OBJECT (MIUseGrid), "activate",
                      GTK_SIGNAL_FUNC (on_MIUseGrid_activate),
                      NULL);

  MIShowGrid = gtk_check_menu_item_new_with_label ("Show grid");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MIShowGrid", MIShowGrid);
  gtk_widget_show (MIShowGrid);
  gtk_container_add (GTK_CONTAINER (menu49), MIShowGrid);
  gtk_signal_connect (GTK_OBJECT (MIShowGrid), "activate",
                      GTK_SIGNAL_FUNC (on_MIShowGrid_activate),
                      NULL);

  MILineEndAlignment = gtk_menu_item_new_with_label ("Line end alignment");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MILineEndAlignment", MILineEndAlignment);
  gtk_widget_show (MILineEndAlignment);
  gtk_container_add (GTK_CONTAINER (menu49), MILineEndAlignment);

  menu50 = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (MainWindow), "menu50", menu50);
  gtk_widget_show (menu50);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (MILineEndAlignment), menu50);

  MILAL_None = gtk_radio_menu_item_new_with_label (__group, "None");
  __group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (MILAL_None));
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MILAL_None", MILAL_None);
  gtk_widget_show (MILAL_None);
  gtk_container_add (GTK_CONTAINER (menu50), MILAL_None);
  gtk_signal_connect (GTK_OBJECT (MILAL_None), "activate",
                      GTK_SIGNAL_FUNC (on_MILAL_None_activate),
                      NULL);

  MILAL_Grid = gtk_radio_menu_item_new_with_label (__group, "Grid");
  __group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (MILAL_Grid));
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MILAL_Grid", MILAL_Grid);
  gtk_widget_show (MILAL_Grid);
  gtk_container_add (GTK_CONTAINER (menu50), MILAL_Grid);
  gtk_signal_connect (GTK_OBJECT (MILAL_Grid), "activate",
                      GTK_SIGNAL_FUNC (on_MILAL_Grid_activate),
                      NULL);

  MILAL_HalfGrid = gtk_radio_menu_item_new_with_label (__group, "Half grid");
  __group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (MILAL_HalfGrid));
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MILAL_HalfGrid", MILAL_HalfGrid);
  gtk_widget_show (MILAL_HalfGrid);
  gtk_container_add (GTK_CONTAINER (menu50), MILAL_HalfGrid);
  gtk_signal_connect (GTK_OBJECT (MILAL_HalfGrid), "activate",
                      GTK_SIGNAL_FUNC (on_MILAL_HalfGrid_activate),
                      NULL);
  gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (MILAL_HalfGrid), TRUE);

  MIRulerOptions = gtk_menu_item_new_with_label ("Ruler options");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "MIRulerOptions", MIRulerOptions);
  gtk_widget_show (MIRulerOptions);
  gtk_container_add (GTK_CONTAINER (menu49), MIRulerOptions);
  gtk_signal_connect (GTK_OBJECT (MIRulerOptions), "activate",
                      GTK_SIGNAL_FUNC (on_MIRulerOptions_activate),
                      NULL);

  separator4 = gtk_menu_item_new ();
  gtk_object_set_data (GTK_OBJECT (MainWindow), "separator4", separator4);
  gtk_widget_show (separator4);
  gtk_container_add (GTK_CONTAINER (menu49), separator4);

  Next = gtk_menu_item_new_with_label ("Next");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "Next", Next);
  gtk_widget_show (Next);
  gtk_container_add (GTK_CONTAINER (menu49), Next);
  gtk_signal_connect (GTK_OBJECT (Next), "activate",
                      GTK_SIGNAL_FUNC (on_Next_activate),
                      NULL);
  gtk_widget_add_accelerator (Next, "activate", accel_group,
                              GDK_2, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  Previous = gtk_menu_item_new_with_label ("Previous");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "Previous", Previous);
  gtk_widget_show (Previous);
  gtk_container_add (GTK_CONTAINER (menu49), Previous);
  gtk_signal_connect (GTK_OBJECT (Previous), "activate",
                      GTK_SIGNAL_FUNC (on_Previous_activate),
                      NULL);
  gtk_widget_add_accelerator (Previous, "activate", accel_group,
                              GDK_1, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  Close = gtk_menu_item_new_with_label ("Close");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "Close", Close);
  gtk_widget_show (Close);
  gtk_container_add (GTK_CONTAINER (menu49), Close);
  gtk_signal_connect (GTK_OBJECT (Close), "activate",
                      GTK_SIGNAL_FUNC (on_Close_activate),
                      NULL);
  gtk_widget_add_accelerator (Close, "activate", accel_group,
                              GDK_0, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  separator2 = gtk_menu_item_new ();
  gtk_object_set_data (GTK_OBJECT (MainWindow), "separator2", separator2);
  gtk_widget_show (separator2);
  gtk_container_add (GTK_CONTAINER (menu49), separator2);

  Help = gtk_menu_item_new_with_label ("Help");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "Help", Help);
  gtk_widget_show (Help);
  gtk_container_add (GTK_CONTAINER (menubar1), Help);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (Help));

  menu51 = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (MainWindow), "menu51", menu51);
  gtk_widget_show (menu51);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (Help), menu51);

  About = gtk_menu_item_new_with_label ("About");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "About", About);
  gtk_widget_show (About);
  gtk_container_add (GTK_CONTAINER (menu51), About);
  gtk_signal_connect (GTK_OBJECT (About), "activate",
                      GTK_SIGNAL_FUNC (on_About_activate),
                      NULL);

  handlebox1 = gtk_handle_box_new ();
  gtk_object_set_data (GTK_OBJECT (MainWindow), "handlebox1", handlebox1);
  gtk_widget_show (handlebox1);
  gtk_box_pack_start (GTK_BOX (vbox1), handlebox1, TRUE, TRUE, 0);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (MainWindow), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (handlebox1), hbox1);

  BBPointer = gtk_toggle_button_new_with_label ("");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "BBPointer", BBPointer);
  gtk_widget_show (BBPointer);
  gtk_box_pack_start (GTK_BOX (hbox1), BBPointer, TRUE, TRUE, 0);
  gtk_widget_set_usize (BBPointer, 18, 28);
  gtk_tooltips_set_tip (tooltips, BBPointer, "Pick and drag", NULL);
  gtk_signal_connect_after (GTK_OBJECT (BBPointer), "released",
                            GTK_SIGNAL_FUNC (on_BB_released),
                            NULL);
  gtk_signal_connect_after (GTK_OBJECT (BBPointer), "pressed",
                            GTK_SIGNAL_FUNC (on_BBPointer_pressed),
                            NULL);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (BBPointer), TRUE);

  label1 = gtk_label_new ("");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "label1", label1);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (hbox1), label1, TRUE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (label1), 4, 0);

  BBLine = gtk_toggle_button_new_with_label ("");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "BBLine", BBLine);
  gtk_widget_show (BBLine);
  gtk_box_pack_start (GTK_BOX (hbox1), BBLine, TRUE, TRUE, 0);
  gtk_widget_set_usize (BBLine, 18, 18);
  gtk_tooltips_set_tip (tooltips, BBLine, "Simple line", NULL);
  gtk_signal_connect_after (GTK_OBJECT (BBLine), "released",
                            GTK_SIGNAL_FUNC (on_BB_released),
                            NULL);
  gtk_signal_connect_after (GTK_OBJECT (BBLine), "pressed",
                            GTK_SIGNAL_FUNC (on_BBLine_pressed),
                            NULL);
  gtk_signal_connect (GTK_OBJECT (BBLine), "button_press_event",
                      GTK_SIGNAL_FUNC (on_BB_button_press_event),
                      NULL);

  BBRightAngleLine = gtk_toggle_button_new_with_label ("");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "BBRightAngleLine", BBRightAngleLine);
  gtk_widget_show (BBRightAngleLine);
  gtk_box_pack_start (GTK_BOX (hbox1), BBRightAngleLine, TRUE, TRUE, 0);
  gtk_widget_set_usize (BBRightAngleLine, 18, 18);
  gtk_tooltips_set_tip (tooltips, BBRightAngleLine, "Right angle line", NULL);
  gtk_signal_connect_after (GTK_OBJECT (BBRightAngleLine), "released",
                            GTK_SIGNAL_FUNC (on_BB_released),
                            NULL);
  gtk_signal_connect_after (GTK_OBJECT (BBRightAngleLine), "pressed",
                            GTK_SIGNAL_FUNC (on_BBRightAngleLine_pressed),
                            NULL);
  gtk_signal_connect (GTK_OBJECT (BBRightAngleLine), "button_press_event",
                      GTK_SIGNAL_FUNC (on_BB_button_press_event),
                      NULL);

  BBFrame = gtk_toggle_button_new_with_label ("");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "BBFrame", BBFrame);
  gtk_widget_show (BBFrame);
  gtk_box_pack_start (GTK_BOX (hbox1), BBFrame, TRUE, TRUE, 0);
  gtk_widget_set_usize (BBFrame, 18, 18);
  gtk_tooltips_set_tip (tooltips, BBFrame, "Frame", NULL);
  gtk_signal_connect_after (GTK_OBJECT (BBFrame), "released",
                            GTK_SIGNAL_FUNC (on_BB_released),
                            NULL);
  gtk_signal_connect_after (GTK_OBJECT (BBFrame), "pressed",
                            GTK_SIGNAL_FUNC (on_BBFrame_pressed),
                            NULL);
  gtk_signal_connect (GTK_OBJECT (BBFrame), "button_press_event",
                      GTK_SIGNAL_FUNC (on_BB_button_press_event),
                      NULL);

  BBText = gtk_toggle_button_new_with_label ("");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "BBText", BBText);
  gtk_widget_show (BBText);
  gtk_box_pack_start (GTK_BOX (hbox1), BBText, TRUE, TRUE, 0);
  gtk_widget_set_usize (BBText, 18, 18);
  gtk_tooltips_set_tip (tooltips, BBText, "Text", NULL);
  gtk_signal_connect_after (GTK_OBJECT (BBText), "released",
                            GTK_SIGNAL_FUNC (on_BB_released),
                            NULL);
  gtk_signal_connect_after (GTK_OBJECT (BBText), "pressed",
                            GTK_SIGNAL_FUNC (on_BBText_pressed),
                            NULL);
  gtk_signal_connect (GTK_OBJECT (BBText), "button_press_event",
                      GTK_SIGNAL_FUNC (on_BB_button_press_event),
                      NULL);

  BBFramedText = gtk_toggle_button_new_with_label ("");
  gtk_object_set_data (GTK_OBJECT (MainWindow), "BBFramedText", BBFramedText);
  gtk_widget_show (BBFramedText);
  gtk_box_pack_start (GTK_BOX (hbox1), BBFramedText, TRUE, TRUE, 0);
  gtk_widget_set_usize (BBFramedText, 18, 18);
  gtk_tooltips_set_tip (tooltips, BBFramedText, "Framed text", NULL);
  gtk_signal_connect_after (GTK_OBJECT (BBFramedText), "released",
                            GTK_SIGNAL_FUNC (on_BB_released),
                            NULL);
  gtk_signal_connect_after (GTK_OBJECT (BBFramedText), "pressed",
                            GTK_SIGNAL_FUNC (on_BBFramedText_pressed),
                            NULL);
  gtk_signal_connect (GTK_OBJECT (BBFramedText), "button_press_event",
                      GTK_SIGNAL_FUNC (on_BB_button_press_event),
                      NULL);

  return MainWindow;
}

