/***********************\
*                       *
*  Grid options dialog  *
*                       *
\***********************/

#include <gtk/gtkspinbutton.h>
#include <gtk/gtkcheckbutton.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkdialog.h>
#include <gtk/gtktable.h>
#include <gtk/gtkbox.h>
#include <gtk/gtkenums.h>
#include <gtk/gtksignal.h>
#include <gtk/gtklabel.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkhbbox.h>
#include "gridoptions.h"

static TCADSheet *OurSheet;
static GtkWidget *Dialog;
static gboolean X_eq_Y;
static int GX,GY;
static GtkSpinButton *SBX,*SBY;
static GtkToggleButton *CBXY;

static void on_BCancel_clicked (GtkButton *button, gpointer user_data)
{
  button = button;
  user_data = user_data;

  // Make window non-modal
  gtk_grab_remove(Dialog);

  // Close window
  gtk_widget_destroy(Dialog);
  Dialog = NULL;
}

void
on_SBY_changed (GtkEditable     *editable,
                gpointer         user_data)
{
  if (SBY == NULL) return;

  editable = editable;
  user_data = user_data;
  GY = gtk_spin_button_get_value_as_int(SBY);
  if (X_eq_Y) gtk_spin_button_set_value(SBX,GY);
}

void
on_SBX_changed (GtkEditable     *editable,
                gpointer         user_data)
{
  if (SBX == NULL) return;

  editable = editable;
  user_data = user_data;
  GX = gtk_spin_button_get_value_as_int(SBX);
  if (X_eq_Y) gtk_spin_button_set_value(SBY,GX);
}

void
on_CBXY_toggled (GtkToggleButton *togglebutton,
                 gpointer         user_data)
{
  if (CBXY == NULL) return;

  togglebutton = togglebutton;
  user_data = user_data;
  X_eq_Y = CBXY->active;
  if (X_eq_Y) gtk_spin_button_set_value(SBY,GX);
}

static void GetSettings()
{
  OurSheet->SetGridOptions(X_eq_Y,GX,GY);
}

static void on_BOK_clicked (GtkButton *button, gpointer user_data)
{
  // Get settings
  GetSettings();

  // Close window
  on_BCancel_clicked(button,user_data);
}


static GtkWidget*
create_DGrid ()
{
  GtkWidget *DGrid;
  GtkWidget *dialog_vbox1;
  GtkWidget *table1;
  GtkObject *SBY_adj;
  GtkWidget *SBY;
  GtkObject *SBX_adj;
  GtkWidget *SBX;
  GtkWidget *label2;
  GtkWidget *label1;
  GtkWidget *CBXY;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbuttonbox1;
  GtkWidget *BOK;
  GtkWidget *BCancel;

  DGrid = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (DGrid), "DGrid", DGrid);
  GTK_WINDOW (DGrid)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_title (GTK_WINDOW (DGrid), "Grid settings");
  gtk_window_set_policy (GTK_WINDOW (DGrid), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (DGrid)->vbox;
  gtk_object_set_data (GTK_OBJECT (DGrid), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);
  gtk_container_border_width (GTK_CONTAINER (dialog_vbox1), 4);

  table1 = gtk_table_new (2, 2, FALSE);
  gtk_object_set_data (GTK_OBJECT (DGrid), "table1", table1);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table1, TRUE, TRUE, 0);
  SBY_adj = gtk_adjustment_new (1, 1, 65536, 1, 10, 10);
  SBY = gtk_spin_button_new (GTK_ADJUSTMENT (SBY_adj), 1, 0);
  gtk_object_set_data (GTK_OBJECT (DGrid), "SBY", SBY);
  gtk_widget_show (SBY);
  gtk_table_attach (GTK_TABLE (table1), SBY, 1, 2, 1, 2,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_signal_connect_after (GTK_OBJECT (SBY), "changed",
                            GTK_SIGNAL_FUNC (on_SBY_changed),
                            NULL);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (SBY), TRUE);

  SBX_adj = gtk_adjustment_new (1, 1, 65536, 1, 10, 10);
  SBX = gtk_spin_button_new (GTK_ADJUSTMENT (SBX_adj), 1, 0);
  gtk_object_set_data (GTK_OBJECT (DGrid), "SBX", SBX);
  gtk_widget_show (SBX);
  gtk_table_attach (GTK_TABLE (table1), SBX, 1, 2, 0, 1,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_signal_connect_after (GTK_OBJECT (SBX), "changed",
                            GTK_SIGNAL_FUNC (on_SBX_changed),
                            NULL);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (SBX), TRUE);

  label2 = gtk_label_new ("Grid Y:");
  gtk_object_set_data (GTK_OBJECT (DGrid), "label2", label2);
  gtk_widget_show (label2);
  gtk_table_attach (GTK_TABLE (table1), label2, 0, 1, 1, 2,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_RIGHT);

  label1 = gtk_label_new ("Grid X:");
  gtk_object_set_data (GTK_OBJECT (DGrid), "label1", label1);
  gtk_widget_show (label1);
  gtk_table_attach (GTK_TABLE (table1), label1, 0, 1, 0, 1,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_RIGHT);
  CBXY = gtk_check_button_new_with_label ("Grid X = Grid Y");
  gtk_object_set_data (GTK_OBJECT (DGrid), "CBXY", CBXY);
  gtk_widget_show (CBXY);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), CBXY, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (CBXY), 2);
  gtk_signal_connect_after (GTK_OBJECT (CBXY), "toggled",
                            GTK_SIGNAL_FUNC (on_CBXY_toggled),
                            NULL);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (CBXY), TRUE);

  dialog_action_area1 = GTK_DIALOG (DGrid)->action_area;
  gtk_object_set_data (GTK_OBJECT (DGrid), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (DGrid), "hbuttonbox1", hbuttonbox1);
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), hbuttonbox1, TRUE, TRUE, 0);

  BOK = gtk_button_new_with_label ("OK");
  gtk_object_set_data (GTK_OBJECT (DGrid), "BOK", BOK);
  gtk_widget_show (BOK);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), BOK);
  gtk_signal_connect (GTK_OBJECT (BOK), "clicked",
                      GTK_SIGNAL_FUNC (on_BOK_clicked),
                      NULL);

  BCancel = gtk_button_new_with_label ("Cancel");
  gtk_object_set_data (GTK_OBJECT (DGrid), "BCancel", BCancel);
  gtk_widget_show (BCancel);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), BCancel);
  gtk_signal_connect (GTK_OBJECT (BCancel), "clicked",
                       GTK_SIGNAL_FUNC (on_BCancel_clicked),
                      NULL);

  return DGrid;
}


void ShowGridOptionsDialog(TCADSheet *Sheet)
{
  if (Dialog != NULL) return;

  OurSheet = Sheet;
  Sheet->GetGridOptions(X_eq_Y,GX,GY);

  CBXY = NULL;
  SBX = NULL;
  SBY = NULL;

  Dialog = create_DGrid();

  CBXY = (GtkToggleButton *)gtk_object_get_data(GTK_OBJECT(Dialog),"CBXY");
  SBX = (GtkSpinButton *)gtk_object_get_data(GTK_OBJECT(Dialog),"SBX");
  SBY = (GtkSpinButton *)gtk_object_get_data(GTK_OBJECT(Dialog),"SBY");
  gtk_toggle_button_set_state(CBXY,X_eq_Y);
  gtk_spin_button_set_value(SBX,GX);
  gtk_spin_button_set_value(SBY,GY);

  gtk_widget_show(Dialog);
  gtk_grab_add(Dialog);
}

