/*************************\
*                         *
*  Implements TCADHandle  *
*                         *
\*************************/

#include <stdio.h>
#include "handle.h"

TCADHandle::TCADHandle(THandleType Type)
{
  this->Type = Type;
  Attached = FALSE;
  HaveColors = FALSE;
}

void
TCADHandle::Draw(GtkWidget *Widget,GdkGC *GC,char Selected)
{
  GdkColormap *CM;

  if (Attached) {
    if (!HaveColors) {
      // Alloc blue color
      CM = gdk_window_get_colormap(Widget->window);

      Blue.pixel = 0;
      Blue.red = 0;
      Blue.green = 0;
      Blue.blue = 65535;
      gdk_colormap_alloc_color(CM,&Blue,TRUE,TRUE);
      gdk_color_black(CM,&Black);

      HaveColors = TRUE;
    }
    gdk_gc_set_foreground(GC,&Blue);
    gdk_draw_rectangle(Widget->window,GC,Selected,x,y,HANDLE_SIZE,HANDLE_SIZE);
    gdk_gc_set_foreground(GC,&Black);
  }
  else {
    gdk_draw_rectangle(Widget->window,GC,Selected,x,y,HANDLE_SIZE,HANDLE_SIZE);
  }
}

