/**********************************************************\
*                                                          *
*  Receives menu signals and calls methods of main widget  *
*                                                          *
\**********************************************************/

#include <gtk/gtkmenuitem.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkmain.h>
#include "main.h"
#include "gladesig.h"
#include "messagebox.h"

void on_New_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_New();
}

void on_Open_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_Open();
}

void on_Save_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_Save();
}

void on_Save_as__activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_SaveAs();
}

void on_Save_all_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_SaveAll();
}

void on_Exit_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_Exit();
}

void on_Next_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_NextWindow();
}

void on_Previous_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_PrevWindow();
}

void on_Close_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_CloseWindow();
}

void on_About_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_About();
}

// Not actually menu signal
gboolean on_MainWindow_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  widget=widget; event=event; user_data=user_data;

  if (gtk_grab_get_current() != NULL) return(TRUE);  // Modal dialog is showing

  System->Menu_Exit();

  return(FALSE);
}

void on_MIEditText_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_EditText();
}

void on_MITextProperties_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_TextProperties();
}

void on_MILineProperties_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  MessageBox("Sorry, no line properties yet.","Information");
}

void on_MIDelete_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_Delete();
}

void on_MILaTeX_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_Export_Latex();
}

void on_MIEPS_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  MessageBox("Sorry, not done yet.","Information");
}

void on_MIFIG_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_Export_FIG();
}

void on_MIArrowProperties_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
  System->Menu_ArrowProperties();
}

void on_MIGridProperties_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data=user_data;
}

void
on_MIUseGrid_activate(GtkMenuItem *menuitem,
                     gpointer user_data)
{
  menuitem = menuitem;
  user_data = user_data;
  System->Menu_UseGridToggled();
}

void
on_MIShowGrid_activate(GtkMenuItem *menuitem,
                      gpointer user_data)
{
  menuitem = menuitem;
  user_data = user_data;
  System->Menu_ShowGridToggled();
}

void
on_MIGridOptions_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem;
  user_data = user_data;
  System->Menu_ShowGridOptions();
}

void
on_MILAL_None_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem;
  user_data = user_data;
}

void
on_MILAL_Grid_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem;
  user_data = user_data;
}

void
on_MILAL_HalfGrid_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem;
  user_data = user_data;
}

void
on_MISelectAll_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data = user_data;

  System->Menu_SelectAll();
}

void
on_MIAlign_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data = user_data;

  System->Menu_Align();
}

void
on_MIRulerOptions_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  menuitem = menuitem; user_data = user_data;

  System->Menu_RulerOptions();
}
