/****************\
*                *
*  Ruler dialog  *
*                *
\****************/

#include <gtk/gtkdialog.h>
#include <gtk/gtkradiobutton.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkhbbox.h>
#include <gtk/gtkframe.h>
#include <gtk/gtksignal.h>

#include "rulerdialog.h"

static TCADSheet *ActSheet;
static GtkWidget *Dialog;

static GtkWidget *CBHVisible;
static GtkWidget *RBHPixels;
static GtkWidget *RBHCentimeters;
static GtkWidget *RBHInches;
static GtkWidget *CBVVisible;
static GtkWidget *RBVPixels;
static GtkWidget *RBVCentimeters;
static GtkWidget *RBVInches;

static void
GetSettings()
{
  ActSheet->VRulerSettings.Visible = GTK_TOGGLE_BUTTON(CBVVisible)->active;
  if (GTK_TOGGLE_BUTTON(RBVPixels)->active) ActSheet->VRulerSettings.Metric = GTK_PIXELS;
  else if (GTK_TOGGLE_BUTTON(RBVCentimeters)->active)
   ActSheet->VRulerSettings.Metric=GTK_CENTIMETERS;
  else if (GTK_TOGGLE_BUTTON(RBVInches)->active) ActSheet->VRulerSettings.Metric = GTK_INCHES;
  
  ActSheet->HRulerSettings.Visible = GTK_TOGGLE_BUTTON(CBHVisible)->active;
  if (GTK_TOGGLE_BUTTON(RBHPixels)->active) ActSheet->HRulerSettings.Metric = GTK_PIXELS;
  else if (GTK_TOGGLE_BUTTON(RBHCentimeters)->active)
   ActSheet->HRulerSettings.Metric=GTK_CENTIMETERS;
  else if (GTK_TOGGLE_BUTTON(RBHInches)->active) ActSheet->HRulerSettings.Metric = GTK_INCHES;

  ActSheet->ApplyRulerSettings();
}

static void
on_BCancel_clicked (GtkButton *button, gpointer user_data)
{
  button = button;
  user_data = user_data;

  // Make window non-modal
  gtk_grab_remove(Dialog);

  // Close window
  gtk_widget_destroy(Dialog);
  Dialog = NULL;
}

static gboolean
window_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  event=event;

  on_BCancel_clicked(NULL,user_data);
}

static void
on_BOK_clicked (GtkButton *button, gpointer user_data)
{
  // Do alignment
  GetSettings();

  // Close window
  on_BCancel_clicked(button,user_data);
}

static GtkWidget *
CreateDialog()
{
  GtkWidget *DRulers;
  GtkWidget *dialog_vbox1;
  GtkWidget *hbox1;
  GtkWidget *FHorizontal;
  GtkWidget *vbox1;
  GtkWidget *FHorizUnits;
  GtkWidget *vbox2;
  GSList *__group = NULL;
  GtkWidget *FVertical;
  GtkWidget *vbox3;
  GtkWidget *FVertUnits;
  GtkWidget *vbox4;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbuttonbox1;
  GtkWidget *BOK;
  GtkWidget *BCancel;

  DRulers = gtk_dialog_new();
  gtk_object_set_data (GTK_OBJECT (DRulers), "DRulers", DRulers);
  GTK_WINDOW (DRulers)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_title (GTK_WINDOW (DRulers), "Rulers");
  gtk_window_set_policy (GTK_WINDOW (DRulers), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (DRulers)->vbox;
  gtk_object_set_data (GTK_OBJECT (DRulers), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  hbox1 = gtk_hbox_new (TRUE, 0);
  gtk_object_set_data (GTK_OBJECT (DRulers), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), hbox1, TRUE, TRUE, 0);

  FHorizontal = gtk_frame_new ("Horizontal");
  gtk_object_set_data (GTK_OBJECT (DRulers), "FHorizontal", FHorizontal);
  gtk_widget_show (FHorizontal);
  gtk_box_pack_start (GTK_BOX (hbox1), FHorizontal, TRUE, TRUE, 0);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (DRulers), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (FHorizontal), vbox1);

  CBHVisible = gtk_check_button_new_with_label ("Visible");
  gtk_object_set_data (GTK_OBJECT (DRulers), "CBHVisible", CBHVisible);
  gtk_widget_show (CBHVisible);
  gtk_box_pack_start (GTK_BOX (vbox1), CBHVisible, TRUE, TRUE, 0);
  FHorizUnits = gtk_frame_new ("Units");
  gtk_object_set_data (GTK_OBJECT (DRulers), "FHorizUnits", FHorizUnits);
  gtk_widget_show (FHorizUnits);
  gtk_box_pack_start (GTK_BOX (vbox1), FHorizUnits, TRUE, TRUE, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (DRulers), "vbox2", vbox2);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (FHorizUnits), vbox2);

  RBHPixels = gtk_radio_button_new_with_label (__group, "Pixels");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBHPixels));
  gtk_object_set_data (GTK_OBJECT (DRulers), "RBHPixels", RBHPixels);
  gtk_widget_show (RBHPixels);
  gtk_box_pack_start (GTK_BOX (vbox2), RBHPixels, TRUE, TRUE, 0);

  RBHCentimeters = gtk_radio_button_new_with_label (__group, "Centimeters");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBHCentimeters));
  gtk_object_set_data (GTK_OBJECT (DRulers), "RBHCentimeters", RBHCentimeters);
  gtk_widget_show (RBHCentimeters);
  gtk_box_pack_start (GTK_BOX (vbox2), RBHCentimeters, TRUE, TRUE, 0);

  RBHInches = gtk_radio_button_new_with_label (__group, "Inches");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBHInches));
  gtk_object_set_data (GTK_OBJECT (DRulers), "RBHInches", RBHInches);
  gtk_widget_show (RBHInches);
  gtk_box_pack_start (GTK_BOX (vbox2), RBHInches, TRUE, TRUE, 0);

  FVertical = gtk_frame_new ("Vertical");
  gtk_object_set_data (GTK_OBJECT (DRulers), "FVertical", FVertical);
  gtk_widget_show (FVertical);
  gtk_box_pack_start (GTK_BOX (hbox1), FVertical, TRUE, TRUE, 0);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (DRulers), "vbox3", vbox3);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (FVertical), vbox3);

  CBVVisible = gtk_check_button_new_with_label ("Visible");
  gtk_object_set_data (GTK_OBJECT (DRulers), "CBVVisible", CBVVisible);
  gtk_widget_show (CBVVisible);
  gtk_box_pack_start (GTK_BOX (vbox3), CBVVisible, TRUE, TRUE, 0);

  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (CBVVisible), TRUE);

  FVertUnits = gtk_frame_new ("Units");
  gtk_object_set_data (GTK_OBJECT (DRulers), "FVertUnits", FVertUnits);
  gtk_widget_show (FVertUnits);
  gtk_box_pack_start (GTK_BOX (vbox3), FVertUnits, TRUE, TRUE, 0);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (DRulers), "vbox4", vbox4);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (FVertUnits), vbox4);

  __group = NULL;
  RBVPixels = gtk_radio_button_new_with_label (__group, "Pixels");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBVPixels));
  gtk_object_set_data (GTK_OBJECT (DRulers), "RBVPixels", RBVPixels);
  gtk_widget_show (RBVPixels);
  gtk_box_pack_start (GTK_BOX (vbox4), RBVPixels, TRUE, TRUE, 0);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (RBVPixels), TRUE);

  RBVCentimeters = gtk_radio_button_new_with_label (__group, "Centimeters");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBVCentimeters));
  gtk_object_set_data (GTK_OBJECT (DRulers), "RBVCentimeters", RBVCentimeters);
  gtk_widget_show (RBVCentimeters);
  gtk_box_pack_start (GTK_BOX (vbox4), RBVCentimeters, TRUE, TRUE, 0);

  RBVInches = gtk_radio_button_new_with_label (__group, "Inches");
  __group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBVInches));
  gtk_object_set_data (GTK_OBJECT (DRulers), "RBVInches", RBVInches);
  gtk_widget_show (RBVInches);
  gtk_box_pack_start (GTK_BOX (vbox4), RBVInches, TRUE, TRUE, 0);

  dialog_action_area1 = GTK_DIALOG (DRulers)->action_area;
  gtk_object_set_data (GTK_OBJECT (DRulers), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (DRulers), "hbuttonbox1", hbuttonbox1);
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), hbuttonbox1, TRUE, TRUE, 0);

  BOK = gtk_button_new_with_label ("OK");
  gtk_object_set_data (GTK_OBJECT (DRulers), "BOK", BOK);
  gtk_widget_show (BOK);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), BOK);
  gtk_signal_connect (GTK_OBJECT (BOK), "clicked",
                      GTK_SIGNAL_FUNC (on_BOK_clicked),
                      DRulers);

  BCancel = gtk_button_new_with_label ("Cancel");
  gtk_object_set_data (GTK_OBJECT (DRulers), "BCancel", BCancel);
  gtk_widget_show (BCancel);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), BCancel);
  gtk_signal_connect (GTK_OBJECT (BCancel), "clicked",
                      GTK_SIGNAL_FUNC (on_BCancel_clicked),
                      DRulers);

  gtk_signal_connect ((GtkObject *)(DRulers), "delete_event",
                      GTK_SIGNAL_FUNC (window_delete_event),
                      DRulers);

  return DRulers;
}

static void
Settings2GUI()
{
  if (ActSheet->HRulerSettings.Visible)
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(CBHVisible), TRUE);

  if (ActSheet->VRulerSettings.Visible)
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(CBVVisible), TRUE);

  switch(ActSheet->HRulerSettings.Metric) {
    case GTK_PIXELS:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(RBHPixels), TRUE);
      break;
    case GTK_INCHES:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(RBHInches), TRUE);
      break;
    case GTK_CENTIMETERS:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(RBHCentimeters), TRUE);
      break;
  }

  switch(ActSheet->VRulerSettings.Metric) {
    case GTK_PIXELS:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(RBVPixels), TRUE);
      break;
    case GTK_INCHES:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(RBVInches), TRUE);
      break;
    case GTK_CENTIMETERS:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(RBVCentimeters), TRUE);
      break;
  }
}

void
ShowRulerDialog(TCADSheet *Sheet)
{
  if (Dialog != NULL) return;

  ActSheet = Sheet;

  Dialog = CreateDialog();
  Settings2GUI();

  gtk_widget_show(Dialog);
  gtk_grab_add(Dialog);
}


