/*****************************\
*                             *
*  Implements TCADSimpleLine  *
*                             *
\*****************************/

#include <string.h>
#include <math.h>
#include "simpleline.h"

TCADSimpleLine::TCADSimpleLine(TCADSheet *Sheet,int x=0,int y=0) : TCADLine(Sheet,x,y)
{
  RecomputeEncapRect();
  RecomputeRefRect();
}

TCADSimpleLine::~TCADSimpleLine() {
}

void
TCADSimpleLine::Save(TCADSaveStream *Fl)
{
  Fl->SaveObjectName("TCADSimpleLine");
  SaveProperties(Fl);
  Fl->SaveEndObject();
}

void
TCADSimpleLine::Draw(GdkRegion *Region)
{
  GdkDrawable *Drawable;
//  printf("TCADSimpleLine(%lu)::Draw()\n",Uniq);

  if (Region)
   if (gdk_region_rect_in(Region, &RefRect) == GDK_OVERLAP_RECTANGLE_OUT) return;

  Drawable = Sheet->GetDrawable();
  gdk_draw_line(Drawable,Sheet->GC,First.x,First.y,Last.x,Last.y);

  // Draw arrows
  DrawArrow(Drawable,Sheet->GC,&First,&Last,FirstArrow,FirstArrowSize);
  DrawArrow(Drawable,Sheet->GC,&Last,&First,LastArrow,LastArrowSize);
}

TCADObject *
TCADSimpleLine::ButtonPressed(int x,int y)
{
  if (TCADLine::ButtonPressed(x,y) == NULL) return(NULL);

  /* Compute distance */
  if (PointNearLine(First,Last,x,y)) return(this);
  else return(NULL);
}

void
TCADSimpleLine::Export(FILE *Fl,TExportFormat Format)
{
  switch(Format) {
    case EF_LATEX:
      int W,H;
      int x,y;
      x = EncapRect.x;
      y = Sheet->EncapRect.height-EncapRect.y;

      W = EncapRect.width;
      H = EncapRect.height;
      fprintf(Fl,"\\put(%d,%d){\\line(%d,%d){%f}}\n",x,y,W,-H,sqrt(W*W+H*H));
      break;
    case EF_FIG:
      ExportFigLine(Fl,2);
      fprintf(Fl,"\t%d %d  %d %d\n",First.x,First.y,Last.x,Last.y);
      break;
  }
}

void
TCADSimpleLine::RecomputeEncapRect()
{
  EncapRect.x = MIN(First.x,Last.x);
  EncapRect.y = MIN(First.y,Last.y);
  EncapRect.width = ABS(First.x-Last.x);
  EncapRect.height = ABS(First.y-Last.y);
}

gboolean
TCADSimpleLine::CanAttach(int& x,int& y,TAttach *Attach)
{
  return(FALSE);
}


